/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;

public class SceKernelModuleInfo
extends pspAbstractMemoryMappedStructureVariableLength {
    public static final int SIZE_OF = 96;
    public byte nsegment;
    public byte[] reserved = new byte[3];
    public int[] segmentaddr = new int[4];
    public int[] segmentsize = new int[4];
    public int entry_addr;
    public int gp_value;
    public int text_addr;
    public int text_size;
    public int data_size;
    public int bss_size;
    public short attribute;
    public int version;
    public String name;

    public void copy(SceModule sceModule) {
        this.nsegment = (byte)(sceModule.nsegment & 0xFF);
        this.segmentaddr[0] = sceModule.segmentaddr[0];
        this.segmentaddr[1] = sceModule.segmentaddr[1];
        this.segmentaddr[2] = sceModule.segmentaddr[2];
        this.segmentaddr[3] = sceModule.segmentaddr[3];
        this.segmentsize[0] = sceModule.segmentsize[0];
        this.segmentsize[1] = sceModule.segmentsize[1];
        this.segmentsize[2] = sceModule.segmentsize[2];
        this.segmentsize[3] = sceModule.segmentsize[3];
        this.entry_addr = sceModule.entry_addr;
        this.gp_value = sceModule.gp_value;
        this.text_addr = sceModule.text_addr;
        this.text_size = sceModule.text_size;
        this.data_size = sceModule.data_size;
        this.bss_size = sceModule.bss_size;
        this.attribute = sceModule.attribute;
        this.version = sceModule.version;
        this.name = sceModule.modname;
    }

    @Override
    protected void read() {
        super.read();
        this.nsegment = (byte)(this.read8() & 0xFF);
        this.reserved[0] = (byte)(this.read8() & 0xFF);
        this.reserved[1] = (byte)(this.read8() & 0xFF);
        this.reserved[2] = (byte)(this.read8() & 0xFF);
        this.segmentaddr[0] = this.read32();
        this.segmentaddr[1] = this.read32();
        this.segmentaddr[2] = this.read32();
        this.segmentaddr[3] = this.read32();
        this.segmentsize[0] = this.read32();
        this.segmentsize[1] = this.read32();
        this.segmentsize[2] = this.read32();
        this.segmentsize[3] = this.read32();
        this.entry_addr = this.read32();
        this.gp_value = this.read32();
        this.text_addr = this.read32();
        this.text_size = this.read32();
        this.data_size = this.read32();
        this.bss_size = this.read32();
        this.attribute = (short)(this.read16() & 0xFFFF);
        this.version = this.read16();
        this.name = this.readStringNZ(28);
    }

    @Override
    protected void write() {
        super.write();
        this.write8(this.nsegment);
        this.writeSkip(3);
        this.write32(this.segmentaddr[0]);
        this.write32(this.segmentaddr[1]);
        this.write32(this.segmentaddr[2]);
        this.write32(this.segmentaddr[3]);
        this.write32(this.segmentsize[0]);
        this.write32(this.segmentsize[1]);
        this.write32(this.segmentsize[2]);
        this.write32(this.segmentsize[3]);
        this.write32(this.entry_addr);
        this.write32(this.gp_value);
        this.write32(this.text_addr);
        this.write32(this.text_size);
        this.write32(this.data_size);
        this.write32(this.bss_size);
        this.write16(this.attribute);
        this.write16((short)this.version);
        this.writeStringNZ(28, this.name);
    }
}

