/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.nio.charset.Charset;
import jpcsp.HLE.ITPointerBase;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.TPointerFunction;
import jpcsp.Memory;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;

public abstract class pspAbstractMemoryMappedStructure {
    private static final int unknown = 0x11111111;
    public static final Charset charset16 = Charset.forName("UTF-16LE");
    private int baseAddress;
    private int maxSize = Integer.MAX_VALUE;
    private int offset;
    protected Memory mem;

    public abstract int sizeof();

    protected abstract void read();

    protected abstract void write();

    private void start(Memory mem) {
        this.mem = mem;
        this.offset = 0;
    }

    protected void start(Memory mem, int address) {
        this.start(mem);
        this.baseAddress = address;
    }

    private void start(Memory mem, int address, int maxSize) {
        this.start(mem, address);
        this.maxSize = maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < 0) {
            maxSize = Integer.MAX_VALUE;
        }
        this.maxSize = maxSize;
    }

    public void read(Memory mem, int address) {
        this.start(mem, address);
        if (address != 0) {
            this.read();
        }
    }

    public void read(ITPointerBase pointer) {
        this.read(pointer, 0);
    }

    public void read(ITPointerBase pointer, int offset) {
        this.start(pointer.getMemory(), pointer.getAddress() + offset);
        if (pointer.isNotNull()) {
            this.read();
        }
    }

    public void write(Memory mem, int address) {
        this.start(mem, address);
        this.write();
    }

    public void write(ITPointerBase pointer) {
        this.write(pointer, 0);
    }

    public void write(ITPointerBase pointer, int offset) {
        this.write(pointer.getMemory(), pointer.getAddress() + offset);
    }

    public void write(Memory mem) {
        this.start(mem);
        this.write();
    }

    protected int read8() {
        int value = this.offset >= this.maxSize ? 0 : this.mem.read8(this.baseAddress + this.offset);
        ++this.offset;
        return value;
    }

    protected void read8Array(byte[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            array[i] = (byte)this.read8();
        }
    }

    protected void align16() {
        this.offset = this.offset + 1 & 0xFFFFFFFE;
    }

    protected void align32() {
        this.offset = this.offset + 3 & 0xFFFFFFFC;
    }

    protected int read16() {
        this.align16();
        int value = this.offset >= this.maxSize ? 0 : this.mem.read16(this.baseAddress + this.offset);
        this.offset += 2;
        if (this.isBigEndian()) {
            value = this.endianSwap16((short)value);
        }
        return value;
    }

    protected int readUnaligned16() {
        int n0 = this.read8();
        int n1 = this.read8();
        if (this.isBigEndian()) {
            return n0 << 8 | n1;
        }
        return n1 << 8 | n0;
    }

    protected int read32() {
        this.align32();
        int value = this.offset >= this.maxSize ? 0 : this.mem.read32(this.baseAddress + this.offset);
        this.offset += 4;
        if (this.isBigEndian()) {
            value = this.endianSwap32(value);
        }
        return value;
    }

    protected int readUnaligned32() {
        int n01 = this.readUnaligned16();
        int n23 = this.readUnaligned16();
        if (this.isBigEndian()) {
            return n01 << 16 | n23;
        }
        return n23 << 16 | n01;
    }

    protected long read64() {
        this.align32();
        long value = this.offset >= this.maxSize ? 0L : this.mem.read64(this.baseAddress + this.offset);
        this.offset += 8;
        if (this.isBigEndian()) {
            value = this.endianSwap64(value);
        }
        return value;
    }

    protected void read32Array(int[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            array[i] = this.read32();
        }
    }

    protected boolean readBoolean() {
        int value = this.read8();
        return value != 0;
    }

    protected void readBooleanArray(boolean[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            array[i] = this.readBoolean();
        }
    }

    protected float readFloat() {
        int int32 = this.read32();
        return Float.intBitsToFloat(int32);
    }

    protected void readFloatArray(float[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            array[i] = this.readFloat();
        }
    }

    protected void readFloatArray(float[][] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            this.readFloatArray(array[i]);
        }
    }

    protected void readUnknown(int length) {
        this.offset += length;
    }

    protected String readStringNZ(int n) {
        String s = this.offset >= this.maxSize ? null : Utilities.readStringNZ(this.mem, this.baseAddress + this.offset, n);
        this.offset += n;
        return s;
    }

    protected String readStringZ(int addr) {
        if (addr == 0) {
            return null;
        }
        return Utilities.readStringZ(this.mem, addr);
    }

    protected String readStringUTF16NZ(int n) {
        StringBuilder s = new StringBuilder();
        while (n > 0) {
            int char16 = this.read16();
            n -= 2;
            if (char16 == 0) break;
            byte[] bytes = new byte[]{(byte)char16, (byte)(char16 >> 8)};
            s.append(new String(bytes, charset16));
        }
        if (n > 0) {
            this.readUnknown(n);
        }
        return s.toString();
    }

    protected int writeStringUTF16NZ(int n, String s) {
        byte[] bytes = s.getBytes(charset16);
        int length = 0;
        if (bytes != null) {
            length = bytes.length;
            for (int i = 0; i < bytes.length && n > 0; ++i, --n) {
                this.write8(bytes[i]);
            }
        }
        if (n > 0) {
            this.write8((byte)0);
            --n;
        }
        if (n > 0) {
            this.write8((byte)0);
            --n;
        }
        if (n > 0) {
            this.offset += n;
        }
        return length;
    }

    protected String readStringUTF16Z(int addr) {
        int char16;
        if (addr == 0) {
            return null;
        }
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, 2);
        StringBuilder s = new StringBuilder();
        while ((char16 = memoryReader.readNext()) != 0) {
            byte[] bytes = new byte[]{(byte)char16, (byte)(char16 >> 8)};
            s.append(new String(bytes, charset16));
        }
        return s.toString();
    }

    protected TPointer readPointer() {
        int value = this.read32();
        if (value == 0) {
            return TPointer.NULL;
        }
        return new TPointer(this.mem, value);
    }

    protected TPointer32 readPointer32() {
        int value = this.read32();
        if (value == 0) {
            return TPointer32.NULL;
        }
        return new TPointer32(this.mem, value);
    }

    protected TPointerFunction readPointerFunction() {
        int value = this.read32();
        return new TPointerFunction(this.mem, value);
    }

    protected void readPointerArray(TPointer[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            array[i] = this.readPointer();
        }
    }

    protected int writeStringUTF16Z(int addr, String s) {
        if (addr == 0 || s == null) {
            return 0;
        }
        byte[] bytes = s.getBytes(charset16);
        if (bytes == null) {
            return 0;
        }
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(addr, bytes.length + 2, 1);
        for (int i = 0; i < bytes.length; ++i) {
            memoryWriter.writeNext(bytes[i] & 0xFF);
        }
        memoryWriter.writeNext(0);
        memoryWriter.writeNext(0);
        memoryWriter.flush();
        return bytes.length;
    }

    protected void read(pspAbstractMemoryMappedStructure object) {
        if (object == null) {
            return;
        }
        if (this.offset < this.maxSize) {
            object.start(this.mem, this.baseAddress + this.offset, this.maxSize - this.offset);
            object.read();
        }
        this.offset += object.sizeof();
    }

    protected void write8(byte data) {
        if (this.offset < this.maxSize) {
            this.mem.write8(this.baseAddress + this.offset, data);
        }
        ++this.offset;
    }

    protected void write8Array(byte[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            this.write8(array[i]);
        }
    }

    protected void write16(short data) {
        this.align16();
        if (this.offset < this.maxSize) {
            if (this.isBigEndian()) {
                data = (short)this.endianSwap16(data);
            }
            this.mem.write16(this.baseAddress + this.offset, data);
        }
        this.offset += 2;
    }

    protected void writeUnaligned16(short data) {
        if (this.isBigEndian()) {
            this.write8((byte)(data >>> 8));
            this.write8((byte)data);
        } else {
            this.write8((byte)data);
            this.write8((byte)(data >>> 8));
        }
    }

    protected void write32(int data) {
        this.align32();
        if (this.offset < this.maxSize) {
            if (this.isBigEndian()) {
                data = this.endianSwap32(data);
            }
            this.mem.write32(this.baseAddress + this.offset, data);
        }
        this.offset += 4;
    }

    protected void writeUnaligned32(int data) {
        if (this.isBigEndian()) {
            this.writeUnaligned16((short)(data >>> 16));
            this.writeUnaligned16((short)data);
        } else {
            this.writeUnaligned16((short)data);
            this.writeUnaligned16((short)(data >>> 16));
        }
    }

    protected void write64(long data) {
        this.align32();
        if (this.offset < this.maxSize) {
            if (this.isBigEndian()) {
                data = this.endianSwap64(data);
            }
            this.mem.write64(this.baseAddress + this.offset, data);
        }
        this.offset += 8;
    }

    protected void write32Array(int[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            this.write32(array[i]);
        }
    }

    protected void writeBoolean(boolean data) {
        this.write8(data ? (byte)1 : 0);
    }

    protected void writeBooleanArray(boolean[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            this.writeBoolean(array[i]);
        }
    }

    protected void writeFloat(float data) {
        int int32 = Float.floatToIntBits(data);
        this.write32(int32);
    }

    protected void writeFloatArray(float[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            this.writeFloat(array[i]);
        }
    }

    protected void writeFloatArray(float[][] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            this.writeFloatArray(array[i]);
        }
    }

    protected void writeUnknown(int length) {
        for (int i = 0; i < length; ++i) {
            this.write8((byte)17);
        }
    }

    protected void writeSkip(int length) {
        this.offset += length;
    }

    protected void writeStringN(int n, String s) {
        if (this.offset < this.maxSize) {
            Utilities.writeStringNZ(this.mem, this.baseAddress + this.offset, n, s);
        }
        this.offset += n;
    }

    protected void writeStringNZ(int n, String s) {
        if (this.offset < this.maxSize) {
            Utilities.writeStringNZ(this.mem, this.baseAddress + this.offset, n - 1, s);
            this.mem.write8(this.baseAddress + this.offset + n - 1, (byte)0);
        }
        this.offset += n;
    }

    protected void writeStringZ(String s, int addr) {
        if (s != null && addr != 0) {
            Utilities.writeStringZ(this.mem, addr, s);
        }
    }

    protected void write(pspAbstractMemoryMappedStructure object) {
        if (object == null) {
            return;
        }
        if (this.offset < this.maxSize) {
            object.start(this.mem, this.baseAddress + this.offset, this.maxSize - this.offset);
            object.write();
        }
        this.offset += object.sizeof();
    }

    protected void writePointer(TPointer pointer) {
        if (pointer == null) {
            this.write32(0);
        } else {
            this.write32(pointer.getAddress());
        }
    }

    protected void writePointer32(TPointer32 pointer) {
        if (pointer == null) {
            this.write32(0);
        } else {
            this.write32(pointer.getAddress());
        }
    }

    protected void writePointerFunction(TPointerFunction pointer) {
        if (pointer == null) {
            this.write32(0);
        } else {
            this.write32(pointer.getAddress());
        }
    }

    protected void writePointerArray(TPointer[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            this.writePointer(array[i]);
        }
    }

    protected int getOffset() {
        return this.offset;
    }

    public int getBaseAddress() {
        return this.baseAddress;
    }

    public boolean isNull() {
        return this.baseAddress == 0;
    }

    public boolean isNotNull() {
        return this.baseAddress != 0;
    }

    protected int endianSwap16(short data) {
        return Short.reverseBytes(data) & 0xFFFF;
    }

    protected int endianSwap32(int data) {
        return Integer.reverseBytes(data);
    }

    protected long endianSwap64(long data) {
        return Long.reverseBytes(data);
    }

    protected long longSwap64(long data) {
        return data >>> 32 | data << 32;
    }

    protected boolean isBigEndian() {
        return false;
    }

    public String toString() {
        return String.format("0x%08X", this.getBaseAddress());
    }
}

