/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules.sceFont;
import jpcsp.HLE.modules.sceNetApctl;
import jpcsp.HLE.modules.sceUtility;
import jpcsp.hardware.Model;
import jpcsp.settings.Settings;
import jpcsp.util.Constants;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceReg
extends HLEModule {
    public static Logger log = Modules.getLogger("sceReg");
    private static final String iregFileName = "flash1:/registry/system.ireg";
    private static final String dregFileName = "flash1:/registry/system.dreg";
    protected static final int DATA_BLOCK_SIZE = 512;
    protected static final int REG_TYPE_DIR = 1;
    protected static final int REG_TYPE_INT = 2;
    protected static final int REG_TYPE_STR = 3;
    protected static final int REG_TYPE_BIN = 4;
    protected static final int REG_MODE_READ_WRITE = 1;
    protected static final int REG_MODE_READ_ONLY = 2;
    private Map<Integer, RegistryHandle> registryHandles;
    private Map<Integer, CategoryHandle> categoryHandles;
    private Map<Integer, KeyHandle> keyHandles;
    private String authName;
    private String authKey;
    private int networkLatestId;
    private int wifiConnectCount;
    private int usbConnectCount;
    private int psnAccountCount;
    private int slideCount;
    private int bootCount;
    private int gameExecCount;
    private int oskVersionId;
    private int oskDispLocale;
    private int oskWritingLocale;
    private int oskInputCharMask;
    private int oskKeytopIndex;
    private String npEnv;
    private String adhocSsidPrefix;
    private int musicVisualizerMode;
    private int musicTrackInfoMode;
    private String lockPassword;
    private String browserHomeUri;
    private String npAccountId;
    private String npLoginId;
    private String npPassword;
    private int npAutoSignInEnable;
    private String ownerName;
    private Registry registry;
    private static MessageDigest sha1;

    private static byte[] sha1(byte[] input) {
        return sceReg.sha1(input, 0, input.length);
    }

    private static byte[] sha1(byte[] input, int offset, int length) {
        sha1.reset();
        sha1.update(input, offset, length);
        byte[] digestBytes = sha1.digest();
        return digestBytes;
    }

    public String getAuthName() {
        return this.authName;
    }

    public void setAuthName(String authName) {
        this.authName = authName;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public void setAuthKey(String authKey) {
        this.authKey = authKey;
    }

    public int getNetworkLatestId() {
        return this.networkLatestId;
    }

    public void setNetworkLatestId(int networkLatestId) {
        this.networkLatestId = networkLatestId;
    }

    public String getNpLoginId() {
        return this.npLoginId;
    }

    public String getNpPassword() {
        return this.npPassword;
    }

    private int getKey(CategoryHandle categoryHandle, String name, TPointer32 ptype, TPointer32 psize, TPointer buf, int size) {
        String fullName = categoryHandle.getFullName();
        fullName = fullName.replace("flash1:/registry/system", "");
        fullName = fullName.replace("flash1/registry/system", "");
        fullName = fullName.replace("flash2/registry/system", "");
        Settings settings = Settings.getInstance();
        if ("/system/DATA/FONT".equals(fullName) || "/DATA/FONT".equals(fullName)) {
            List<sceFont.FontRegistryEntry> fontRegistry = Modules.sceFontModule.getFontRegistry();
            if ("path_name".equals(name)) {
                ptype.setValue(3);
                psize.setValue(Modules.sceFontModule.getFontDirPath().length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, Modules.sceFontModule.getFontDirPath());
                }
            } else if ("num_fonts".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(fontRegistry.size());
                }
            } else {
                log.warn((Object)String.format("Unknown font registry entry '%s'", name));
            }
        } else if (fullName.startsWith("/system/DATA/FONT/PROPERTY/INFO") || fullName.startsWith("/DATA/FONT/PROPERTY/INFO")) {
            List<sceFont.FontRegistryEntry> fontRegistry = Modules.sceFontModule.getFontRegistry();
            int index = Integer.parseInt(fullName.substring(fullName.indexOf("INFO") + 4));
            if (index < 0 || index >= fontRegistry.size()) {
                return -1;
            }
            sceFont.FontRegistryEntry entry = fontRegistry.get(index);
            if ("h_size".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.h_size);
                }
            } else if ("v_size".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.v_size);
                }
            } else if ("h_resolution".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.h_resolution);
                }
            } else if ("v_resolution".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.v_resolution);
                }
            } else if ("extra_attributes".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.extra_attributes);
                }
            } else if ("weight".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.weight);
                }
            } else if ("family_code".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.family_code);
                }
            } else if ("style".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.style);
                }
            } else if ("sub_style".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.sub_style);
                }
            } else if ("language_code".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.language_code);
                }
            } else if ("region_code".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.region_code);
                }
            } else if ("country_code".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.country_code);
                }
            } else if ("file_name".equals(name)) {
                ptype.setValue(3);
                psize.setValue(entry.file_name == null ? 0 : entry.file_name.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, entry.file_name);
                }
            } else if ("font_name".equals(name)) {
                ptype.setValue(3);
                psize.setValue(entry.font_name == null ? 0 : entry.font_name.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, entry.font_name);
                }
            } else if ("expire_date".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.expire_date);
                }
            } else if ("shadow_option".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(entry.shadow_option);
                }
            } else {
                log.warn((Object)String.format("Unknown font registry entry '%s'", name));
            }
        } else if ("/CONFIG/DATE".equals(fullName)) {
            if ("date_format".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(settings.readInt("registry.date_format", 2));
                }
            } else if ("time_format".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(settings.readInt("registry.time_format", 0));
                }
            } else if ("time_zone_offset".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(settings.readInt("registry.time_zone_offset", 0));
                }
            } else if ("time_zone_area".equals(name)) {
                String timeZoneArea = settings.readString("registry.time_zone_area", "united_kingdom");
                ptype.setValue(3);
                psize.setValue(timeZoneArea.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, timeZoneArea);
                }
            } else if ("summer_time".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(settings.readInt("registry.summer_time", 0));
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/BROWSER".equals(fullName)) {
            if ("flash_activated".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("home_uri".equals(name)) {
                ptype.setValue(3);
                psize.setValue(512);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.browserHomeUri);
                }
            } else if ("cookie_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("proxy_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(2);
                }
            } else if ("proxy_address".equals(name)) {
                ptype.setValue(3);
                psize.setValue(128);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, "");
                }
            } else if ("proxy_port".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("picture".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("animation".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("javascript".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("cache_size".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(512);
                }
            } else if ("char_size".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("disp_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("flash_play".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("connect_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("proxy_protect".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("proxy_autoauth".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("proxy_user".equals(name)) {
                ptype.setValue(3);
                psize.setValue(128);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, "");
                }
            } else if ("proxy_password".equals(name)) {
                ptype.setValue(3);
                psize.setValue(128);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, "");
                }
            } else if ("webpage_quality".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/BROWSER2".equals(fullName)) {
            if ("tm_service".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("tm_ec_ttl".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("tm_ec_ttl_update_time".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/NP".equals(fullName)) {
            if ("account_id".equals(name)) {
                ptype.setValue(4);
                psize.setValue(16);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.npAccountId);
                }
            } else if ("login_id".equals(name)) {
                ptype.setValue(3);
                psize.setValue(this.npLoginId.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.npLoginId);
                }
            } else if ("password".equals(name)) {
                ptype.setValue(3);
                psize.setValue(this.npPassword.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.npPassword);
                }
            } else if ("auto_sign_in_enable".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.npAutoSignInEnable);
                }
            } else if ("nav_only".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("env".equals(name)) {
                ptype.setValue(3);
                psize.setValue(this.npEnv.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.npEnv);
                }
            } else if ("guest_country".equals(name)) {
                String guestCount = "";
                ptype.setValue(3);
                psize.setValue(guestCount.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, guestCount);
                }
            } else if ("view_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("check_drm".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/PREMO".equals(fullName)) {
            if ("ps3_mac".equals(name)) {
                byte[] ps3Mac = new byte[]{17, 34, 51, 68, 85, 102};
                ptype.setValue(4);
                psize.setValue(ps3Mac.length);
                if (size > 0) {
                    buf.setArray(ps3Mac, ps3Mac.length);
                }
            } else if ("ps3_name".equals(name)) {
                String ps3Name = "My PS3";
                ptype.setValue(3);
                psize.setValue(ps3Name.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, ps3Name);
                }
            } else if ("guide_page".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("response".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("custom_video_buffer1".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("custom_video_bitrate1".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("setting_internet".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("custom_video_buffer2".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("custom_video_bitrate2".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("button_assign".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("ps3_keytype".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("ps3_key".equals(name)) {
                ptype.setValue(4);
                psize.setValue(16);
                if (size >= 16) {
                    buf.clear(16);
                }
            } else if ("flags".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("account_id".equals(name)) {
                ptype.setValue(4);
                psize.setValue(16);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.npAccountId);
                }
            } else if ("login_id".equals(name)) {
                ptype.setValue(3);
                psize.setValue(this.npLoginId.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.npLoginId);
                }
            } else if ("password".equals(name)) {
                ptype.setValue(3);
                psize.setValue(this.npPassword.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.npPassword);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/SYSTEM".equals(fullName)) {
            if ("exh_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("umd_autoboot".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("usb_auto_connect".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("owner_mob".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("owner_dob".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("umd_cache".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("owner_name".equals(name)) {
                ptype.setValue(3);
                psize.setValue(this.ownerName.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.ownerName);
                }
            } else if ("slide_welcome".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("first_boot_tick".equals(name)) {
                ptype.setValue(4);
                String firstBootTick = "";
                psize.setValue(firstBootTick.length());
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, firstBootTick);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/SYSTEM/SOUND".equals(fullName)) {
            if ("dynamic_normalizer".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("operation_sound_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("avls".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/SYSTEM/CHARACTER_SET".equals(fullName)) {
            if ("oem".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(5);
                }
            } else if ("ansi".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(19);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/SYSTEM/XMB".equals(fullName)) {
            if ("language".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(sceUtility.getSystemParamLanguage());
                }
            } else if ("button_assign".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(sceUtility.getSystemParamButtonPreference());
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/SYSTEM/XMB/THEME".equals(fullName)) {
            if ("wallpaper_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(settings.readInt("registry.theme.wallpaper_mode", 0));
                }
            } else if ("custom_theme_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(settings.readInt("registry.theme.custom_theme_mode", 0));
                }
            } else if ("color_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(settings.readInt("registry.theme.color_mode", 0));
                }
            } else if ("system_color".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(settings.readInt("registry.theme.system_color", 0));
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/SYSPROFILE/RESOLUTION".equals(fullName)) {
            if ("horizontal".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(8210);
                }
            } else if ("vertical".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(8210);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/ALARM".equals(fullName)) {
            if (name.matches("alarm_\\d+_time")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(-1);
                }
            } else if (name.matches("alarm_\\d+_property")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/NETWORK/GO_MESSENGER".equals(fullName)) {
            if (name.equals("auth_name")) {
                ptype.setValue(3);
                psize.setValue(this.authName.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.authName);
                }
            } else if (name.equals("auth_key")) {
                ptype.setValue(3);
                psize.setValue(this.authKey.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.authKey);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/NETWORK/ADHOC".equals(fullName)) {
            if (name.equals("ssid_prefix")) {
                ptype.setValue(3);
                psize.setValue(this.adhocSsidPrefix.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.adhocSsidPrefix);
                }
            } else if (name.equals("channel")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(sceUtility.getSystemParamAdhocChannel());
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/NETWORK/INFRASTRUCTURE".equals(fullName)) {
            if ("latest_id".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.networkLatestId);
                }
            } else if (name.equals("eap_md5")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if (name.equals("auto_setting")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if (name.equals("wifisvc_setting")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if (fullName.matches("/CONFIG/NETWORK/INFRASTRUCTURE/\\d+")) {
            String indexName = fullName.replace("/CONFIG/NETWORK/INFRASTRUCTURE/", "");
            int index = Integer.parseInt(indexName);
            if ("cnf_name".equals(name)) {
                ptype.setValue(3);
                String cnfName = sceUtility.getNetParamName(index);
                psize.setValue(cnfName.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, cnfName);
                }
            } else if ("ssid".equals(name)) {
                ptype.setValue(3);
                String ssid = sceNetApctl.getSSID();
                if (ssid.length() > 32) {
                    ssid = ssid.substring(0, 32);
                }
                psize.setValue(ssid.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, ssid);
                }
            } else if ("auth_proto".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("wep_key".equals(name)) {
                ptype.setValue(4);
                String wepKey = "XXXXXXXXXXXXX";
                psize.setValue(wepKey.length());
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, wepKey);
                }
            } else if ("how_to_set_ip".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("dns_flag".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("primary_dns".equals(name)) {
                ptype.setValue(3);
                String dns = sceNetApctl.getPrimaryDNS();
                psize.setValue(dns.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, dns);
                }
            } else if ("secondary_dns".equals(name)) {
                ptype.setValue(3);
                String dns = sceNetApctl.getSecondaryDNS();
                psize.setValue(dns.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, dns);
                }
            } else if ("http_proxy_flag".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("http_proxy_server".equals(name)) {
                ptype.setValue(3);
                String httpProxyServer = "";
                psize.setValue(httpProxyServer.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, httpProxyServer);
                }
            } else if ("http_proxy_port".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(80);
                }
            } else if ("version".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(2);
                }
            } else if ("auth_8021x_type".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("browser_flag".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("ip_address".equals(name)) {
                ptype.setValue(3);
                String ip = sceNetApctl.getLocalHostIP();
                psize.setValue(ip.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, ip);
                }
            } else if ("netmask".equals(name)) {
                ptype.setValue(3);
                String netmask = sceNetApctl.getSubnetMask();
                psize.setValue(netmask.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, netmask);
                }
            } else if ("default_route".equals(name)) {
                ptype.setValue(3);
                String gateway = sceNetApctl.getGateway();
                psize.setValue(gateway.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, gateway);
                }
            } else if (name.equals("device")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if (name.equals("auth_name")) {
                ptype.setValue(3);
                psize.setValue(this.authName.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.authName);
                }
            } else if (name.equals("auth_key")) {
                ptype.setValue(3);
                psize.setValue(this.authKey.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.authKey);
                }
            } else if (name.equals("auth_8021x_auth_name")) {
                ptype.setValue(3);
                psize.setValue(this.authName.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.authName);
                }
            } else if (name.equals("auth_8021x_auth_key")) {
                ptype.setValue(3);
                psize.setValue(this.authKey.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.authKey);
                }
            } else if ("wpa_key_type".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if (name.equals("wpa_key")) {
                ptype.setValue(4);
                String wpaKey = "";
                psize.setValue(wpaKey.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, wpaKey);
                }
            } else if ("wifisvc_config".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if (fullName.matches("/CONFIG/NETWORK/INFRASTRUCTURE/\\d+/SUB1")) {
            String indexName = fullName.replace("/CONFIG/NETWORK/INFRASTRUCTURE/", "");
            int index = Integer.parseInt(indexName.substring(0, indexName.indexOf("/")));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("/CONFIG/NETWORK/INFRASTRUCTURE, index=%d, SUB1", index));
            }
            if ("last_leased_dhcp_addr".equals(name)) {
                ptype.setValue(3);
                String lastLeasedDhcpAddr = "";
                psize.setValue(lastLeasedDhcpAddr.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, lastLeasedDhcpAddr);
                }
            } else if (name.equals("wifisvc_auth_name")) {
                ptype.setValue(3);
                psize.setValue(this.authName.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.authName);
                }
            } else if (name.equals("wifisvc_auth_key")) {
                ptype.setValue(3);
                psize.setValue(this.authKey.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.authKey);
                }
            } else if (name.equals("wifisvc_option")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if (name.equals("bt_id")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if (name.equals("at_command")) {
                ptype.setValue(3);
                String atCommand = "";
                psize.setValue(atCommand.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, atCommand);
                }
            } else if (name.equals("phone_number")) {
                ptype.setValue(3);
                String phoneNumber = "";
                psize.setValue(phoneNumber.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, phoneNumber);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/DATA/COUNT".equals(fullName)) {
            if ("wifi_connect_count".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.wifiConnectCount);
                }
            } else if (name.equals("usb_connect_count")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.usbConnectCount);
                }
            } else if (name.equals("psn_access_count")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.psnAccountCount);
                }
            } else if (name.equals("slide_count")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.slideCount);
                }
            } else if (name.equals("boot_count")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.bootCount);
                }
            } else if (name.equals("game_exec_count")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.gameExecCount);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/SYSTEM/LOCK".equals(fullName)) {
            if ("parental_level".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("browser_start".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("password".equals(name)) {
                ptype.setValue(4);
                psize.setValue(this.lockPassword.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, this.lockPassword);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/SYSTEM/POWER_SAVING".equals(fullName)) {
            if ("backlight_off_interval".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("suspend_interval".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("wlan_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("active_backlight_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/TOOL/CONFIG".equals(fullName)) {
            if ("np_debug".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/REGISTRY".equals(fullName)) {
            if ("category_version".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.getRegistryCategoryVersion());
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/OSK".equals(fullName)) {
            if ("version_id".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.oskVersionId);
                }
            } else if (name.equals("disp_locale")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.oskDispLocale);
                }
            } else if (name.equals("writing_locale")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.oskWritingLocale);
                }
            } else if (name.equals("input_char_mask")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.oskInputCharMask);
                }
            } else if (name.equals("keytop_index")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.oskKeytopIndex);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/MUSIC".equals(fullName)) {
            if ("visualizer_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.musicVisualizerMode);
                }
            } else if (name.equals("track_info_mode")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(this.musicTrackInfoMode);
                }
            } else if (name.equals("wma_play")) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/PHOTO".equals(fullName)) {
            if ("slideshow_speed".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/VIDEO".equals(fullName)) {
            if ("lr_button_enable".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("list_play_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("title_display_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("sound_language".equals(name)) {
                ptype.setValue(4);
                psize.setValue(2);
                if (size >= 2) {
                    buf.setValue8(0, (byte)48);
                    buf.setValue8(1, (byte)48);
                }
            } else if ("subtitle_language".equals(name)) {
                ptype.setValue(4);
                psize.setValue(2);
                if (size >= 2) {
                    buf.setValue8(0, (byte)101);
                    buf.setValue8(1, (byte)110);
                }
            } else if ("menu_language".equals(name)) {
                ptype.setValue(4);
                psize.setValue(2);
                if (size >= 2) {
                    buf.setValue8(0, (byte)101);
                    buf.setValue8(1, (byte)110);
                }
            } else if ("appended_volume".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/INFOBOARD".equals(fullName)) {
            if ("locale_lang".equals(name)) {
                String localeLang = "en/en/rss.xml";
                ptype.setValue(3);
                psize.setValue(localeLang.length() + 1);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, localeLang);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/CAMERA".equals(fullName)) {
            if ("still_size".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("still_quality".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("movie_size".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("movie_quality".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("white_balance".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("exposure_bias".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("still_effect".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("file_folder".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(101);
                }
            } else if ("file_number".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("movie_fps".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("shutter_sound_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("file_number_eflash".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(1);
                }
            } else if ("folder_number_eflash".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(101);
                }
            } else if ("msid".equals(name)) {
                String msid = "";
                ptype.setValue(4);
                psize.setValue(16);
                if (size > 0) {
                    Utilities.writeStringNZ(buf.getMemory(), buf.getAddress(), size, msid);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/RSS".equals(fullName)) {
            if ("download_items".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(5);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/DISPLAY".equals(fullName)) {
            if ("color_space_mode".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else if ("screensaver_start_time".equals(name)) {
                ptype.setValue(2);
                psize.setValue(4);
                if (size >= 4) {
                    buf.setValue32(0);
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else {
            log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
        }
        return 0;
    }

    private int getRegistryCategoryVersion() {
        int firmwareVersion = RuntimeContextLLE.getFirmwareVersion();
        if (firmwareVersion <= 152) {
            return 1;
        }
        if (firmwareVersion <= 201) {
            return 6;
        }
        if (firmwareVersion <= 250) {
            return 19;
        }
        if (firmwareVersion <= 260) {
            return 20;
        }
        if (firmwareVersion <= 271) {
            return 27;
        }
        if (firmwareVersion <= 282) {
            return 32;
        }
        if (firmwareVersion <= 303) {
            return 38;
        }
        if (firmwareVersion <= 311) {
            return 44;
        }
        if (firmwareVersion <= 340) {
            return 49;
        }
        if (firmwareVersion <= 352) {
            return 53;
        }
        if (firmwareVersion <= 360) {
            return 54;
        }
        if (firmwareVersion <= 373) {
            return 59;
        }
        if (firmwareVersion <= 393) {
            return 62;
        }
        if (firmwareVersion <= 401) {
            return 64;
        }
        if (firmwareVersion <= 405) {
            return 67;
        }
        if (firmwareVersion <= 505) {
            return 76;
        }
        if (firmwareVersion <= 555) {
            return 88;
        }
        if (firmwareVersion <= 570) {
            return 97;
        }
        if (firmwareVersion <= 610) {
            return 99;
        }
        if (firmwareVersion <= 620) {
            return 100;
        }
        return 102;
    }

    private void createEmptyRegistry() {
        int i;
        Settings settings = Settings.getInstance();
        Registry registry = new Registry(256, 256);
        int index = registry.addDirectory(RegistryDirectoryHeader.NO_PARENT, "REGISTRY", 1, 1);
        registry.addKey(index, "category_version", this.getRegistryCategoryVersion());
        index = registry.addDirectory(RegistryDirectoryHeader.NO_PARENT, "CONFIG", 20, 2);
        registry.addKey(index, "VIDEO");
        registry.addKey(index, "PHOTO");
        registry.addKey(index, "MUSIC");
        registry.addKey(index, "BROWSER");
        registry.addKey(index, "LFTV");
        registry.addKey(index, "RSS");
        registry.addKey(index, "ALARM");
        registry.addKey(index, "PREMO");
        registry.addKey(index, "CAMERA");
        registry.addKey(index, "DISPLAY");
        registry.addKey(index, "NP");
        registry.addKey(index, "ONESEG");
        registry.addKey(index, "SYSTEM");
        registry.addKey(index, "DATE");
        registry.addKey(index, "NETWORK");
        registry.addKey(index, "BROWSER2");
        registry.addKey(index, "OSK");
        registry.addKey(index, "INFOBOARD");
        registry.addKey(index, "BT");
        registry.addKey(index, "GAME");
        int parent = index;
        index = registry.addDirectory(parent, "BROWSER2", 4, 1);
        registry.addKey(index, "tm_service", 0);
        registry.addKey(index, "tm_ec_ttl", 0);
        registry.addKey(index, "tm_ec_ttl_update_time", new byte[8]);
        registry.addKey(index, "tm_service_sub_status", 0);
        index = registry.addDirectory(parent, "VIDEO", 9, 1);
        registry.addKey(index, "menu_language", "en".getBytes(Constants.charset));
        registry.addKey(index, "sound_language", "00".getBytes(Constants.charset));
        registry.addKey(index, "subtitle_language", "en".getBytes(Constants.charset));
        registry.addKey(index, "appended_volume", 0);
        registry.addKey(index, "lr_button_enable", 1);
        registry.addKey(index, "list_play_mode", 1);
        registry.addKey(index, "title_display_mode", 0);
        registry.addKey(index, "output_ext_menu", 0);
        registry.addKey(index, "output_ext_func", 0);
        index = registry.addDirectory(parent, "NP", 15, 2);
        registry.addKey(index, "env", this.npEnv, 32);
        registry.addKey(index, "account_id", this.npAccountId.getBytes(Constants.charset), 16);
        registry.addKey(index, "login_id", this.npLoginId, 96);
        registry.addKey(index, "password", this.npPassword, 32);
        registry.addKey(index, "auto_sign_in_enable", this.npAutoSignInEnable);
        registry.addKey(index, "nav_only", 0);
        registry.addKey(index, "np_ad_clock_diff", 0);
        registry.addKey(index, "view_mode", 0);
        registry.addKey(index, "np_geo_filtering", 0);
        registry.addKey(index, "guest_country", "", 32);
        registry.addKey(index, "guest_lang", "", 32);
        registry.addKey(index, "guest_yob", 0);
        registry.addKey(index, "guest_mob", 0);
        registry.addKey(index, "guest_dob", 0);
        registry.addKey(index, "check_drm", 0);
        index = registry.addDirectory(parent, "PHOTO", 1, 1);
        registry.addKey(index, "slideshow_speed", 1);
        index = registry.addDirectory(parent, "BT", 9, 1);
        registry.addKey(index, "connect_mode", 0);
        for (i = 0; i < 8; ++i) {
            registry.addKey(index, String.format("DEVICE%d", i));
        }
        for (i = 0; i < 8; ++i) {
            int deviceIndex = registry.addDirectory(index, String.format("DEVICE%d", i), 3, 1);
            registry.addKey(deviceIndex, "audio_type", 1);
            registry.addKey(deviceIndex, "device_type", 0);
            registry.addKey(deviceIndex, "device_name", new byte[64]);
        }
        index = registry.addDirectory(parent, "MUSIC", 3, 1);
        registry.addKey(index, "wma_play", 1);
        registry.addKey(index, "visualizer_mode", this.musicVisualizerMode);
        registry.addKey(index, "track_info_mode", this.musicTrackInfoMode);
        index = registry.addDirectory(parent, "ALARM", 20, 2);
        for (i = 0; i < 10; ++i) {
            registry.addKey(index, String.format("alarm_%d_time", i), -1);
        }
        for (i = 0; i < 10; ++i) {
            registry.addKey(index, String.format("alarm_%d_property", i), 0);
        }
        index = registry.addDirectory(parent, "PREMO", 16, 2);
        registry.addKey(index, "guide_page", 1);
        registry.addKey(index, "response", 0);
        registry.addKey(index, "ps3_name", "", 128);
        registry.addKey(index, "ps3_mac", new byte[6]);
        registry.addKey(index, "ps3_keytype", 1);
        registry.addKey(index, "ps3_key", new byte[16]);
        registry.addKey(index, "custom_video_bitrate1", 1);
        registry.addKey(index, "custom_video_bitrate2", 1);
        registry.addKey(index, "custom_video_buffer1", 1);
        registry.addKey(index, "custom_video_buffer2", 1);
        registry.addKey(index, "setting_internet", 1);
        registry.addKey(index, "button_assign", 1);
        registry.addKey(index, "flags", 1);
        registry.addKey(index, "account_id", new byte[16]);
        registry.addKey(index, "login_id", "", 96);
        registry.addKey(index, "password", "", 32);
        index = registry.addDirectory(parent, "CAMERA", 15, 2);
        registry.addKey(index, "still_size", 1);
        registry.addKey(index, "movie_size", 1);
        registry.addKey(index, "still_quality", 0);
        registry.addKey(index, "movie_quality", 0);
        registry.addKey(index, "movie_fps", 1);
        registry.addKey(index, "white_balance", 0);
        registry.addKey(index, "exposure_bias", 0);
        registry.addKey(index, "shutter_sound_mode", 0);
        registry.addKey(index, "file_folder", 101);
        registry.addKey(index, "file_number", 1);
        registry.addKey(index, "msid", new byte[16]);
        registry.addKey(index, "still_effect", 0);
        registry.addKey(index, "medium_type", 0);
        registry.addKey(index, "file_number_eflash", 1);
        registry.addKey(index, "folder_number_eflash", 101);
        index = registry.addDirectory(parent, "ONESEG", 1, 1);
        registry.addKey(index, "schedule_data_key", new byte[16]);
        index = registry.addDirectory(parent, "RSS", 1, 1);
        registry.addKey(index, "download_items", 5);
        index = registry.addDirectory(parent, "OSK", 5, 1);
        registry.addKey(index, "version_id", this.oskVersionId);
        registry.addKey(index, "disp_locale", this.oskDispLocale);
        registry.addKey(index, "writing_locale", this.oskWritingLocale);
        registry.addKey(index, "input_char_mask", this.oskInputCharMask);
        registry.addKey(index, "keytop_index", this.oskKeytopIndex);
        index = registry.addDirectory(parent, "SYSTEM", 17, 2);
        registry.addKey(index, "owner_name", this.ownerName, 128);
        int backlightBrightness = 3;
        if (Model.getGeneration() == 11) {
            backlightBrightness = Math.min(backlightBrightness, 2);
        }
        registry.addKey(index, "backlight_brightness", backlightBrightness);
        registry.addKey(index, "umd_autoboot", 0);
        registry.addKey(index, "usb_charge", 1);
        registry.addKey(index, "umd_cache", 1);
        registry.addKey(index, "usb_auto_connect", 1);
        registry.addKey(index, "XMB");
        registry.addKey(index, "SOUND");
        registry.addKey(index, "POWER_SAVING");
        registry.addKey(index, "LOCK");
        registry.addKey(index, "CHARACTER_SET");
        registry.addKey(index, "slide_action", 0);
        registry.addKey(index, "first_boot_tick", new byte[64]);
        registry.addKey(index, "owner_mob", 0);
        registry.addKey(index, "owner_dob", 0);
        registry.addKey(index, "slide_welcome", 0);
        registry.addKey(index, "exh_mode", 0);
        int parentSystem = index;
        index = registry.addDirectory(parentSystem, "XMB", 4, 1);
        registry.addKey(index, "theme_type", 0);
        registry.addKey(index, "language", 1);
        registry.addKey(index, "button_assign", 1);
        registry.addKey(index, "THEME");
        int parentXmb = index;
        index = registry.addDirectory(parentXmb, "THEME", 4, 1);
        registry.addKey(index, "color_mode", settings.readInt("registry.theme.color_mode", 0));
        registry.addKey(index, "wallpaper_mode", settings.readInt("registry.theme.wallpaper_mode", 0));
        registry.addKey(index, "system_color", settings.readInt("registry.theme.system_color", 0));
        registry.addKey(index, "custom_theme_mode", settings.readInt("registry.theme.custom_theme_mode", 0));
        index = registry.addDirectory(parentSystem, "POWER_SAVING", 4, 1);
        registry.addKey(index, "suspend_interval", 600);
        registry.addKey(index, "backlight_off_interval", 300);
        registry.addKey(index, "wlan_mode", 0);
        registry.addKey(index, "active_backlight_mode", 0);
        index = registry.addDirectory(parentSystem, "LOCK", 3, 1);
        registry.addKey(index, "password", this.lockPassword.getBytes(Constants.charset));
        registry.addKey(index, "parental_level", 0);
        registry.addKey(index, "browser_start", 0);
        index = registry.addDirectory(parentSystem, "CHARACTER_SET", 2, 1);
        registry.addKey(index, "oem", 5);
        registry.addKey(index, "ansi", 19);
        index = registry.addDirectory(parentSystem, "SOUND", 6, 1);
        registry.addKey(index, "main_volume", 22);
        registry.addKey(index, "mute", 0);
        registry.addKey(index, "avls", 0);
        registry.addKey(index, "equalizer_mode", 0);
        registry.addKey(index, "operation_sound_mode", 1);
        registry.addKey(index, "dynamic_normalizer", 0);
        index = registry.addDirectory(parent, "INFOBOARD", 2, 1);
        registry.addKey(index, "locale_lang", "en/en/rss.xml", 16);
        registry.addKey(index, "qa_server", 0);
        index = registry.addDirectory(parent, "DATE", 5, 1);
        registry.addKey(index, "time_format", settings.readInt("registry.time_format", 0));
        registry.addKey(index, "date_format", settings.readInt("registry.date_format", 2));
        registry.addKey(index, "summer_time", settings.readInt("registry.summer_time", 0));
        registry.addKey(index, "time_zone_offset", settings.readInt("registry.time_zone_offset", 0));
        registry.addKey(index, "time_zone_area", settings.readString("registry.time_zone_area", "united_kingdom"), 64);
        index = registry.addDirectory(parent, "GAME", 3, 1);
        registry.addKey(index, "hibernation_ow_guide", 1);
        registry.addKey(index, "hibernation_op_guide", 1);
        registry.addKey(index, "subs_expiration_guide", 1);
        index = registry.addDirectory(parent, "DISPLAY", 5, 1);
        registry.addKey(index, "aspect_ratio", 0);
        registry.addKey(index, "scan_mode", 0);
        registry.addKey(index, "screensaver_start_time", 600);
        registry.addKey(index, "color_space_mode", 0);
        registry.addKey(index, "pi_blending_mode", 1);
        index = registry.addDirectory(parent, "LFTV", 32, 4);
        registry.addKey(index, "easy_reg_done", 0);
        registry.addKey(index, "netav_domain_name", "", 256);
        registry.addKey(index, "netav_ip_address", "", 32);
        registry.addKey(index, "netav_port_no_home", 5021);
        registry.addKey(index, "netav_port_no_away", 5021);
        registry.addKey(index, "netav_nonce", "", 64);
        registry.addKey(index, "base_station_version", "0.000", 32);
        registry.addKey(index, "base_station_region", 0);
        registry.addKey(index, "tuner_type", 0);
        registry.addKey(index, "input_line", 0);
        registry.addKey(index, "tv_channel", 0);
        registry.addKey(index, "bitrate_home", 0);
        registry.addKey(index, "bitrate_away", 0);
        registry.addKey(index, "channel_setting_jp", new byte[24]);
        registry.addKey(index, "channel_setting_us", new byte[68]);
        registry.addKey(index, "channel_setting_us_catv", new byte[125]);
        registry.addKey(index, "overwrite_netav_setting", 1);
        registry.addKey(index, "screen_mode", 0);
        registry.addKey(index, "remocon_setting_region", 0);
        registry.addKey(index, "remocon_setting", new byte[96]);
        registry.addKey(index, "remocon_setting_revision", "0000.00", 32);
        registry.addKey(index, "external_tuner_channel", 0);
        registry.addKey(index, "ssid", "", 64);
        registry.addKey(index, "audio_gain", 0);
        registry.addKey(index, "broadcast_standard_video1", 0);
        registry.addKey(index, "broadcast_standard_video2", 0);
        registry.addKey(index, "version", 0);
        registry.addKey(index, "tv_channel_range", 0);
        registry.addKey(index, "tuner_type_no", 0);
        registry.addKey(index, "input_line_no", 0);
        registry.addKey(index, "audio_channel", 0);
        registry.addKey(index, "shared_remocon_setting", new byte[96]);
        index = registry.addDirectory(parent, "BROWSER", 19, 4);
        registry.addKey(index, "home_uri", this.browserHomeUri, 512, 1024);
        registry.addKey(index, "cookie_mode", 1);
        registry.addKey(index, "proxy_mode", 2);
        registry.addKey(index, "proxy_address", "", 128, 128);
        registry.addKey(index, "proxy_port", 0);
        registry.addKey(index, "picture", 1);
        registry.addKey(index, "animation", 0);
        registry.addKey(index, "javascript", 1);
        registry.addKey(index, "cache_size", 512);
        registry.addKey(index, "char_size", 1);
        registry.addKey(index, "disp_mode", 0);
        registry.addKey(index, "connect_mode", 0);
        registry.addKey(index, "flash_activated", 1);
        registry.addKey(index, "flash_play", 1);
        registry.addKey(index, "proxy_protect", 0);
        registry.addKey(index, "proxy_autoauth", 0);
        registry.addKey(index, "proxy_user", "", 128, 128);
        registry.addKey(index, "proxy_password", "", 128, 128);
        registry.addKey(index, "webpage_quality", 1);
        index = registry.addDirectory(parent, "NETWORK", 3, 1);
        registry.addKey(index, "ADHOC");
        registry.addKey(index, "INFRASTRUCTURE");
        registry.addKey(index, "GO_MESSENGER");
        int parentNetwork = index;
        index = registry.addDirectory(parentNetwork, "INFRASTRUCTURE", 6, 1);
        registry.addKey(index, "latest_id", this.networkLatestId);
        registry.addKey(index, "eap_md5", 0);
        registry.addKey(index, "auto_setting", 2);
        registry.addKey(index, "wifisvc_setting", 0);
        registry.addKey(index, "btdun_warnings_check", 0);
        registry.addKey(index, "0");
        int parentInfrastructure = index;
        index = registry.addDirectory(parentInfrastructure, "0", 26, 4);
        registry.addKey(index, "SUB1");
        registry.addKey(index, "version", 5);
        registry.addKey(index, "device", 1);
        registry.addKey(index, "cnf_name", "", 64);
        registry.addKey(index, "ssid", "", 64);
        registry.addKey(index, "auth_proto", 0);
        registry.addKey(index, "wep_key", new byte[5]);
        registry.addKey(index, "how_to_set_ip", 0);
        registry.addKey(index, "ip_address", "", 32);
        registry.addKey(index, "netmask", "", 32);
        registry.addKey(index, "default_route", "", 32);
        registry.addKey(index, "dns_flag", 0);
        registry.addKey(index, "primary_dns", "", 32);
        registry.addKey(index, "secondary_dns", "", 32);
        registry.addKey(index, "auth_name", this.authName, 128);
        registry.addKey(index, "auth_key", this.authKey, 128);
        registry.addKey(index, "http_proxy_flag", 0);
        registry.addKey(index, "http_proxy_server", "", 128);
        registry.addKey(index, "http_proxy_port", 8080);
        registry.addKey(index, "auth_8021x_type", 0);
        registry.addKey(index, "auth_8021x_auth_name", this.authName, 128);
        registry.addKey(index, "auth_8021x_auth_key", this.authKey, 128);
        registry.addKey(index, "wpa_key_type", 0);
        registry.addKey(index, "wpa_key", new byte[64]);
        registry.addKey(index, "browser_flag", 0);
        registry.addKey(index, "wifisvc_config", 0);
        int parent0 = index;
        index = registry.addDirectory(parent0, "SUB1", 7, 2);
        registry.addKey(index, "wifisvc_auth_name", this.authName, 128);
        registry.addKey(index, "wifisvc_auth_key", this.authKey, 128);
        registry.addKey(index, "wifisvc_option", 0);
        registry.addKey(index, "last_leased_dhcp_addr", "", 32);
        registry.addKey(index, "bt_id", 0);
        registry.addKey(index, "at_command", "", 96);
        registry.addKey(index, "phone_number", "", 64);
        for (int i2 = 1; i2 <= 2; ++i2) {
            index = registry.addDirectory(parentInfrastructure, Integer.toString(i2), 26, 4);
            registry.addKey(index, "SUB1");
            registry.addKey(index, "version", 5);
            registry.addKey(index, "device", 1);
            registry.addKey(index, "cnf_name", String.format("Jpcsp %d", i2), 64);
            registry.addKey(index, "ssid", String.format("Jpcsp SSID %d", i2), 64);
            registry.addKey(index, "auth_proto", 0);
            registry.addKey(index, "wep_key", new byte[5]);
            registry.addKey(index, "how_to_set_ip", 0);
            registry.addKey(index, "ip_address", "", 32);
            registry.addKey(index, "netmask", "", 32);
            registry.addKey(index, "default_route", "", 32);
            registry.addKey(index, "dns_flag", 0);
            registry.addKey(index, "primary_dns", "", 32);
            registry.addKey(index, "secondary_dns", "", 32);
            registry.addKey(index, "auth_name", this.authName, 128);
            registry.addKey(index, "auth_key", this.authKey, 128);
            registry.addKey(index, "http_proxy_flag", 0);
            registry.addKey(index, "http_proxy_server", "", 128);
            registry.addKey(index, "http_proxy_port", 8080);
            registry.addKey(index, "auth_8021x_type", 0);
            registry.addKey(index, "auth_8021x_auth_name", this.authName, 128);
            registry.addKey(index, "auth_8021x_auth_key", this.authKey, 128);
            registry.addKey(index, "wpa_key_type", 0);
            registry.addKey(index, "wpa_key", new byte[64]);
            registry.addKey(index, "browser_flag", 0);
            registry.addKey(index, "wifisvc_config", 0);
            int parentN = index;
            index = registry.addDirectory(parentN, "SUB1", 7, 2);
            registry.addKey(index, "wifisvc_auth_name", this.authName, 128);
            registry.addKey(index, "wifisvc_auth_key", this.authKey, 128);
            registry.addKey(index, "wifisvc_option", 0);
            registry.addKey(index, "last_leased_dhcp_addr", "", 32);
            registry.addKey(index, "bt_id", 0);
            registry.addKey(index, "at_command", "", 96);
            registry.addKey(index, "phone_number", "", 64);
        }
        index = registry.addDirectory(parentNetwork, "GO_MESSENGER", 2, 1);
        registry.addKey(index, "auth_name", this.authName, 64, 64);
        registry.addKey(index, "auth_key", this.authKey, 64, 64);
        index = registry.addDirectory(parentNetwork, "ADHOC", 2, 1);
        registry.addKey(index, "channel", 0);
        registry.addKey(index, "ssid_prefix", this.adhocSsidPrefix, 32);
        index = registry.addDirectory(RegistryDirectoryHeader.NO_PARENT, "DATA", 2, 1);
        registry.addKey(index, "FONT");
        registry.addKey(index, "COUNT");
        List<sceFont.FontRegistryEntry> fontRegistry = Modules.sceFontModule.getFontRegistry();
        parent = index;
        index = registry.addDirectory(parent, "FONT", 3, 1);
        registry.addKey(index, "path_name", Modules.sceFontModule.getFontDirPath(), 64);
        registry.addKey(index, "num_fonts", fontRegistry.size());
        registry.addKey(index, "PROPERTY");
        int parentFont = index;
        index = registry.addDirectory(parentFont, "PROPERTY", fontRegistry.size(), 2);
        for (int i3 = 0; i3 < fontRegistry.size(); ++i3) {
            registry.addKey(index, String.format("INFO%d", i3));
        }
        int parentProperty = index;
        for (int i4 = 0; i4 < fontRegistry.size(); ++i4) {
            sceFont.FontRegistryEntry fontRegistryEntry = fontRegistry.get(i4);
            index = registry.addDirectory(parentProperty, String.format("INFO%d", i4), 16, 2);
            registry.addKey(index, "h_size", fontRegistryEntry.h_size);
            registry.addKey(index, "v_size", fontRegistryEntry.v_size);
            registry.addKey(index, "h_resolution", fontRegistryEntry.h_resolution);
            registry.addKey(index, "v_resolution", fontRegistryEntry.v_resolution);
            registry.addKey(index, "extra_attributes", fontRegistryEntry.extra_attributes);
            registry.addKey(index, "weight", fontRegistryEntry.weight);
            registry.addKey(index, "family_code", fontRegistryEntry.family_code);
            registry.addKey(index, "style", fontRegistryEntry.style);
            registry.addKey(index, "sub_style", fontRegistryEntry.sub_style);
            registry.addKey(index, "language_code", fontRegistryEntry.language_code);
            registry.addKey(index, "region_code", fontRegistryEntry.region_code);
            registry.addKey(index, "country_code", fontRegistryEntry.country_code);
            registry.addKey(index, "font_name", fontRegistryEntry.font_name, 64);
            registry.addKey(index, "file_name", fontRegistryEntry.file_name, 64);
            registry.addKey(index, "expire_date", fontRegistryEntry.expire_date);
            registry.addKey(index, "shadow_option", fontRegistryEntry.shadow_option);
        }
        index = registry.addDirectory(parent, "COUNT", 6, 1);
        registry.addKey(index, "boot_count", 0);
        registry.addKey(index, "game_exec_count", this.gameExecCount);
        registry.addKey(index, "slide_count", 0);
        registry.addKey(index, "usb_connect_count", this.usbConnectCount);
        registry.addKey(index, "wifi_connect_count", this.wifiConnectCount);
        registry.addKey(index, "psn_access_count", 0);
        index = registry.addDirectory(RegistryDirectoryHeader.NO_PARENT, "SYSPROFILE", 2, 1);
        registry.addKey(index, "sound_reduction", 0);
        registry.addKey(index, "RESOLUTION");
        parent = index;
        index = registry.addDirectory(parent, "RESOLUTION", 2, 1);
        registry.addKey(index, "horizontal", 8210);
        registry.addKey(index, "vertical", 8210);
        registry.save(iregFileName, dregFileName);
    }

    @Override
    public void start() {
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e);
        }
        this.registryHandles = new HashMap<Integer, RegistryHandle>();
        this.categoryHandles = new HashMap<Integer, CategoryHandle>();
        this.keyHandles = new HashMap<Integer, KeyHandle>();
        Settings settings = Settings.getInstance();
        this.authName = "";
        this.authKey = "";
        this.networkLatestId = 0;
        this.wifiConnectCount = 0;
        this.usbConnectCount = 0;
        this.gameExecCount = 0;
        this.oskVersionId = 550;
        this.oskDispLocale = 1;
        this.oskWritingLocale = 1;
        this.oskInputCharMask = 15;
        this.oskKeytopIndex = 5;
        this.npEnv = "np";
        this.adhocSsidPrefix = "PSP";
        this.musicVisualizerMode = 0;
        this.musicTrackInfoMode = 1;
        this.lockPassword = "0000";
        this.browserHomeUri = "";
        this.npAccountId = settings.readString("registry.npAccountId");
        this.npLoginId = settings.readString("registry.npLoginId");
        this.npPassword = settings.readString("registry.npPassword");
        this.npAutoSignInEnable = settings.readInt("registry.npAutoSignInEnable");
        this.ownerName = sceUtility.getSystemParamNickname();
        byte[] ireg = Utilities.readCompleteFile(iregFileName);
        byte[] dreg = Utilities.readCompleteFile(dregFileName);
        if (ireg != null && dreg != null) {
            this.registry = new Registry(ireg, dreg);
            this.registry.dump();
        } else {
            this.createEmptyRegistry();
        }
        super.start();
    }

    @HLEFunctions(value={@HLEFunction(nid=-1830546816, version=150), @HLEFunction(nid=-609982716, version=660)})
    public int sceRegOpenRegistry(TPointer reg, int mode, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 h) {
        int regType = reg.getValue32(0);
        int nameLen = reg.getValue32(260);
        int unknown1 = reg.getValue32(264);
        int unknown2 = reg.getValue32(268);
        String name = Utilities.readStringNZ(reg.getAddress() + 4, nameLen);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("RegParam: regType=%d, name='%s'(len=%d), unknown1=%d, unknown2=%d", regType, name, nameLen, unknown1, unknown2));
        }
        RegistryHandle registryHandle = new RegistryHandle(regType, name, unknown1, unknown2);
        this.registryHandles.put(registryHandle.uid, registryHandle);
        h.setValue(registryHandle.uid);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-91596999, version=150), @HLEFunction(nid=1238859109, version=660)})
    public int sceRegCloseRegistry(int h) {
        RegistryHandle registryHandle = this.registryHandles.get(h);
        if (registryHandle == null) {
            return -1;
        }
        registryHandle.release();
        this.registryHandles.remove(h);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-556100929, version=150)
    public int sceRegRemoveRegistry(TPointer reg) {
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=495613486, version=150), @HLEFunction(nid=1330058327, version=660)})
    public int sceRegOpenCategory(int h, String name, int mode, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 hd) {
        RegistryHandle registryHandle = this.registryHandles.get(h);
        if (registryHandle == null) {
            return -1;
        }
        CategoryHandle categoryHandle = new CategoryHandle(registryHandle, name, mode);
        this.categoryHandles.put(categoryHandle.uid, categoryHandle);
        hd.setValue(categoryHandle.uid);
        if (categoryHandle.getFullName().startsWith("/system/DATA/FONT/PROPERTY/INFO")) {
            List<sceFont.FontRegistryEntry> fontRegistry = Modules.sceFontModule.getFontRegistry();
            int index = Integer.parseInt(categoryHandle.getFullName().substring(31));
            if ((index < 0 || index >= fontRegistry.size()) && mode != 1) {
                return -2146949352;
            }
        } else if (categoryHandle.getFullName().startsWith("flash2/registry/system/CONFIG/NETWORK/INFRASTRUCTURE/")) {
            int index;
            String indexString = categoryHandle.getFullName().substring(53);
            int sep = indexString.indexOf(47);
            if (sep >= 0) {
                indexString = indexString.substring(0, sep);
            }
            if ((index = Integer.parseInt(indexString)) > 10) {
                return -2146949352;
            }
        }
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=212763435, version=150), @HLEFunction(nid=-59496623, version=660)})
    public int sceRegCloseCategory(int hd) {
        CategoryHandle categoryHandle = this.categoryHandles.get(hd);
        if (categoryHandle == null) {
            return -1;
        }
        categoryHandle.release();
        this.categoryHandles.remove(hd);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=960895821, version=150), @HLEFunction(nid=1607759434, version=660)})
    public int sceRegFlushRegistry(int h) {
        RegistryHandle registryHandle = this.registryHandles.get(h);
        if (registryHandle == null) {
            return -1;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=225034048, version=150), @HLEFunction(nid=-683432440, version=660)})
    public int sceRegFlushCategory(int hd) {
        CategoryHandle categoryHandle = this.categoryHandles.get(hd);
        if (categoryHandle == null) {
            return -1;
        }
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=1466178177, version=150), @HLEFunction(nid=996975078, version=660)})
    public int sceRegCreateKey(int hd, String name, int type, int size) {
        CategoryHandle categoryHandle = this.categoryHandles.get(hd);
        if (categoryHandle == null) {
            return -1;
        }
        if (categoryHandle.getFullName().startsWith("/system/DATA/FONT/PROPERTY/INFO")) {
            List<sceFont.FontRegistryEntry> fontRegistry = Modules.sceFontModule.getFontRegistry();
            int index = Integer.parseInt(categoryHandle.getFullName().substring(31));
            if (index < 0 || index > fontRegistry.size()) {
                return -1;
            }
            if (index == fontRegistry.size()) {
                log.info((Object)String.format("sceRegCreateKey creating a new font entry '%s'", categoryHandle.getFullName()));
                sceFont.FontRegistryEntry entry = new sceFont.FontRegistryEntry();
                fontRegistry.add(entry);
                if (!("h_size".equals(name) && size >= 4 && type == 2 || "v_size".equals(name) && size >= 4 && type == 2 || "h_resolution".equals(name) && size >= 4 && type == 2 || "v_resolution".equals(name) && size >= 4 && type == 2 || "extra_attributes".equals(name) && size >= 4 && type == 2 || "weight".equals(name) && size >= 4 && type == 2 || "family_code".equals(name) && size >= 4 && type == 2 || "style".equals(name) && size >= 4 && type == 2 || "sub_style".equals(name) && size >= 4 && type == 2 || "language_code".equals(name) && size >= 4 && type == 2 || "region_code".equals(name) && size >= 4 && type == 2 || "country_code".equals(name) && size >= 4 && type == 2 || "file_name".equals(name) && size >= 0 && type == 3 || "font_name".equals(name) && size >= 0 && type == 3 || "expire_date".equals(name) && size >= 4 && type == 2 || "shadow_option".equals(name) && size >= 4 && type == 2)) {
                    log.warn((Object)String.format("Unknown font registry entry '%s' size=0x%X, type=%d", name, size, type));
                }
            }
        } else {
            log.warn((Object)String.format("Unknown registry entry '%s/%s'", categoryHandle.getFullName(), name));
        }
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=393645588, version=150), @HLEFunction(nid=1237778787, version=660)})
    public int sceRegSetKeyValue(int hd, String name, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer buf, int size) {
        CategoryHandle categoryHandle = this.categoryHandles.get(hd);
        if (categoryHandle == null) {
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("buf: %s", Utilities.getMemoryDump(buf.getAddress(), size)));
        }
        String fullName = categoryHandle.getFullName();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRegSetKeyValue fullName='%s/%s'", fullName, name));
        }
        fullName = fullName.replace("flash1:/registry/system", "");
        fullName = fullName.replace("flash1/registry/system", "");
        fullName = fullName.replace("flash2/registry/system", "");
        Settings settings = Settings.getInstance();
        if ("/system/DATA/FONT".equals(fullName)) {
            if ("path_name".equals(name)) {
                String fontDirPath = buf.getStringNZ(size);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Setting font dir path to '%s'", fontDirPath));
                }
                Modules.sceFontModule.setFontDirPath(fontDirPath);
            } else if ("num_fonts".equals(name) && size >= 4) {
                List<sceFont.FontRegistryEntry> fontRegistry = Modules.sceFontModule.getFontRegistry();
                int numFonts = buf.getValue32();
                if (numFonts != fontRegistry.size() && log.isInfoEnabled()) {
                    log.info((Object)String.format("Changing the number of fonts from %d to %d", fontRegistry.size(), numFonts));
                }
            } else {
                log.warn((Object)String.format("Unknown font registry entry '%s'", name));
            }
        } else if (fullName.startsWith("/system/DATA/FONT/PROPERTY/INFO")) {
            List<sceFont.FontRegistryEntry> fontRegistry = Modules.sceFontModule.getFontRegistry();
            int index = Integer.parseInt(fullName.substring(31));
            if (index < 0 || index >= fontRegistry.size()) {
                return -1;
            }
            sceFont.FontRegistryEntry entry = fontRegistry.get(index);
            if ("h_size".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else if ("v_size".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else if ("h_resolution".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else if ("v_resolution".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else if ("extra_attributes".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else if ("weight".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else if ("family_code".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else if ("style".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else if ("sub_style".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else if ("language_code".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else if ("region_code".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else if ("country_code".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else if ("file_name".equals(name)) {
                entry.file_name = buf.getStringNZ(size);
            } else if ("font_name".equals(name)) {
                entry.font_name = buf.getStringNZ(size);
            } else if ("expire_date".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else if ("shadow_option".equals(name) && size >= 4) {
                entry.h_size = buf.getValue32();
            } else {
                log.warn((Object)String.format("Unknown font registry entry '%s'", name));
            }
        } else if ("/DATA/COUNT".equals(fullName)) {
            if ("wifi_connect_count".equals(name) && size >= 4) {
                this.wifiConnectCount = buf.getValue32();
            } else if ("usb_connect_count".equals(name) && size >= 4) {
                this.usbConnectCount = buf.getValue32();
            } else if ("psn_access_count".equals(name) && size >= 4) {
                this.psnAccountCount = buf.getValue32();
            } else if ("slide_count".equals(name) && size >= 4) {
                this.slideCount = buf.getValue32();
            } else if ("boot_count".equals(name) && size >= 4) {
                this.bootCount = buf.getValue32();
            } else if ("game_exec_count".equals(name) && size >= 4) {
                this.gameExecCount = buf.getValue32();
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s'", name));
            }
        } else if ("/CONFIG/OSK".equals(fullName)) {
            if ("version_id".equals(name) && size >= 4) {
                this.oskVersionId = buf.getValue32();
            } else if (name.equals("disp_locale") && size >= 4) {
                this.oskDispLocale = buf.getValue32();
            } else if (name.equals("writing_locale") && size >= 4) {
                this.oskWritingLocale = buf.getValue32();
            } else if (name.equals("input_char_mask") && size >= 4) {
                this.oskInputCharMask = buf.getValue32();
            } else if (name.equals("keytop_index") && size >= 4) {
                this.oskKeytopIndex = buf.getValue32();
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s'", name));
            }
        } else if ("/CONFIG/NP".equals(fullName)) {
            if ("env".equals(name)) {
                this.npEnv = buf.getStringNZ(size);
            } else if ("account_id".equals(name)) {
                this.npAccountId = buf.getStringNZ(size);
                settings.writeString("registry.npAccountId", this.npAccountId);
            } else if ("login_id".equals(name)) {
                this.npLoginId = buf.getStringNZ(size);
                settings.writeString("registry.npLoginId", this.npLoginId);
            } else if ("password".equals(name)) {
                this.npPassword = buf.getStringNZ(size);
                settings.writeString("registry.npPassword", this.npPassword);
            } else if ("auto_sign_in_enable".equals(name) && size >= 4) {
                this.npAutoSignInEnable = buf.getValue32();
                settings.writeInt("registry.npAutoSignInEnable", this.npAutoSignInEnable);
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s'", name));
            }
        } else if ("/CONFIG/NETWORK/INFRASTRUCTURE".equals(fullName)) {
            if ("latest_id".equals(name) && size >= 4) {
                this.networkLatestId = buf.getValue32();
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if (fullName.matches("/CONFIG/NETWORK/INFRASTRUCTURE/\\d+")) {
            String indexName = fullName.replace("/CONFIG/NETWORK/INFRASTRUCTURE/", "");
            int index = Integer.parseInt(indexName);
            if ("cnf_name".equals(name)) {
                String cnfName = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set cnf_name#%d='%s'", index, cnfName));
                }
            } else if ("ssid".equals(name)) {
                String ssid = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set ssid#%d='%s'", index, ssid));
                }
            } else if ("auth_proto".equals(name) && size >= 4) {
                int authProto = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set auth_proto#%d='%s'", index, authProto));
                }
            } else if ("wep_key".equals(name)) {
                String wepKey = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set wep_key#%d='%s'", index, wepKey));
                }
            } else if ("how_to_set_ip".equals(name) && size >= 4) {
                int howToSetIp = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set how_to_set_ip#%d=%d", index, howToSetIp));
                }
            } else if ("ip_address".equals(name)) {
                String ipAddress = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set ip_address#%d='%s'", index, ipAddress));
                }
            } else if ("netmask".equals(name)) {
                String netmask = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set netmask#%d='%s'", index, netmask));
                }
            } else if ("default_route".equals(name)) {
                String defaultRoute = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set default_route#%d='%s'", index, defaultRoute));
                }
            } else if ("dns_flag".equals(name) && size >= 4) {
                int dnsFlag = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set dns_flag#%d=%d", index, dnsFlag));
                }
            } else if ("primary_dns".equals(name)) {
                String primaryDns = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set primary_dns#%d='%s'", index, primaryDns));
                }
            } else if ("secondary_dns".equals(name)) {
                String secondaryDns = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set secondary_dns#%d='%s'", index, secondaryDns));
                }
            } else if ("auth_name".equals(name)) {
                String authName = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set auth_name#%d='%s'", index, authName));
                }
            } else if ("auth_key".equals(name)) {
                String authKey = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set auth_key#%d='%s'", index, authKey));
                }
            } else if ("http_proxy_flag".equals(name) && size >= 4) {
                int httpProxyFlag = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set http_proxy_flag#%d=%d", index, httpProxyFlag));
                }
            } else if ("http_proxy_server".equals(name)) {
                String httpProxyServer = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set http_proxy_server#%d='%s'", index, httpProxyServer));
                }
            } else if ("http_proxy_port".equals(name) && size >= 4) {
                int httpProxyPort = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set http_proxy_port#%d=%d", index, httpProxyPort));
                }
            } else if ("version".equals(name) && size >= 4) {
                int version = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set version#%d=%d", index, version));
                }
            } else if ("device".equals(name) && size >= 4) {
                int device = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set device#%d=%d", index, device));
                }
            } else if ("auth_8021x_type".equals(name) && size >= 4) {
                int authType = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set auth_8021x_type#%d=%d", index, authType));
                }
            } else if ("auth_8021x_auth_name".equals(name)) {
                String authName = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set auth_8021x_auth_name#%d='%s'", index, authName));
                }
            } else if ("auth_8021x_auth_key".equals(name)) {
                String authKey = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set auth_8021x_auth_key#%d='%s'", index, authKey));
                }
            } else if ("wpa_key_type".equals(name) && size >= 4) {
                int wpaKeyType = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set wpa_key_type#%d=%d", index, wpaKeyType));
                }
            } else if ("wpa_key".equals(name)) {
                String wpaKey = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set wpa_key#%d='%s'", index, wpaKey));
                }
            } else if ("browser_flag".equals(name) && size >= 4) {
                int browserFlag = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set browser_flag#%d=%d", index, browserFlag));
                }
            } else if ("wifisvc_config".equals(name) && size >= 4) {
                int wifisvcConfig = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set wifisvc_config#%d=%d", index, wifisvcConfig));
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if (fullName.matches("/CONFIG/NETWORK/INFRASTRUCTURE/\\d+/SUB1")) {
            String indexName = fullName.replace("/CONFIG/NETWORK/INFRASTRUCTURE/", "");
            int index = Integer.parseInt(indexName.substring(0, indexName.indexOf("/")));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("/CONFIG/NETWORK/INFRASTRUCTURE, index=%d, SUB1", index));
            }
            if ("wifisvc_auth_name".equals(name)) {
                String authName = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set wifisvc_auth_name#%d='%s'", index, authName));
                }
            } else if ("wifisvc_auth_key".equals(name)) {
                String authKey = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set wifisvc_auth_key#%d='%s'", index, authKey));
                }
            } else if ("wifisvc_option".equals(name)) {
                int wifisvcOption = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set wifisvc_option#%d=%d", index, wifisvcOption));
                }
            } else if ("last_leased_dhcp_addr".equals(name)) {
                String lastLeasedDhcpAddr = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set last_leased_dhcp_addr#%d='%s'", index, lastLeasedDhcpAddr));
                }
            } else if ("bt_id".equals(name)) {
                int btId = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set bt_id#%d=%d", index, btId));
                }
            } else if ("at_command".equals(name)) {
                String atCommand = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set at_command#%d='%s'", index, atCommand));
                }
            } else if ("phone_number".equals(name)) {
                String phoneNumber = buf.getStringNZ(size);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("set phone_number#%d='%s'", index, phoneNumber));
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/NETWORK/ADHOC".equals(fullName)) {
            if ("ssid_prefix".equals(name)) {
                this.adhocSsidPrefix = buf.getStringNZ(size);
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s'", name));
            }
        } else if ("/CONFIG/SYSTEM".equals(fullName)) {
            if ("owner_name".equals(name)) {
                this.ownerName = buf.getStringNZ(size);
            }
        } else if ("/CONFIG/SYSTEM/XMB/THEME".equals(fullName)) {
            if ("custom_theme_mode".equals(name) && size >= 4) {
                settings.writeInt("registry.theme.custom_theme_mode", buf.getValue32());
            } else if ("color_mode".equals(name) && size >= 4) {
                settings.writeInt("registry.theme.color_mode", buf.getValue32());
            } else if ("wallpaper_mode".equals(name) && size >= 4) {
                settings.writeInt("registry.theme.wallpaper_mode", buf.getValue32());
            } else if ("system_color".equals(name) && size >= 4) {
                settings.writeInt("registry.theme.system_color", buf.getValue32());
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s'", name));
            }
        } else if ("/CONFIG/MUSIC".equals(fullName)) {
            if ("visualizer_mode".equals(name) && size >= 4) {
                this.musicVisualizerMode = buf.getValue32();
            } else if (name.equals("track_info_mode") && size >= 4) {
                this.musicTrackInfoMode = buf.getValue32();
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/CAMERA".equals(fullName)) {
            if ("msid".equals(name) && size >= 0) {
                String msid = buf.getStringNZ(16);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceRegSetKeyValue msid='%s'", msid));
                }
            } else if (name.equals("file_folder") && size >= 4) {
                int fileFolder = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceRegSetKeyValue fileFolder=0x%X", fileFolder));
                }
            } else if (name.equals("file_number") && size >= 4) {
                int fileNumber = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceRegSetKeyValue fileNumber=0x%X", fileNumber));
                }
            } else if (name.equals("movie_quality") && size >= 4) {
                int movieQuality = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceRegSetKeyValue movieQuality=0x%X", movieQuality));
                }
            } else if (name.equals("movie_size") && size >= 4) {
                int movieSize = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceRegSetKeyValue movieSize=0x%X", movieSize));
                }
            } else if (name.equals("movie_fps") && size >= 4) {
                int movieFps = buf.getValue32();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceRegSetKeyValue movieFps=0x%X", movieFps));
                }
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/DATE".equals(fullName)) {
            if ("date_format".equals(name)) {
                settings.writeInt("registry.date_format", buf.getValue32());
            } else if ("time_format".equals(name)) {
                settings.writeInt("registry.time_format", buf.getValue32());
            } else if ("time_zone_offset".equals(name)) {
                settings.writeInt("registry.time_zone_offset", buf.getValue32());
            } else if ("time_zone_area".equals(name)) {
                settings.writeString("registry.time_zone_area", buf.getStringZ());
            } else if ("summer_time".equals(name)) {
                settings.writeInt("registry.summer_time", buf.getValue32());
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else if ("/CONFIG/SYSTEM/XMB".equals(fullName)) {
            if ("language".equals(name)) {
                settings.writeInt("emu.impose.language", buf.getValue32());
            } else if ("button_assign".equals(name)) {
                settings.writeInt("emu.impose.button", buf.getValue32());
            } else {
                log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
            }
        } else {
            log.warn((Object)String.format("Unknown registry entry '%s/%s'", fullName, name));
        }
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-733521240, version=150), @HLEFunction(nid=-1719643745, version=150)})
    public int sceRegGetKeyInfo(int hd, String name, TPointer32 hk, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 ptype, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 psize) {
        CategoryHandle categoryHandle = this.categoryHandles.get(hd);
        if (categoryHandle == null) {
            return -1;
        }
        KeyHandle keyHandle = new KeyHandle(name);
        this.keyHandles.put(keyHandle.uid, keyHandle);
        hk.setValue(keyHandle.uid);
        return this.getKey(categoryHandle, name, ptype, psize, TPointer.NULL, 0);
    }

    @HLEFunctions(value={@HLEFunction(nid=682158474, version=150), @HLEFunction(nid=-190585962, version=660)})
    public int sceRegGetKeyValue(int hd, int hk, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer buf, int size) {
        CategoryHandle categoryHandle = this.categoryHandles.get(hd);
        if (categoryHandle == null) {
            return -1;
        }
        KeyHandle keyHandle = this.keyHandles.get(hk);
        if (keyHandle == null) {
            return -1;
        }
        return this.getKey(categoryHandle, keyHandle.name, TPointer32.NULL, TPointer32.NULL, buf, size);
    }

    @HLEUnimplemented
    @HLEFunction(nid=739097053, version=150)
    public int sceRegGetKeysNum(int hd, int num) {
        CategoryHandle categoryHandle = this.categoryHandles.get(hd);
        if (categoryHandle == null) {
            return -1;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=757141813, version=150)
    public int sceRegGetKeys(int hd, TPointer buf, int num) {
        CategoryHandle categoryHandle = this.categoryHandles.get(hd);
        if (categoryHandle == null) {
            return -1;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1285646483, version=150), @HLEFunction(nid=1641782534, version=660)})
    public int sceRegRemoveCategory(int h, String name) {
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-982086398, version=150), @HLEFunction(nid=-228486137, version=660)})
    public int sceRegGetKeyInfoByName(int hd, String name, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 ptype, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 psize) {
        CategoryHandle categoryHandle = this.categoryHandles.get(hd);
        if (categoryHandle == null) {
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRegGetKeyInfoByName fullName='%s/%s'", categoryHandle.getFullName(), name));
        }
        return this.getKey(categoryHandle, name, ptype, psize, TPointer.NULL, 0);
    }

    @HLEFunctions(value={@HLEFunction(nid=817758809, version=150), @HLEFunction(nid=943807391, version=660)})
    public int sceRegGetKeyValueByName(int hd, String name, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer buf, int size) {
        CategoryHandle categoryHandle = this.categoryHandles.get(hd);
        if (categoryHandle == null) {
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRegGetKeyValueByName fullName='%s/%s'", categoryHandle.getFullName(), name));
        }
        return this.getKey(categoryHandle, name, TPointer32.NULL, TPointer32.NULL, buf, size);
    }

    protected static class KeyHandle {
        private static int index = 0;
        public int uid;
        public String name;

        public KeyHandle(String name) {
            this.name = name;
            this.uid = index++;
        }
    }

    protected static class CategoryHandle {
        private static final String categoryHandlePurpose = "sceReg.CategoryHandle";
        public int uid;
        public RegistryHandle registryHandle;
        public String name;
        public int mode;

        public CategoryHandle(RegistryHandle registryHandle, String name, int mode) {
            this.registryHandle = registryHandle;
            this.name = name;
            this.mode = mode;
            this.uid = SceUidManager.getNewUid(categoryHandlePurpose);
        }

        public String getFullName() {
            return this.registryHandle.name + this.name;
        }

        public void release() {
            SceUidManager.releaseUid(this.uid, categoryHandlePurpose);
            this.uid = -1;
        }
    }

    protected static class RegistryHandle {
        private static final String registryHandlePurpose = "sceReg.RegistryHandle";
        public int uid;
        public int type;
        public String name;
        public int unknown1;
        public int unknown2;

        public RegistryHandle(int type, String name, int unknown1, int unknown2) {
            this.type = type;
            this.name = name;
            this.unknown1 = unknown1;
            this.unknown2 = unknown2;
            this.uid = SceUidManager.getNewUid(registryHandlePurpose);
        }

        public void release() {
            SceUidManager.releaseUid(this.uid, registryHandlePurpose);
            this.uid = -1;
        }
    }

    protected static class RegistryKeyEntry {
        public static final int SIZE_OF = 32;
        public int type;
        public String name;
        public int intValue;
        public int size;
        public int maxKeyBlocks;
        public String stringValue;
        public byte[] binValue;

        public RegistryKeyEntry(String name, int intValue) {
            this.type = 2;
            this.name = name;
            this.intValue = intValue;
        }

        public RegistryKeyEntry(String name, String stringValue, int maxSize) {
            this.type = 3;
            this.name = name;
            this.stringValue = stringValue;
            this.maxKeyBlocks = maxSize / 32;
            this.binValue = stringValue.getBytes(Constants.charset);
            this.size = this.binValue.length + 1;
        }

        public RegistryKeyEntry(String name, String stringValue, int size, int maxSize) {
            this.type = 3;
            this.name = name;
            this.stringValue = stringValue;
            this.size = size;
            this.maxKeyBlocks = maxSize / 32;
            this.binValue = stringValue.getBytes(Constants.charset);
        }

        public RegistryKeyEntry(String name, byte[] binValue) {
            this.type = 4;
            this.name = name;
            this.binValue = binValue;
            this.maxKeyBlocks = Utilities.alignUp(binValue.length, 31) / 32;
            this.size = binValue.length;
        }

        public RegistryKeyEntry(String name) {
            this.type = 1;
            this.name = name;
        }

        public RegistryKeyEntry(byte[] dataBlocks, int offset) {
            this.type = Utilities.read8(dataBlocks, offset + 0);
            this.name = Utilities.readStringNZ(dataBlocks, offset + 1, 27);
            switch (this.type) {
                case 2: {
                    this.intValue = Utilities.readUnaligned32(dataBlocks, offset + 28);
                    break;
                }
                case 4: {
                    this.size = Utilities.readUnaligned16(dataBlocks, offset + 28);
                    this.maxKeyBlocks = Utilities.read8(dataBlocks, offset + 30);
                    this.binValue = new byte[this.size];
                    int valueOffset = Utilities.read8(dataBlocks, offset + 31) * 32;
                    System.arraycopy(dataBlocks, valueOffset, this.binValue, 0, this.size);
                    break;
                }
                case 3: {
                    this.size = Utilities.readUnaligned16(dataBlocks, offset + 28);
                    this.maxKeyBlocks = Utilities.read8(dataBlocks, offset + 30);
                    int valueOffset = Utilities.read8(dataBlocks, offset + 31) * 32;
                    this.stringValue = Utilities.readStringNZ(dataBlocks, valueOffset, this.size);
                    this.binValue = this.stringValue.getBytes(Constants.charset);
                }
            }
        }

        public void write(byte[] dataBlocks, int child, int valueData) {
            int offset = child * 32;
            int valueOffset = valueData * 32;
            Utilities.write8(dataBlocks, offset + 0, this.type);
            Utilities.writeStringNZ(dataBlocks, offset + 1, 27, this.name);
            switch (this.type) {
                case 2: {
                    Utilities.writeUnaligned32(dataBlocks, offset + 28, this.intValue);
                    break;
                }
                case 4: {
                    Utilities.writeUnaligned16(dataBlocks, offset + 28, this.size);
                    Utilities.write8(dataBlocks, offset + 30, this.maxKeyBlocks);
                    Utilities.write8(dataBlocks, offset + 31, valueData);
                    System.arraycopy(this.binValue, 0, dataBlocks, valueOffset, this.size);
                    break;
                }
                case 3: {
                    Utilities.writeUnaligned16(dataBlocks, offset + 28, this.size);
                    Utilities.write8(dataBlocks, offset + 30, this.maxKeyBlocks);
                    Utilities.write8(dataBlocks, offset + 31, valueData);
                    System.arraycopy(this.binValue, 0, dataBlocks, valueOffset, this.binValue.length);
                    Arrays.fill(dataBlocks, valueOffset + this.binValue.length, valueOffset + this.size, (byte)0);
                }
            }
        }

        public String toString() {
            StringBuilder s = new StringBuilder(String.format("name='%s'", this.name));
            switch (this.type) {
                case 2: {
                    s.append(String.format(", value=0x%08X", this.intValue));
                    break;
                }
                case 3: {
                    s.append(String.format(", value='%s'", this.stringValue));
                    if (this.size != this.binValue.length + 1) {
                        s.append(String.format("(size=0x%X)", this.size));
                    }
                    s.append(String.format(", maxKeyBlocks=0x%X", this.maxKeyBlocks));
                    break;
                }
                case 4: {
                    s.append(String.format(", value=%s", Utilities.getMemoryDump(this.binValue)));
                    break;
                }
                case 1: {
                    s.append(String.format(", directory", new Object[0]));
                    break;
                }
                default: {
                    s.append(String.format(", type=0x%02X", this.type));
                }
            }
            return s.toString();
        }
    }

    protected static class RegistryHeaderKeyEntry {
        public int numberKeyEntries;
        public int firstFreeDataKey;
        public int checksum;

        public RegistryHeaderKeyEntry(int numberBlocks) {
            this.firstFreeDataKey = numberBlocks * 512 / 32 - 1;
        }

        public RegistryHeaderKeyEntry(byte[] dataBlocks) {
            this.numberKeyEntries = Utilities.readUnaligned16(dataBlocks, 8);
            this.firstFreeDataKey = Utilities.readUnaligned16(dataBlocks, 10);
            this.checksum = Utilities.readUnaligned32(dataBlocks, 14);
        }

        private static int computeChecksum(byte[] dataBlocks) {
            Utilities.writeUnaligned32(dataBlocks, 14, 0);
            byte[] digestBytes = sceReg.sha1(dataBlocks);
            int checksum = 0;
            int n = 0;
            for (int i = 0; i < 32; i += 8) {
                int j = 0;
                while (j < 5) {
                    checksum ^= (digestBytes[n] & 0xFF) << i;
                    ++j;
                    ++n;
                }
            }
            return checksum;
        }

        public boolean isValidChecksum(byte[] dataBlocks) {
            return this.checksum == RegistryHeaderKeyEntry.computeChecksum(dataBlocks);
        }

        public int getNextFreeDataKeyEntry() {
            return this.firstFreeDataKey--;
        }

        public void write(byte[] dataBlocks) {
            Utilities.writeUnaligned16(dataBlocks, 8, this.numberKeyEntries);
            Utilities.writeUnaligned16(dataBlocks, 10, this.firstFreeDataKey);
            this.checksum = RegistryHeaderKeyEntry.computeChecksum(dataBlocks);
            Utilities.writeUnaligned32(dataBlocks, 14, this.checksum);
        }
    }

    protected static class RegistryDirectoryHeader {
        public static final int SIZE_OF = 58;
        public static final int NO_PARENT = RuntimeContextLLE.getFirmwareVersion() <= 152 ? 0 : 65535;
        public int unknown0;
        public int unknown1;
        public int parent;
        public int nameHash;
        public int unknown3;
        public int numberChildren;
        public int numberBlocks;
        public String name;
        public int unknown4;
        public final int[] blocks = new int[5];
        public int unknown5;
        private int nextFreeChild;
        private RegistryHeaderKeyEntry registryHeaderKeyEntry;

        public RegistryDirectoryHeader(int numberChildren, int numberBlocks) {
            this.numberChildren = numberChildren;
            this.registryHeaderKeyEntry = new RegistryHeaderKeyEntry(numberBlocks);
            this.registryHeaderKeyEntry.numberKeyEntries = numberChildren + 1;
            for (int i = 0; i < this.blocks.length; ++i) {
                this.blocks[i] = 65535;
            }
            this.nextFreeChild = 1;
        }

        public RegistryDirectoryHeader(byte[] ireg, int offset) {
            this.unknown0 = Utilities.readUnaligned16(ireg, offset + 0);
            this.unknown1 = Utilities.readUnaligned16(ireg, offset + 2);
            this.parent = Utilities.readUnaligned16(ireg, offset + 4);
            this.nameHash = Utilities.readUnaligned16(ireg, offset + 6);
            this.unknown3 = Utilities.readUnaligned16(ireg, offset + 8);
            this.numberChildren = Utilities.readUnaligned16(ireg, offset + 10);
            this.numberBlocks = Utilities.readUnaligned16(ireg, offset + 12);
            this.name = Utilities.readStringNZ(ireg, offset + 14, 28);
            this.unknown4 = Utilities.readUnaligned16(ireg, offset + 42);
            for (int i = 0; i < this.blocks.length; ++i) {
                this.blocks[i] = Utilities.readUnaligned16(ireg, offset + 44 + i * 2);
            }
            this.unknown5 = Utilities.readUnaligned32(ireg, offset + 54);
            this.registryHeaderKeyEntry = new RegistryHeaderKeyEntry(this.numberBlocks);
            this.registryHeaderKeyEntry.numberKeyEntries = this.numberChildren + 1;
            this.nextFreeChild = this.numberChildren + 1;
        }

        public void write(byte[] ireg, int offset, byte[] dreg) {
            Utilities.writeUnaligned16(ireg, offset + 0, this.unknown0);
            Utilities.writeUnaligned16(ireg, offset + 2, this.unknown1);
            Utilities.writeUnaligned16(ireg, offset + 4, this.parent);
            Utilities.writeUnaligned16(ireg, offset + 6, this.nameHash);
            Utilities.writeUnaligned16(ireg, offset + 8, this.unknown3);
            Utilities.writeUnaligned16(ireg, offset + 10, this.numberChildren);
            Utilities.writeUnaligned16(ireg, offset + 12, this.numberBlocks);
            Utilities.writeStringNZ(ireg, offset + 14, 28, this.name);
            Utilities.writeUnaligned16(ireg, offset + 42, this.unknown4);
            for (int i = 0; i < this.blocks.length; ++i) {
                Utilities.writeUnaligned16(ireg, offset + 44 + i * 2, this.blocks[i]);
            }
            Utilities.writeUnaligned32(ireg, offset + 54, this.unknown5);
            byte[] dataBlocks = this.getDataBlocks(dreg);
            this.registryHeaderKeyEntry.write(dataBlocks);
            this.updateDataBlocks(dreg, dataBlocks);
        }

        public boolean isValidChecksum(byte[] dreg) {
            byte[] dataBlocks = this.getDataBlocks(dreg);
            return this.registryHeaderKeyEntry.isValidChecksum(dataBlocks);
        }

        public byte[] getDataBlocks(byte[] dreg) {
            byte[] dataBlocks = new byte[this.numberBlocks * 512];
            for (int i = 0; i < this.numberBlocks; ++i) {
                System.arraycopy(dreg, this.blocks[i] * 512, dataBlocks, i * 512, 512);
            }
            return dataBlocks;
        }

        public void updateDataBlocks(byte[] dreg, byte[] dataBlocks) {
            for (int i = 0; i < this.numberBlocks; ++i) {
                System.arraycopy(dataBlocks, i * 512, dreg, this.blocks[i] * 512, 512);
            }
        }

        public boolean hasParent() {
            return this.parent != NO_PARENT;
        }

        public int getNextFreeChild() {
            return this.nextFreeChild++;
        }

        public int getNextFreeValue(int length) {
            int index = -1;
            while (length > 0) {
                index = this.registryHeaderKeyEntry.getNextFreeDataKeyEntry();
                length -= 32;
            }
            return index;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(String.format("nameHash=0x%X, parent=0x%X, numberChildren=0x%X, numberBlocks=0x%X, name='%s'", this.nameHash, this.parent, this.numberChildren, this.numberBlocks, this.name));
            for (int i = 0; i < this.numberBlocks; ++i) {
                s.append(String.format(", block[%d]=0x%X", i, this.blocks[i]));
            }
            return s.toString();
        }
    }

    protected static class RegistryHeader {
        public static final int SIZE_OF = 92;
        public static final int MAGIC_IRF = 1179797760;
        public int magic;
        public int version;
        public final byte[] checksum = new byte[20];
        public int unknown28;
        public int unknown32;
        public int numberDirectoryEntries;
        public int unknown40;
        public int unknown44;
        public int unknown48;
        public int sizeDirectoryEntries;
        public int headerSize;
        public final byte[] unknown60 = new byte[32];

        public RegistryHeader(int numberDirectoryEntries) {
            this.magic = 1179797760;
            this.version = 65539;
            this.numberDirectoryEntries = numberDirectoryEntries;
            this.sizeDirectoryEntries = 58 * numberDirectoryEntries;
            this.headerSize = 92;
        }

        public RegistryHeader(byte[] ireg) {
            this.magic = Utilities.readUnaligned32(ireg, 0);
            this.version = Utilities.readUnaligned32(ireg, 4);
            System.arraycopy(ireg, 8, this.checksum, 0, this.checksum.length);
            this.unknown28 = Utilities.readUnaligned32(ireg, 28);
            this.unknown32 = Utilities.readUnaligned32(ireg, 32);
            this.numberDirectoryEntries = Utilities.readUnaligned32(ireg, 36);
            this.unknown40 = Utilities.readUnaligned32(ireg, 40);
            this.unknown44 = Utilities.readUnaligned32(ireg, 44);
            this.unknown48 = Utilities.readUnaligned32(ireg, 48);
            this.sizeDirectoryEntries = Utilities.readUnaligned32(ireg, 52);
            this.headerSize = Utilities.readUnaligned32(ireg, 56);
            System.arraycopy(ireg, 60, this.unknown60, 0, this.unknown60.length);
        }

        public boolean isValid(byte[] ireg) {
            return this.magic == 1179797760 && this.isValidChecksum(ireg);
        }

        private byte[] computeChecksum(byte[] ireg) {
            Arrays.fill(ireg, 8, 8 + this.checksum.length, (byte)0);
            return sceReg.sha1(ireg);
        }

        public boolean isValidChecksum(byte[] ireg) {
            return Arrays.equals(this.checksum, this.computeChecksum(ireg));
        }

        public void write(byte[] ireg) {
            Utilities.writeUnaligned32(ireg, 0, this.magic);
            Utilities.writeUnaligned32(ireg, 4, this.version);
            Utilities.writeUnaligned32(ireg, 28, this.unknown28);
            Utilities.writeUnaligned32(ireg, 32, this.unknown32);
            Utilities.writeUnaligned32(ireg, 36, this.numberDirectoryEntries);
            Utilities.writeUnaligned32(ireg, 40, this.unknown40);
            Utilities.writeUnaligned32(ireg, 44, this.unknown44);
            Utilities.writeUnaligned32(ireg, 48, this.unknown48);
            Utilities.writeUnaligned32(ireg, 52, this.sizeDirectoryEntries);
            Utilities.writeUnaligned32(ireg, 56, this.headerSize);
            System.arraycopy(this.unknown60, 0, ireg, 60, this.unknown60.length);
            System.arraycopy(this.computeChecksum(ireg), 0, ireg, 8, this.checksum.length);
        }

        public String toString() {
            return String.format("magic=0x%08X, version=0x%X, unknown28=0x%X, unknown32=0x%X, numberDirectoryEntries=0x%X, unknown40=0x%X, unknown44=0x%X, unknown48=0x%X, sizeDirectoryEntries=0x%X, headerSize=0x%X", this.magic, this.version, this.unknown28, this.unknown32, this.numberDirectoryEntries, this.unknown40, this.unknown44, this.unknown48, this.sizeDirectoryEntries, this.headerSize);
        }
    }

    protected static class Registry {
        private byte[] ireg;
        private byte[] dreg;
        private RegistryHeader header;
        private RegistryDirectoryHeader[] entries;
        private int nextFreeDataBlock;

        public Registry(int numberDirectoryEntries, int numberDataBlocks) {
            this.header = new RegistryHeader(numberDirectoryEntries);
            this.ireg = new byte[numberDirectoryEntries * 58 + 92];
            this.dreg = new byte[numberDataBlocks * 512];
            this.entries = new RegistryDirectoryHeader[numberDirectoryEntries];
        }

        public Registry(byte[] ireg, byte[] dreg) {
            this.ireg = ireg;
            this.dreg = dreg;
            this.read();
        }

        private void read() {
            this.header = new RegistryHeader(this.ireg);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("RegistryHeader: %s, valid %b", this.header, this.header.isValid(this.ireg)));
            }
            if (this.header.isValid(this.ireg)) {
                this.entries = new RegistryDirectoryHeader[(this.ireg.length - 92) / 58];
                int offset = 92;
                int i = 0;
                while (i < this.entries.length) {
                    RegistryDirectoryHeader entry = new RegistryDirectoryHeader(this.ireg, offset);
                    if (entry.numberBlocks != 0) {
                        this.entries[i] = entry;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("RegistryDirectoryHeader#%d: %s, valid checksum %b", i, entry, entry.isValidChecksum(this.dreg)));
                        }
                    }
                    ++i;
                    offset += 58;
                }
            }
        }

        public void save(String iregFileName, String dregFileName) {
            int offset = 92;
            int i = 0;
            while (i < this.entries.length) {
                if (this.entries[i] != null) {
                    this.entries[i].write(this.ireg, offset, this.dreg);
                }
                ++i;
                offset += 58;
            }
            this.header.write(this.ireg);
            Utilities.writeCompleteFile(iregFileName, this.ireg, true);
            Utilities.writeCompleteFile(dregFileName, this.dreg, true);
        }

        public void dump() {
            if (this.entries != null) {
                for (int i = 0; i < this.entries.length; ++i) {
                    if (this.entries[i] == null || this.entries[i].hasParent()) continue;
                    this.dumpChildren(i, 0);
                }
            }
        }

        private void dumpEntry(int n, int level) {
            if (log.isDebugEnabled()) {
                StringBuilder prefix = new StringBuilder();
                for (int i = 0; i < level; ++i) {
                    prefix.append("  ");
                }
                log.debug((Object)String.format("%s%s: %s", prefix, this.getFullName(n), this.entries[n]));
                byte[] dataBlocks = this.entries[n].getDataBlocks(this.dreg);
                RegistryHeaderKeyEntry registryHeaderKeyEntry = new RegistryHeaderKeyEntry(dataBlocks);
                int numberKeyEntries = Math.max(this.entries[n].numberChildren, registryHeaderKeyEntry.numberKeyEntries - 1);
                int i = 0;
                int offset = 32;
                while (i < numberKeyEntries) {
                    RegistryKeyEntry keyEntry = new RegistryKeyEntry(dataBlocks, offset);
                    log.debug((Object)String.format("%s  %s", prefix, keyEntry));
                    ++i;
                    offset += 32;
                }
            }
        }

        private void dumpChildren(int parent, int level) {
            this.dumpEntry(parent, level);
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i] == null || this.entries[i].parent != parent) continue;
                this.dumpChildren(i, level + 1);
            }
        }

        private int getFreeDataBlock() {
            return this.nextFreeDataBlock++;
        }

        private int hashName(String name) {
            byte[] bytes = name.getBytes(Constants.charset);
            int hash = 0;
            if (bytes != null && bytes.length > 0) {
                bytes = Utilities.add(bytes, (byte)0);
                int start = bytes[0] * 100;
                for (int i = 1; i < bytes.length; i += 2) {
                    byte b = bytes[i];
                    int n = hash + start + b;
                    hash = n - ((n + (int)((long)n * -765411987L >>> 32) >> 14) + (n < 0 ? 1 : 0)) * 19937;
                }
            }
            hash = hash >= 0 ? (hash %= this.header.numberDirectoryEntries) : (int)(((long)hash & 0xFFFFFFFFL) % (long)this.header.numberDirectoryEntries);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hashName '%s' = 0x%X", name, hash));
            }
            return hash;
        }

        private String getFullName(int index) {
            if (index == RegistryDirectoryHeader.NO_PARENT || this.entries[index] == null) {
                return "";
            }
            return this.getFullName(this.entries[index].parent) + "/" + this.entries[index].name;
        }

        private String getFullName(int parent, String name) {
            StringBuilder s = new StringBuilder();
            if (parent != RegistryDirectoryHeader.NO_PARENT) {
                s.append(this.getFullName(parent));
            }
            s.append("/");
            s.append(name);
            return s.toString();
        }

        public int addDirectory(int parent, String name, int numberChildren, int numberBlocks) {
            int nameHash;
            String fullName = this.getFullName(parent, name);
            int index = nameHash = this.hashName(fullName);
            while (this.entries[index] != null) {
                index = (index + 1) % this.header.numberDirectoryEntries;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Storing entry '%s' at index 0x%X", fullName, index));
            }
            RegistryDirectoryHeader registryDirectoryHeader = new RegistryDirectoryHeader(numberChildren, numberBlocks);
            registryDirectoryHeader.parent = parent;
            registryDirectoryHeader.name = name;
            registryDirectoryHeader.numberBlocks = numberBlocks;
            registryDirectoryHeader.nameHash = nameHash;
            for (int i = 0; i < numberBlocks; ++i) {
                registryDirectoryHeader.blocks[i] = this.getFreeDataBlock();
            }
            this.entries[index] = registryDirectoryHeader;
            return index;
        }

        private void addKey(int index, RegistryKeyEntry keyEntry, int valueSize) {
            RegistryDirectoryHeader entry = this.entries[index];
            int child = entry.getNextFreeChild();
            int nextFreeValue = entry.getNextFreeValue(valueSize);
            byte[] dataBlocks = entry.getDataBlocks(this.dreg);
            keyEntry.write(dataBlocks, child, nextFreeValue);
            entry.updateDataBlocks(this.dreg, dataBlocks);
        }

        public void addKey(int index, String name, int value) {
            this.addKey(index, new RegistryKeyEntry(name, value), 0);
        }

        public void addKey(int index, String name, byte[] binValue) {
            this.addKey(index, new RegistryKeyEntry(name, binValue), binValue.length);
        }

        public void addKey(int index, String name, byte[] binValue, int binValueLength) {
            while (binValue.length < binValueLength) {
                binValue = Utilities.add(binValue, (byte)0);
            }
            this.addKey(index, name, binValue);
        }

        public void addKey(int index, String name, String stringValue, int maxSize) {
            this.addKey(index, name, stringValue, stringValue.getBytes(Constants.charset).length + 1, maxSize);
        }

        public void addKey(int index, String name, String stringValue, int size, int maxSize) {
            this.addKey(index, new RegistryKeyEntry(name, stringValue, size, maxSize), maxSize);
        }

        public void addKey(int index, String name) {
            this.addKey(index, new RegistryKeyEntry(name), 0);
        }
    }
}

