/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import jpcsp.Clock;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.TPointer64;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import org.apache.log4j.Logger;

public class sceRtc
extends HLEModule {
    public static Logger log = Modules.getLogger("sceRtc");
    static final int PSP_TIME_INVALID_YEAR = -1;
    static final int PSP_TIME_INVALID_MONTH = -2;
    static final int PSP_TIME_INVALID_DAY = -3;
    static final int PSP_TIME_INVALID_HOUR = -4;
    static final int PSP_TIME_INVALID_MINUTES = -5;
    static final int PSP_TIME_INVALID_SECONDS = -6;
    static final int PSP_TIME_INVALID_MICROSECONDS = -7;
    static final int PSP_TIME_SECONDS_IN_MINUTE = 60;
    static final int PSP_TIME_SECONDS_IN_HOUR = 3600;
    static final int PSP_TIME_SECONDS_IN_DAY = 86400;
    static final int PSP_TIME_SECONDS_IN_WEEK = 604800;
    static final int PSP_TIME_SECONDS_IN_MONTH = 2629743;
    static final int PSP_TIME_SECONDS_IN_YEAR = 31556926;
    private static final long rtcMagicOffset = 62135596800000000L;
    protected static SimpleDateFormat rfc3339 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public static long hleGetCurrentTick() {
        return sceRtc.hleGetCurrentMicros() + 62135596800000000L;
    }

    public static long hleGetCurrentMicros() {
        Clock.TimeNanos timeNanos = Emulator.getClock().currentTimeNanos();
        return (long)(timeNanos.micros + timeNanos.millis * 1000) + (long)timeNanos.seconds * 1000000L;
    }

    protected int hleRtcTickAdd64(TPointer64 dstPtr, TPointer64 srcPtr, long value, long multiplier) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleRtcTickAdd64 dstPtr=%s, srcPtr=%s(%d), %d * %d", dstPtr, srcPtr, srcPtr.getValue(), value, multiplier));
        }
        long src = srcPtr.getValue();
        dstPtr.setValue(src + multiplier * value);
        return 0;
    }

    protected int hleRtcTickAdd32(TPointer64 dstPtr, TPointer64 srcPtr, int value, long multiplier) {
        log.debug((Object)("hleRtcTickAdd32 " + multiplier + " * " + value));
        long src = srcPtr.getValue();
        dstPtr.setValue(src + multiplier * (long)value);
        return 0;
    }

    protected Date getDateFromTick(long tick) {
        return new Date((tick - 62135596800000000L) / 1000L);
    }

    protected String formatRFC3339(Date date) {
        String result = rfc3339.format(date);
        result = result.replaceFirst("(\\d\\d)(\\d\\d)$", "$1:$2");
        return result;
    }

    protected TimeZone getLocalTimeZone() {
        return TimeZone.getDefault();
    }

    @HLEFunction(nid=-1004787629, version=150)
    public int sceRtcGetTickResolution() {
        return 1000000;
    }

    @HLEFunction(nid=1065015143, version=150)
    public int sceRtcGetCurrentTick(TPointer64 currentTick) {
        currentTick.setValue(sceRtc.hleGetCurrentTick());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetCurrentTick returning %d", currentTick.getValue()));
        }
        return 0;
    }

    @HLEFunction(nid=18809793, version=150)
    public long sceRtcGetAccumulativeTime() {
        return sceRtc.hleGetCurrentTick();
    }

    @HLEFunction(nid=43819955, version=150)
    public long sceRtcGetAccumlativeTime() {
        return sceRtc.hleGetCurrentTick();
    }

    @HLEFunction(nid=1291474864, version=150)
    public int sceRtcGetCurrentClock(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.out) TPointer addr, int tz) {
        ScePspDateTime pspTime = new ScePspDateTime(tz);
        pspTime.write(addr);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-406684389, version=150), @HLEFunction(nid=-1877823168, version=660)})
    public int sceRtcGetCurrentClockLocalTime(TPointer addr) {
        ScePspDateTime pspTime = new ScePspDateTime();
        pspTime.write(addr);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=881352205, version=150), @HLEFunction(nid=1311145474, version=660)})
    public int sceRtcConvertUtcToLocalTime(TPointer64 utcPtr, TPointer64 localPtr) {
        TimeZone localTimeZone = this.getLocalTimeZone();
        this.hleRtcTickAdd64(localPtr, utcPtr, localTimeZone.getRawOffset(), 1000L);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=2006074018, version=150), @HLEFunction(nid=1046924158, version=660)})
    public int sceRtcConvertLocalTimeToUTC(TPointer64 localPtr, TPointer64 utcPtr) {
        TimeZone localTimeZone = this.getLocalTimeZone();
        this.hleRtcTickAdd64(utcPtr, localPtr, -localTimeZone.getRawOffset(), 1000L);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=1110473239, version=150), @HLEFunction(nid=16149766, version=660)})
    public boolean sceRtcIsLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=99562028, version=150), @HLEFunction(nid=497761523, version=660)})
    public int sceRtcGetDaysInMonth(int year, int month) {
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, 1);
        int days = ((Calendar)cal).getActualMaximum(5);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetDaysInMonth returning %d", days));
        }
        return days;
    }

    @HLEFunctions(value={@HLEFunction(nid=1467116481, version=150), @HLEFunction(nid=840598426, version=660)})
    public int sceRtcGetDayOfWeek(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day);
        int dayOfWeekNumber = cal.get(7);
        dayOfWeekNumber = (dayOfWeekNumber - 1 + 7) % 7;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetDayOfWeek returning %d", dayOfWeekNumber));
        }
        return dayOfWeekNumber;
    }

    @HLEFunction(nid=1260084866, version=150)
    public int sceRtcCheckValid(ScePspDateTime time) {
        GregorianCalendar cal = new GregorianCalendar(time.year, time.month - 1, time.day, time.hour, time.minute, time.second);
        int result = 0;
        if (time.year < 1582 || time.year > 3000) {
            result = -1;
        } else if (time.month < 1 || time.month > 12) {
            result = -2;
        } else if (time.day < 1 || time.day > 31) {
            result = -3;
        } else if (time.hour < 0 || time.hour > 23) {
            result = -4;
        } else if (time.minute < 0 || time.minute > 59) {
            result = -5;
        } else if (time.second < 0 || time.second > 59) {
            result = -6;
        } else if (time.microsecond < 0 || time.microsecond >= 1000000) {
            result = -7;
        } else if (cal.get(5) != time.day) {
            result = -3;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcCheckValid time=%s, cal=%s, returning 0x%08X", time, cal, result));
        }
        return result;
    }

    @HLEFunctions(value={@HLEFunction(nid=981499080, version=150), @HLEFunction(nid=1085308530, version=660)})
    public int sceRtcSetTime_t(TPointer dateAddr, int time) {
        ScePspDateTime dateTime = ScePspDateTime.fromUnixTime(time);
        dateTime.write(dateAddr);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=667179340, version=150), @HLEFunction(nid=-395472960, version=660)})
    public int sceRtcGetTime_t(ScePspDateTime dateTime, TPointer32 timeAddr) {
        Calendar cal = Calendar.getInstance();
        cal.set(dateTime.year, dateTime.month - 1, dateTime.day, dateTime.hour, dateTime.minute, dateTime.second);
        int unixtime = (int)(cal.getTime().getTime() / 1000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetTime_t returning %d", unixtime));
        }
        timeAddr.setValue(unixtime);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-267980188, version=150), @HLEFunction(nid=1953967308, version=660)})
    public int sceRtcSetDosTime(TPointer dateAddr, int time) {
        ScePspDateTime dateTime = ScePspDateTime.fromMSDOSTime(time);
        dateTime.write(dateAddr);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=906450279, version=150), @HLEFunction(nid=-1532641509, version=660)})
    public int sceRtcGetDosTime(ScePspDateTime dateTime, TPointer32 timeAddr) {
        Calendar cal = Calendar.getInstance();
        cal.set(dateTime.year, dateTime.month - 1, dateTime.day, dateTime.hour, dateTime.minute, dateTime.second);
        int dostime = (int)(cal.getTime().getTime() / 1000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetDosTime returning %d", dostime));
        }
        timeAddr.setValue(dostime);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=2060340228, version=150), @HLEFunction(nid=-822542706, version=660)})
    public int sceRtcSetWin32FileTime(TPointer dateAddr, long time) {
        ScePspDateTime dateTime = ScePspDateTime.fromFILETIMETime(time);
        dateTime.write(dateAddr);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-816441197, version=150), @HLEFunction(nid=-1296672884, version=660)})
    public int sceRtcGetWin32FileTime(ScePspDateTime dateTime, TPointer64 timeAddr) {
        Calendar cal = Calendar.getInstance();
        cal.set(dateTime.year, dateTime.month - 1, dateTime.day, dateTime.hour, dateTime.minute, dateTime.second);
        int filetimetime = (int)(cal.getTime().getTime() / 1000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetWin32FileTime returning %d", filetimetime));
        }
        timeAddr.setValue(filetimetime);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=2127732288, version=150), @HLEFunction(nid=-407655436, version=660)})
    public int sceRtcSetTick(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.out) TPointer timeAddr, @BufferInfo(usage=BufferInfo.Usage.in) TPointer64 ticksAddr) {
        long ticks = ticksAddr.getValue() - 62135596800000000L;
        ScePspDateTime time = ScePspDateTime.fromMicros(ticks);
        time.write(timeAddr);
        return 0;
    }

    @HLEFunction(nid=1878264524, version=150)
    public int sceRtcGetTick(ScePspDateTime time, TPointer64 ticksAddr) {
        GregorianCalendar cal = new GregorianCalendar(time.year, time.month - 1, time.day, time.hour, time.minute, time.second);
        cal.set(14, time.microsecond / 1000);
        ((Calendar)cal).setTimeZone(ScePspDateTime.GMT);
        long ticks = 62135596800000000L + cal.getTimeInMillis() * 1000L + (long)(time.microsecond % 1000);
        ticksAddr.setValue(ticks);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetTick returning %d", ticks));
        }
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-1630491001, version=150), @HLEFunction(nid=672220414, version=660)})
    public int sceRtcCompareTick(TPointer64 firstPtr, TPointer64 secondPtr) {
        long tick2;
        long tick1 = firstPtr.getValue();
        if (tick1 < (tick2 = secondPtr.getValue())) {
            return -1;
        }
        if (tick1 > tick2) {
            return 1;
        }
        return 0;
    }

    @HLEFunction(nid=1156865541, version=150)
    public int sceRtcTickAddTicks(TPointer64 dstPtr, TPointer64 srcPtr, long value) {
        log.debug((Object)"sceRtcTickAddTicks redirecting to hleRtcTickAdd64(1)");
        return this.hleRtcTickAdd64(dstPtr, srcPtr, value, 1L);
    }

    @HLEFunctions(value={@HLEFunction(nid=651319901, version=150), @HLEFunction(nid=-1203058729, version=660)})
    public int sceRtcTickAddMicroseconds(TPointer64 dstPtr, TPointer64 srcPtr, long value) {
        log.debug((Object)"sceRtcTickAddMicroseconds redirecting to hleRtcTickAdd64(1)");
        return this.hleRtcTickAdd64(dstPtr, srcPtr, value, 1L);
    }

    @HLEFunctions(value={@HLEFunction(nid=-224088091, version=150), @HLEFunction(nid=-1980087710, version=660)})
    public int sceRtcTickAddSeconds(TPointer64 dstPtr, TPointer64 srcPtr, long value) {
        log.debug((Object)"sceRtcTickAddSeconds redirecting to hleRtcTickAdd64(1000000)");
        return this.hleRtcTickAdd64(dstPtr, srcPtr, value, 1000000L);
    }

    @HLEFunctions(value={@HLEFunction(nid=-429892662, version=150), @HLEFunction(nid=1997767495, version=660)})
    public int sceRtcTickAddMinutes(TPointer64 dstPtr, TPointer64 srcPtr, long value) {
        log.debug((Object)"sceRtcTickAddMinutes redirecting to hleRtcTickAdd64(60*1000000)");
        return this.hleRtcTickAdd64(dstPtr, srcPtr, value, 60000000L);
    }

    @HLEFunctions(value={@HLEFunction(nid=651665994, version=150), @HLEFunction(nid=-2079077668, version=660)})
    public int sceRtcTickAddHours(TPointer64 dstPtr, TPointer64 srcPtr, int value) {
        log.debug((Object)"sceRtcTickAddHours redirecting to hleRtcTickAdd32(60*60*1000000)");
        return this.hleRtcTickAdd32(dstPtr, srcPtr, value, 3600000000L);
    }

    @HLEFunctions(value={@HLEFunction(nid=-451196038, version=150), @HLEFunction(nid=-888850179, version=660)})
    public int sceRtcTickAddDays(TPointer64 dstPtr, TPointer64 srcPtr, int value) {
        log.debug((Object)"sceRtcTickAddDays redirecting to hleRtcTickAdd32(24*60*60*1000000)");
        return this.hleRtcTickAdd32(dstPtr, srcPtr, value, 86400000000L);
    }

    @HLEFunctions(value={@HLEFunction(nid=-818271064, version=150), @HLEFunction(nid=-2131617481, version=660)})
    public int sceRtcTickAddWeeks(TPointer64 dstPtr, TPointer64 srcPtr, int value) {
        log.debug((Object)"sceRtcTickAddWeeks redirecting to hleRtcTickAdd32(7*24*60*60*1000000)");
        return this.hleRtcTickAdd32(dstPtr, srcPtr, value, 604800000000L);
    }

    @HLEFunctions(value={@HLEFunction(nid=-604549349, version=150), @HLEFunction(nid=-464050442, version=660)})
    public int sceRtcTickAddMonths(TPointer64 dstPtr, TPointer64 srcPtr, int value) {
        log.debug((Object)"sceRtcTickAddMonths redirecting to hleRtcTickAdd32(30*24*60*60*1000000)");
        return this.hleRtcTickAdd32(dstPtr, srcPtr, value, 2629743000000L);
    }

    @HLEFunctions(value={@HLEFunction(nid=1115958391, version=150), @HLEFunction(nid=-1431400193, version=660)})
    public int sceRtcTickAddYears(TPointer64 dstPtr, TPointer64 srcPtr, int value) {
        log.debug((Object)"sceRtcTickAddYears redirecting to hleRtcTickAdd32(365*24*60*60*1000000)");
        return this.hleRtcTickAdd32(dstPtr, srcPtr, value, 31556926000000L);
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-966544455, version=150), @HLEFunction(nid=445052413, version=660)})
    public int sceRtcFormatRFC2822() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=2112254235, version=150), @HLEFunction(nid=670755984, version=660)})
    public int sceRtcFormatRFC2822LocalTime() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=77134652, version=150), @HLEFunction(nid=533634595, version=660)})
    public int sceRtcFormatRFC3339() {
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=670664003, version=150), @HLEFunction(nid=-1913842662, version=660)})
    public int sceRtcFormatRFC3339LocalTime(TPointer resultString, TPointer64 srcPtr) {
        Date date = this.getDateFromTick(srcPtr.getValue());
        String result = this.formatRFC3339(date);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcFormatRFC3339LocalTime src=%d, returning '%s'", srcPtr.getValue(), result));
        }
        resultString.setStringZ(result);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-541303018, version=150), @HLEFunction(nid=-1012398354, version=660)})
    public int sceRtcParseDateTime() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=685894024, version=150), @HLEFunction(nid=-1113192297, version=660)})
    public int sceRtcParseRFC3339() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=2099232467, version=150), @HLEFunction(nid=-526876465, version=660)})
    public int sceRtcSetAlarmTick(@CanBeNull TPointer64 srcPtr) {
        if (log.isDebugEnabled() && srcPtr.isNotNull()) {
            log.debug((Object)String.format("sceRtcSetAlarmTick src=0x%X", srcPtr.getValue()));
        }
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=540863245, version=200), @HLEFunction(nid=2087622160, version=660)})
    public int sceRtcGetLastReincarnatedTime(TPointer64 tickAddr) {
        tickAddr.setValue(sceRtc.hleGetCurrentTick());
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=1651007128, version=200), @HLEFunction(nid=-376443834, version=660)})
    public int sceRtcGetLastAdjustedTime(TPointer64 tickAddr) {
        tickAddr.setValue(sceRtc.hleGetCurrentTick());
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=420071835, version=200), @HLEFunction(nid=-816967968, version=660)})
    public int sceRtcSetTime64_t(TPointer dateAddr, long time) {
        ScePspDateTime dateTime = ScePspDateTime.fromUnixTime(time);
        dateTime.write(dateAddr);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-506905017, version=200), @HLEFunction(nid=-1809689264, version=660)})
    public int sceRtcGetTime64_t(ScePspDateTime dateTime, TPointer64 timeAddr) {
        Calendar cal = Calendar.getInstance();
        cal.set(dateTime.year, dateTime.month - 1, dateTime.day, dateTime.hour, dateTime.minute, dateTime.second);
        long unixtime = cal.getTime().getTime() / 1000L;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetTime64_t psptime=%s returning unixtime=%d", dateTime, unixtime));
        }
        timeAddr.setValue(unixtime);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-80013107, version=271), @HLEFunction(nid=1393201214, version=660)})
    public int sceRtcRegisterCallback(int callbackId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1785163053, version=271), @HLEFunction(nid=2106472417, version=660)})
    public int sceRtcUnregisterCallback(int callbackId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-167982699, version=150), @HLEFunction(nid=-317377713, version=660)})
    public int sceRtcGetCurrentNetworkTick(TPointer64 networkTick) {
        networkTick.setValue(sceRtc.hleGetCurrentTick());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceRtcGetCurrentNetworkTick returning %d", networkTick.getValue()));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1025655115, version=150), @HLEFunction(nid=912681430, version=660)})
    public int sceRtcGetAlarmTick(TPointer64 alarmTick) {
        alarmTick.setValue(0L);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-823188593, version=150), @HLEFunction(nid=-1270097171, version=660)})
    public int sceRtcGetCurrentSecureTick(TPointer64 currentTick) {
        return this.sceRtcGetCurrentTick(currentTick);
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1972975557, version=150), @HLEFunction(nid=-537721229, version=660)})
    public int sceRtcSetConf(int unknown1, int unknown2, int unknown3, int unknown4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=398617600, version=150), @HLEFunction(nid=1711623210, version=660)})
    public int sceRtcSetCurrentSecureTick() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1221623152, version=150)
    public int sceRtcResume() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-2114135500, version=150), @HLEFunction(nid=-814297115, version=660)})
    public int sceRtcIsAlarmed() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1351329355, version=660)
    public int sceRtc_driver_508BA64B(@CanBeNull @BufferInfo(usage=BufferInfo.Usage.in) TPointer64 unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1859391914, version=150)
    public int sceRtcInit() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1755070152, version=150), @HLEFunction(nid=-1835654962, version=660)})
    public int sceRtcSetCurrentTick() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1664976514, version=150)
    public int sceRtcSuspend() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1057789039, version=150)
    public int sceRtc_driver_C0F36B91() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-965896570, version=150)
    public int sceRtc_driver_C66D9686() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-836248017, version=150)
    public int sceRtcEnd() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-996561105, version=150), @HLEFunction(nid=471357919, version=660)})
    public int sceRtcReset() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-256551140, version=150), @HLEFunction(nid=-2061347400, version=660)})
    public int sceRtcSynchronize() {
        return 0;
    }
}

