/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEPointerFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointerFunction;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspIoDrv;
import jpcsp.HLE.kernel.types.pspIoDrvFuncs;
import jpcsp.HLE.kernel.types.pspUsbDriver;
import jpcsp.HLE.kernel.types.pspUsbdDeviceReq;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.memory.ByteArrayMemory;
import jpcsp.scheduler.Scheduler;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceUsbPspcm
extends HLEModule {
    public static Logger log = Modules.getLogger("sceUsbPspcm");
    private final UsbCommunicationStub usbCommunicationStub = new UsbCommunicationStub();
    private pspUsbDriver usbDriver;
    private pspIoDrv ioDriver;
    private int registeredThreadUid = -1;
    private boolean registeredThreadStarted;
    private SysMemUserForUser.SysMemInfo startThreadParametersSysMemInfo;
    private TPointer startThreadParameters;
    private boolean usbActivated;
    private int simulateIoReadIndex;

    public UsbCommunicationStub getUsbCommunicationStub() {
        return this.usbCommunicationStub;
    }

    private int simulateIoRead(TPointer data, int size) {
        RuntimeContext.debugMemory(data.getAddress(), size);
        ++this.simulateIoReadIndex;
        String simulateIoReadProperty = Settings.getInstance().readString(String.format("sceUsbPspcm.simulateIoRead.%d", this.simulateIoReadIndex));
        simulateIoReadProperty = simulateIoReadProperty.replace(" ", "");
        int result = 0;
        int i = 0;
        while (i < simulateIoReadProperty.length() - 1) {
            String byteString = simulateIoReadProperty.substring(i, i + 2);
            data.setUnsignedValue8(result, Integer.parseInt(byteString, 16));
            i += 2;
            ++result;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("simulateIoRead returning 0x%X: %s", result, Utilities.getMemoryDump(data, result)));
        }
        return result;
    }

    private int simulateIoWrite(TPointer data, int size) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("simulateIoWrite size=0x%X, %s", size, Utilities.getMemoryDump(data, size)));
        }
        return size;
    }

    @Override
    public void load() {
        if (this.usbDriver == null) {
            this.usbDriver = new pspUsbDriver();
            this.usbDriver.name = "USBPSPCommunicationDriver";
            this.usbDriver.endpoints = 4;
            Modules.sceUsbBusModule.hleUsbbdRegister(this.usbDriver);
        }
        if (this.ioDriver == null) {
            this.ioDriver = new pspIoDrv();
            this.ioDriver.name = "usbpspcm";
            this.ioDriver.ioDrvFuncs = new pspIoDrvFuncs();
            this.ioDriver.ioDrvFuncs.ioDevctl = new IoDevctlCallback();
            this.ioDriver.ioDrvFuncs.ioOpen = new IoOpenCallback();
            this.ioDriver.ioDrvFuncs.ioIoctl = new IoIoctlCallback();
            this.ioDriver.ioDrvFuncs.ioWrite = new IoWriteCallback();
            this.ioDriver.ioDrvFuncs.ioRead = new IoReadCallback();
            Modules.IoFileMgrForKernelModule.hleIoAddDrv(this.ioDriver);
        }
        super.load();
    }

    @Override
    public void unload() {
        if (this.usbDriver != null) {
            Modules.sceUsbBusModule.hleUsbbdUnregister(this.usbDriver);
            this.usbDriver = null;
        }
        if (this.ioDriver != null) {
            Modules.IoFileMgrForKernelModule.hleIoDelDrv(this.ioDriver.name);
            this.ioDriver = null;
        }
        super.unload();
    }

    private void startRegisteredThread() {
        if (this.usbActivated && !this.registeredThreadStarted && this.registeredThreadUid >= 0) {
            SceKernelThreadInfo registeredThread;
            if (this.startThreadParameters == null) {
                this.startThreadParametersSysMemInfo = Modules.SysMemUserForUserModule.malloc(2, "sceUsbPspcm Registered Thread Parameters", 0, 8, 0);
                this.startThreadParameters = new TPointer(this.getMemory(), this.startThreadParametersSysMemInfo.addr);
            }
            if ((registeredThread = Modules.ThreadManForUserModule.getThreadById(this.registeredThreadUid)) != null) {
                this.startThreadParameters.setValue32(0, 0);
                this.startThreadParameters.setValue32(4, 129);
                Modules.ThreadManForUserModule.hleKernelStartThread(registeredThread, 8, this.startThreadParameters, 0);
                this.registeredThreadStarted = true;
            }
        }
    }

    public void onUsbActivate(int pid) {
        if (this.usbDriver != null) {
            this.usbActivated = true;
            this.startRegisteredThread();
        } else {
            pspUsbDriver usbDriver = Modules.sceUsbBusModule.getRegisteredUsbDriver("USBPSPCommunicationDriver");
            if (usbDriver != null) {
                Modules.sceUsbPspcmModule.getUsbCommunicationStub().hleUsbActivate(usbDriver, pid);
            }
        }
    }

    public void onUsbDeactivate() {
        this.usbActivated = false;
        this.registeredThreadStarted = false;
    }

    private class IoReadCallback
    extends HLEPointerFunction {
        private IoReadCallback() {
        }

        @Override
        public int executeCallback(int iob, int dataAddr, int size) {
            return sceUsbPspcm.this.simulateIoRead(new TPointer(sceUsbPspcm.this.getMemory(), dataAddr), size);
        }
    }

    private class IoWriteCallback
    extends HLEPointerFunction {
        private IoWriteCallback() {
        }

        @Override
        public int executeCallback(int iob, int dataAddr, int size) {
            return sceUsbPspcm.this.simulateIoWrite(new TPointer(sceUsbPspcm.this.getMemory(), dataAddr), size);
        }
    }

    private class IoIoctlCallback
    extends HLEPointerFunction {
        private IoIoctlCallback() {
        }

        @Override
        public int executeCallback(int iob, int cmd, int indata, int inlen, int outdata, int outlen) {
            block0 : switch (cmd) {
                case 54616322: {
                    if (inlen < 4) break;
                    int mode = sceUsbPspcm.this.getMemory().read32(indata);
                    switch (mode) {
                        case 0: {
                            log.debug((Object)"IoIoctlCallback set unknown mode");
                            break block0;
                        }
                        case 1: {
                            log.debug((Object)"IoIoctlCallback set read mode");
                            break block0;
                        }
                        case 2: {
                            log.debug((Object)"IoIoctlCallback set write mode");
                            break block0;
                        }
                    }
                    log.error((Object)String.format("IoIoctlCallback unknown mode 0x%X", mode));
                }
            }
            return 0;
        }
    }

    private class IoOpenCallback
    extends HLEPointerFunction {
        private IoOpenCallback() {
        }

        @Override
        public int executeCallback(int iob) {
            TPointer iobBuffer = new TPointer(sceUsbPspcm.this.getMemory(), iob);
            int fsNum = iobBuffer.getValue32(4);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("IoOpenCallback on usbpspcm%d:", fsNum));
            }
            return 0;
        }
    }

    private class IoDevctlCallback
    extends HLEPointerFunction {
        private IoDevctlCallback() {
        }

        @Override
        public int executeCallback(int unknownArg0, int deviceName, int cmd, int indata, int inlen, int outdata, int outlen) {
            switch (cmd) {
                case 54611969: {
                    sceUsbPspcm.this.registeredThreadStarted = false;
                    if (inlen >= 4) {
                        sceUsbPspcm.this.registeredThreadUid = sceUsbPspcm.this.getMemory().read32(indata);
                        Scheduler.getInstance().addAction(Scheduler.getNow() + 100000L, new StartRegisteredThreadAction());
                        break;
                    }
                    sceUsbPspcm.this.registeredThreadUid = -1;
                    break;
                }
                case 54611970: {
                    sceUsbPspcm.this.registeredThreadStarted = false;
                    sceUsbPspcm.this.registeredThreadUid = -1;
                    break;
                }
                case 54743045: {
                    if (outlen < 11) break;
                    Utilities.writeStringZ(sceUsbPspcm.this.getMemory(), outdata, "usbpspcm0:");
                }
            }
            return 0;
        }
    }

    private class StartRegisteredThreadAction
    implements IAction {
        private StartRegisteredThreadAction() {
        }

        @Override
        public void execute() {
            sceUsbPspcm.this.startRegisteredThread();
        }
    }

    public static class UsbCommunicationStub
    implements IAction {
        private int version;
        private Action action;
        private SysMemUserForUser.SysMemInfo bufferSysMemInfo;
        private TPointer buffer;
        private pspUsbDriver usbPspcmDriver;
        private SceKernelThreadInfo thread;
        private UsbCommunicationEndpoint[] endpoints;

        private TPointer getBuffer() {
            if (this.bufferSysMemInfo == null) {
                this.bufferSysMemInfo = Modules.SysMemUserForUserModule.malloc(2, "sceUsb Buffer", 0, 8, 0);
                this.buffer = new TPointer(Memory.getInstance(), this.bufferSysMemInfo.addr);
            }
            return this.buffer;
        }

        public int hleUsbbdReqRecv(pspUsbDriver usbDriver, pspUsbdDeviceReq deviceReq, TPointer req) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("UsbCommunicationStub.sceUsbbdReqRecv endpnum=0x%X", deviceReq.endp.getValue32(0)));
            }
            UsbCommunicationEndpoint endpoint = this.endpoints[deviceReq.endp.getValue32(0)];
            if (this.version == 0) {
                this.scheduleAction(usbDriver, Action.REQUEST_VERSION);
            }
            this.receiveData(endpoint, deviceReq, req);
            return 0;
        }

        public int hleUsbbdReqSend(pspUsbDriver usbDriver, pspUsbdDeviceReq deviceReq, TPointer req) {
            TPointer data = deviceReq.data;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("UsbCommunicationStub.sceUsbbdReqSend endpnum=0x%X, action=%s", new Object[]{deviceReq.endp.getValue32(0), this.action}));
            }
            switch (this.action) {
                case REQUEST_VERSION: {
                    if (deviceReq.size != 4) break;
                    this.version = data.getValue32(0);
                    this.scheduleAction(usbDriver, Action.INITIALIZE_CONNECTION);
                    break;
                }
                case INITIALIZE_CONNECTION: {
                    if (deviceReq.size != 8 || data.getValue32(0) != 4) break;
                    int unknown0 = data.getUnsignedValue8(4);
                    int unknown1 = data.getUnsignedValue8(5);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Bind request unknown0=0x%02X, unknown1=0x%02X", unknown0, unknown1));
                    }
                    this.scheduleAction(usbDriver, Action.BIND);
                    break;
                }
                case BIND: {
                    if (deviceReq.size != 1) break;
                    int success = data.getUnsignedValue8(0);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Bind response success=%d", success));
                    }
                    if (success == 0) break;
                    this.action = Action.TRANSFER;
                    break;
                }
                case TRANSFER: {
                    if (deviceReq.size == 8 && data.getValue32(0) == 0x810000) {
                        this.action = Action.RECEIVE_DATA;
                        break;
                    }
                    if (deviceReq.size != 8 || data.getValue32(0) != 65536) break;
                    this.action = Action.TRANSFER_DATA;
                    break;
                }
                case TRANSFER_DATA: {
                    Modules.sceUsbPspcmModule.simulateIoWrite(data, deviceReq.size);
                    this.action = Action.TRANSFER;
                    break;
                }
                case RECEIVE_DATA: {
                    Modules.sceUsbPspcmModule.simulateIoWrite(data, deviceReq.size);
                    this.scheduleAction(usbDriver, Action.SEND_DATA_HEADER);
                    break;
                }
            }
            return 0;
        }

        public int hleUsbActivate(pspUsbDriver usbDriver, int pid) {
            this.endpoints = new UsbCommunicationEndpoint[usbDriver.endpoints];
            for (int i = 0; i < this.endpoints.length; ++i) {
                this.endpoints[i] = new UsbCommunicationEndpoint();
            }
            this.scheduleAction(usbDriver, Action.ACTIVATE);
            return 0;
        }

        private void scheduleAction(pspUsbDriver usbDriver, Action action) {
            this.usbPspcmDriver = usbDriver;
            this.action = action;
            this.thread = Modules.ThreadManForUserModule.getCurrentThread();
            Emulator.getScheduler().addAction(Scheduler.getNow() + 100000L, this);
        }

        private void storeResponse(pspUsbdDeviceReq deviceReq, TPointer req, int size) {
            deviceReq.recvsize = size;
            deviceReq.retcode = 0;
            deviceReq.write(req);
        }

        @Override
        public void execute() {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("UsbCommunicationStub action=%s", new Object[]{this.action}));
            }
            UsbCommunicationEndpoint ctrlEndpoint = this.endpoints[0];
            TPointer buffer = this.getBuffer();
            switch (this.action) {
                case ACTIVATE: {
                    ctrlEndpoint.receiveBuffer.setValue32(0, 0x3000000);
                    ctrlEndpoint.receiveBuffer.setValue32(0, 33947664);
                    ctrlEndpoint.receiveBufferSize = 4;
                    buffer.setUnsignedValue8(0, 65);
                    buffer.setUnsignedValue8(1, 7);
                    buffer.setUnsignedValue16(6, ctrlEndpoint.receiveBufferSize);
                    this.callReceivedCallback(buffer);
                    break;
                }
                case REQUEST_VERSION: {
                    buffer.setUnsignedValue8(0, 193);
                    buffer.setUnsignedValue8(1, 8);
                    this.callReceivedCallback(buffer);
                    break;
                }
                case INITIALIZE_CONNECTION: {
                    ctrlEndpoint.receiveBuffer.setValue32(0, 2);
                    ctrlEndpoint.receiveBuffer.setValue32(4, 2);
                    ctrlEndpoint.receiveBuffer.setValue32(8, 4096);
                    ctrlEndpoint.receiveBufferSize = 12;
                    buffer.setUnsignedValue8(0, 65);
                    buffer.setUnsignedValue8(1, 2);
                    buffer.setUnsignedValue16(2, 0);
                    buffer.setUnsignedValue16(6, ctrlEndpoint.receiveBufferSize);
                    this.callReceivedCallback(buffer);
                    break;
                }
                case BIND: {
                    ctrlEndpoint.receiveBufferSize = 0;
                    buffer.setUnsignedValue8(0, 193);
                    buffer.setUnsignedValue8(1, 4);
                    buffer.setUnsignedValue16(6, ctrlEndpoint.receiveBufferSize);
                    this.callReceivedCallback(buffer);
                    break;
                }
                case SEND_DATA_HEADER: {
                    TPointer data = new TPointer(this.endpoints[2].receiveBuffer, 8);
                    int readSize = Modules.sceUsbPspcmModule.simulateIoRead(data, 504);
                    this.endpoints[2].receiveBuffer.setUnalignedValue16(0, 0);
                    this.endpoints[2].receiveBuffer.setUnalignedValue16(2, 1);
                    this.endpoints[2].receiveBuffer.setValue32(4, readSize);
                    this.endpoints[2].receiveBufferSize = 8;
                    this.endpoints[2].receiveBufferSize2 = readSize;
                    this.onDataReceived(this.endpoints[2]);
                    this.action = Action.TRANSFER;
                    break;
                }
            }
        }

        private void receiveData(UsbCommunicationEndpoint endpoint, pspUsbdDeviceReq deviceReq, TPointer req) {
            if (endpoint.receiveBufferSize <= 0) {
                endpoint.pendingReadRequest = deviceReq;
                endpoint.pendingReadRequestPtr = req;
            } else {
                TPointer data = deviceReq.data;
                int size = Math.min(endpoint.receiveBufferSize, deviceReq.size);
                data.memcpy(endpoint.receiveBuffer, size);
                endpoint.receiveBufferSize -= size;
                this.storeResponse(deviceReq, req, size);
                if (endpoint.receiveBufferSize == 0 && endpoint.receiveBufferSize2 > 0) {
                    endpoint.receiveBuffer.memcpy(endpoint.receiveBufferSize, new TPointer(endpoint.receiveBuffer, size), endpoint.receiveBufferSize2);
                    endpoint.receiveBufferSize += endpoint.receiveBufferSize2;
                    endpoint.receiveBufferSize2 = 0;
                }
                Modules.sceUsbBusModule.triggerCompletionFunction(deviceReq);
            }
        }

        private void onDataReceived(UsbCommunicationEndpoint endpoint) {
            if (endpoint.pendingReadRequest != null) {
                this.receiveData(endpoint, endpoint.pendingReadRequest, endpoint.pendingReadRequestPtr);
            }
        }

        private void callReceivedCallback(TPointer buffer) {
            TPointerFunction recvctl = this.usbPspcmDriver.recvctl;
            int recipient = buffer.getUnsignedValue8(0) & 0x1F;
            if (recvctl != null) {
                recvctl.executeCallback(this.thread, recipient, 0, buffer.getAddress());
            }
        }

        private static class UsbCommunicationEndpoint {
            public final TPointer receiveBuffer = new ByteArrayMemory(new byte[512]).getPointer();
            public int receiveBufferSize;
            public int receiveBufferSize2;
            public pspUsbdDeviceReq pendingReadRequest;
            public TPointer pendingReadRequestPtr;

            private UsbCommunicationEndpoint() {
            }
        }

        private static enum Action {
            ACTIVATE,
            REQUEST_VERSION,
            INITIALIZE_CONNECTION,
            BIND,
            TRANSFER,
            TRANSFER_DATA,
            RECEIVE_DATA,
            SEND_DATA_HEADER;

        }
    }
}

