/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import jpcsp.Controller;
import jpcsp.Emulator;
import jpcsp.GUI.SettingsGUI;
import jpcsp.GeneralJpcspException;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEModuleManager;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.StringInfo;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.local.LocalVirtualFileSystem;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.managers.SystemTimeManager;
import jpcsp.HLE.kernel.types.SceFontInfo;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.SceKernelLMOption;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.kernel.types.SceUtilityGameSharingParams;
import jpcsp.HLE.kernel.types.SceUtilityGamedataInstallParams;
import jpcsp.HLE.kernel.types.SceUtilityHtmlViewerParams;
import jpcsp.HLE.kernel.types.SceUtilityInstallParams;
import jpcsp.HLE.kernel.types.SceUtilityMsgDialogParams;
import jpcsp.HLE.kernel.types.SceUtilityNetconfParams;
import jpcsp.HLE.kernel.types.SceUtilityNpSigninParams;
import jpcsp.HLE.kernel.types.SceUtilityOskParams;
import jpcsp.HLE.kernel.types.SceUtilitySavedataParam;
import jpcsp.HLE.kernel.types.SceUtilityScreenshotParams;
import jpcsp.HLE.kernel.types.pspCharInfo;
import jpcsp.HLE.kernel.types.pspUtilityBaseDialog;
import jpcsp.HLE.kernel.types.pspUtilityDialogCommon;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.HLE.modules.ModuleMgrForUser;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.HLE.modules.sceNetApctl;
import jpcsp.HLE.modules.sceRtc;
import jpcsp.Memory;
import jpcsp.NIDMapper;
import jpcsp.Processor;
import jpcsp.State;
import jpcsp.crypto.CryptoEngine;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.format.PNG;
import jpcsp.format.PSF;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.capture.CaptureImage;
import jpcsp.hardware.MemoryStick;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.ImageReader;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.settings.Settings;
import jpcsp.util.HLEUtilities;
import jpcsp.util.MemoryInputStream;
import jpcsp.util.Utilities;
import jpcsp.util.sceGu;
import org.apache.log4j.Logger;

public class sceUtility
extends HLEModule {
    public static Logger log = Modules.getLogger("sceUtility");
    public static final String SYSTEMPARAM_SETTINGS_OPTION_NICKNAME = "emu.sysparam.nickname";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_ADHOC_CHANNEL = "emu.sysparam.adhocchannel";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_WLAN_POWER_SAVE = "emu.sysparam.wlanpowersave";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_DATE_FORMAT = "emu.sysparam.dateformat";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_TIME_FORMAT = "emu.sysparam.timeformat";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_TIME_ZONE = "emu.sysparam.timezone";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_DAYLIGHT_SAVING_TIME = "emu.sysparam.daylightsavings";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_LANGUAGE = "emu.impose.language";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_BUTTON_PREFERENCE = "emu.impose.button";
    public static final String SYSTEMPARAM_SETTINGS_OPTION_LOCK_PARENTAL_LEVEL = "emu.sysparam.locl.parentallevel";
    public static final int PSP_SYSTEMPARAM_ID_STRING_NICKNAME = 1;
    public static final int PSP_SYSTEMPARAM_ID_INT_ADHOC_CHANNEL = 2;
    public static final int PSP_SYSTEMPARAM_ID_INT_WLAN_POWERSAVE = 3;
    public static final int PSP_SYSTEMPARAM_ID_INT_DATE_FORMAT = 4;
    public static final int PSP_SYSTEMPARAM_ID_INT_TIME_FORMAT = 5;
    public static final int PSP_SYSTEMPARAM_ID_INT_TIMEZONE = 6;
    public static final int PSP_SYSTEMPARAM_ID_INT_DAYLIGHTSAVINGS = 7;
    public static final int PSP_SYSTEMPARAM_ID_INT_LANGUAGE = 8;
    public static final int PSP_SYSTEMPARAM_ID_INT_BUTTON_PREFERENCE = 9;
    public static final int PSP_SYSTEMPARAM_ID_INT_LOCK_PARENTAL_LEVEL = 10;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_JAPANESE = 0;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_ENGLISH = 1;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_FRENCH = 2;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_SPANISH = 3;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_GERMAN = 4;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_ITALIAN = 5;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_DUTCH = 6;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_PORTUGUESE = 7;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_RUSSIAN = 8;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_KOREAN = 9;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_CHINESE_TRADITIONAL = 10;
    public static final int PSP_SYSTEMPARAM_LANGUAGE_CHINESE_SIMPLIFIED = 11;
    public static final int PSP_SYSTEMPARAM_DATE_FORMAT_YYYYMMDD = 0;
    public static final int PSP_SYSTEMPARAM_DATE_FORMAT_MMDDYYYY = 1;
    public static final int PSP_SYSTEMPARAM_DATE_FORMAT_DDMMYYYY = 2;
    public static final int PSP_SYSTEMPARAM_TIME_FORMAT_24HR = 0;
    public static final int PSP_SYSTEMPARAM_TIME_FORMAT_12HR = 1;
    public static final int PSP_SYSTEMPARAM_BUTTON_CIRCLE = 0;
    public static final int PSP_SYSTEMPARAM_BUTTON_CROSS = 1;
    public static final int PSP_UTILITY_DIALOG_STATUS_NONE = 0;
    public static final int PSP_UTILITY_DIALOG_STATUS_INIT = 1;
    public static final int PSP_UTILITY_DIALOG_STATUS_VISIBLE = 2;
    public static final int PSP_UTILITY_DIALOG_STATUS_QUIT = 3;
    public static final int PSP_UTILITY_DIALOG_STATUS_FINISHED = 4;
    public static final int PSP_UTILITY_DIALOG_STATUS_SCREENSHOT_UNKNOWN = 5;
    public static final int PSP_UTILITY_DIALOG_RESULT_OK = 0;
    public static final int PSP_UTILITY_DIALOG_RESULT_CANCELED = 1;
    public static final int PSP_UTILITY_DIALOG_RESULT_ABORTED = 2;
    public static final int PSP_NETPARAM_NAME = 0;
    public static final int PSP_NETPARAM_SSID = 1;
    public static final int PSP_NETPARAM_SECURE = 2;
    public static final int PSP_NETPARAM_WEPKEY = 3;
    public static final int PSP_NETPARAM_IS_STATIC_IP = 4;
    public static final int PSP_NETPARAM_IP = 5;
    public static final int PSP_NETPARAM_NETMASK = 6;
    public static final int PSP_NETPARAM_ROUTE = 7;
    public static final int PSP_NETPARAM_MANUAL_DNS = 8;
    public static final int PSP_NETPARAM_PRIMARYDNS = 9;
    public static final int PSP_NETPARAM_SECONDARYDNS = 10;
    public static final int PSP_NETPARAM_PROXY_USER = 11;
    public static final int PSP_NETPARAM_PROXY_PASS = 12;
    public static final int PSP_NETPARAM_USE_PROXY = 13;
    public static final int PSP_NETPARAM_PROXY_SERVER = 14;
    public static final int PSP_NETPARAM_PROXY_PORT = 15;
    public static final int PSP_NETPARAM_VERSION = 16;
    public static final int PSP_NETPARAM_UNKNOWN = 17;
    public static final int PSP_NETPARAM_8021X_AUTH_TYPE = 18;
    public static final int PSP_NETPARAM_8021X_USER = 19;
    public static final int PSP_NETPARAM_8021X_PASS = 20;
    public static final int PSP_NETPARAM_WPA_TYPE = 21;
    public static final int PSP_NETPARAM_WPA_KEY = 22;
    public static final int PSP_NETPARAM_BROWSER = 23;
    public static final int PSP_NETPARAM_WIFI_CONFIG = 24;
    public static final int PSP_NETPARAM_MAX_NUMBER_DUMMY_ENTRIES = 10;
    protected static final int maxLineLengthForDialog = 40;
    protected static final int icon0Width = 144;
    protected static final int icon0Height = 80;
    protected static final int icon0PixelFormat = 3;
    protected static final int smallIcon0Width = 80;
    protected static final int smallIcon0Height = 44;
    protected static final int icon0BufferWidth = VideoEngine.alignBufferWidth(144 + IRenderingEngine.alignementOfTextureBufferWidth[3] - 1, 3);
    protected GameSharingUtilityDialogState gameSharingState;
    protected UtilityDialogState netplayDialogState;
    protected NetconfUtilityDialogState netconfState;
    protected SavedataUtilityDialogState savedataState;
    protected MsgDialogUtilityDialogState msgDialogState;
    protected OskUtilityDialogState oskState;
    protected UtilityDialogState npSigninState;
    protected UtilityDialogState PS3ScanState;
    protected UtilityDialogState rssReaderState;
    protected UtilityDialogState rssSubscriberState;
    protected ScreenshotUtilityDialogState screenshotState;
    protected HtmlViewerUtilityDialogState htmlViewerState;
    protected UtilityDialogState savedataErrState;
    protected GamedataInstallUtilityDialogState gamedataInstallState;
    protected UtilityDialogState storeCheckoutState;
    protected UtilityDialogState psnState;
    protected UtilityDialogState dnasDialogState;
    protected UtilityDialogState authDialogState;
    protected UtilityDialogState autoConnectDialogState;
    protected UtilityDialogState startedDialogState;
    private static final String dummyNetParamName = "NetConf #%d";
    private static final int utilityThreadActionRegister = 16;
    private static final int utilityThreadDelayRegister = 17;
    private static final int UTILITY_THREAD_ACTION_INIT_START = 0;
    private static final int UTILITY_THREAD_ACTION_INIT_COMPLETE = 1;
    private static final int UTILITY_THREAD_ACTION_SHUTDOWN_START = 2;
    private static final int UTILITY_THREAD_ACTION_SHUTDOWN_COMPLETE = 3;
    protected Map<String, int[]> loadedModules = new HashMap<String, int[]>();
    protected Set<String> waitingModules = new HashSet<String>();
    public static final String[] utilityAvModuleNames = new String[]{"PSP_AV_MODULE_AVCODEC", "PSP_AV_MODULE_SASCORE", "PSP_AV_MODULE_ATRAC3PLUS", "PSP_AV_MODULE_MPEGBASE", "PSP_AV_MODULE_MP3", "PSP_AV_MODULE_VAUDIO", "PSP_AV_MODULE_AAC", "PSP_AV_MODULE_G729"};
    public static final String[] utilityUsbModuleNames = new String[]{"PSP_USB_MODULE_UNKNOWN_0", "PSP_USB_MODULE_PSPCM", "PSP_USB_MODULE_ACC", "PSP_USB_MODULE_MIC", "PSP_USB_MODULE_CAM", "PSP_USB_MODULE_GPS"};
    private static HashMap<String, String> utilityPrivateModules;
    public static final int PSP_AV_MODULE_AVCODEC = 0;
    public static final int PSP_AV_MODULE_SASCORE = 1;
    public static final int PSP_AV_MODULE_ATRAC3PLUS = 2;
    public static final int PSP_AV_MODULE_MPEGBASE = 3;
    public static final int PSP_AV_MODULE_MP3 = 4;
    public static final int PSP_AV_MODULE_VAUDIO = 5;
    public static final int PSP_AV_MODULE_AAC = 6;
    public static final int PSP_AV_MODULE_G729 = 7;
    public static final int PSP_USB_MODULE_PSPCM = 1;
    public static final int PSP_USB_MODULE_ACC = 2;
    public static final int PSP_USB_MODULE_MIC = 3;
    public static final int PSP_USB_MODULE_CAM = 4;
    public static final int PSP_USB_MODULE_GPS = 5;
    public static final String[] utilityNetModuleNames;
    public static final int PSP_NET_MODULE_COMMON = 1;
    public static final int PSP_NET_MODULE_ADHOC = 2;
    public static final int PSP_NET_MODULE_INET = 3;
    public static final int PSP_NET_MODULE_PARSEURI = 4;
    public static final int PSP_NET_MODULE_PARSEHTTP = 5;
    public static final int PSP_NET_MODULE_HTTP = 6;
    public static final int PSP_NET_MODULE_SSL = 7;
    protected InstallUtilityDialogState installState;
    private int UTILITY_LOOP_ADDRESS;

    @Override
    public void start() {
        this.gameSharingState = new GameSharingUtilityDialogState("sceUtilityGameSharing");
        this.netplayDialogState = new NotImplementedUtilityDialogState("sceNetplayDialog");
        this.netconfState = new NetconfUtilityDialogState("sceUtilityNetconf");
        this.savedataState = new SavedataUtilityDialogState("sceUtilitySavedata");
        this.msgDialogState = new MsgDialogUtilityDialogState("sceUtilityMsgDialog");
        this.oskState = new OskUtilityDialogState("sceUtilityOsk");
        this.npSigninState = new NpSigninUtilityDialogState("sceUtilityNpSignin");
        this.PS3ScanState = new NotImplementedUtilityDialogState("sceUtilityPS3Scan");
        this.rssReaderState = new NotImplementedUtilityDialogState("sceUtilityRssReader");
        this.rssSubscriberState = new NotImplementedUtilityDialogState("sceUtilityRssSubscriber");
        this.screenshotState = new ScreenshotUtilityDialogState("sceUtilityScreenshot");
        this.htmlViewerState = new HtmlViewerUtilityDialogState("sceUtilityHtmlViewer");
        this.savedataErrState = new NotImplementedUtilityDialogState("sceUtilitySavedataErr");
        this.gamedataInstallState = new GamedataInstallUtilityDialogState("sceUtilityGamedataInstall");
        this.storeCheckoutState = new NotImplementedUtilityDialogState("sceUtilityStoreCheckout");
        this.psnState = new NotImplementedUtilityDialogState("sceUtilityPsn");
        this.installState = new InstallUtilityDialogState("sceUtilityInstall");
        this.dnasDialogState = new NotImplementedUtilityDialogState("sceUtilityDNAS");
        this.authDialogState = new NotImplementedUtilityDialogState("sceUtilityAuthDialog");
        this.autoConnectDialogState = new NotImplementedUtilityDialogState("sceUtilityAutoConnect");
        this.startedDialogState = null;
        utilityPrivateModules = new HashMap();
        utilityPrivateModules.put("htmlviewer_ui", "flash0:/vsh/module/htmlviewer_ui.prx");
        utilityPrivateModules.put("hvauth_r", "flash0:/vsh/module/hvauth_r.prx");
        utilityPrivateModules.put("hvauth_t", "flash0:/vsh/module/hvauth_t.prx");
        utilityPrivateModules.put("netfront", "flash0:/vsh/module/netfront.prx");
        utilityPrivateModules.put("mgvideo", "flash0:/kd/mgvideo.prx");
        utilityPrivateModules.put("mm_flash", "flash0:/vsh/module/mm_flash.prx");
        utilityPrivateModules.put("libslim", "flash0:/vsh/module/libslim.prx");
        utilityPrivateModules.put("libwww", "flash0:/vsh/module/libwww.prx");
        utilityPrivateModules.put("libfont_hv", "flash0:/vsh/module/libfont_hv.prx");
        this.UTILITY_LOOP_ADDRESS = HLEUtilities.getInstance().installLoopHandler(this, "hleUtilityThread");
        super.start();
    }

    @Override
    public void stop() {
        this.loadedModules.clear();
        this.waitingModules.clear();
        super.stop();
    }

    private String getNetModuleName(int module) {
        if (module < 0 || module >= utilityNetModuleNames.length) {
            return "PSP_NET_MODULE_UNKNOWN_" + module;
        }
        return utilityNetModuleNames[module];
    }

    public int loadModules(String moduleName) {
        HLEModuleManager moduleManager = HLEModuleManager.getInstance();
        if (this.loadedModules.containsKey(moduleName) || this.waitingModules.contains(moduleName)) {
            return -2146367486;
        }
        if (!moduleManager.hasFlash0Module(moduleName)) {
            this.waitingModules.add(moduleName);
            return -2146367487;
        }
        int[] moduleIds = moduleManager.LoadFlash0Module(moduleName);
        this.loadedModules.put(moduleName, moduleIds);
        return 0;
    }

    public int unloadModules(String moduleName) {
        if (this.loadedModules.containsKey(moduleName)) {
            HLEModuleManager moduleManager = HLEModuleManager.getInstance();
            int[] moduleIds = this.loadedModules.remove(moduleName);
            if (moduleIds != null) {
                for (int moduleId : moduleIds) {
                    SceModule sceModule = Managers.modules.getModuleByUID(moduleId);
                    if (sceModule == null) continue;
                    moduleManager.UnloadFlash0Module(sceModule);
                }
            }
            return 0;
        }
        if (this.waitingModules.contains(moduleName)) {
            this.waitingModules.remove(moduleName);
            return 0;
        }
        return -2146367485;
    }

    private static Locale getUtilityLocale(int language) {
        Locale utilityLocale = Locale.getDefault();
        switch (language) {
            case 0: {
                utilityLocale = Locale.JAPANESE;
                break;
            }
            case 1: {
                utilityLocale = Locale.ENGLISH;
                break;
            }
            case 2: {
                utilityLocale = Locale.FRENCH;
                break;
            }
            case 3: {
                utilityLocale = new Locale("es");
                break;
            }
            case 4: {
                utilityLocale = Locale.GERMAN;
                break;
            }
            case 5: {
                utilityLocale = Locale.ITALIAN;
                break;
            }
            case 6: {
                utilityLocale = new Locale("nl");
                break;
            }
            case 7: {
                utilityLocale = new Locale("pt");
                break;
            }
            case 8: {
                utilityLocale = new Locale("ru");
                break;
            }
            case 9: {
                utilityLocale = Locale.KOREAN;
                break;
            }
            case 10: {
                utilityLocale = Locale.TRADITIONAL_CHINESE;
                break;
            }
            case 11: {
                utilityLocale = Locale.CHINESE;
            }
        }
        return utilityLocale;
    }

    private static String getDateTimeFormatString() {
        StringBuilder dateTimeFormat = new StringBuilder();
        switch (sceUtility.getSystemParamDateFormat()) {
            case 2: {
                dateTimeFormat.append("%te/%<tm/%<tY");
                break;
            }
            case 1: {
                dateTimeFormat.append("%tm/%<te/%<tY");
                break;
            }
            case 0: {
                dateTimeFormat.append("%tY/%<tm/%<te");
                break;
            }
            default: {
                dateTimeFormat.append("%tF");
            }
        }
        dateTimeFormat.append(" ");
        switch (sceUtility.getSystemParamTimeFormat()) {
            case 1: {
                dateTimeFormat.append("%<tl:%<tM %<Tp");
                break;
            }
            case 0: {
                dateTimeFormat.append("%<tk:%<tM");
                break;
            }
            default: {
                dateTimeFormat.append("%<tR");
            }
        }
        return dateTimeFormat.toString();
    }

    private static String formatDateTime(Calendar dateTime) {
        String formattedDateTime = String.format(sceUtility.getDateTimeFormatString(), dateTime);
        if (formattedDateTime.startsWith("0")) {
            formattedDateTime = formattedDateTime.substring(1);
        }
        formattedDateTime = formattedDateTime.replace("/0", "/");
        return formattedDateTime;
    }

    @HLEFunction(nid=-1, version=150)
    public void hleUtilityThread(Processor processor) {
        SceKernelThreadInfo currentThread = Modules.ThreadManForUserModule.getCurrentThread();
        int action = processor.cpu.getRegister(16);
        int delay = processor.cpu.getRegister(17);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleUtilityThread action=%d, delay=%d", action, delay));
        }
        switch (action) {
            case 0: {
                int lockResult = Modules.sceSuspendForUserModule.hleKernelVolatileMemLock(0, false);
                if (lockResult < 0) {
                    log.error((Object)String.format("hleUtilityThread init thread cannot lock the volatile mem 0x%08X", lockResult));
                }
                currentThread.cpuContext.setRegister(16, 1);
                if (!currentThread.isRunning() || delay <= 0) break;
                Modules.ThreadManForUserModule.hleKernelDelayThread(delay, false);
                break;
            }
            case 1: {
                this.startedDialogState.status = 2;
                this.startedDialogState.startVisibleTimeMillis = Emulator.getClock().currentTimeMillis();
                if (!this.startedDialogState.hasDialog()) {
                    this.startedDialogState.dialogState = UtilityDialogState.DialogState.quit;
                }
                processor.cpu._v0 = 0;
                Modules.ThreadManForUserModule.hleKernelExitDeleteThread();
                break;
            }
            case 2: {
                int unlockResult = Modules.sceSuspendForUserModule.hleKernelVolatileMemUnlock(0);
                if (unlockResult < 0) {
                    log.error((Object)String.format("hleUtilityThread shutdown thread cannot unlock the volatile mem 0x%08X", unlockResult));
                } else {
                    Memory mem = Memory.getInstance();
                    mem.memset(0x8400000, (byte)0, 0x400000);
                }
                currentThread.cpuContext.setRegister(16, 3);
                if (!currentThread.isRunning() || delay <= 0) break;
                Modules.ThreadManForUserModule.hleKernelDelayThread(delay, false);
                break;
            }
            case 3: {
                this.startedDialogState.status = 0;
                processor.cpu._v0 = 0;
                Modules.ThreadManForUserModule.hleKernelExitDeleteThread();
            }
        }
    }

    public static String getSystemParamNickname() {
        return Settings.getInstance().readString(SYSTEMPARAM_SETTINGS_OPTION_NICKNAME);
    }

    public static int getSystemParamAdhocChannel() {
        int indexedValue = Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_ADHOC_CHANNEL, 0);
        String[] guiValues = SettingsGUI.getSysparamAdhocChannels();
        int channel = 0;
        if (guiValues == null || indexedValue < 0 || indexedValue >= guiValues.length) {
            return channel;
        }
        if (indexedValue == 0) {
            return channel;
        }
        try {
            channel = Integer.parseInt(guiValues[indexedValue]);
        }
        catch (NumberFormatException e) {
            log.error((Object)String.format("Invalid channel settings value %d from %s", indexedValue, guiValues));
        }
        return channel;
    }

    public static int getSystemParamWlanPowersave() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_WLAN_POWER_SAVE, 0);
    }

    public static int getSystemParamDateFormat() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_DATE_FORMAT, 0);
    }

    public static int getSystemParamTimeFormat() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_TIME_FORMAT, 0);
    }

    public static int getSystemParamTimeZone() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_TIME_ZONE, 0);
    }

    public static int getSystemParamDaylightSavingTime() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_DAYLIGHT_SAVING_TIME, 0);
    }

    public static int getSystemParamLanguage() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_LANGUAGE, 1);
    }

    public static int getSystemParamButtonPreference() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_BUTTON_PREFERENCE, 1);
    }

    public static int getSystemParamLockParentalLevel() {
        return Settings.getInstance().readInt(SYSTEMPARAM_SETTINGS_OPTION_LOCK_PARENTAL_LEVEL, 0);
    }

    protected static String getNetParamName(int id) {
        if (id == 0) {
            return "";
        }
        return String.format(dummyNetParamName, id);
    }

    protected static String formatMessageForDialog(String message) {
        StringBuilder formattedMessage = new StringBuilder();
        int i = 0;
        while (i < message.length()) {
            String rest = message.substring(i);
            int newLineIndex = rest.indexOf("\n");
            if (newLineIndex >= 0 && newLineIndex < 40) {
                formattedMessage.append(rest.substring(0, newLineIndex + 1));
                i += newLineIndex + 1;
                continue;
            }
            if (rest.length() > 40) {
                int lastSpace = rest.lastIndexOf(32, 40);
                rest = rest.substring(0, lastSpace >= 0 ? lastSpace : 40);
                formattedMessage.append(rest);
                i += rest.length() + 1;
                formattedMessage.append("\n");
                continue;
            }
            formattedMessage.append(rest);
            i += rest.length();
        }
        return formattedMessage.toString();
    }

    private String getModuleName(int module) {
        for (UtilityModule m : UtilityModule.values()) {
            if (m.getID() != module) continue;
            return m.name();
        }
        return String.format("PSP_MODULE_UNKNOWN_%X", module);
    }

    private String getAvModuleName(int module) {
        if (module < 0 || module >= utilityAvModuleNames.length) {
            return "PSP_AV_MODULE_UNKNOWN_" + module;
        }
        return utilityAvModuleNames[module];
    }

    private String getUsbModuleName(int module) {
        if (module < 0 || module >= utilityUsbModuleNames.length) {
            return "PSP_USB_MODULE_UNKNOWN_" + module;
        }
        return utilityUsbModuleNames[module];
    }

    @HLEFunction(nid=-997001391, version=150)
    public int sceUtilityGameSharingInitStart(TPointer paramsAddr) {
        return this.gameSharingState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-272173041, version=150)
    public int sceUtilityGameSharingShutdownStart() {
        return this.gameSharingState.executeShutdownStart();
    }

    @HLEFunction(nid=2018711597, version=150)
    public int sceUtilityGameSharingUpdate(int drawSpeed) {
        return this.gameSharingState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-1805032461, version=150)
    public int sceUtilityGameSharingGetStatus() {
        return this.gameSharingState.executeGetStatus();
    }

    @HLEFunction(nid=987040487, version=150)
    public int sceNetplayDialogInitStart(TPointer paramsAddr) {
        return this.netplayDialogState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-1133813098, version=150)
    public int sceNetplayDialogShutdownStart() {
        return this.netplayDialogState.executeShutdownStart();
    }

    @HLEFunction(nid=1098640724, version=150)
    public int sceNetplayDialogUpdate(int drawSpeed) {
        return this.netplayDialogState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-1227954793, version=150)
    public int sceNetplayDialogGetStatus() {
        return this.netplayDialogState.executeGetStatus();
    }

    @HLEFunction(nid=1303504697, version=150)
    public int sceUtilityNetconfInitStart(TPointer paramsAddr) {
        return this.netconfState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-125741578, version=150)
    public int sceUtilityNetconfShutdownStart() {
        return this.netconfState.executeShutdownStart();
    }

    @HLEFunction(nid=-1847128523, version=150)
    public int sceUtilityNetconfUpdate(int drawSpeed) {
        return this.netconfState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=1664264761, version=150)
    public int sceUtilityNetconfGetStatus() {
        return this.netconfState.executeGetStatus();
    }

    @HLEFunction(nid=1355074903, version=150)
    public int sceUtilitySavedataInitStart(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.inout) TPointer paramsAddr) {
        return this.savedataState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-1752124612, version=150)
    public int sceUtilitySavedataShutdownStart() {
        return this.savedataState.executeShutdownStart();
    }

    @HLEFunction(nid=-726048773, version=150)
    public int sceUtilitySavedataUpdate(int drawSpeed) {
        return this.savedataState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-2005607456, version=150)
    public int sceUtilitySavedataGetStatus() {
        return this.savedataState.executeGetStatus();
    }

    @HLEFunction(nid=697684000, version=150)
    public int sceUtilitySavedataErrInitStart(TPointer paramsAddr) {
        return this.savedataErrState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-1238744991, version=150)
    public int sceUtilitySavedataErrShutdownStart() {
        return this.savedataErrState.executeShutdownStart();
    }

    @HLEFunction(nid=-317739720, version=150)
    public int sceUtilitySavedataErrUpdate(int drawSpeed) {
        return this.savedataErrState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-2000915450, version=150)
    public int sceUtilitySavedataErrGetStatus() {
        return this.savedataErrState.executeGetStatus();
    }

    @HLEFunction(nid=718856761, version=150)
    public int sceUtilityMsgDialogInitStart(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.inout) TPointer paramsAddr) {
        return this.msgDialogState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=1739535400, version=150)
    public int sceUtilityMsgDialogShutdownStart() {
        return this.msgDialogState.executeShutdownStart();
    }

    @HLEFunction(nid=-1778637509, version=150)
    public int sceUtilityMsgDialogUpdate(int drawSpeed) {
        return this.msgDialogState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-1709403689, version=150)
    public int sceUtilityMsgDialogGetStatus() {
        return this.msgDialogState.executeGetStatus();
    }

    @HLEFunction(nid=-165241982, version=150)
    public int sceUtilityOskInitStart(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.inout) TPointer paramsAddr) {
        return this.oskState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=1039854505, version=150)
    public int sceUtilityOskShutdownStart() {
        return this.oskState.executeShutdownStart();
    }

    @HLEFunction(nid=1267058785, version=150)
    public int sceUtilityOskUpdate(int drawSpeed) {
        return this.oskState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-201891817, version=150)
    public int sceUtilityOskGetStatus() {
        return this.oskState.executeGetStatus();
    }

    @HLEFunction(nid=382741232, version=150)
    public int sceUtilityNpSigninInitStart(TPointer paramsAddr) {
        return this.npSigninState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-509831210, version=150)
    public int sceUtilityNpSigninShutdownStart() {
        return this.npSigninState.executeShutdownStart();
    }

    @HLEFunction(nid=-201603726, version=150)
    public int sceUtilityNpSigninUpdate(int drawSpeed) {
        return this.npSigninState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-2035557605, version=150)
    public int sceUtilityNpSigninGetStatus() {
        return this.npSigninState.executeGetStatus();
    }

    @HLEFunction(nid=1107761795, version=150)
    public int sceUtilityPS3ScanInitStart(TPointer paramsAddr) {
        return this.PS3ScanState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-780532365, version=150)
    public int sceUtilityPS3ScanShutdownStart() {
        return this.PS3ScanState.executeShutdownStart();
    }

    @HLEFunction(nid=-665662002, version=150)
    public int sceUtilityPS3ScanUpdate(int drawSpeed) {
        return this.PS3ScanState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-1993245553, version=150)
    public int sceUtilityPS3ScanGetStatus() {
        return this.PS3ScanState.executeGetStatus();
    }

    @HLEFunction(nid=-2117843194, version=150)
    public int sceUtilityRssReaderInitStart(TPointer paramsAddr) {
        return this.rssReaderState.executeInitStart(paramsAddr);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1325694987, version=150)
    public int sceUtilityRssReaderContStart() {
        return -2146369533;
    }

    @HLEFunction(nid=-407406376, version=150)
    public int sceUtilityRssReaderShutdownStart() {
        return this.rssReaderState.executeShutdownStart();
    }

    @HLEFunction(nid=1867971023, version=150)
    public int sceUtilityRssReaderUpdate(int drawSpeed) {
        return this.rssReaderState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-2094617851, version=150)
    public int sceUtilityRssReaderGetStatus() {
        return this.rssReaderState.executeGetStatus();
    }

    @HLEFunction(nid=1258983397, version=150)
    public int sceUtilityRssSubscriberInitStart(TPointer paramsAddr) {
        return this.rssSubscriberState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=111445593, version=150)
    public int sceUtilityRssSubscriberShutdownStart() {
        return this.rssSubscriberState.executeShutdownStart();
    }

    @HLEFunction(nid=-1601904554, version=150)
    public int sceUtilityRssSubscriberUpdate(int drawSpeed) {
        return this.rssSubscriberState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=731256635, version=150)
    public int sceUtilityRssSubscriberGetStatus() {
        return this.rssSubscriberState.executeGetStatus();
    }

    @HLEFunction(nid=38908212, version=150)
    public int sceUtilityScreenshotInitStart(TPointer paramsAddr) {
        return this.screenshotState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-2036319705, version=150)
    public int sceUtilityScreenshotContStart(TPointer paramsAddr) {
        return this.screenshotState.executeContStart(paramsAddr);
    }

    @HLEFunction(nid=-102760308, version=150)
    public int sceUtilityScreenshotShutdownStart() {
        return this.screenshotState.executeShutdownStart();
    }

    @HLEFunction(nid=-1425523031, version=150)
    public int sceUtilityScreenshotUpdate(int drawSpeed) {
        return this.screenshotState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-669427785, version=150)
    public int sceUtilityScreenshotGetStatus() {
        return this.screenshotState.executeGetStatus();
    }

    @HLEFunction(nid=-842814911, version=150)
    public int sceUtilityHtmlViewerInitStart(TPointer paramsAddr) {
        return this.htmlViewerState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-171044556, version=150)
    public int sceUtilityHtmlViewerShutdownStart() {
        return this.htmlViewerState.executeShutdownStart();
    }

    @HLEFunction(nid=95402468, version=150)
    public int sceUtilityHtmlViewerUpdate(int drawSpeed) {
        return this.htmlViewerState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-1113073516, version=150)
    public int sceUtilityHtmlViewerGetStatus() {
        return this.htmlViewerState.executeGetStatus();
    }

    @HLEFunction(nid=615264747, version=150)
    public int sceUtilityGamedataInstallInitStart(TPointer paramsAddr) {
        return this.gamedataInstallState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=853749195, version=150)
    public int sceUtilityGamedataInstallShutdownStart() {
        return this.gamedataInstallState.executeShutdownStart();
    }

    @HLEFunction(nid=1257034105, version=150)
    public int sceUtilityGamedataInstallUpdate(int drawSpeed) {
        return this.gamedataInstallState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-1249995303, version=150)
    public int sceUtilityGamedataInstallGetStatus() {
        return this.gamedataInstallState.executeGetStatus();
    }

    @HLEFunction(nid=1170310406, version=150)
    public int sceUtilitySetSystemParamInt(int id, int value) {
        switch (id) {
            case 2: {
                if (value != 0 && value != 1 && value != 6 && value != 11) {
                    return -2146369276;
                }
                Settings.getInstance().writeInt(SYSTEMPARAM_SETTINGS_OPTION_ADHOC_CHANNEL, value);
                break;
            }
            case 3: {
                Settings.getInstance().writeInt(SYSTEMPARAM_SETTINGS_OPTION_WLAN_POWER_SAVE, value);
                break;
            }
            default: {
                return -2146369277;
            }
        }
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=1105397364, version=150)
    public int sceUtilitySetSystemParamString(int id, int string) {
        return -2146369277;
    }

    @HLEFunction(nid=-1512430586, version=150)
    public int sceUtilityGetSystemParamInt(int id, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 valueAddr) {
        switch (id) {
            case 2: {
                valueAddr.setValue(sceUtility.getSystemParamAdhocChannel());
                break;
            }
            case 3: {
                valueAddr.setValue(sceUtility.getSystemParamWlanPowersave());
                break;
            }
            case 4: {
                valueAddr.setValue(sceUtility.getSystemParamDateFormat());
                break;
            }
            case 5: {
                valueAddr.setValue(sceUtility.getSystemParamTimeFormat());
                break;
            }
            case 6: {
                valueAddr.setValue(sceUtility.getSystemParamTimeZone());
                break;
            }
            case 7: {
                valueAddr.setValue(sceUtility.getSystemParamDaylightSavingTime());
                break;
            }
            case 8: {
                valueAddr.setValue(sceUtility.getSystemParamLanguage());
                break;
            }
            case 9: {
                valueAddr.setValue(sceUtility.getSystemParamButtonPreference());
                break;
            }
            case 10: {
                if (Emulator.getInstance().getFirmwareVersion() <= 500) {
                    log.warn((Object)String.format("sceUtilityGetSystemParamInt id=%d, value_addr=%s PSP_SYSTEMPARAM_ID_INT_LOCK_PARENTAL_LEVEL not available in PSP v%d", id, valueAddr, Emulator.getInstance().getFirmwareVersion()));
                    return -2146369277;
                }
                valueAddr.setValue(sceUtility.getSystemParamLockParentalLevel());
                break;
            }
            default: {
                log.warn((Object)String.format("sceUtilityGetSystemParamInt id=%d, valueAddr=%s invalid id", id, valueAddr));
                return -2146369277;
            }
        }
        return 0;
    }

    @HLEFunction(nid=884441923, version=150)
    public int sceUtilityGetSystemParamString(int id, TPointer strAddr, int len) {
        switch (id) {
            case 1: {
                strAddr.setStringNZ(len, sceUtility.getSystemParamNickname());
                break;
            }
            default: {
                log.warn((Object)String.format("sceUtilityGetSystemParamString id=%d, strAddr=%s, len=%d invalid id", id, strAddr, len));
                return -2146369277;
            }
        }
        return 0;
    }

    @HLEFunction(nid=1592681800, version=150)
    public int sceUtilityCheckNetParam(int id) {
        boolean available;
        boolean bl = available = id >= 0 && id <= 24;
        if (id > 10) {
            available = false;
        }
        return available ? 0 : -2146367999;
    }

    @HLEFunction(nid=1129139002, version=150)
    public int sceUtilityGetNetParam(int id, int param, TPointer data) {
        if (id < 0 || id > 24) {
            log.warn((Object)String.format("sceUtilityGetNetParam invalid id=%d", id));
            return -2146367999;
        }
        switch (param) {
            case 0: {
                data.setStringZ(sceUtility.getNetParamName(id));
                break;
            }
            case 1: {
                data.setStringZ(sceNetApctl.getSSID());
                break;
            }
            case 2: {
                data.setValue32(1);
                break;
            }
            case 3: {
                data.setStringZ("XXXXXXXXXXXXXXXXX");
                break;
            }
            case 4: {
                data.setValue32(1);
                break;
            }
            case 5: {
                data.setStringZ(sceNetApctl.getLocalHostIP());
                break;
            }
            case 6: {
                data.setStringZ(sceNetApctl.getSubnetMask());
                break;
            }
            case 7: {
                data.setStringZ(sceNetApctl.getGateway());
                break;
            }
            case 8: {
                data.setValue32(0);
                break;
            }
            case 9: {
                data.setStringZ(sceNetApctl.getPrimaryDNS());
                break;
            }
            case 10: {
                data.setStringZ(sceNetApctl.getSecondaryDNS());
                break;
            }
            case 11: {
                data.setStringZ("JPCSP");
                break;
            }
            case 12: {
                data.setStringZ("JPCSP");
                break;
            }
            case 13: {
                data.setValue32(0);
                break;
            }
            case 14: {
                data.setStringZ("dummy_server");
                break;
            }
            case 15: {
                data.setValue32(0);
                break;
            }
            case 16: {
                data.setValue32(2);
                break;
            }
            case 17: {
                data.setValue32(0);
                break;
            }
            case 18: {
                data.setValue32(0);
                break;
            }
            case 19: {
                data.setStringZ("JPCSP");
                break;
            }
            case 20: {
                data.setStringZ("JPCSP");
                break;
            }
            case 21: {
                data.setValue32(0);
                break;
            }
            case 22: {
                data.setStringZ("XXXXXXXXXXXXXXXXX");
                break;
            }
            case 23: {
                data.setValue32(0);
                break;
            }
            case 24: {
                data.setValue32(0);
                break;
            }
            default: {
                log.warn((Object)String.format("sceUtilityGetNetParam invalid param %d", param));
                return -2146367996;
            }
        }
        return 0;
    }

    @HLEFunction(nid=1340941528, version=150)
    public int sceUtilityGetNetParamLatestID(TPointer32 idAddr) {
        idAddr.setValue(Modules.sceRegModule.getNetworkLatestId());
        return 0;
    }

    @HLEFunction(nid=360292697, version=200, checkInsideInterrupt=true)
    public int sceUtilityLoadNetModule(int module) {
        String moduleName = this.getNetModuleName(module);
        int result = this.loadModules(moduleName);
        if (result == -2146367487) {
            log.info((Object)String.format("IGNORING: sceUtilityLoadNetModule(module=0x%04X) %s", module, moduleName));
            Modules.ThreadManForUserModule.hleKernelDelayThread(50000, false);
            return 0;
        }
        log.info((Object)String.format("sceUtilityLoadNetModule(module=0x%04X) %s loaded", module, moduleName));
        if (result >= 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(50000, false);
        }
        return result;
    }

    @HLEFunction(nid=1691683926, version=200, checkInsideInterrupt=true)
    public int sceUtilityUnloadNetModule(int module) {
        String moduleName = this.getNetModuleName(module);
        log.info((Object)String.format("sceUtilityUnloadNetModule(module=0x%04X) %s unloaded", module, moduleName));
        return this.unloadModules(moduleName);
    }

    @HLEFunction(nid=310499982, version=200)
    public int sceUtilityInstallInitStart(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.inout) TPointer paramsAddr) {
        return this.installState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=1592902218, version=200)
    public int sceUtilityInstallShutdownStart() {
        return this.installState.executeShutdownStart();
    }

    @HLEFunction(nid=-1606604358, version=200)
    public int sceUtilityInstallUpdate(int drawSpeed) {
        return this.installState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=-999288925, version=200)
    public int sceUtilityInstallGetStatus() {
        return this.installState.executeGetStatus();
    }

    @HLEFunction(nid=1227406742, version=260)
    public int sceUtilityMsgDialogAbort() {
        return this.msgDialogState.executeAbort();
    }

    @HLEFunction(nid=-970346714, version=270, checkInsideInterrupt=true)
    public int sceUtilityLoadAvModule(int module) {
        String moduleName = this.getAvModuleName(module);
        int result = this.loadModules(moduleName);
        if (result == -2146365695) {
            log.info((Object)String.format("IGNORING: sceUtilityLoadAvModule(module=0x%04X) %s", module, moduleName));
            Modules.ThreadManForUserModule.hleKernelDelayThread(50000, false);
            return 0;
        }
        if (result >= 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(50000, false);
        }
        return result;
    }

    @HLEFunction(nid=-136785774, version=270, checkInsideInterrupt=true)
    public int sceUtilityUnloadAvModule(int module) {
        String moduleName = this.getAvModuleName(module);
        return this.unloadModules(moduleName);
    }

    @HLEFunction(nid=224118482, version=270, checkInsideInterrupt=true)
    public int sceUtilityLoadUsbModule(int module) {
        String moduleName = this.getUsbModuleName(module);
        int result = this.loadModules(moduleName);
        if (result == -2146365695) {
            log.info((Object)String.format("IGNORING: sceUtilityLoadUsbModule(module=0x%04X) %s", module, moduleName));
            Modules.ThreadManForUserModule.hleKernelDelayThread(50000, false);
            return 0;
        }
        if (result >= 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(50000, false);
        }
        return result;
    }

    @HLEFunction(nid=-162983696, version=270, checkInsideInterrupt=true)
    public int sceUtilityUnloadUsbModule(int module) {
        String moduleName = this.getUsbModuleName(module);
        return this.unloadModules(moduleName);
    }

    @HLEFunction(nid=707476960, version=303, checkInsideInterrupt=true)
    public int sceUtilityLoadModule(int module) {
        int newCurrentThreadID;
        String moduleName = this.getModuleName(module);
        if (this.loadedModules.containsKey(moduleName) || this.waitingModules.contains(moduleName)) {
            return -2146365182;
        }
        if (module == UtilityModule.PSP_MODULE_NET_HTTPSTORAGE.id && !this.loadedModules.containsKey(UtilityModule.PSP_MODULE_NET_HTTP.name())) {
            log.error((Object)"Library not find");
            return -2147352260;
        }
        int currentThreadID = Modules.ThreadManForUserModule.getCurrentThreadID();
        int result = this.loadModules(moduleName);
        if (result >= 0 && currentThreadID == (newCurrentThreadID = Modules.ThreadManForUserModule.getCurrentThreadID())) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(currentThreadID, 50000, false);
        }
        return result;
    }

    @HLEFunction(nid=-459538798, version=303, checkInsideInterrupt=true)
    public int sceUtilityUnloadModule(int module) {
        String moduleName = this.getModuleName(module);
        return this.unloadModules(moduleName);
    }

    @HLEFunction(nid=-627576406, version=500)
    public int sceUtilityStoreCheckoutInitStart(TPointer paramsAddr) {
        return this.storeCheckoutState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=1420150319, version=500)
    public int sceUtilityStoreCheckoutShutdownStart() {
        return this.storeCheckoutState.executeShutdownStart();
    }

    @HLEFunction(nid=-1202115233, version=500)
    public int sceUtilityStoreCheckoutUpdate(int drawSpeed) {
        return this.storeCheckoutState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=984437212, version=500)
    public int sceUtilityStoreCheckoutGetStatus() {
        return this.storeCheckoutState.executeGetStatus();
    }

    @HLEFunction(nid=-1480885145, version=500)
    public int sceUtilityPsnInitStart(TPointer paramsAddr) {
        return this.psnState.executeInitStart(paramsAddr);
    }

    @HLEFunction(nid=-1053764543, version=500)
    public int sceUtilityPsnShutdownStart() {
        return this.psnState.executeShutdownStart();
    }

    @HLEFunction(nid=155230649, version=500)
    public int sceUtilityPsnUpdate(int drawSpeed) {
        return this.psnState.executeUpdate(drawSpeed);
    }

    @HLEFunction(nid=155293880, version=500)
    public int sceUtilityPsnGetStatus() {
        return this.psnState.executeGetStatus();
    }

    @HLEFunction(nid=403667810, version=600)
    public int sceUtilityGamedataInstallAbort() {
        return this.gamedataInstallState.executeAbort();
    }

    @HLEFunction(nid=-320744475, version=150)
    public int sceUtility_ECE1D3E5_setAuthName(@StringInfo(maxLength=64) PspString authName) {
        Modules.sceRegModule.setAuthName(authName.getString());
        return 0;
    }

    @HLEFunction(nid=684938804, version=150)
    public int sceUtility_28D35634_getAuthName(TPointer authNameAddr) {
        String authName = Modules.sceRegModule.getAuthName();
        authNameAddr.setStringNZ(64, authName);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUtility_28D35634_getAuthName returning '%s'", authName));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1881570015, version=150)
    public int sceUtility_70267ADF_setAuthKey(@StringInfo(maxLength=64) PspString authKey) {
        Modules.sceRegModule.setAuthKey(authKey.getString());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-281705806, version=150)
    public int sceUtility_EF3582B2_getAuthKey(TPointer authKeyAddr) {
        String authKey = Modules.sceRegModule.getAuthKey();
        authKeyAddr.setStringNZ(64, authKey);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUtility_EF3582B2_getAuthKey returning '%s'", authKey));
        }
        return 0;
    }

    @HLEFunction(nid=1740771419, version=150)
    public int sceUtilityGetNetParamInternal(int id, int param, TPointer data) {
        return this.sceUtilityGetNetParam(id, param, data);
    }

    @HLEFunction(nid=1836562805, version=150)
    public int sceUtilitySetNetParamLatestID(int id) {
        Modules.sceRegModule.setNetworkLatestId(id);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1573639104, version=150)
    public int sceUtility_private_5DCBD3C0() {
        return 0;
    }

    @HLEFunction(nid=76282950, version=150)
    public int sceUtility_private_048BFC46(PspString libraryName, int unknown1, @CanBeNull TPointer optionAddr) {
        String path = utilityPrivateModules.get(libraryName.getString());
        if (path == null) {
            return -1;
        }
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceUtility_private_048BFC46 options: %s", lmOption));
            }
        }
        ModuleMgrForUser.LoadModuleContext loadModuleContext = new ModuleMgrForUser.LoadModuleContext();
        loadModuleContext.fileName = path;
        loadModuleContext.lmOption = lmOption;
        loadModuleContext.allocMem = true;
        loadModuleContext.isSignChecked = Modules.ModuleMgrForUserModule.isSignChecked(path);
        return Modules.ModuleMgrForUserModule.hleKernelLoadModule(loadModuleContext);
    }

    @HLEFunction(nid=2023947788, version=150)
    public int sceUtility_private_78A2FE0C(int uid) {
        return Modules.ModuleMgrForUserModule.hleKernelUnloadModule(uid);
    }

    @HLEUnimplemented
    @HLEFunction(nid=52234564, version=150)
    public int sceUtility_private_031D0944(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1176909937, version=150)
    public int sceUtility_private_B9D9C78F(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1641048174, version=150)
    public int sceUtility_netparam_internal_61D0686E(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1286701988, version=150)
    public int sceUtility_netparam_internal_4CB183A4(int unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=597632525, version=150)
    public int sceUtility_netparam_internal_239F260D(int type, TPointer value) {
        switch (type) {
            case 0: {
                String configurationName = value.getStringZ();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("sceUtility_netparam_internal_239F260D configurationName='%s'", configurationName));
                break;
            }
            case 1: {
                String ssid = value.getStringZ();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("sceUtility_netparam_internal_239F260D SSID='%s'", ssid));
                break;
            }
            case 2: {
                int security = value.getValue32();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("sceUtility_netparam_internal_239F260D security=%d", security));
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 13: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("sceUtility_netparam_internal_239F260D unknown value: %s", Utilities.getMemoryDump(value.getAddress(), 16)));
                break;
            }
            case 22: {
                String wepKey = value.getStringZ();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("sceUtility_netparam_internal_239F260D wepKey='%s'", wepKey));
            }
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=974507274, version=620)
    public int sceUtilityAutoConnectInitStart(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.inout) TPointer paramsAddr) {
        return this.autoConnectDialogState.executeInitStart(paramsAddr);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-768186892, version=620)
    public int sceUtilityAutoConnectUpdate(int drawSpeed) {
        return this.autoConnectDialogState.executeUpdate(drawSpeed);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-725435021, version=620)
    public int sceUtilityAutoConnectGetStatus() {
        return this.autoConnectDialogState.executeGetStatus();
    }

    @HLEUnimplemented
    @HLEFunction(nid=235677615, version=620)
    public int sceUtilityAutoConnectAbort() {
        return this.autoConnectDialogState.executeAbort();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1624163052, version=620)
    public int sceUtilityAutoConnectShutdownStart() {
        return this.autoConnectDialogState.executeShutdownStart();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1807959482, version=500)
    public int sceUtilityAuthDialogInitStart(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.inout) TPointer paramsAddr) {
        return this.authDialogState.executeInitStart(paramsAddr);
    }

    @HLEUnimplemented
    @HLEFunction(nid=379693272, version=500)
    public int sceUtilityAuthDialogGetStatus() {
        return this.authDialogState.executeGetStatus();
    }

    @HLEUnimplemented
    @HLEFunction(nid=343899269, version=500)
    public int sceUtilityAuthDialogUpdate(int drawSpeed) {
        return this.authDialogState.executeUpdate(drawSpeed);
    }

    @HLEUnimplemented
    @HLEFunction(nid=255781548, version=500)
    public int sceUtilityAuthDialogShutdownStart() {
        return this.authDialogState.executeShutdownStart();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-572180323, version=500)
    public int sceUtilityDNASInitStart(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.inout) TPointer paramsAddr) {
        return this.dnasDialogState.executeInitStart(paramsAddr);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1525785808, version=500)
    public int sceUtilityDNASGetStatus() {
        return this.dnasDialogState.executeGetStatus();
    }

    @HLEUnimplemented
    @HLEFunction(nid=1250114468, version=500)
    public int sceUtilityDNASUpdate(int drawSpeed) {
        return this.dnasDialogState.executeUpdate(drawSpeed);
    }

    @HLEUnimplemented
    @HLEFunction(nid=345667733, version=500)
    public int sceUtilityDNASShutdownStart() {
        return this.dnasDialogState.executeShutdownStart();
    }

    @HLEUnimplemented
    @HLEFunction(nid=2611539, version=150)
    public int sceUtility_private_0027D953() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=202040678, version=150)
    public int sceUtility_private_0C0AE566() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=225125284, version=150)
    public int sceUtility_private_0D6B23A4() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=282178559, version=150)
    public int sceUtility_private_10D1B3FF() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=350833957, version=150)
    public int sceUtility_private_14E94D25() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=409611396, version=150)
    public int sceUtility_private_186A2C84() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=511900489, version=150)
    public int sceUtility_private_1E82FB49() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=651210853, version=150)
    public int sceUtility_private_26D0B065() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=699392150, version=150)
    public int sceUtility_private_29AFE096() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=827416897, version=150)
    public int sceUtility_private_31516141() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=875824774, version=150)
    public int sceUtility_private_34340686() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=909775586, version=150)
    public int sceUtility_private_363A12E2() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=916268516, version=150)
    public int sceUtility_private_369D25E4() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=971467051, version=150)
    public int sceUtility_private_39E7692B() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1090233650, version=150)
    public int sceUtility_private_40FBA532() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1109272358, version=150)
    public int sceUtility_private_421E2726() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1332739196, version=150)
    public int sceUtility_private_4F6FFC7C() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1477030986, version=150)
    public int sceUtility_private_5809B44A() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1508588055, version=150)
    public int sceUtility_private_59EB3A17() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1548307142, version=150)
    public int sceUtility_private_5C494AC6() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1590783674, version=150)
    public int sceUtility_private_5ED16EBA() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1772824808, version=150)
    public int sceUtility_private_69AB28E8() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1969918899, version=150)
    public int sceUtility_private_756A93B3() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2028771373, version=150)
    public int sceUtility_private_78EC982D() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2114800589, version=150)
    public int sceUtility_private_7E0D4BCD() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2126340616, version=150)
    public int sceUtility_private_7EBD6208() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2145059673, version=150)
    public int sceUtility_private_8024FCA7() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2035650372, version=150)
    public int sceUtility_private_86AA70BC() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1922556192, version=150)
    public int sceUtility_private_8D681EE0() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1771498798, version=150)
    public int sceUtility_private_966912D2() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1742733966, version=150)
    public int sceUtility_private_981FFD72() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1590391422, version=150)
    public int sceUtility_private_A1348D82() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1570897516, version=150)
    public int sceUtility_private_A25E0194() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1498209311, version=150)
    public int sceUtility_private_A6B323E1() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1400907940, version=150)
    public int sceUtility_private_AC7FD75C() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1397327359, version=150)
    public int sceUtility_private_ACB67A01() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1286683475, version=150)
    public int sceUtility_private_B34EC4AD() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1157645867, version=150)
    public int sceUtility_private_BAFFB9D5() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1144186747, version=150)
    public int sceUtility_private_BBCD1885() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1047433947, version=150)
    public int sceUtility_private_C1916D25() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-942303169, version=150)
    public int sceUtility_private_C7D5983F() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-839991582, version=150)
    public int sceUtility_private_CDEEBEE2() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-834125499, version=150)
    public int sceUtility_private_CE484145() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-553492912, version=150)
    public int sceUtility_private_DF025E50() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-520757567, version=150)
    public int sceUtility_private_E0F5DEC1() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-387035513, version=150)
    public int sceUtility_private_E8EE4E87() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-364614443, version=150)
    public int sceUtility_private_EA446CD5() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-313641014, version=150)
    public int sceUtility_private_ED4E37CA() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-58451261, version=150)
    public int sceUtility_private_FC841AC3() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=39423416, version=150)
    public int sceUtility_netparam_internal_02598DB8() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=160454198, version=150)
    public int sceUtility_netparam_internal_09905636() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1566812678, version=150)
    public int sceUtility_netparam_internal_5D63AA06() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1796982316, version=150)
    public int sceUtility_netparam_internal_6B1BC62C() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-261968218, version=150)
    public int sceUtilityInit() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=549882932, version=150)
    public int sceUtilityEnd() {
        return 0;
    }

    static {
        utilityNetModuleNames = new String[]{"PSP_NET_MODULE_UNKNOWN_0", "PSP_NET_MODULE_COMMON", "PSP_NET_MODULE_ADHOC", "PSP_NET_MODULE_INET", "PSP_NET_MODULE_PARSEURI", "PSP_NET_MODULE_PARSEHTTP", "PSP_NET_MODULE_HTTP", "PSP_NET_MODULE_SSL"};
    }

    public static enum UtilityModule {
        PSP_MODULE_NET_COMMON(256),
        PSP_MODULE_NET_ADHOC(257),
        PSP_MODULE_NET_INET(258),
        PSP_MODULE_NET_PARSEURI(259),
        PSP_MODULE_NET_PARSEHTTP(260),
        PSP_MODULE_NET_HTTP(261),
        PSP_MODULE_NET_SSL(262),
        PSP_MODULE_NET_UPNP(263),
        PSP_MODULE_NET_HTTPSTORAGE(264),
        PSP_MODULE_USB_PSPCM(512),
        PSP_MODULE_USB_MIC(513),
        PSP_MODULE_USB_CAM(514),
        PSP_MODULE_USB_GPS(515),
        PSP_MODULE_AV_AVCODEC(768),
        PSP_MODULE_AV_SASCORE(769),
        PSP_MODULE_AV_ATRAC3PLUS(770),
        PSP_MODULE_AV_MPEGBASE(771),
        PSP_MODULE_AV_MP3(772),
        PSP_MODULE_AV_VAUDIO(773),
        PSP_MODULE_AV_AAC(774),
        PSP_MODULE_AV_G729(775),
        PSP_MODULE_AV_MP4(776),
        PSP_MODULE_NP_COMMON(1024),
        PSP_MODULE_NP_SERVICE(1025),
        PSP_MODULE_NP_MATCHING2(1026),
        PSP_MODULE_NP_COMMERCE2(1027),
        PSP_MODULE_NP_DRM(1280),
        PSP_MODULE_IRDA(1536);

        private final int id;

        private UtilityModule(int id) {
            this.id = id;
        }

        public int getID() {
            return this.id;
        }
    }

    protected static class GuGamedataInstallCompletedDialog
    extends GuUtilityDialog {
        private final String strTitle;
        private final String strCompleted;

        public GuGamedataInstallCompletedDialog(SceUtilityGamedataInstallParams gamedataInstallParams, GamedataInstallUtilityDialogState gamedataInstallUtilityDialogState) {
            super(gamedataInstallParams.base);
            this.strTitle = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilityGamedataInstall.title");
            this.strCompleted = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilityGamedataInstall.completed");
            this.createDialog(gamedataInstallUtilityDialogState);
        }

        @Override
        protected void updateDialog() {
            this.setSoftShadows(true);
            this.gu.sceGuClear(1, 9864833);
            float scale = 0.79f;
            int lineHeight = 19;
            int lineCount = this.getTextLines(this.strCompleted);
            int textHeight = 19 * lineCount;
            int totalHeight = textHeight + 24;
            int topLineY = (272 - totalHeight) / 2;
            this.drawHeader(this.strTitle);
            int lineColor = -2106663;
            this.gu.sceGuDrawHorizontalLine(60, 420, topLineY, -2106663);
            this.gu.sceGuDrawHorizontalLine(60, 420, topLineY + totalHeight, -2106663);
            int y = topLineY + 17;
            this.drawTextWithShadow(this.centerText(this.getDefaultFontInfo(), this.strCompleted, 0.79f), y, 0.79f, this.strCompleted);
            y += textHeight;
            this.drawBack();
        }

        @Override
        protected boolean canConfirm() {
            return false;
        }
    }

    protected static class GuGamedataInstallProgressDialog
    extends GuUtilityDialog {
        private final GamedataInstallUtilityDialogState gamedataInstallUtilityDialogState;
        private final String strTitle;
        private final String strInstalling;
        private final String strWait;
        private final String strSecondsLeft;
        private final String strPercent;

        public GuGamedataInstallProgressDialog(SceUtilityGamedataInstallParams gamedataInstallParams, GamedataInstallUtilityDialogState gamedataInstallUtilityDialogState) {
            super(gamedataInstallParams.base);
            this.gamedataInstallUtilityDialogState = gamedataInstallUtilityDialogState;
            this.strTitle = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilityGamedataInstall.title");
            this.strInstalling = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilityGamedataInstall.installing");
            this.strWait = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilityGamedataInstall.wait");
            this.strSecondsLeft = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilityGamedataInstall.secondsLeft");
            this.strPercent = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilityGamedataInstall.percent");
            this.createDialog(gamedataInstallUtilityDialogState);
        }

        @Override
        protected void updateDialog() {
            this.setSoftShadows(true);
            this.gu.sceGuClear(1, 9864833);
            float scale = 0.79f;
            int lineHeight = 19;
            int lineCount = 4;
            int textHeight = 76;
            int totalHeight = textHeight + 44;
            int topLineY = (272 - totalHeight) / 2;
            this.drawHeader(this.strTitle);
            int lineColor = -2106663;
            this.gu.sceGuDrawHorizontalLine(60, 420, topLineY, -2106663);
            this.gu.sceGuDrawHorizontalLine(60, 420, topLineY + totalHeight, -2106663);
            int x1 = this.centerText(this.getDefaultFontInfo(), this.strInstalling, 0.79f);
            int x2 = this.centerText(this.getDefaultFontInfo(), this.strWait, 0.79f);
            int x = Math.min(x1, x2);
            int y = topLineY + 17;
            this.drawTextWithShadow(x, y, 0.79f, this.strInstalling);
            this.drawTextWithShadow(x, y += 19, 0.79f, this.strWait);
            y += 19;
            int progressStart = 70;
            int progressEnd = 410;
            String secondsLeftText = String.format(this.strSecondsLeft, this.gamedataInstallUtilityDialogState.getSecondsLeft());
            this.drawTextWithShadow(this.rightAlignText(this.getDefaultFontInfo(), secondsLeftText, 410, 0.79f), y += 10, 0.79f, secondsLeftText);
            y += 19;
            ++y;
            int progressLineColor = -3782862;
            int progress = this.gamedataInstallUtilityDialogState.getProgress();
            int progressX = 70 + progress * 340 / 100;
            for (int i = 0; i < 5; ++i) {
                this.gu.sceGuDrawHorizontalLine(70, progressX, y + i, -3782862);
                this.gu.sceGuDrawHorizontalLine(progressX, 410, y + i, -2106663);
            }
            String percentText = String.format(this.strPercent, progress);
            this.drawTextWithShadow(this.centerText(this.getDefaultFontInfo(), percentText, 0.79f), y += 12, 0.79f, percentText);
            y += 19;
            this.drawCancel();
        }

        @Override
        protected boolean canConfirm() {
            return false;
        }
    }

    protected static class GuGamedataInstallConfirmationDialog
    extends GuUtilityDialog {
        private final String strTitle;
        private final String strConfirmation;

        public GuGamedataInstallConfirmationDialog(SceUtilityGamedataInstallParams gamedataInstallParams, GamedataInstallUtilityDialogState gamedataInstallUtilityDialogState) {
            super(gamedataInstallParams.base);
            this.strTitle = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilityGamedataInstall.title");
            this.strConfirmation = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilityGamedataInstall.confirmation");
            gamedataInstallUtilityDialogState.setYesSelected(true);
            this.createDialog(gamedataInstallUtilityDialogState);
        }

        @Override
        protected void updateDialog() {
            this.setSoftShadows(true);
            this.gu.sceGuClear(1, 9864833);
            float scale = 0.79f;
            String confirmationText = String.format(this.strConfirmation, State.title);
            confirmationText = this.wrapText(this.getDefaultFontInfo(), confirmationText, 300, 0.79f);
            int lineHeight = 19;
            int lineCount = this.getTextLines(confirmationText);
            int textHeight = 19 * lineCount;
            int totalHeight = textHeight + 44;
            int topLineY = (272 - totalHeight) / 2;
            this.drawHeader(this.strTitle);
            int lineColor = -2106663;
            this.gu.sceGuDrawHorizontalLine(60, 420, topLineY, -2106663);
            this.gu.sceGuDrawHorizontalLine(60, 420, topLineY + totalHeight, -2106663);
            int y = topLineY + 17;
            this.drawTextWithShadow(90, y, 0.79f, confirmationText);
            this.drawYesNo(185, 255, y += textHeight);
            this.drawEnter();
            this.drawBack();
        }

        @Override
        protected boolean hasYesNo() {
            return true;
        }
    }

    protected static class OskDialog
    extends UtilityDialog {
        private static final long serialVersionUID = 1155047781007677923L;
        protected JTextField textField;

        public OskDialog(SceUtilityOskParams oskParams, OskUtilityDialogState oskState) {
            this.createDialog(oskState, oskParams.oskData[oskState.oskDataIndex].desc);
            this.textField = new JTextField(oskParams.oskData[oskState.oskDataIndex].inText);
            this.messagePane.add(this.textField);
            JButton okButton = new JButton("Ok");
            okButton.addActionListener(this.closeActionListener);
            okButton.setActionCommand("OK");
            this.buttonPane.add(okButton);
            this.setDefaultButton(okButton);
            this.endDialog();
        }
    }

    protected static class GuMsgDialog
    extends GuUtilityDialog {
        protected SceUtilityMsgDialogParams msgDialogParams;

        public GuMsgDialog(SceUtilityMsgDialogParams msgDialogParams, MsgDialogUtilityDialogState msgDialogState) {
            super(msgDialogParams.base);
            this.msgDialogParams = msgDialogParams;
            msgDialogState.setYesSelected(msgDialogParams.isOptionYesNoDefaultYes());
            this.createDialog(msgDialogState);
        }

        @Override
        protected void updateDialog() {
            this.setSoftShadows(true);
            this.gu.sceGuClear(1, 9864833);
            int buttonY = 192;
            String message = this.getMessage();
            if (message != null) {
                int currentLineLength = 0;
                LinkedList<String> lines = new LinkedList<String>();
                StringBuilder currentLine = new StringBuilder();
                int splitLineIndex = -1;
                int maxLineLength = 430;
                int longestLine = 0;
                SceFontInfo fontInfo = this.getDefaultFontInfo();
                for (int i = 0; i < message.length(); ++i) {
                    char c = message.charAt(i);
                    if (c == '\n') {
                        longestLine = Math.max(longestLine, currentLineLength);
                        lines.add(currentLine.toString());
                        currentLine.setLength(0);
                        currentLineLength = 0;
                        splitLineIndex = -1;
                        continue;
                    }
                    int charLength = this.getTextLength(fontInfo, c);
                    if (currentLineLength + charLength > maxLineLength) {
                        if (splitLineIndex < 0) {
                            splitLineIndex = currentLine.length();
                        }
                        String line = currentLine.substring(0, splitLineIndex);
                        longestLine = Math.max(longestLine, this.getTextLength(fontInfo, line));
                        lines.add(line);
                        currentLine.delete(0, splitLineIndex);
                        currentLineLength = this.getTextLength(fontInfo, currentLine.toString());
                        splitLineIndex = -1;
                    }
                    currentLine.append(c);
                    currentLineLength += charLength;
                    if (c != ' ') continue;
                    splitLineIndex = currentLine.length();
                }
                if (currentLine.length() > 0) {
                    longestLine = Math.max(longestLine, currentLineLength);
                    lines.add(currentLine.toString());
                }
                int lineHeight = 19;
                int lineCount = lines.size();
                int textHeight = 19 * lineCount;
                int totalHeight = textHeight + 24;
                if (this.msgDialogParams.isOptionYesNo() || this.msgDialogParams.isOptionOk()) {
                    totalHeight += 33;
                }
                int topLineY = (272 - totalHeight) / 2;
                buttonY = topLineY + totalHeight - 29;
                int lineColor = -2106663;
                this.gu.sceGuDrawHorizontalLine(60, 420, topLineY, lineColor);
                this.gu.sceGuDrawHorizontalLine(60, 420, topLineY + totalHeight, lineColor);
                float scale = 0.79f;
                int y = topLineY + 17;
                int x = 63 + (360 - Math.round((float)longestLine * 0.79f)) / 2;
                for (String line : lines) {
                    this.drawTextWithShadow(x, y, 0.79f, line);
                    y += 19;
                }
            }
            if (this.msgDialogParams.isOptionYesNo()) {
                this.drawYesNo(185, 255, buttonY);
            } else if (this.msgDialogParams.isOptionOk()) {
                this.drawButton(223, buttonY, "OK", true);
            }
            if ((this.msgDialogParams.options & 1) != 0 && !this.msgDialogParams.isOptionOk() && !this.msgDialogParams.isOptionYesNo()) {
                if (this.msgDialogParams.base.totalSizeof() == 708 && (this.msgDialogParams.options & 0x80) == 0) {
                    this.drawBack();
                } else if (this.msgDialogParams.base.totalSizeof() == 580 && (this.msgDialogParams.options & 0x80) == 0) {
                    this.drawBack();
                } else {
                    this.useNoButtons();
                }
            } else if ((this.msgDialogParams.options & 0x80) == 0) {
                if (this.msgDialogParams.options != 0) {
                    if (this.msgDialogParams.enterButtonString != null) {
                        if (!this.msgDialogParams.enterButtonString.equals("")) {
                            this.drawEnterWithString(this.msgDialogParams.enterButtonString);
                        } else {
                            this.drawEnter();
                        }
                    } else {
                        this.drawEnter();
                    }
                }
                if (this.msgDialogParams.backButtonString != null) {
                    if (!this.msgDialogParams.backButtonString.equals("")) {
                        this.drawBackWithString(this.msgDialogParams.backButtonString);
                    } else {
                        this.drawBack();
                    }
                } else {
                    this.drawBack();
                }
            } else if ((this.msgDialogParams.options & 0x30) != 0) {
                if (this.msgDialogParams.enterButtonString != null) {
                    if (!this.msgDialogParams.enterButtonString.equals("")) {
                        this.drawEnterWithString(this.msgDialogParams.enterButtonString);
                    } else {
                        this.drawEnter();
                    }
                } else {
                    this.drawEnter();
                }
            }
        }

        protected String getMessage() {
            if (this.msgDialogParams.mode == 0) {
                return String.format("Error 0x%08X", this.msgDialogParams.errorValue);
            }
            return this.msgDialogParams.message;
        }

        @Override
        protected boolean canCancel() {
            return (this.msgDialogParams.options & 0x80) == 0;
        }

        @Override
        protected boolean canConfirm() {
            return (this.msgDialogParams.options & 0x30) != 0;
        }

        @Override
        protected int getButtonPressedOK() {
            if (this.msgDialogParams.isOptionYesNo()) {
                return this.utilityDialogState.isYesSelected() ? 1 : 2;
            }
            return super.getButtonPressedOK();
        }

        @Override
        protected boolean hasYesNo() {
            return this.msgDialogParams.isOptionYesNo();
        }
    }

    protected static class GuSavedataDialog
    extends GuUtilityDialog {
        private final SavedataUtilityDialogState savedataDialogState;
        private final SceUtilitySavedataParam savedataParams;
        private final String[] saveNames;
        private final int numberRows;
        private int selectedRow;
        private String strNewData;
        private final String strNoData;

        public GuSavedataDialog(SceUtilitySavedataParam savedataParams, SavedataUtilityDialogState savedataDialogState, String[] saveNames) {
            super(savedataParams.base);
            this.savedataDialogState = savedataDialogState;
            this.savedataParams = savedataParams;
            this.saveNames = saveNames;
            this.strNoData = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilitySavedata.strNoData.text");
            this.strNewData = savedataParams.newData != null && savedataParams.newData.title != null ? savedataParams.newData.title : ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilitySavedata.strNewData.text");
            this.createDialog(savedataDialogState);
            this.numberRows = saveNames == null ? 0 : saveNames.length;
            savedataDialogState.saveListEmpty = this.numberRows <= 0;
            this.selectedRow = 0;
            block0 : switch (savedataParams.focus) {
                case 1: {
                    this.selectedRow = 0;
                    break;
                }
                case 2: {
                    this.selectedRow = this.numberRows - 1;
                    break;
                }
                case 3: {
                    long latestTimestamp = Long.MIN_VALUE;
                    for (int i = 0; i < this.numberRows; ++i) {
                        long timestamp = this.getTimestamp(saveNames[i]);
                        if (timestamp <= latestTimestamp) continue;
                        latestTimestamp = timestamp;
                        this.selectedRow = i;
                    }
                    break;
                }
                case 4: {
                    long oldestTimestamp = Long.MAX_VALUE;
                    for (int i = 0; i < this.numberRows; ++i) {
                        long timestamp = this.getTimestamp(saveNames[i]);
                        if (timestamp >= oldestTimestamp) continue;
                        oldestTimestamp = timestamp;
                        this.selectedRow = i;
                    }
                    break;
                }
                case 7: {
                    for (int i = 0; i < this.numberRows; ++i) {
                        if (!this.isEmpty(saveNames[i])) continue;
                        this.selectedRow = i;
                        break block0;
                    }
                    break;
                }
                case 8: {
                    for (int i = this.numberRows - 1; i >= 0; --i) {
                        if (!this.isEmpty(saveNames[i])) continue;
                        this.selectedRow = i;
                        break block0;
                    }
                    break;
                }
            }
        }

        private boolean isEmpty(String saveName) {
            return !this.savedataParams.isPresent(this.savedataParams.gameName, saveName);
        }

        private long getTimestamp(String saveName) {
            return this.savedataParams.getTimestamp(this.savedataParams.gameName, saveName);
        }

        private InputStream getIcon0InputStream(int index) {
            ByteArrayInputStream iconStream = null;
            if (index < 0 || index >= this.saveNames.length) {
                return iconStream;
            }
            String iconFileName = this.savedataParams.getFileName(this.saveNames[index], "ICON0.PNG");
            SeekableDataInput iconDataInput = Modules.IoFileMgrForUserModule.getFile(iconFileName, 1);
            if (iconDataInput != null) {
                try {
                    int length = (int)iconDataInput.length();
                    byte[] iconBuffer = new byte[length];
                    iconDataInput.readFully(iconBuffer);
                    iconDataInput.close();
                    iconStream = new ByteArrayInputStream(iconBuffer);
                }
                catch (IOException e) {
                    log.debug((Object)"getIcon0", (Throwable)e);
                }
            } else if (this.savedataParams.newData != null && this.savedataParams.newData.icon0 != null) {
                int addr = this.savedataParams.newData.icon0.buf;
                int size = this.savedataParams.newData.icon0.size;
                if (addr != 0 && size > 0) {
                    size = PNG.getEndOfPNG(Memory.getInstance(), addr, size);
                    byte[] iconBuffer = new byte[size];
                    IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, size, 1);
                    for (int i = 0; i < size; ++i) {
                        iconBuffer[i] = (byte)memoryReader.readNext();
                    }
                    iconStream = new ByteArrayInputStream(iconBuffer);
                }
            }
            return iconStream;
        }

        private int getIcon0(int index) {
            InputStream iconStream = this.getIcon0InputStream(index);
            return this.readIcon(iconStream);
        }

        private PSF getPsf(int index) {
            PSF psf = null;
            if (index < 0 || index >= this.saveNames.length) {
                return psf;
            }
            String sfoFileName = this.savedataParams.getFileName(this.saveNames[index], "PARAM.SFO");
            SeekableDataInput sfoDataInput = Modules.IoFileMgrForUserModule.getFile(sfoFileName, 1);
            if (sfoDataInput != null) {
                try {
                    int length = (int)sfoDataInput.length();
                    byte[] sfoBuffer = new byte[length];
                    sfoDataInput.readFully(sfoBuffer);
                    sfoDataInput.close();
                    psf = new PSF();
                    psf.read(ByteBuffer.wrap(sfoBuffer));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return psf;
        }

        private void drawIconByRow(int row, int iconX, int iconY, int iconWidth, int iconHeight) {
            this.drawIcon(this.getIcon0(row), iconX, iconY, iconWidth, iconHeight);
        }

        @Override
        protected void updateDialog() {
            if (this.numberRows > 0) {
                this.drawIconByRow(this.selectedRow, 26, 96, 144, 80);
                PSF psf = this.getPsf(this.selectedRow);
                if (psf != null) {
                    String title = psf.getString("TITLE");
                    String detail = psf.getString("SAVEDATA_DETAIL");
                    String savedataTitle = psf.getString("SAVEDATA_TITLE");
                    Calendar savedTime = this.savedataParams.getSavedTime(this.saveNames[this.selectedRow]);
                    int textX = 180;
                    int textY = 119;
                    this.drawTextWithShadow(textX, textY, 13747898, 0.85f, this.truncateText(title, 480 - textX, 0.85f));
                    textY += 22;
                    if (savedTime != null) {
                        String text = sceUtility.formatDateTime(savedTime);
                        int sizeKb = this.savedataParams.getSizeKb(this.savedataParams.gameName, this.saveNames[this.selectedRow]);
                        text = text + " " + MemoryStick.getSizeKbString(sizeKb);
                        this.drawTextWithShadow(textX, textY, 0.7f, text);
                    }
                    this.gu.sceGuDrawHorizontalLine(textX, 480, textY - 6, -1);
                    this.drawTextWithShadow(textX -= 5, textY += 23, 0.7f, savedataTitle);
                    this.drawTextWithShadow(textX, textY += 24, 0.7f, detail);
                } else {
                    this.drawTextWithShadow(180, 130, 0.75f, this.strNewData);
                }
                this.drawEnter();
                this.drawBack();
                if (this.selectedRow > 0) {
                    this.drawIconByRow(this.selectedRow - 1, 58, 38, 80, 44);
                    if (this.selectedRow > 1) {
                        this.drawIconByRow(this.selectedRow - 2, 58, -5, 80, 44);
                    }
                }
                if (this.selectedRow < this.numberRows - 1) {
                    this.drawIconByRow(this.selectedRow + 1, 58, 190, 80, 44);
                    if (this.selectedRow < this.numberRows - 2) {
                        this.drawIconByRow(this.selectedRow + 2, 58, 233, 80, 44);
                    }
                }
            } else {
                this.gu.sceGuDrawHorizontalLine(201, 464, 114, -1);
                this.drawTextWithShadow(this.centerText(this.getDefaultFontInfo(), this.strNoData, 201, 464, 0.75f), 131, 0.75f, this.strNoData);
                this.gu.sceGuDrawHorizontalLine(201, 464, 157, -1);
                this.drawBack();
            }
            String dialogTitle = this.savedataDialogState.getDialogTitle(this.savedataParams.getModeName(), "Savedata List", this.utilityLocale);
            this.drawHeader(dialogTitle);
        }

        @Override
        public void checkController() {
            if (this.isDownPressed()) {
                ++this.selectedRow;
            } else if (this.isUpPressed()) {
                --this.selectedRow;
            } else if (this.isButtonPressed(256)) {
                this.selectedRow = 0;
            } else if (this.isButtonPressed(512)) {
                this.selectedRow = this.numberRows - 1;
            }
            this.selectedRow = Math.max(this.selectedRow, 0);
            this.selectedRow = Math.min(this.selectedRow, this.numberRows - 1);
            if (this.selectedRow >= 0) {
                this.savedataDialogState.saveListSelection = this.saveNames[this.selectedRow];
                this.savedataDialogState.saveListSelectionIcon0 = this.getIcon0InputStream(this.selectedRow);
            } else {
                this.savedataDialogState.saveListSelection = null;
                this.savedataDialogState.saveListSelectionIcon0 = null;
            }
            super.checkController();
        }

        @Override
        protected boolean canConfirm() {
            return this.numberRows > 0;
        }
    }

    protected static class GuSavedataDialogCompleted
    extends GuUtilityDialog {
        protected final SavedataUtilityDialogState savedataDialogState;
        protected final SceUtilitySavedataParam savedataParams;
        private final InputStream icon0;
        protected boolean isYesSelected;
        private String strCompleted;

        protected GuSavedataDialogCompleted(SceUtilitySavedataParam savedataParams, SavedataUtilityDialogState savedataDialogState, InputStream icon0) {
            super(savedataParams.base);
            this.savedataDialogState = savedataDialogState;
            this.savedataParams = savedataParams;
            this.icon0 = icon0;
            if (icon0 != null) {
                icon0.mark(Integer.MAX_VALUE);
            }
            try {
                this.strCompleted = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString(String.format("sceUtilitySavedata.%s.strCompleted.text", savedataParams.getModeName()));
            }
            catch (MissingResourceException e) {
                this.strCompleted = "Completed";
            }
            this.createDialog(savedataDialogState);
        }

        @Override
        protected void updateDialog() {
            int textureAddr;
            String dialogTitle = this.savedataDialogState.getDialogTitle(this.savedataParams.getModeName(), "Save", this.utilityLocale);
            Calendar savedTime = this.savedataParams.getSavedTime();
            if (this.savedataParams.icon0FileData.buf == 0 && this.icon0 != null) {
                try {
                    this.icon0.reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                textureAddr = this.readIcon(this.icon0);
            } else {
                textureAddr = this.readIcon(this.savedataParams.icon0FileData.buf);
            }
            this.drawIcon(textureAddr, 26, 96, 144, 80);
            this.gu.sceGuDrawHorizontalLine(201, 464, 114, -1);
            this.drawTextWithShadow(270, 131, 0.75f, this.strCompleted);
            this.gu.sceGuDrawHorizontalLine(201, 464, 157, -1);
            this.drawTextWithShadow(6, 202, 0.75f, this.savedataParams.sfoParam.savedataTitle);
            if (savedTime != null) {
                this.drawTextWithShadow(6, 219, 0.7f, sceUtility.formatDateTime(savedTime));
            }
            this.drawTextWithShadow(6, 237, 0.75f, MemoryStick.getSizeKbString(this.savedataParams.getRequiredSizeKb()));
            this.drawBack();
            this.drawHeader(dialogTitle);
        }

        @Override
        protected boolean canConfirm() {
            return false;
        }
    }

    protected static class GuSavedataDialogLoad
    extends GuUtilityDialog {
        protected final SavedataUtilityDialogState savedataDialogState;
        protected final SceUtilitySavedataParam savedataParams;
        protected boolean isYesSelected;
        protected boolean hasYesNo;
        private final String strNoData;
        private final String strAskLoadData;

        protected GuSavedataDialogLoad(SceUtilitySavedataParam savedataParams, SavedataUtilityDialogState savedataDialogState) {
            super(savedataParams.base);
            this.savedataDialogState = savedataDialogState;
            this.savedataParams = savedataParams;
            this.hasYesNo = savedataParams.isPresent();
            this.strNoData = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilitySavedata.strNoData.text");
            this.strAskLoadData = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilitySavedata.strAskLoadData.text");
            savedataDialogState.setYesSelected(true);
            this.createDialog(savedataDialogState);
        }

        @Override
        protected void updateDialog() {
            String dialogTitle = this.savedataDialogState.getDialogTitle(this.savedataParams.getModeName(), "Load", this.utilityLocale);
            Calendar savedTime = this.savedataParams.getSavedTime();
            this.drawIcon(this.readIcon(this.savedataParams.icon0FileData.buf), 26, 96, 144, 80);
            if (!this.hasYesNo()) {
                this.gu.sceGuDrawHorizontalLine(201, 464, 114, -1);
                this.drawTextWithShadow(270, 131, 0.75f, this.strNoData);
                this.gu.sceGuDrawHorizontalLine(201, 464, 157, -1);
            } else {
                this.gu.sceGuDrawHorizontalLine(201, 464, 87, -1);
                this.drawTextWithShadow(236, 105, 0.75f, this.strAskLoadData);
                this.drawYesNo(278, 349, 154);
                this.gu.sceGuDrawHorizontalLine(201, 464, 184, -1);
                this.drawTextWithShadow(6, 202, 0.75f, this.savedataParams.sfoParam.savedataTitle);
                if (savedTime != null) {
                    this.drawTextWithShadow(6, 219, 0.7f, sceUtility.formatDateTime(savedTime));
                }
                this.drawTextWithShadow(6, 237, 0.75f, MemoryStick.getSizeKbString(this.savedataParams.getRequiredSizeKb()));
                this.drawEnter();
            }
            this.drawBack();
            this.drawHeader(dialogTitle);
        }

        @Override
        protected boolean hasYesNo() {
            return this.hasYesNo;
        }

        @Override
        protected boolean canConfirm() {
            return this.hasYesNo();
        }
    }

    protected static class GuSavedataDialogSave
    extends GuUtilityDialog {
        protected final SavedataUtilityDialogState savedataDialogState;
        protected final SceUtilitySavedataParam savedataParams;
        protected boolean isYesSelected;
        private final String strAskSaveData;
        private final String strAskOverwriteData;

        protected GuSavedataDialogSave(SceUtilitySavedataParam savedataParams, SavedataUtilityDialogState savedataDialogState) {
            super(savedataParams.base);
            this.savedataDialogState = savedataDialogState;
            this.savedataParams = savedataParams;
            this.strAskSaveData = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilitySavedata.strAskSaveData.text");
            this.strAskOverwriteData = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilitySavedata.strAskOverwriteData.text");
            savedataDialogState.setYesSelected(!savedataParams.isPresent());
            this.createDialog(savedataDialogState);
        }

        @Override
        protected void updateDialog() {
            boolean multiLines;
            String dialogTitle = this.savedataDialogState.getDialogTitle(this.savedataParams.getModeName(), "Save", this.utilityLocale);
            Calendar savedTime = this.savedataParams.getSavedTime();
            this.drawIcon(this.readIcon(this.savedataParams.icon0FileData.buf), 26, 96, 144, 80);
            String text = this.getText(dialogTitle);
            boolean bl = multiLines = this.getTextLines(text) > 1;
            if (this.hasYesNo()) {
                int textX = multiLines ? 236 : this.centerText(this.getDefaultFontInfo(), text, 201, 464, 0.75f);
                this.gu.sceGuDrawHorizontalLine(201, 464, multiLines ? 87 : 97, -1);
                this.drawTextWithShadow(textX, multiLines ? 105 : 113, 0.75f, text);
                this.drawYesNo(278, 349, multiLines ? 154 : 145);
                this.gu.sceGuDrawHorizontalLine(201, 464, multiLines ? 184 : 174, -1);
            } else {
                int textX = multiLines ? 270 : this.centerText(this.getDefaultFontInfo(), text, 201, 464, 0.75f);
                this.gu.sceGuDrawHorizontalLine(201, 464, 114, -1);
                this.drawTextWithShadow(textX, 131, 0.75f, text);
                this.gu.sceGuDrawHorizontalLine(201, 464, 157, -1);
            }
            this.drawTextWithShadow(6, 202, 0.75f, this.savedataParams.sfoParam.savedataTitle);
            if (savedTime != null) {
                this.drawTextWithShadow(6, 219, 0.7f, sceUtility.formatDateTime(savedTime));
            }
            this.drawTextWithShadow(6, 237, 0.75f, MemoryStick.getSizeKbString(this.savedataParams.getRequiredSizeKb()));
            if (this.hasEnter()) {
                this.drawEnter();
            }
            this.drawBack();
            this.drawHeader(dialogTitle);
        }

        protected String getText(String dialogTitle) {
            return this.savedataParams.isPresent() ? this.strAskOverwriteData : this.strAskSaveData;
        }

        protected boolean hasEnter() {
            return true;
        }

        @Override
        protected boolean hasYesNo() {
            return true;
        }
    }

    protected static abstract class GuUtilityDialog {
        protected long pressedTimestamp;
        protected static final int repeatDelay = 100000;
        protected boolean downPressedButton;
        protected boolean downPressedAnalog;
        protected boolean upPressedButton;
        protected boolean upPressedAnalog;
        protected boolean leftPressedButton;
        protected boolean leftPressedAnalog;
        protected boolean rightPressedButton;
        protected boolean rightPressedAnalog;
        protected sceGu gu;
        protected UtilityDialogState utilityDialogState;
        private int x;
        private int y;
        private int textX;
        private int textY;
        private int textWidth;
        private int textHeight;
        private int textLineHeight;
        private int textAddr;
        private SceFontInfo defaultFontInfo;
        protected static final float defaultFontScale = 0.75f;
        protected static final int baseAscender = 15;
        protected static final int defaultTextWidth = 512;
        protected static final int defaultTextHeight = 32;
        protected static final int textColor = 0xFFFFFF;
        protected static final int shadowColor = 0;
        protected boolean softShadows;
        protected long startDialogMillis;
        protected int drawSpeed;
        private boolean buttonsSwapped;
        private boolean hasNoButtons;
        protected final Locale utilityLocale;
        private final String strEnter;
        private final String strBack;
        private final String strYes;
        private final String strNo;
        private final String strCancel;

        protected GuUtilityDialog(pspUtilityDialogCommon utilityDialogCommon) {
            this.utilityLocale = sceUtility.getUtilityLocale(utilityDialogCommon.language);
            this.buttonsSwapped = utilityDialogCommon.buttonSwap == 0;
            this.hasNoButtons = false;
            this.strEnter = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilitySavedata.strEnter.text");
            this.strBack = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilitySavedata.strBack.text");
            this.strYes = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilitySavedata.strYes.text");
            this.strNo = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtilitySavedata.strNo.text");
            this.strCancel = ResourceBundle.getBundle("jpcsp/languages/jpcsp", this.utilityLocale).getString("sceUtility.strCancel.text");
        }

        protected void createDialog(UtilityDialogState utilityDialogState) {
            this.utilityDialogState = utilityDialogState;
            if (log.isDebugEnabled()) {
                int partitionId = 2;
                log.debug((Object)String.format("Free memory total=0x%X, max=0x%X", Modules.SysMemUserForUserModule.totalFreeMemSize(partitionId), Modules.SysMemUserForUserModule.maxFreeMemSize(partitionId)));
            }
            this.startDialogMillis = Emulator.getClock().milliTime();
            this.gu = new sceGu(0x100000);
        }

        protected void dispose() {
            if (this.gu != null) {
                this.gu.free();
                this.gu = null;
            }
        }

        public boolean isVisible() {
            return this.gu != null;
        }

        protected void update(int drawSpeed) {
            this.drawSpeed = drawSpeed;
            if (this.gu != null && !this.gu.isListDrawing()) {
                this.gu.sceGuStart();
                this.gu.sceGuDisable(1);
                this.gu.sceGuDisable(0);
                this.gu.sceGuDisable(7);
                this.gu.sceGuDisable(10);
                this.gu.sceGuDisable(18);
                this.gu.sceGuDisable(3);
                this.gu.sceGuDisable(5);
                this.gu.sceGuDisable(2);
                this.gu.sceGuBlendFunc(0, 2, 3, 0, 0);
                this.gu.sceGuEnable(4);
                this.updateDialog();
                this.gu.sceGuFinish();
            }
            this.checkController();
        }

        protected String truncateText(String text, int width, float scale) {
            int textLength;
            String truncatedText = text;
            String truncation = "";
            while ((textLength = this.getTextLength(this.getDefaultFontInfo(), truncatedText + truncation, scale)) > width) {
                truncatedText = truncatedText.substring(0, truncatedText.length() - 1);
                truncation = "...";
            }
            return truncatedText + truncation;
        }

        protected String wrapText(SceFontInfo fontInfo, String text, int width, float scale) {
            int glyphType = 0;
            StringBuilder wrappedText = new StringBuilder();
            int x = 0;
            int lastSpaceStart = -1;
            int lastSpaceEnd = -1;
            boolean isSpace = false;
            int scaledWidth = (int)((float)width / scale);
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                pspCharInfo charInfo = fontInfo.getCharInfo(c, glyphType);
                if (c == ' ') {
                    if (!isSpace) {
                        lastSpaceStart = i;
                        isSpace = true;
                    }
                    lastSpaceEnd = i + 1;
                } else if (isSpace) {
                    lastSpaceEnd = i;
                    isSpace = false;
                }
                int nextX = x + (charInfo.sfp26AdvanceH >> 6);
                if (c == '\n') {
                    x = 0;
                    wrappedText.append(c);
                    continue;
                }
                if (nextX > scaledWidth) {
                    x = 0;
                    if (lastSpaceStart >= 0) {
                        wrappedText.replace(lastSpaceStart, lastSpaceEnd, "\n");
                    } else {
                        wrappedText.append('\n');
                    }
                    if (isSpace) continue;
                    wrappedText.append(c);
                    continue;
                }
                x = nextX;
                wrappedText.append(c);
            }
            return wrappedText.toString();
        }

        private void drawText(SceFontInfo fontInfo, int baseAscender, char c, int glyphType) {
            pspCharInfo charInfo = fontInfo.getCharInfo(c, glyphType);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("drawText '%c'(%d), glyphType=0x%X, baseAscender=%d, position (%d,%d), %s", Character.valueOf(c), (int)c, glyphType, baseAscender, this.x, this.y, charInfo));
            }
            if (charInfo == null) {
                return;
            }
            if (c == '\n') {
                this.x = this.textX;
                this.y += this.textLineHeight;
                return;
            }
            fontInfo.printFont(this.textAddr, this.textWidth / 2, this.textWidth, this.textHeight, this.x - this.textX + charInfo.bitmapLeft, this.y - this.textY + baseAscender - charInfo.bitmapTop, 0, 0, 0, 0, this.textWidth, this.textHeight, 0, c, 32, glyphType, true);
            if (glyphType != 0) {
                charInfo = fontInfo.getCharInfo(c, 0);
            }
            this.x += charInfo.sfp26AdvanceH >> 6;
        }

        protected int getTextLines(String s) {
            int newLine;
            int lines = 1;
            int index = 0;
            while (index < s.length() && (newLine = s.indexOf("\n", index)) >= 0) {
                ++lines;
                index = newLine + 1;
            }
            return lines;
        }

        protected int centerText(SceFontInfo fontInfo, String s, float scale) {
            return this.centerText(fontInfo, s, 0, 480, scale);
        }

        protected int centerText(SceFontInfo fontInfo, String s, int x0, int x1, float scale) {
            int width;
            int textLength = this.getTextLength(fontInfo, s, scale);
            if (textLength >= (width = x1 - x0 + 1)) {
                return x0;
            }
            return x0 + (width - textLength) / 2;
        }

        protected int rightAlignText(SceFontInfo fontInfo, String s, int x, float scale) {
            int textLength = this.getTextLength(fontInfo, s, scale);
            return x - textLength;
        }

        protected int getTextLength(SceFontInfo fontInfo, String s, float scale) {
            int textLength = this.getTextLength(fontInfo, s);
            textLength = (int)(scale * (float)textLength);
            return textLength;
        }

        protected int getTextLength(SceFontInfo fontInfo, String s) {
            int length26 = 0;
            for (int i = 0; i < s.length(); ++i) {
                length26 += this.getTextLength26(fontInfo, s.charAt(i));
            }
            return length26 >> 6;
        }

        private int getTextLength26(SceFontInfo fontInfo, char c) {
            pspCharInfo charInfo = fontInfo.getCharInfo(c, 0);
            if (charInfo == null) {
                return 0;
            }
            return charInfo.sfp26AdvanceH;
        }

        protected int getTextLength(SceFontInfo fontInfo, char c) {
            return this.getTextLength26(fontInfo, c) >> 6;
        }

        protected void drawTextWithShadow(int textX, int textY, float scale, String s) {
            this.drawTextWithShadow(textX, textY, 0xFFFFFF, scale, s);
        }

        protected void drawTextWithShadow(int textX, int textY, int textColor, float scale, String s) {
            SceFontInfo fontInfo = this.getDefaultFontInfo();
            s = this.wrapText(fontInfo, s, 480 - textX, scale);
            int txtHeight = 32;
            if (s.contains("\n")) {
                txtHeight = 272 - textY;
            }
            this.drawTextWithShadow(textX, textY, 512, txtHeight, 20, fontInfo, 15, textColor, 0, scale, s);
        }

        protected void drawTextWithShadow(int textX, int textY, int textWidth, int textHeight, int textLineHeight, SceFontInfo fontInfo, int baseAscender, int textColor, int shadowColor, float scale, String s) {
            this.drawText(textX, textY, textWidth, textHeight, textLineHeight, fontInfo, baseAscender, scale, shadowColor, s, 1);
            this.drawText(textX, textY, textWidth, textHeight, textLineHeight, fontInfo, baseAscender, scale, textColor, s, 0);
        }

        protected void setSoftShadows(boolean softShadows) {
            this.softShadows = softShadows;
        }

        protected void drawText(int textX, int textY, int textWidth, int textHeight, int textLineHeight, SceFontInfo fontInfo, int baseAscender, float scale, int color, String s, int glyphType) {
            this.textX = textX;
            this.textY = textY;
            this.textWidth = textWidth;
            this.textHeight = textHeight;
            this.textLineHeight = textLineHeight;
            this.x = textX;
            this.y = textY;
            int textSize = textWidth * textHeight / 2;
            this.textAddr = this.gu.sceGuGetMemory(textSize);
            if (this.textAddr == 0) {
                return;
            }
            Memory.getInstance().memset(this.textAddr, (byte)0, textSize);
            for (int i = 0; i < s.length(); ++i) {
                this.drawText(fontInfo, baseAscender, s.charAt(i), glyphType);
            }
            int numberOfVertex = 2;
            int textVertexAddr = this.gu.sceGuGetMemory(20);
            IMemoryWriter vertexWriter = MemoryWriter.getMemoryWriter(textVertexAddr, 2);
            vertexWriter.writeNext(0);
            vertexWriter.writeNext(0);
            vertexWriter.writeNext(textX);
            vertexWriter.writeNext(textY);
            vertexWriter.writeNext(0);
            vertexWriter.writeNext(textWidth);
            vertexWriter.writeNext(textHeight);
            vertexWriter.writeNext(textX + (int)((float)textWidth * scale));
            vertexWriter.writeNext(textY + (int)((float)textHeight * scale));
            vertexWriter.writeNext(0);
            vertexWriter.flush();
            int clutAddr = this.gu.sceGuGetMemory(64);
            IMemoryWriter clutWriter = MemoryWriter.getMemoryWriter(clutAddr, 4);
            color &= 0xFFFFFF;
            for (int i = 0; i < 16; ++i) {
                int alpha = i << 4 | i;
                if (this.softShadows && glyphType == 1) {
                    alpha >>= 1;
                }
                clutWriter.writeNext(alpha << 24 | color);
            }
            this.gu.sceGuClutMode(3, 0, 255, 0);
            this.gu.sceGuClutLoad(2, clutAddr);
            this.gu.sceGuTexMode(4, 0, false);
            this.gu.sceGuTexFunc(3, true, false);
            this.gu.sceGuTexEnvColor(0);
            this.gu.sceGuTexWrap(1, 1);
            this.gu.sceGuTexFilter(1, 1);
            this.gu.sceGuEnable(9);
            this.gu.sceGuTexImage(0, 512, 256, textWidth, this.textAddr);
            this.gu.sceGuDrawArray(6, 8388866, 2, 0, textVertexAddr);
        }

        protected void drawButton(int x, int y, String text, boolean selected) {
            if (selected) {
                int alpha = this.getAnimationIndex(255);
                this.gu.sceGuDrawRectangle(x, y, x + text.length() * 17, y + 16, alpha << 24 | 0xC5C8CF);
            }
            this.drawTextWithShadow(x + 5, y + 2, 0.8f, text);
        }

        protected abstract void updateDialog();

        public void checkController() {
            if (this.canConfirm() && (this.isConfirmButtonPressed() || this.hasNoButtons())) {
                this.utilityDialogState.setButtonPressed(this.getButtonPressedOK());
                this.dispose();
            } else if (this.canCancel() && this.isCancelButtonPressed()) {
                this.utilityDialogState.setButtonPressed(3);
                this.dispose();
            }
            if (this.hasYesNo()) {
                if (this.isLeftPressed()) {
                    this.utilityDialogState.setYesSelected(true);
                } else if (this.isRightPressed()) {
                    this.utilityDialogState.setYesSelected(false);
                }
            }
        }

        protected boolean isButtonPressed(int button) {
            Controller controller = State.controller;
            return (controller.getButtons() & button) == button;
        }

        protected boolean isConfirmButtonPressed() {
            return this.isButtonPressed(this.areButtonsSwapped() ? 8192 : 16384);
        }

        protected boolean isCancelButtonPressed() {
            return this.isButtonPressed(this.areButtonsSwapped() ? 16384 : 8192);
        }

        protected void useNoButtons() {
            this.hasNoButtons = true;
        }

        protected boolean hasNoButtons() {
            return this.hasNoButtons;
        }

        private int getControllerLy() {
            return State.controller.getLy() & 0xFF;
        }

        private int getControllerLx() {
            return State.controller.getLx() & 0xFF;
        }

        private int getControllerAnalogCenter() {
            return 128;
        }

        protected boolean canConfirm() {
            return true;
        }

        protected boolean canCancel() {
            return true;
        }

        protected boolean hasYesNo() {
            return false;
        }

        protected int getButtonPressedOK() {
            return 1;
        }

        private void checkRepeat() {
            if (this.pressedTimestamp != 0L && SystemTimeManager.getSystemTime() - this.pressedTimestamp > 100000L) {
                this.upPressedAnalog = false;
                this.upPressedButton = false;
                this.downPressedAnalog = false;
                this.downPressedButton = false;
                this.leftPressedAnalog = false;
                this.leftPressedButton = false;
                this.rightPressedAnalog = false;
                this.rightPressedButton = false;
                this.pressedTimestamp = 0L;
            }
        }

        protected boolean isUpPressed() {
            this.checkRepeat();
            if (this.upPressedButton || this.upPressedAnalog) {
                if (!this.isButtonPressed(16)) {
                    this.upPressedButton = false;
                }
                if (this.getControllerLy() >= this.getControllerAnalogCenter()) {
                    this.upPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(16)) {
                this.upPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLy() < this.getControllerAnalogCenter()) {
                this.upPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        protected boolean isDownPressed() {
            this.checkRepeat();
            if (this.downPressedButton || this.downPressedAnalog) {
                if (!this.isButtonPressed(64)) {
                    this.downPressedButton = false;
                }
                if (this.getControllerLy() <= this.getControllerAnalogCenter()) {
                    this.downPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(64)) {
                this.downPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLy() > this.getControllerAnalogCenter()) {
                this.downPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        protected boolean isLeftPressed() {
            this.checkRepeat();
            if (this.leftPressedButton || this.leftPressedAnalog) {
                if (!this.isButtonPressed(128)) {
                    this.leftPressedButton = false;
                }
                if (this.getControllerLx() >= this.getControllerAnalogCenter()) {
                    this.leftPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(128)) {
                this.leftPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLx() < this.getControllerAnalogCenter()) {
                this.leftPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        protected boolean isRightPressed() {
            this.checkRepeat();
            if (this.rightPressedButton || this.rightPressedAnalog) {
                if (!this.isButtonPressed(32)) {
                    this.rightPressedButton = false;
                }
                if (this.getControllerLx() <= this.getControllerAnalogCenter()) {
                    this.rightPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(32)) {
                this.rightPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLx() > this.getControllerAnalogCenter()) {
                this.rightPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        protected SceFontInfo getDefaultFontInfo() {
            if (this.defaultFontInfo == null) {
                this.defaultFontInfo = Modules.sceFontModule.getFont((int)0).fontInfo;
            }
            return this.defaultFontInfo;
        }

        private String getCross() {
            return "X";
        }

        private String getCircle() {
            return "O";
        }

        protected boolean areButtonsSwapped() {
            return this.buttonsSwapped;
        }

        private int getCrossX() {
            return 183;
        }

        private int getCircleX() {
            return 260;
        }

        private int getEnterX() {
            return this.areButtonsSwapped() ? this.getCircleX() : this.getCrossX();
        }

        private int getBackX() {
            return this.areButtonsSwapped() ? this.getCrossX() : this.getCircleX();
        }

        private String getConfirmString() {
            return this.areButtonsSwapped() ? this.getCircle() : this.getCross();
        }

        private String getCancelString() {
            return this.areButtonsSwapped() ? this.getCross() : this.getCircle();
        }

        protected void drawEnter() {
            this.drawTextWithShadow(this.getEnterX(), 254, 0.75f, String.format("%s %s", this.getConfirmString(), this.strEnter));
        }

        protected void drawBack() {
            this.drawTextWithShadow(this.getBackX(), 254, 0.75f, String.format("%s %s", this.getCancelString(), this.strBack));
        }

        protected void drawEnterWithString(String str) {
            this.drawTextWithShadow(this.getEnterX(), 254, 0.75f, String.format("%s %s", this.getConfirmString(), str));
        }

        protected void drawBackWithString(String str) {
            this.drawTextWithShadow(this.getBackX(), 254, 0.75f, String.format("%s %s", this.getCancelString(), str));
        }

        protected void drawCancel() {
            this.drawTextWithShadow(this.getBackX(), 254, 0.75f, String.format("%s %s", this.getCancelString(), this.strCancel));
        }

        protected void drawHeader(String title) {
            this.gu.sceGuDrawRectangle(0, 0, 480, 22, -2141168556);
            this.drawText(30, 4, 256, 32, 20, this.getDefaultFontInfo(), 15, 0.82f, 0xFFFFFF, title, 0);
            this.drawText(9, 5, 32, 32, 20, this.getDefaultFontInfo(), 15, 0.65f, 0xFFFFFF, new String(Character.toChars(9679)), 0);
        }

        protected void drawYesNo(int xYes, int xNo, int y) {
            this.drawButton(xYes, y, this.strYes, this.utilityDialogState.isYesSelected());
            this.drawButton(xNo, y, this.strNo, this.utilityDialogState.isNoSelected());
        }

        protected void drawIcon(int textureAddr, int iconX, int iconY, int iconWidth, int iconHeight) {
            if (textureAddr == 0) {
                return;
            }
            int numberOfVertex = 2;
            int iconVertexAddr = this.gu.sceGuGetMemory(10 * numberOfVertex);
            if (iconVertexAddr == 0) {
                return;
            }
            IMemoryWriter vertexWriter = MemoryWriter.getMemoryWriter(iconVertexAddr, 2);
            vertexWriter.writeNext(0);
            vertexWriter.writeNext(0);
            vertexWriter.writeNext(iconX);
            vertexWriter.writeNext(iconY);
            vertexWriter.writeNext(0);
            vertexWriter.writeNext(144);
            vertexWriter.writeNext(80);
            vertexWriter.writeNext(iconX + iconWidth);
            vertexWriter.writeNext(iconY + iconHeight);
            vertexWriter.writeNext(0);
            vertexWriter.flush();
            this.gu.sceGuTexEnvColor(0);
            this.gu.sceGuTexMode(3, 0, false);
            this.gu.sceGuTexImage(0, 256, 128, icon0BufferWidth, textureAddr);
            this.gu.sceGuTexFunc(3, true, false);
            this.gu.sceGuTexFilter(1, 1);
            this.gu.sceGuTexWrap(1, 1);
            this.gu.sceGuEnable(9);
            this.gu.sceGuDrawArray(6, 8388866, numberOfVertex, 0, iconVertexAddr);
        }

        protected int readIcon(InputStream is) {
            BufferedImage image = null;
            if (is != null) {
                try {
                    image = ImageIO.read(is);
                }
                catch (IOException e) {
                    log.debug((Object)"getIcon0", (Throwable)e);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (image == null) {
                try {
                    image = ImageIO.read(this.getClass().getResource("/jpcsp/images/icon0.png"));
                }
                catch (IOException e) {
                    log.error((Object)"Cannot read default icon0.png", (Throwable)e);
                }
            }
            if (image == null) {
                return 0;
            }
            int bytesPerPixel = IRenderingEngine.sizeOfTextureType[3];
            int textureAddr = this.gu.sceGuGetMemory(icon0BufferWidth * 80 * bytesPerPixel);
            if (textureAddr == 0) {
                return 0;
            }
            IMemoryWriter textureWriter = MemoryWriter.getMemoryWriter(textureAddr, bytesPerPixel);
            int width = Math.min(image.getWidth(), 144);
            int height = Math.min(image.getHeight(), 80);
            for (int hy = 0; hy < height; ++hy) {
                int wx;
                for (wx = 0; wx < width; ++wx) {
                    int colorARGB = image.getRGB(wx, hy);
                    int colorABGR = ImageReader.colorARGBtoABGR(colorARGB);
                    textureWriter.writeNext(colorABGR);
                }
                for (wx = width; wx < icon0BufferWidth; ++wx) {
                    textureWriter.writeNext(0);
                }
            }
            textureWriter.flush();
            return textureAddr;
        }

        protected int readIcon(int address) {
            MemoryInputStream iconStream = null;
            if (address != 0) {
                iconStream = new MemoryInputStream(address);
            }
            return this.readIcon(iconStream);
        }

        protected int getAnimationIndex(int maxIndex) {
            if (this.drawSpeed <= 0) {
                return maxIndex;
            }
            long now = Emulator.getClock().currentTimeMillis();
            int durationMillis = (int)(now - this.startDialogMillis);
            int animationIndex = durationMillis % 500 * (maxIndex + 1) / 500;
            if (durationMillis / 500 % 2 != 0) {
                animationIndex = maxIndex - animationIndex;
            }
            return animationIndex;
        }
    }

    protected static abstract class UtilityDialog
    extends JComponent {
        private static final long serialVersionUID = -993546461292372048L;
        protected JDialog dialog;
        protected int buttonPressed;
        protected JPanel messagePane;
        protected JPanel buttonPane;
        protected ActionListener closeActionListener;
        protected static final String actionCommandOK = "OK";
        protected static final String actionCommandYES = "YES";
        protected static final String actionCommandNO = "NO";
        protected static final String actionCommandESC = "ESC";
        protected UtilityDialogState utilityDialogState;
        protected String confirmButtonActionCommand = "OK";
        protected String cancelButtonActionCommand = "ESC";
        protected long pressedTimestamp;
        protected static final int repeatDelay = 200000;
        protected boolean downPressedButton;
        protected boolean downPressedAnalog;
        protected boolean upPressedButton;
        protected boolean upPressedAnalog;

        protected UtilityDialog() {
        }

        protected void createDialog(UtilityDialogState utilityDialogState, String message) {
            this.utilityDialogState = utilityDialogState;
            String title = String.format("Message from %s", State.title);
            this.dialog = new JDialog((Frame)null, title, false);
            this.dialog.setDefaultCloseOperation(2);
            this.messagePane = new JPanel();
            this.messagePane.setBorder(new EmptyBorder(5, 10, 5, 10));
            this.messagePane.setLayout(new BoxLayout(this.messagePane, 1));
            if (message != null) {
                message = sceUtility.formatMessageForDialog(message);
                while (message.length() > 0) {
                    int newLinePosition = message.indexOf("\n");
                    JLabel label = new JLabel();
                    label.setHorizontalAlignment(0);
                    label.setAlignmentX(0.5f);
                    if (newLinePosition < 0) {
                        label.setText(message);
                        message = "";
                    } else {
                        String messagePart = message.substring(0, newLinePosition);
                        label.setText(messagePart);
                        message = message.substring(newLinePosition + 1);
                    }
                    this.messagePane.add(label);
                }
            }
            if (JDialog.isDefaultLookAndFeelDecorated() && UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
                this.dialog.setUndecorated(true);
                this.getRootPane().setWindowDecorationStyle(3);
            }
            this.buttonPane = new JPanel();
            this.buttonPane.setBorder(new EmptyBorder(5, 10, 5, 10));
            this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 0));
            this.closeActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    this.processActionCommand(event.getActionCommand());
                    this.dispose();
                }
            };
        }

        protected void dispose() {
            this.dialog.dispose();
            Emulator.getMainGUI().endWindowDialog();
        }

        protected void processActionCommand(String actionCommand) {
            this.buttonPressed = actionCommandYES.equals(actionCommand) ? 1 : (actionCommandNO.equals(actionCommand) ? 2 : (actionCommandOK.equals(actionCommand) ? 1 : (actionCommandESC.equals(actionCommand) ? 3 : 0)));
        }

        protected void endDialog() {
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            contentPane.add(this.messagePane);
            contentPane.add(this.buttonPane);
            this.dialog.pack();
            Emulator.getMainGUI().startWindowDialog(this.dialog);
        }

        protected void setDefaultButton(JButton button) {
            this.dialog.getRootPane().setDefaultButton(button);
        }

        @Override
        public void setVisible(boolean flag) {
            this.dialog.setVisible(flag);
        }

        @Override
        public boolean isVisible() {
            return this.dialog.isVisible();
        }

        @Override
        public Point getLocation() {
            return this.dialog.getLocation();
        }

        @Override
        public Dimension getSize() {
            return this.dialog.getSize();
        }

        protected boolean isButtonPressed(int button) {
            Controller controller = State.controller;
            return (controller.getButtons() & button) == button;
        }

        protected boolean isConfirmButtonPressed() {
            return this.isButtonPressed(sceUtility.getSystemParamButtonPreference() == 0 ? 8192 : 16384);
        }

        protected boolean isCancelButtonPressed() {
            return this.isButtonPressed(sceUtility.getSystemParamButtonPreference() == 0 ? 16384 : 8192);
        }

        private int getControllerLy() {
            return State.controller.getLy() & 0xFF;
        }

        private int getControllerAnalogCenter() {
            return 128;
        }

        private void checkRepeat() {
            if (this.pressedTimestamp != 0L && SystemTimeManager.getSystemTime() - this.pressedTimestamp > 200000L) {
                this.upPressedAnalog = false;
                this.upPressedButton = false;
                this.downPressedAnalog = false;
                this.downPressedButton = false;
                this.pressedTimestamp = 0L;
            }
        }

        protected boolean isUpPressed() {
            this.checkRepeat();
            if (this.upPressedButton || this.upPressedAnalog) {
                if (!this.isButtonPressed(16)) {
                    this.upPressedButton = false;
                }
                if (this.getControllerLy() >= this.getControllerAnalogCenter()) {
                    this.upPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(16)) {
                this.upPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLy() < this.getControllerAnalogCenter()) {
                this.upPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        protected boolean isDownPressed() {
            this.checkRepeat();
            if (this.downPressedButton || this.downPressedAnalog) {
                if (!this.isButtonPressed(64)) {
                    this.downPressedButton = false;
                }
                if (this.getControllerLy() <= this.getControllerAnalogCenter()) {
                    this.downPressedAnalog = false;
                }
                return false;
            }
            if (this.isButtonPressed(64)) {
                this.downPressedButton = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            if (this.getControllerLy() > this.getControllerAnalogCenter()) {
                this.downPressedAnalog = true;
                this.pressedTimestamp = SystemTimeManager.getSystemTime();
                return true;
            }
            return false;
        }

        public void checkController() {
            if (this.isConfirmButtonPressed()) {
                this.processActionCommand(this.confirmButtonActionCommand);
                this.dispose();
            } else if (this.isCancelButtonPressed()) {
                this.processActionCommand(this.cancelButtonActionCommand);
                this.dispose();
            }
        }
    }

    protected static class HtmlViewerUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityHtmlViewerParams htmlViewerParams;

        public HtmlViewerUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible() {
            return false;
        }

        @Override
        protected pspUtilityBaseDialog createParams() {
            this.htmlViewerParams = new SceUtilityHtmlViewerParams();
            return this.htmlViewerParams;
        }

        @Override
        protected boolean hasDialog() {
            return false;
        }
    }

    protected static class NpSigninUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityNpSigninParams npSigninParams;

        public NpSigninUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected pspUtilityBaseDialog createParams() {
            this.npSigninParams = new SceUtilityNpSigninParams();
            return this.npSigninParams;
        }

        @Override
        protected boolean executeUpdateVisible() {
            int sceNp_02CA8CAA;
            int address;
            int sceNpService_7EF4312E;
            int sceNp_C48F2847;
            Memory mem = Processor.memory;
            this.npSigninParams.signinStatus = 1;
            this.npSigninParams.write(mem);
            int sceNp_E24DA399 = NIDMapper.getInstance().getAddressByName("sceNp_E24DA399");
            if (sceNp_E24DA399 != 0) {
                int address2 = mem.read16(sceNp_E24DA399 + 0) << 16;
                if (Memory.isAddressGood(address2 += (short)mem.read16(sceNp_E24DA399 + 8))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("sceNp_E24DA399 Address 0x%08X", address2));
                    }
                    mem.write32(address2, 1);
                }
            }
            if ((sceNp_C48F2847 = NIDMapper.getInstance().getAddressByName("sceNp_C48F2847")) != 0) {
                int address3 = mem.read16(sceNp_C48F2847 + 116) << 16;
                if (Memory.isAddressGood(address3 += (short)mem.read16(sceNp_C48F2847 + 120))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("sceNp_C48F2847 Address 0x%08X", address3));
                    }
                    Utilities.writeStringZ(mem, address3, Modules.sceNpModule.getOnlineId());
                }
            }
            if ((sceNpService_7EF4312E = NIDMapper.getInstance().getAddressByName("sceNpService_7EF4312E")) != 0) {
                int subAddress = (mem.read32(sceNpService_7EF4312E + 120) & 0x3FFFFFF) << 2;
                address = mem.read16(subAddress + 20) << 16;
                if (Memory.isAddressGood(address += (short)mem.read16(subAddress + 56))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("sceNpService_7EF4312E Address 0x%08X", address));
                    }
                    SysMemUserForUser.SysMemInfo memInfo = Modules.SysMemUserForUserModule.malloc(1, "sceNpService_7EF4312E", 0, 100, 0);
                    mem.write32(address, memInfo.addr);
                    mem.memset(memInfo.addr, (byte)0, 100);
                    Utilities.writeStringZ(mem, memInfo.addr + 12, Modules.sceNpModule.getOnlineId());
                    Modules.SysMemForKernelModule.SysMemUserForUser_945E45DA(new TPointer(mem, memInfo.addr + 64));
                }
            }
            if ((sceNp_02CA8CAA = NIDMapper.getInstance().getAddressByName("sceNp_02CA8CAA")) != 0) {
                address = mem.read16(sceNp_02CA8CAA + 140) << 16;
                if (Memory.isAddressGood(address += (short)mem.read16(sceNp_02CA8CAA + 144))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("sceNp_02CA8CAA Address 0x%08X", address));
                    }
                    mem.write64(address, sceRtc.hleGetCurrentTick());
                }
            }
            return false;
        }

        @Override
        protected boolean hasDialog() {
            return false;
        }
    }

    protected static class GamedataInstallUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityGamedataInstallParams gamedataInstallParams;
        private StringBuilder sourceLocalFileName;
        private StringBuilder destinationLocalFileName;
        private IVirtualFileSystem ivfs;
        private IVirtualFileSystem ovfs;
        private String[] fileNames;
        private int filenameIndex;
        private IVirtualFile ivf;
        private IVirtualFile ovf;
        private long totalLength;
        private long totalProcessedLength;
        private long fileTotalLength;
        private long fileProcessedLength;
        private final byte[] buffer = new byte[524288];
        private long startMillis;
        private int secondsLeft;

        public GamedataInstallUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected pspUtilityBaseDialog createParams() {
            this.gamedataInstallParams = new SceUtilityGamedataInstallParams();
            return this.gamedataInstallParams;
        }

        @Override
        protected int checkValidity() {
            int paramSize = this.gamedataInstallParams.base.totalSizeof();
            if (paramSize != 1424 && paramSize != 1432) {
                log.warn((Object)String.format("sceGamedataInstallInitStart invalid parameter size %d", paramSize));
                return -2146369532;
            }
            return super.checkValidity();
        }

        private void init() {
            this.sourceLocalFileName = null;
            this.destinationLocalFileName = null;
            this.ivfs = null;
            this.ovfs = null;
            this.fileNames = null;
            this.filenameIndex = 0;
            if (this.ivf != null) {
                this.ivf.ioClose();
                this.ivf = null;
            }
            if (this.ovf != null) {
                this.ovf.ioClose();
                this.ovf = null;
            }
            this.totalLength = 0L;
            this.totalProcessedLength = 0L;
            this.fileTotalLength = 0L;
            this.fileProcessedLength = 0L;
            this.startMillis = 0L;
            this.secondsLeft = 120;
        }

        @Override
        public int executeInitStart(TPointer paramsAddr) {
            this.init();
            return super.executeInitStart(paramsAddr);
        }

        @Override
        public int executeShutdownStart() {
            this.init();
            return super.executeShutdownStart();
        }

        @Override
        protected boolean executeUpdateVisible() {
            boolean keepVisible = true;
            int result = 0;
            switch (this.dialogState) {
                case quit: {
                    this.dialogState = UtilityDialogState.DialogState.init;
                    break;
                }
                case init: {
                    if (this.gamedataInstallParams.mode > 1) {
                        log.warn((Object)String.format("sceGamedataInstallInitStart invalid mode %d", this.gamedataInstallParams.mode));
                        this.gamedataInstallParams.base.result = -2146363128;
                        keepVisible = false;
                        break;
                    }
                    if (this.gamedataInstallParams.mode == 1) {
                        this.dialogState = UtilityDialogState.DialogState.confirmation;
                        break;
                    }
                    this.dialogState = UtilityDialogState.DialogState.inProgress;
                    break;
                }
                case confirmation: {
                    if (!this.isDialogOpen()) {
                        GuGamedataInstallConfirmationDialog gu = new GuGamedataInstallConfirmationDialog(this.gamedataInstallParams, this);
                        this.openDialog(gu);
                        break;
                    }
                    if (!this.isDialogActive()) {
                        if (this.getButtonPressed() != 1 || this.isNoSelected()) {
                            this.cancel();
                            break;
                        }
                        this.closeDialog();
                        this.dialogState = UtilityDialogState.DialogState.inProgress;
                        break;
                    }
                    this.updateDialog();
                    break;
                }
                case inProgress: {
                    if (this.ivf == null || this.ovf == null) {
                        if (this.ivfs == null || this.ovfs == null) {
                            String[] allFileNames;
                            IoFileMgrForUser fileMgr = Modules.IoFileMgrForUserModule;
                            this.sourceLocalFileName = new StringBuilder();
                            this.ivfs = fileMgr.getVirtualFileSystem("disc0:/PSP_GAME/INSDIR", this.sourceLocalFileName);
                            if (this.ivfs != null && (allFileNames = this.ivfs.ioDopen(this.sourceLocalFileName.toString())) != null) {
                                this.ivfs.ioDclose(this.sourceLocalFileName.toString());
                                this.destinationLocalFileName = new StringBuilder();
                                this.ovfs = fileMgr.getVirtualFileSystem(String.format("%s%s%s", "ms0:/PSP/SAVEDATA/", this.gamedataInstallParams.gameName, this.gamedataInstallParams.dataName), this.destinationLocalFileName);
                                if (this.ovfs != null) {
                                    SceIoStat stat = new SceIoStat();
                                    this.fileNames = null;
                                    this.totalLength = 0L;
                                    this.totalProcessedLength = 0L;
                                    this.filenameIndex = 0;
                                    this.startMillis = GamedataInstallUtilityDialogState.getNowMillis();
                                    for (int i = 0; i < allFileNames.length; ++i) {
                                        String sourceFileName;
                                        String fileName = allFileNames[i];
                                        if (fileName.equals(".") || fileName.equals("\u0001") || fileName.equals("..") || this.ivfs.ioGetstat(sourceFileName = String.format("%s/%s", this.sourceLocalFileName.toString(), fileName), stat) < 0) continue;
                                        this.fileNames = Utilities.add(this.fileNames, fileName);
                                        this.totalLength += stat.size;
                                    }
                                    if (this.totalLength > MemoryStick.getFreeSize()) {
                                        result = -2146363134;
                                        keepVisible = false;
                                    }
                                }
                            }
                        }
                        if (keepVisible && this.fileNames != null && this.filenameIndex < this.fileNames.length) {
                            String fileName = this.fileNames[this.filenameIndex++];
                            String sourceFileName = String.format("%s/%s", this.sourceLocalFileName.toString(), fileName);
                            this.ivf = this.ivfs.ioOpen(sourceFileName, 1, 0);
                            if (this.ivf != null) {
                                this.fileTotalLength = this.ivf.length();
                                this.fileProcessedLength = 0L;
                                String destinationFileName = String.format("%s/%s", this.destinationLocalFileName.toString(), fileName);
                                this.ovf = this.ovfs.ioOpen(destinationFileName, 514, 511);
                                if (this.ovf != null) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)String.format("GamedataInstall: copying file disc0:/%s to ms0:/%s", sourceFileName, destinationFileName));
                                    }
                                } else {
                                    this.ivf.ioClose();
                                    this.ivf = null;
                                }
                            }
                        } else {
                            this.gamedataInstallParams.base.result = result;
                            this.gamedataInstallParams.remainingSize = 0L;
                            this.gamedataInstallParams.progress = result == 0 ? 100 : 0;
                            this.gamedataInstallParams.memoryStickMissingFreeSpace = Math.max(this.totalLength - MemoryStick.getFreeSize(), 0L);
                            this.gamedataInstallParams.memoryStickMissingFreeSpaceText = MemoryStick.getSizeString(this.gamedataInstallParams.memoryStickMissingFreeSpace);
                            this.gamedataInstallParams.memoryStickFreeSpace = MemoryStick.getFreeSize();
                            this.gamedataInstallParams.memoryStickFreeSpaceText = MemoryStick.getSizeString(this.gamedataInstallParams.memoryStickFreeSpace);
                            this.gamedataInstallParams.write(this.paramsAddr);
                            if (this.hasProgressDialog()) {
                                this.openDialog(new GuGamedataInstallCompletedDialog(this.gamedataInstallParams, this));
                                this.dialogState = UtilityDialogState.DialogState.completed;
                            } else {
                                this.quitDialog(result);
                                keepVisible = false;
                            }
                        }
                    }
                    if (this.ivf != null && this.ovf != null) {
                        int length = this.buffer.length;
                        long fileRemainingLength = this.fileTotalLength - this.fileProcessedLength;
                        if ((long)length > fileRemainingLength) {
                            length = (int)fileRemainingLength;
                        }
                        if ((length = this.ivf.ioRead(this.buffer, 0, length)) > 0) {
                            this.ovf.ioWrite(this.buffer, 0, length);
                            this.fileProcessedLength += (long)length;
                            this.totalProcessedLength += (long)length;
                            this.gamedataInstallParams.remainingSize = this.totalLength - this.totalProcessedLength;
                            this.gamedataInstallParams.progress = (int)(100L * this.totalProcessedLength / this.totalLength);
                            this.gamedataInstallParams.writeProgress(this.paramsAddr);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("GamedataInstall %d%%, copied %d/%d to %s", this.gamedataInstallParams.progress, this.fileProcessedLength, this.fileTotalLength, this.ovf));
                            }
                        }
                        if (this.fileProcessedLength >= this.fileTotalLength) {
                            this.ivf.ioClose();
                            this.ivf = null;
                            this.ovf.ioClose();
                            this.ovf = null;
                        }
                    }
                    if (keepVisible) {
                        if (!this.hasProgressDialog()) break;
                        if (!this.isDialogOpen()) {
                            GuGamedataInstallProgressDialog gu = new GuGamedataInstallProgressDialog(this.gamedataInstallParams, this);
                            this.openDialog(gu);
                            break;
                        }
                        if (!this.isDialogActive()) {
                            this.cancel();
                            break;
                        }
                        this.updateDialog();
                        break;
                    }
                    if (this.ivf != null) {
                        this.ivf.ioClose();
                        this.ivf = null;
                    }
                    this.ivfs = null;
                    if (this.ovf != null) {
                        this.ovf.ioClose();
                        this.ovf = null;
                    }
                    this.ovfs = null;
                    break;
                }
                case completed: {
                    if (!this.isDialogActive()) {
                        this.quitDialog();
                        break;
                    }
                    this.updateDialog();
                    break;
                }
                case display: {
                    keepVisible = false;
                }
            }
            return keepVisible;
        }

        private boolean hasProgressDialog() {
            return this.gamedataInstallParams.mode == 1;
        }

        public int getProgress() {
            return this.gamedataInstallParams.progress;
        }

        private static long getNowMillis() {
            return Emulator.getClock().milliTime();
        }

        public int getSecondsLeft() {
            long endMillis;
            int newSecondsLeft;
            long nowMillis = GamedataInstallUtilityDialogState.getNowMillis();
            if (this.getProgress() > 0 && (newSecondsLeft = (int)(((endMillis = this.startMillis + 100L * (nowMillis - this.startMillis) / (long)this.getProgress()) - nowMillis + 500L) / 1000L)) < this.secondsLeft) {
                this.secondsLeft = newSecondsLeft;
            }
            return this.secondsLeft;
        }

        @Override
        protected boolean hasDialog() {
            return false;
        }

        @Override
        protected int getShutdownDelay() {
            return 50000;
        }
    }

    protected static class ScreenshotUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityScreenshotParams screenshotParams;

        public ScreenshotUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible() {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("SceUtilityScreenshotParams %s", Utilities.getMemoryDump(this.paramsAddr.getAddress(), this.params.sizeof())));
            }
            if (this.status == 2 && (this.screenshotParams.isContModeAuto() || this.screenshotParams.isContModeFinish())) {
                this.status = 5;
            }
            if (this.status == 2 && !this.screenshotParams.isContModeAuto() && !this.screenshotParams.isContModeFinish() && Memory.isAddressGood(this.screenshotParams.imgFrameBufAddr)) {
                String fileSuffix;
                Buffer buffer = Memory.getInstance().getBuffer(this.screenshotParams.imgFrameBufAddr, this.screenshotParams.imgFrameBufWidth * this.screenshotParams.displayHeigth * IRenderingEngine.sizeOfTextureType[this.screenshotParams.imgPixelFormat]);
                String directoyName = String.format(Settings.getInstance().getDirectoryMapping("ms0") + "PSP/SCREENSHOT/%s/", this.screenshotParams.screenshotID);
                new File(directoyName).mkdirs();
                String fileName = null;
                String string = fileSuffix = this.screenshotParams.imgFormat == 2 ? "jpeg" : "png";
                if (this.screenshotParams.nameRule == 1) {
                    for (int fileIndex = 1; fileIndex <= 9999 && new File(fileName = String.format("%s%s_%04d.%s", directoyName, this.screenshotParams.fileName, fileIndex, fileSuffix)).exists(); ++fileIndex) {
                    }
                } else {
                    fileName = String.format("%s%s.%s", directoyName, this.screenshotParams.fileName, fileSuffix);
                }
                CaptureImage captureImage = new CaptureImage(this.screenshotParams.imgFrameBufAddr, 0, buffer, this.screenshotParams.displayWidth, this.screenshotParams.displayHeigth, this.screenshotParams.imgFrameBufWidth, this.screenshotParams.imgPixelFormat, false, 0, false, true, null);
                if (this.screenshotParams.imgFormat == 1) {
                    captureImage.setFileFormat("png");
                } else if (this.screenshotParams.imgFormat == 2) {
                    captureImage.setFileFormat("jpg");
                }
                captureImage.setFileName(fileName);
                try {
                    captureImage.write();
                }
                catch (IOException e) {
                    log.error((Object)"sceUtilityScreenshot", (Throwable)e);
                }
            }
            return false;
        }

        protected int executeContStart(TPointer paramsAddr) {
            if (this.status != 5) {
                return -2146369535;
            }
            this.paramsAddr = paramsAddr;
            this.params = this.createParams();
            this.params.read(paramsAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("%sContStart %s", this.name, this.params.toString()));
            }
            if (!this.screenshotParams.isContModeAuto()) {
                return -2146364887;
            }
            this.status = 3;
            return 0;
        }

        @Override
        protected pspUtilityBaseDialog createParams() {
            this.screenshotParams = new SceUtilityScreenshotParams();
            return this.screenshotParams;
        }

        @Override
        protected boolean hasDialog() {
            return false;
        }
    }

    protected static class NetconfUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityNetconfParams netconfParams;

        public NetconfUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible() {
            boolean keepVisible = false;
            if (this.netconfParams.netAction == 0 || this.netconfParams.netAction == 3) {
                int state = Modules.sceNetApctlModule.hleNetApctlGetState();
                if (state == 4) {
                    this.quitDialog();
                    keepVisible = false;
                } else {
                    keepVisible = true;
                    if (state == 0) {
                        Modules.sceNetApctlModule.hleNetApctlConnect(1);
                    }
                }
            } else if (this.netconfParams.netAction == 2 || this.netconfParams.netAction == 4 || this.netconfParams.netAction == 5) {
                int state = Modules.sceNetAdhocctlModule.hleNetAdhocctlGetState();
                if (state == 1) {
                    this.quitDialog();
                    keepVisible = false;
                } else {
                    this.updateDialog();
                    keepVisible = true;
                    if (state == 0 && this.netconfParams.netconfData != null) {
                        Modules.sceNetAdhocctlModule.hleNetAdhocctlConnect(this.netconfParams.netconfData.groupName);
                    }
                }
            }
            return keepVisible;
        }

        @Override
        protected pspUtilityBaseDialog createParams() {
            this.netconfParams = new SceUtilityNetconfParams();
            return this.netconfParams;
        }
    }

    protected static class GameSharingUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityGameSharingParams gameSharingParams;

        public GameSharingUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible() {
            return false;
        }

        @Override
        protected pspUtilityBaseDialog createParams() {
            this.gameSharingParams = new SceUtilityGameSharingParams();
            return this.gameSharingParams;
        }

        @Override
        protected boolean hasDialog() {
            return false;
        }
    }

    protected static class OskUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityOskParams oskParams;
        protected OskDialog oskDialog;
        protected int oskDataIndex;
        protected String[] outText;
        protected int[] result;

        public OskUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible() {
            Memory mem = Processor.memory;
            if (!this.isDialogOpen()) {
                if (this.isReadyForVisible()) {
                    this.oskDataIndex = 0;
                    this.outText = new String[this.oskParams.oskDataCount];
                    this.result = new int[this.oskParams.oskDataCount];
                    this.oskDialog = new OskDialog(this.oskParams, this);
                    this.openDialog(this.oskDialog);
                }
            } else if (!this.isDialogActive()) {
                if (this.oskDialog.buttonPressed == 1) {
                    this.result[this.oskDataIndex] = 2;
                    this.outText[this.oskDataIndex] = this.oskDialog.textField.getText();
                    log.info((Object)String.format("hleUtilityOskDisplay #%d returning '%s'", this.oskDataIndex + 1, this.oskParams.oskData[this.oskDataIndex].outText));
                } else {
                    this.result[this.oskDataIndex] = 1;
                    this.outText[this.oskDataIndex] = this.oskDialog.textField.getText();
                    log.info((Object)"hleUtilityOskDisplay cancelled");
                }
                ++this.oskDataIndex;
                if (this.oskDataIndex >= this.oskParams.oskDataCount) {
                    this.quitDialog(0);
                    for (int i = 0; i < this.oskDataIndex; ++i) {
                        this.oskParams.oskData[i].result = this.result[i];
                        this.oskParams.oskData[i].outText = this.outText[i];
                    }
                    this.oskParams.write(mem);
                    this.oskDataIndex = 0;
                    this.outText = null;
                    this.result = null;
                } else {
                    this.closeDialog();
                    this.oskDialog = new OskDialog(this.oskParams, this);
                    this.openDialog(this.oskDialog);
                }
            } else {
                this.oskDialog.checkController();
                this.updateDialog();
            }
            return false;
        }

        @Override
        protected pspUtilityBaseDialog createParams() {
            this.oskParams = new SceUtilityOskParams();
            return this.oskParams;
        }

        @Override
        protected int getInitDelay() {
            return 100000;
        }
    }

    protected static class MsgDialogUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityMsgDialogParams msgDialogParams;

        public MsgDialogUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible() {
            Memory mem = Processor.memory;
            if (!this.isDialogOpen()) {
                GuMsgDialog gu = new GuMsgDialog(this.msgDialogParams, this);
                this.openDialog(gu);
            } else if (!this.isDialogActive()) {
                this.msgDialogParams.buttonPressed = this.msgDialogParams.mode == 1 ? this.getButtonPressed() : (this.msgDialogParams.mode == 0 ? 3 : 0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceUtilityMsgDialog returning buttonPressed=%d", this.msgDialogParams.buttonPressed));
                }
                this.quitDialog(0);
                this.msgDialogParams.write(mem);
            } else {
                this.updateDialog();
            }
            return false;
        }

        @Override
        protected pspUtilityBaseDialog createParams() {
            this.msgDialogParams = new SceUtilityMsgDialogParams();
            return this.msgDialogParams;
        }
    }

    protected static class SavedataUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilitySavedataParam savedataParams;
        protected volatile String saveListSelection;
        protected volatile InputStream saveListSelectionIcon0;
        protected boolean saveListEmpty;
        private int savedataMultiStatus;

        public SavedataUtilityDialogState(String name) {
            super(name);
            this.setMinimumVisibleDurationMillis(500);
        }

        @Override
        protected pspUtilityBaseDialog createParams() {
            this.savedataParams = new SceUtilitySavedataParam();
            return this.savedataParams;
        }

        @Override
        protected int checkValidity() {
            int paramSize = this.savedataParams.base.totalSizeof();
            if (paramSize != 1480 && paramSize != 1500 && paramSize != 1536) {
                log.warn((Object)String.format("sceUtilitySavedataInitStart invalid parameter size %d", paramSize));
                return -2146369532;
            }
            return super.checkValidity();
        }

        protected int checkMultipleCallStatus(int result) {
            if (this.savedataParams.multiStatus == 0 || this.savedataParams.multiStatus == 1) {
                this.savedataMultiStatus = this.savedataParams.multiStatus;
                return result;
            }
            if ((this.savedataParams.multiStatus == 2 || this.savedataParams.multiStatus == 3) && this.savedataMultiStatus <= this.savedataParams.multiStatus) {
                this.savedataMultiStatus = this.savedataParams.multiStatus;
                return result;
            }
            return -2146368724;
        }

        @Override
        protected boolean executeUpdateVisible() {
            Memory mem = Processor.memory;
            switch (this.savedataParams.mode) {
                case 0: {
                    if ((this.savedataParams.saveName == null || this.savedataParams.saveName.equals("<>") || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                        this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                    }
                    try {
                        this.savedataParams.load(mem);
                        this.savedataParams.write(mem);
                    }
                    catch (IOException e) {
                        if (!this.savedataParams.isGameDirectoryPresent()) {
                            this.savedataParams.base.result = -2146368761;
                            break;
                        }
                        if (this.savedataParams.base.totalSizeof() < 1536) {
                            this.savedataParams.base.result = -2146368761;
                            break;
                        }
                        this.savedataParams.base.result = -2146368759;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368763;
                        log.error((Object)e);
                    }
                    break;
                }
                case 2: {
                    switch (this.dialogState) {
                        case init: {
                            if ((this.savedataParams.saveName == null || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                                this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                            }
                            GuSavedataDialogLoad gu = new GuSavedataDialogLoad(this.savedataParams, this);
                            this.openDialog(gu);
                            this.dialogState = UtilityDialogState.DialogState.confirmation;
                            break;
                        }
                        case confirmation: {
                            if (!this.isDialogActive()) {
                                if (this.getButtonPressed() != 1 || this.isNoSelected()) {
                                    this.cancel();
                                    break;
                                }
                                this.closeDialog();
                                this.dialogState = UtilityDialogState.DialogState.inProgress;
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                        case inProgress: {
                            try {
                                this.savedataParams.load(mem);
                                this.savedataParams.write(mem);
                            }
                            catch (IOException e) {
                                this.savedataParams.base.result = !this.savedataParams.isGameDirectoryPresent() ? -2146368761 : (this.savedataParams.base.totalSizeof() < 1536 ? -2146368761 : -2146368759);
                            }
                            catch (Exception e) {
                                this.savedataParams.base.result = -2146368763;
                                log.error((Object)e);
                            }
                            if (!this.isReadyForVisible()) break;
                            GuSavedataDialogCompleted gu = new GuSavedataDialogCompleted(this.savedataParams, this, this.saveListSelectionIcon0);
                            this.openDialog(gu);
                            this.dialogState = UtilityDialogState.DialogState.completed;
                            break;
                        }
                        case completed: {
                            if (!this.isDialogActive()) {
                                this.quitDialog();
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (this.dialogState) {
                        case init: {
                            ArrayList<String> validNames = new ArrayList<String>();
                            for (int i = 0; i < this.savedataParams.saveNameList.length; ++i) {
                                this.savedataParams.saveName = this.savedataParams.saveNameList[i];
                                if (!this.savedataParams.isPresent()) continue;
                                validNames.add(this.savedataParams.saveName);
                            }
                            if (!this.isReadyForVisible()) break;
                            GuSavedataDialog gu = new GuSavedataDialog(this.savedataParams, this, validNames.toArray(new String[validNames.size()]));
                            this.openDialog(gu);
                            break;
                        }
                        case display: {
                            if (!this.isDialogActive()) {
                                if (this.getButtonPressed() != 1) {
                                    this.savedataParams.base.result = this.saveListEmpty ? -2146368761 : 1;
                                    this.quitDialog(this.savedataParams.base.result);
                                    break;
                                }
                                if (this.saveListSelection == null) {
                                    log.warn((Object)"Savedata MODE_LISTLOAD no save selected");
                                    this.quitDialog(-2146368760);
                                    break;
                                }
                                this.closeDialog();
                                this.dialogState = UtilityDialogState.DialogState.inProgress;
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                        case inProgress: {
                            try {
                                this.savedataParams.saveName = this.saveListSelection;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)String.format("Loading savedata %s", this.savedataParams.saveName));
                                }
                                this.savedataParams.load(mem);
                                this.savedataParams.write(mem);
                            }
                            catch (IOException e) {
                                this.savedataParams.base.result = !this.savedataParams.isGameDirectoryPresent() ? -2146368761 : (this.savedataParams.base.totalSizeof() < 1536 ? -2146368761 : -2146368759);
                            }
                            catch (Exception e) {
                                this.savedataParams.base.result = -2146368763;
                                log.error((Object)e);
                            }
                            if (!this.isReadyForVisible()) break;
                            GuSavedataDialogCompleted gu = new GuSavedataDialogCompleted(this.savedataParams, this, this.saveListSelectionIcon0);
                            this.openDialog(gu);
                            this.dialogState = UtilityDialogState.DialogState.completed;
                            break;
                        }
                        case completed: {
                            if (!this.isDialogActive()) {
                                this.quitDialog();
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                    }
                    break;
                }
                case 1: {
                    if ((this.savedataParams.saveName == null || this.savedataParams.saveName.equals("<>") || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                        this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                    }
                    try {
                        this.savedataParams.save(mem, true);
                    }
                    catch (IOException e) {
                        this.savedataParams.base.result = -2146368635;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368635;
                        log.error((Object)e);
                    }
                    break;
                }
                case 3: {
                    switch (this.dialogState) {
                        case init: {
                            if ((this.savedataParams.saveName == null || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                                this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                            }
                            GuSavedataDialogSave gu = new GuSavedataDialogSave(this.savedataParams, this);
                            this.openDialog(gu);
                            this.dialogState = UtilityDialogState.DialogState.confirmation;
                            break;
                        }
                        case confirmation: {
                            if (!this.isDialogActive()) {
                                if (this.getButtonPressed() != 1 || this.isNoSelected()) {
                                    this.cancel();
                                    break;
                                }
                                this.closeDialog();
                                this.dialogState = UtilityDialogState.DialogState.inProgress;
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                        case inProgress: {
                            try {
                                this.savedataParams.save(mem, true);
                            }
                            catch (IOException e) {
                                this.savedataParams.base.result = -2146368635;
                            }
                            catch (Exception e) {
                                this.savedataParams.base.result = -2146368635;
                                log.error((Object)e);
                            }
                            if (!this.isReadyForVisible()) break;
                            GuSavedataDialogCompleted gu = new GuSavedataDialogCompleted(this.savedataParams, this, this.saveListSelectionIcon0);
                            this.openDialog(gu);
                            this.dialogState = UtilityDialogState.DialogState.completed;
                            break;
                        }
                        case completed: {
                            if (!this.isDialogActive()) {
                                this.quitDialog();
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (this.dialogState) {
                        case init: {
                            if (!this.isReadyForVisible()) break;
                            GuSavedataDialog gu = new GuSavedataDialog(this.savedataParams, this, this.savedataParams.saveNameList);
                            this.openDialog(gu);
                            break;
                        }
                        case display: {
                            if (!this.isDialogActive()) {
                                this.closeDialog();
                                if (this.getButtonPressed() != 1) {
                                    this.quitDialog(-2146368632);
                                    break;
                                }
                                if (this.saveListSelection == null) {
                                    log.warn((Object)"Savedata MODE_LISTSAVE no save selected");
                                    this.quitDialog(1);
                                    break;
                                }
                                this.savedataParams.saveName = this.saveListSelection;
                                this.savedataParams.write(mem);
                                if (this.savedataParams.isPresent(this.savedataParams.gameName, this.saveListSelection)) {
                                    if (!this.isReadyForVisible()) break;
                                    GuSavedataDialogSave gu = new GuSavedataDialogSave(this.savedataParams, this);
                                    this.openDialog(gu);
                                    this.dialogState = UtilityDialogState.DialogState.confirmation;
                                    break;
                                }
                                this.dialogState = UtilityDialogState.DialogState.inProgress;
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                        case confirmation: {
                            if (!this.isDialogActive()) {
                                if (this.getButtonPressed() != 1 || this.isNoSelected()) {
                                    this.cancel();
                                    break;
                                }
                                this.closeDialog();
                                this.dialogState = UtilityDialogState.DialogState.inProgress;
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                        case inProgress: {
                            try {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)String.format("Saving savedata %s", this.savedataParams.saveName));
                                }
                                this.savedataParams.save(mem, true);
                            }
                            catch (IOException e) {
                                this.savedataParams.base.result = -2146368635;
                            }
                            catch (Exception e) {
                                this.savedataParams.base.result = -2146368635;
                                log.error((Object)e);
                            }
                            if (!this.isReadyForVisible()) break;
                            GuSavedataDialogCompleted gu = new GuSavedataDialogCompleted(this.savedataParams, this, this.saveListSelectionIcon0);
                            this.openDialog(gu);
                            this.dialogState = UtilityDialogState.DialogState.completed;
                            break;
                        }
                        case completed: {
                            if (!this.isDialogActive()) {
                                this.quitDialog();
                                break;
                            }
                            this.updateDialog();
                            break;
                        }
                    }
                    break;
                }
                case 7: {
                    if (!this.isDialogOpen()) {
                        String pattern = this.savedataParams.gameName + ".*";
                        String[] entries = Modules.IoFileMgrForUserModule.listFiles("ms0:/PSP/SAVEDATA/", pattern);
                        ArrayList<String> validNames = new ArrayList<String>();
                        for (int i = 0; entries != null && i < entries.length; ++i) {
                            String saveName = entries[i].substring(this.savedataParams.gameName.length());
                            if (!this.savedataParams.isPresent(this.savedataParams.gameName, saveName)) continue;
                            validNames.add(saveName);
                        }
                        GuSavedataDialog gu = new GuSavedataDialog(this.savedataParams, this, validNames.toArray(new String[validNames.size()]));
                        this.openDialog(gu);
                        break;
                    }
                    if (!this.isDialogActive()) {
                        if (this.getButtonPressed() != 1) {
                            this.savedataParams.base.result = -2146368696;
                        } else if (this.saveListSelection == null) {
                            log.warn((Object)"Savedata MODE_DELETE no save selected");
                            this.savedataParams.base.result = -2146368696;
                        } else {
                            String dirName = this.savedataParams.getBasePath(this.saveListSelection);
                            if (this.savedataParams.deleteDir(dirName)) {
                                log.debug((Object)("Savedata MODE_DELETE deleting " + dirName));
                                this.savedataParams.base.result = 0;
                            } else {
                                this.savedataParams.base.result = -2146368699;
                            }
                        }
                        this.quitDialog(this.savedataParams.base.result);
                        break;
                    }
                    this.updateDialog();
                    break;
                }
                case 8: {
                    int utilityDataAddr;
                    int msDataAddr;
                    int msFreeAddr;
                    int retval = 0;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("MODE_SIZES: msFreeAddr=0x%08X-0x%08X, msDataAddr=0x%08X-0x%08X, utilityDataAddr=0x%08X-0x%08X", this.savedataParams.msFreeAddr, this.savedataParams.msFreeAddr + 20, this.savedataParams.msDataAddr, this.savedataParams.msDataAddr + 64, this.savedataParams.utilityDataAddr, this.savedataParams.utilityDataAddr + 28));
                    }
                    if ((msFreeAddr = this.savedataParams.msFreeAddr) != 0) {
                        String memoryStickFreeSpaceString = MemoryStick.getSizeKbString(MemoryStick.getFreeSizeKb());
                        mem.write32(msFreeAddr + 0, MemoryStick.getSectorSize());
                        mem.write32(msFreeAddr + 4, MemoryStick.getFreeSizeKb() / MemoryStick.getSectorSizeKb());
                        mem.write32(msFreeAddr + 8, MemoryStick.getFreeSizeKb());
                        Utilities.writeStringNZ(mem, msFreeAddr + 12, 8, memoryStickFreeSpaceString);
                        log.debug((Object)("Memory Stick Free Space = " + memoryStickFreeSpaceString));
                    }
                    if ((msDataAddr = this.savedataParams.msDataAddr) != 0) {
                        String gameName = Utilities.readStringNZ(mem, msDataAddr, 13);
                        String saveName = Utilities.readStringNZ(mem, msDataAddr + 16, 20);
                        if (this.savedataParams.isDirectoryPresent(gameName, saveName = this.savedataParams.getAnySaveName(gameName, saveName))) {
                            int savedataSizeKb = this.savedataParams.getSizeKb(gameName, saveName);
                            int savedataSize32Kb = MemoryStick.getSize32Kb(savedataSizeKb);
                            mem.write32(msDataAddr + 36, savedataSizeKb / MemoryStick.getSectorSizeKb());
                            mem.write32(msDataAddr + 40, savedataSizeKb);
                            Utilities.writeStringNZ(mem, msDataAddr + 44, 8, MemoryStick.getSizeKbString(savedataSizeKb));
                            mem.write32(msDataAddr + 52, savedataSize32Kb);
                            Utilities.writeStringNZ(mem, msDataAddr + 56, 8, MemoryStick.getSizeKbString(savedataSize32Kb));
                            log.debug((Object)("Memory Stick Used Space = " + MemoryStick.getSizeKbString(savedataSizeKb)));
                        } else {
                            log.debug((Object)String.format("Savedata MODE_SIZES directory not found, gameName='%s', saveName='%s'", gameName, saveName));
                            retval = -2146368569;
                        }
                    }
                    if ((utilityDataAddr = this.savedataParams.utilityDataAddr) != 0) {
                        int memoryStickRequiredSpaceKb = this.savedataParams.getRequiredSizeKb();
                        String memoryStickRequiredSpaceString = MemoryStick.getSizeKbString(memoryStickRequiredSpaceKb);
                        int memoryStickRequiredSpace32Kb = MemoryStick.getSize32Kb(memoryStickRequiredSpaceKb);
                        String memoryStickRequiredSpace32KbString = MemoryStick.getSizeKbString(memoryStickRequiredSpace32Kb);
                        mem.write32(utilityDataAddr + 0, memoryStickRequiredSpaceKb / MemoryStick.getSectorSizeKb());
                        mem.write32(utilityDataAddr + 4, memoryStickRequiredSpaceKb);
                        Utilities.writeStringNZ(mem, utilityDataAddr + 8, 8, memoryStickRequiredSpaceString);
                        mem.write32(utilityDataAddr + 16, memoryStickRequiredSpace32Kb);
                        Utilities.writeStringNZ(mem, utilityDataAddr + 20, 8, memoryStickRequiredSpace32KbString);
                        log.debug((Object)("Memory Stick Required Space = " + memoryStickRequiredSpaceString));
                    }
                    this.savedataParams.base.result = retval;
                    break;
                }
                case 9: {
                    if (this.savedataParams.deleteDir(this.savedataParams.getBasePath())) {
                        this.savedataParams.base.result = 0;
                    } else {
                        log.warn((Object)"Savedata MODE_AUTODELETE directory not found!");
                        this.savedataParams.base.result = -2146368697;
                    }
                    this.status = 3;
                    break;
                }
                case 10: {
                    if (this.savedataParams.deleteFile(this.savedataParams.fileName)) {
                        this.savedataParams.base.result = 0;
                    } else {
                        log.warn((Object)"Savedata MODE_SINGLEDELETE file not found!");
                        this.savedataParams.base.result = -2146368703;
                    }
                    this.status = 3;
                    break;
                }
                case 11: {
                    int buffer4Addr = this.savedataParams.idListAddr;
                    if (Memory.isAddressGood(buffer4Addr)) {
                        int maxEntries = mem.read32(buffer4Addr + 0);
                        int entriesAddr = mem.read32(buffer4Addr + 8);
                        String saveName = this.savedataParams.saveName;
                        String pattern = saveName.replace('?', '.');
                        pattern = pattern.replace("*", ".*");
                        pattern = this.savedataParams.gameName + pattern;
                        String[] entries = Modules.IoFileMgrForUserModule.listFiles("ms0:/PSP/SAVEDATA/", pattern);
                        int numEntries = entries == null ? 0 : entries.length;
                        numEntries = Math.min(numEntries, maxEntries);
                        for (int i = 0; i < numEntries; ++i) {
                            String filePath = "ms0:/PSP/SAVEDATA//" + entries[i];
                            SceIoStat stat = Modules.IoFileMgrForUserModule.statFile(filePath);
                            int entryAddr = entriesAddr + i * 72;
                            if (stat != null) {
                                mem.write32(entryAddr + 0, stat.mode);
                                stat.ctime.write(mem, entryAddr + 4);
                                stat.atime.write(mem, entryAddr + 20);
                                stat.mtime.write(mem, entryAddr + 36);
                            }
                            String entryName = entries[i].substring(this.savedataParams.gameName.length());
                            entryName = LocalVirtualFileSystem.getMsFileName(entryName);
                            Utilities.writeStringNZ(mem, entryAddr + 52, 20, entryName);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)String.format("MODE_LIST returning filePath=%s, stat=%s, entryName=%s at 0x%08X", filePath, stat, entryName, entryAddr));
                        }
                        mem.write32(buffer4Addr + 4, numEntries);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("MODE_LIST returning %d entries", numEntries));
                        }
                    }
                    this.savedataParams.base.result = this.checkMultipleCallStatus(0);
                    break;
                }
                case 12: {
                    int fileListAddr = this.savedataParams.fileListAddr;
                    if (!Memory.isAddressGood(fileListAddr)) break;
                    int saveFileSecureMaxNumEntries = mem.read32(fileListAddr);
                    int saveFileMaxNumEntries = mem.read32(fileListAddr + 4);
                    int systemMaxNumEntries = mem.read32(fileListAddr + 8);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("MaxFiles in FileList: secure=%d, normal=%d, system=%d", saveFileSecureMaxNumEntries, saveFileMaxNumEntries, systemMaxNumEntries));
                    }
                    int saveFileSecureEntriesAddr = mem.read32(fileListAddr + 24);
                    int saveFileEntriesAddr = mem.read32(fileListAddr + 28);
                    int systemEntriesAddr = mem.read32(fileListAddr + 32);
                    String path = this.savedataParams.getBasePath();
                    String[] entries = Modules.IoFileMgrForUserModule.listFiles(path, null);
                    int maxNumEntries = entries == null ? 0 : entries.length;
                    int saveFileSecureNumEntries = 0;
                    int saveFileNumEntries = 0;
                    int systemFileNumEntries = 0;
                    for (int i = 0; i < maxNumEntries; ++i) {
                        int entryAddr;
                        String entry = LocalVirtualFileSystem.getMsFileName(entries[i]);
                        String filePath = path + "/" + entry;
                        SceIoStat stat = Modules.IoFileMgrForUserModule.statFile(filePath);
                        if (SceUtilitySavedataParam.isSystemFile(entry)) {
                            if (systemEntriesAddr == 0 || systemFileNumEntries >= systemMaxNumEntries) continue;
                            entryAddr = systemEntriesAddr + systemFileNumEntries * 80;
                            if (stat != null) {
                                mem.write32(entryAddr + 0, stat.mode);
                                mem.write64(entryAddr + 8, stat.size);
                                stat.ctime.write(mem, entryAddr + 16);
                                stat.atime.write(mem, entryAddr + 32);
                                stat.mtime.write(mem, entryAddr + 48);
                            }
                            Utilities.writeStringNZ(mem, entryAddr + 64, 16, entry);
                            ++systemFileNumEntries;
                            continue;
                        }
                        if (this.savedataParams.isSecureFile(entry)) {
                            if (saveFileSecureEntriesAddr == 0 || saveFileSecureNumEntries >= saveFileSecureMaxNumEntries) continue;
                            entryAddr = saveFileSecureEntriesAddr + saveFileSecureNumEntries * 80;
                            if (stat != null) {
                                mem.write32(entryAddr + 0, stat.mode);
                                long fileSize = stat.size;
                                if (CryptoEngine.getSavedataCryptoStatus()) {
                                    fileSize -= 16L;
                                }
                                mem.write64(entryAddr + 8, fileSize);
                                stat.ctime.write(mem, entryAddr + 16);
                                stat.atime.write(mem, entryAddr + 32);
                                stat.mtime.write(mem, entryAddr + 48);
                            }
                            Utilities.writeStringNZ(mem, entryAddr + 64, 16, entry);
                            ++saveFileSecureNumEntries;
                            continue;
                        }
                        if (saveFileEntriesAddr == 0 || saveFileNumEntries >= saveFileMaxNumEntries) continue;
                        entryAddr = saveFileEntriesAddr + saveFileNumEntries * 80;
                        if (stat != null) {
                            mem.write32(entryAddr + 0, stat.mode);
                            mem.write64(entryAddr + 8, stat.size);
                            stat.ctime.write(mem, entryAddr + 16);
                            stat.atime.write(mem, entryAddr + 32);
                            stat.mtime.write(mem, entryAddr + 48);
                        }
                        Utilities.writeStringNZ(mem, entryAddr + 64, 16, entry);
                        ++saveFileNumEntries;
                    }
                    this.savedataParams.base.result = entries == null ? -2146368729 : this.checkMultipleCallStatus(0);
                    if (this.savedataParams.base.result == 0) {
                        mem.write32(fileListAddr + 12, saveFileSecureNumEntries);
                        mem.write32(fileListAddr + 16, saveFileNumEntries);
                        mem.write32(fileListAddr + 20, systemFileNumEntries);
                    }
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)String.format("FileList: %s", Utilities.getMemoryDump(fileListAddr, 36)));
                    if (saveFileSecureEntriesAddr != 0 && saveFileSecureNumEntries > 0) {
                        log.debug((Object)String.format("SecureEntries: %s", Utilities.getMemoryDump(saveFileSecureEntriesAddr, saveFileSecureNumEntries * 80)));
                    }
                    if (saveFileEntriesAddr != 0 && saveFileNumEntries > 0) {
                        log.debug((Object)String.format("NormalEntries: %s", Utilities.getMemoryDump(saveFileEntriesAddr, saveFileNumEntries * 80)));
                    }
                    if (systemEntriesAddr == 0 || systemFileNumEntries <= 0) break;
                    log.debug((Object)String.format("SystemEntries: %s", Utilities.getMemoryDump(systemEntriesAddr, systemFileNumEntries * 80)));
                    break;
                }
                case 13: 
                case 14: {
                    try {
                        this.savedataParams.save(mem, this.savedataParams.mode == 13);
                        this.savedataParams.base.result = this.checkMultipleCallStatus(this.savedataParams.base.result);
                    }
                    catch (IOException e) {
                        this.savedataParams.base.result = -2146368731;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368731;
                        log.error((Object)e);
                    }
                    break;
                }
                case 15: 
                case 16: {
                    if ((this.savedataParams.saveName == null || this.savedataParams.saveName.length() == 0) && this.savedataParams.saveNameList != null && this.savedataParams.saveNameList.length > 0) {
                        this.savedataParams.saveName = this.savedataParams.saveNameList[0];
                    }
                    try {
                        this.savedataParams.load(mem);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("MODE_READ/MODE_READSECURE reading %s", Utilities.getMemoryDump(this.savedataParams.dataBuf, this.savedataParams.dataSize, 4, 16)));
                        }
                        this.savedataParams.base.result = this.checkMultipleCallStatus(this.savedataParams.base.result);
                        this.savedataParams.write(mem);
                    }
                    catch (FileNotFoundException e) {
                        if (this.savedataParams.isGameDirectoryPresent()) {
                            this.savedataParams.base.result = -2146368727;
                            break;
                        }
                        this.savedataParams.base.result = -2146368729;
                    }
                    catch (IOException e) {
                        this.savedataParams.base.result = -2146368729;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368731;
                        log.error((Object)e);
                    }
                    break;
                }
                case 17: 
                case 18: {
                    try {
                        this.savedataParams.save(mem, this.savedataParams.mode == 17);
                        this.savedataParams.base.result = this.checkMultipleCallStatus(this.savedataParams.base.result);
                    }
                    catch (IOException e) {
                        if (!this.savedataParams.isGameDirectoryPresent()) {
                            this.savedataParams.base.result = -2146368729;
                            break;
                        }
                        this.savedataParams.base.result = -2146368731;
                    }
                    catch (Exception e) {
                        this.savedataParams.base.result = -2146368731;
                        log.error((Object)e);
                    }
                    break;
                }
                case 21: {
                    if (this.savedataParams.deleteFile(this.savedataParams.fileName)) {
                        this.savedataParams.base.result = this.checkMultipleCallStatus(0);
                        break;
                    }
                    log.warn((Object)"Savedata MODE_DELETEDATA no data found!");
                    this.savedataParams.base.result = -2146368729;
                    break;
                }
                case 22: {
                    int buffer6Addr = this.savedataParams.sizeAddr;
                    boolean isPresent = this.savedataParams.isPresent();
                    if (Memory.isAddressGood(buffer6Addr)) {
                        int sizeKb;
                        String fileName;
                        long size;
                        int entryAddr;
                        int i;
                        int saveFileSecureNumEntries = mem.read32(buffer6Addr + 0);
                        int saveFileNumEntries = mem.read32(buffer6Addr + 4);
                        int saveFileSecureEntriesAddr = mem.read32(buffer6Addr + 8);
                        int saveFileEntriesAddr = mem.read32(buffer6Addr + 12);
                        int totalSizeKb = 0;
                        for (i = 0; i < saveFileSecureNumEntries; ++i) {
                            entryAddr = saveFileSecureEntriesAddr + i * 24;
                            size = mem.read64(entryAddr);
                            fileName = Utilities.readStringNZ(entryAddr + 8, 16);
                            sizeKb = Utilities.getSizeKb(size);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("   Secure File '%s', size %d (%d KB)", fileName, size, sizeKb));
                            }
                            totalSizeKb += sizeKb;
                        }
                        for (i = 0; i < saveFileNumEntries; ++i) {
                            entryAddr = saveFileEntriesAddr + i * 24;
                            size = mem.read64(entryAddr);
                            fileName = Utilities.readStringNZ(entryAddr + 8, 16);
                            sizeKb = Utilities.getSizeKb(size);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("   File '%s', size %d (%d KB)", fileName, size, sizeKb));
                            }
                            totalSizeKb += sizeKb;
                        }
                        int freeSizeKb = MemoryStick.getFreeSizeKb();
                        String memoryStickFreeSpaceString = MemoryStick.getSizeKbString(freeSizeKb);
                        mem.write32(buffer6Addr + 16, MemoryStick.getSectorSize());
                        mem.write32(buffer6Addr + 20, freeSizeKb / MemoryStick.getSectorSizeKb());
                        mem.write32(buffer6Addr + 24, freeSizeKb);
                        Utilities.writeStringNZ(mem, buffer6Addr + 28, 8, memoryStickFreeSpaceString);
                        if (totalSizeKb > freeSizeKb) {
                            int neededSizeKb = totalSizeKb - freeSizeKb;
                            mem.write32(buffer6Addr + 36, neededSizeKb);
                            Utilities.writeStringNZ(mem, buffer6Addr + 40, 8, MemoryStick.getSizeKbString(neededSizeKb));
                            if (isPresent) {
                                mem.write32(buffer6Addr + 48, neededSizeKb);
                                Utilities.writeStringNZ(mem, buffer6Addr + 52, 8, MemoryStick.getSizeKbString(neededSizeKb));
                            }
                        } else {
                            mem.write32(buffer6Addr + 36, 0);
                            if (isPresent) {
                                mem.write32(buffer6Addr + 48, 0);
                            }
                        }
                    }
                    if (MemoryStick.getStateMs() != 1) {
                        this.savedataParams.base.result = -2146368735;
                        break;
                    }
                    if (!isPresent) {
                        this.savedataParams.base.result = -2146368729;
                        break;
                    }
                    this.savedataParams.base.result = this.checkMultipleCallStatus(0);
                    break;
                }
                case 19: {
                    if (this.savedataParams.fileName != null) {
                        String save = this.savedataParams.getFileName(this.savedataParams.saveName, this.savedataParams.fileName);
                        if (Modules.IoFileMgrForUserModule.deleteFile(save)) {
                            this.savedataParams.base.result = this.checkMultipleCallStatus(0);
                            break;
                        }
                        if (this.savedataParams.isGameDirectoryPresent()) {
                            this.savedataParams.base.result = -2146368729;
                            break;
                        }
                        this.savedataParams.base.result = -2146368727;
                        break;
                    }
                    log.warn((Object)"Savedata MODE_ERASESECURE no fileName specified!");
                    this.savedataParams.base.result = -2146368729;
                    break;
                }
                default: {
                    log.warn((Object)String.format("Savedata - Unsupported mode %d", this.savedataParams.mode));
                    this.quitDialog(-1);
                }
            }
            this.savedataParams.base.writeResult(mem);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleUtilitySavedataDisplay result: 0x%08X", this.savedataParams.base.result));
            }
            return false;
        }

        @Override
        protected boolean hasDialog() {
            switch (this.savedataParams.mode) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 10: {
                    return true;
                }
            }
            return false;
        }
    }

    protected static class NotImplementedUtilityDialogState
    extends UtilityDialogState {
        public NotImplementedUtilityDialogState(String name) {
            super(name);
        }

        @Override
        public int executeInitStart(TPointer paramsAddr) {
            log.warn((Object)String.format("Unimplemented: %sInitStart params: %s", this.name, Utilities.getMemoryDump(paramsAddr.getAddress(), paramsAddr.getValue32())));
            return -2146369533;
        }

        @Override
        public int executeShutdownStart() {
            log.warn((Object)String.format("Unimplemented: %sShutdownStart", this.name));
            return -2146369533;
        }

        @Override
        public int executeGetStatus() {
            log.warn((Object)String.format("Unimplemented: %sGetStatus", this.name));
            return -2146369533;
        }

        @Override
        protected boolean executeUpdateVisible() {
            log.warn((Object)String.format("Unimplemented: %sUpdate", this.name));
            return false;
        }

        @Override
        protected pspUtilityBaseDialog createParams() {
            return null;
        }

        @Override
        protected boolean hasDialog() {
            return false;
        }
    }

    protected static abstract class UtilityDialogState {
        protected String name;
        protected pspUtilityBaseDialog params;
        protected TPointer paramsAddr;
        protected int status;
        protected UtilityDialog dialog;
        protected int drawSpeed;
        protected int minimumVisibleDurationMillis;
        protected long startVisibleTimeMillis;
        protected int buttonPressed;
        protected GuUtilityDialog guDialog;
        protected boolean isYesSelected;
        protected DialogState dialogState;

        public UtilityDialogState(String name) {
            this.name = name;
            this.status = 0;
            this.dialogState = DialogState.init;
            this.setButtonPressed(0);
        }

        protected void openDialog(UtilityDialog dialog) {
            if (this.dialogState == DialogState.init) {
                this.dialogState = DialogState.display;
            }
            this.status = 2;
            this.dialog = dialog;
            dialog.setVisible(true);
        }

        protected void openDialog(GuUtilityDialog guDialog) {
            if (this.dialogState == DialogState.init) {
                this.dialogState = DialogState.display;
            }
            this.status = 2;
            this.guDialog = guDialog;
        }

        protected boolean isDialogOpen() {
            return this.dialog != null || this.guDialog != null;
        }

        protected void updateDialog() {
            int delayMicros = 16666;
            Modules.ThreadManForUserModule.hleKernelDelayThread(delayMicros, false);
        }

        protected boolean isDialogActive() {
            if (this.isDialogOpen()) {
                if (this.dialog != null) {
                    return this.dialog.isVisible();
                }
                if (this.guDialog != null) {
                    return this.guDialog.isVisible();
                }
            }
            return false;
        }

        protected void closeDialog() {
            if (this.dialog != null) {
                this.dialog = null;
            }
            if (this.guDialog != null) {
                this.guDialog = null;
            }
        }

        private void setResult(int result) {
            if (this.params != null && this.params.base != null) {
                this.params.base.result = result;
                this.params.base.writeResult(this.paramsAddr);
            }
        }

        protected void quitDialog() {
            this.closeDialog();
            this.status = 3;
            this.dialogState = DialogState.quit;
        }

        protected void quitDialog(int result) {
            this.quitDialog();
            this.setResult(result);
        }

        public int getButtonPressed() {
            return this.buttonPressed;
        }

        public final void setButtonPressed(int buttonPressed) {
            this.buttonPressed = buttonPressed;
        }

        public int executeInitStart(TPointer paramsAddr) {
            int validityResult;
            if (this.status != 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%sInitStart already started status=%d", this.name, this.status));
                }
                return -2146369535;
            }
            this.setYesSelected(true);
            this.paramsAddr = paramsAddr;
            this.params = this.createParams();
            this.params.read(paramsAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("%sInitStart %s-0x%08X: %s", this.name, paramsAddr, paramsAddr.getAddress() + this.params.sizeof(), this.params.toString()));
            }
            if ((validityResult = this.checkValidity()) == 0) {
                this.status = 1;
                this.dialogState = DialogState.init;
                Modules.sceUtilityModule.startedDialogState = this;
                SceKernelThreadInfo initThread = Modules.ThreadManForUserModule.hleKernelCreateThread("SceUtilityInit", Modules.sceUtilityModule.UTILITY_LOOP_ADDRESS, this.params.base.accessThread, 2048, 0, 0, 2);
                Modules.ThreadManForUserModule.hleKernelStartThread(initThread, 0, TPointer.NULL, initThread.gpReg_addr);
                initThread.cpuContext.setRegister(16, 0);
                initThread.cpuContext.setRegister(17, this.getInitDelay());
            }
            return validityResult;
        }

        protected boolean isReadyForVisible() {
            if ((State.controller.getButtons() & 0xFFFF) != 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Not ready for visible, button pressed 0x%X", State.controller.getButtons()));
                }
                return false;
            }
            return true;
        }

        protected boolean hasDialog() {
            return true;
        }

        public int executeGetStatus() {
            if (Modules.sceUtilityModule.startedDialogState == null || Modules.sceUtilityModule.startedDialogState != this) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%sGetStatus returning ERROR_UTILITY_WRONG_TYPE", this.name));
                }
                return -2146369531;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%sGetStatus status %d", this.name, this.status));
            }
            int previousStatus = this.status;
            return previousStatus;
        }

        public int executeShutdownStart() {
            if (Modules.sceUtilityModule.startedDialogState == null || Modules.sceUtilityModule.startedDialogState != this) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%ShutdownStart returning ERROR_UTILITY_WRONG_TYPE", this.name));
                }
                return -2146369531;
            }
            if (this.status != 3) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%ShutdownStart returning ERROR_UTILITY_INVALID_STATUS", this.name));
                }
                return -2146369535;
            }
            this.status = 4;
            SceKernelThreadInfo shutdownThread = Modules.ThreadManForUserModule.hleKernelCreateThread("SceUtilityShutdown", Modules.sceUtilityModule.UTILITY_LOOP_ADDRESS, this.params.base.accessThread, 2048, 0, 0, 2);
            Modules.ThreadManForUserModule.hleKernelStartThread(shutdownThread, 0, TPointer.NULL, shutdownThread.gpReg_addr);
            shutdownThread.cpuContext.setRegister(16, 2);
            shutdownThread.cpuContext.setRegister(17, this.getShutdownDelay());
            return 0;
        }

        public final int executeUpdate(int drawSpeed) {
            this.drawSpeed = drawSpeed;
            if (Modules.sceUtilityModule.startedDialogState == null || Modules.sceUtilityModule.startedDialogState != this) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%sUpdate returning ERROR_UTILITY_WRONG_TYPE", this.name));
                }
                return -2146369531;
            }
            int result = -2146369535;
            if (this.status == 1 && this.isReadyForVisible()) {
                this.status = 2;
                this.startVisibleTimeMillis = Emulator.getClock().currentTimeMillis();
            } else if (this.status == 2 || this.status == 5) {
                long now;
                result = 0;
                this.params.read(this.paramsAddr);
                if (this.guDialog != null) {
                    this.guDialog.update(drawSpeed);
                }
                boolean keepVisible = this.executeUpdateVisible();
                if (this.status == 2 && this.isDialogOpen()) {
                    if (this.dialog != null) {
                        this.dialog.checkController();
                    }
                    if (this.guDialog != null) {
                        this.guDialog.checkController();
                    }
                }
                if (this.status == 2 && !this.isDialogOpen() && !keepVisible && this.dialogState == DialogState.quit && (now = Emulator.getClock().currentTimeMillis()) - this.startVisibleTimeMillis >= (long)this.getMinimumVisibleDurationMillis()) {
                    this.status = 3;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%sUpdate returning 0x%08X", this.name, result));
            }
            return result;
        }

        public int executeAbort() {
            if (Modules.sceUtilityModule.startedDialogState == null || Modules.sceUtilityModule.startedDialogState != this) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%sAbort returning ERROR_UTILITY_WRONG_TYPE", this.name));
                }
                return -2146369531;
            }
            if (this.status != 2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("%sAbort returning ERROR_UTILITY_INVALID_STATUS", this.name));
                }
                return -2146369535;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%sAbort", this.name));
            }
            this.quitDialog(2);
            return 0;
        }

        public void cancel() {
            this.quitDialog(1);
        }

        protected abstract boolean executeUpdateVisible();

        protected abstract pspUtilityBaseDialog createParams();

        protected int checkValidity() {
            return 0;
        }

        public int getMinimumVisibleDurationMillis() {
            return this.minimumVisibleDurationMillis;
        }

        public void setMinimumVisibleDurationMillis(int minimumVisibleDurationMillis) {
            this.minimumVisibleDurationMillis = minimumVisibleDurationMillis;
        }

        protected String getDialogTitle(String key, String defaultTitle, Locale utilityLocale) {
            String title;
            try {
                ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp", utilityLocale);
                title = key == null ? bundle.getString(this.name) : bundle.getString(this.name + "." + key);
            }
            catch (MissingResourceException mre) {
                title = defaultTitle;
            }
            return title;
        }

        public boolean isYesSelected() {
            return this.isYesSelected;
        }

        public boolean isNoSelected() {
            return !this.isYesSelected;
        }

        public void setYesSelected(boolean isYesSelected) {
            this.isYesSelected = isYesSelected;
        }

        protected int getShutdownDelay() {
            if (this.hasDialog()) {
                return 50000;
            }
            return 2000;
        }

        protected int getInitDelay() {
            return 0;
        }

        protected static enum DialogState {
            init,
            display,
            confirmation,
            inProgress,
            completed,
            quit;

        }
    }

    protected static class InstallUtilityDialogState
    extends UtilityDialogState {
        protected SceUtilityInstallParams installParams;

        public InstallUtilityDialogState(String name) {
            super(name);
        }

        @Override
        protected boolean executeUpdateVisible() {
            boolean keepVisible = false;
            log.warn((Object)String.format("Partial sceUtilityInstallUpdate %s", this.installParams.toString()));
            String fileName = String.format("ms0:/PSP/GAME/%s/EBOOT.PBP", this.installParams.gameName);
            try {
                SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(fileName, 1);
                if (moduleInput != null) {
                    byte[] moduleBytes = new byte[(int)moduleInput.length()];
                    moduleInput.readFully(moduleBytes);
                    ByteBuffer moduleBuffer = ByteBuffer.wrap(moduleBytes);
                    SceModule module = Emulator.getInstance().load(this.name, moduleBuffer, true, false, this.installParams.key);
                    Emulator.getClock().resume();
                    if ((module.fileFormat & 1) == 1) {
                        this.installParams.base.result = 0;
                        keepVisible = false;
                    } else {
                        log.warn((Object)"sceUtilityInstall - failed, target is not an ELF");
                        this.installParams.base.result = -1;
                    }
                    moduleInput.close();
                }
            }
            catch (GeneralJpcspException e) {
                log.error((Object)("General Error : " + e.getMessage()));
                Emulator.PauseEmu();
            }
            catch (IOException e) {
                log.error((Object)String.format("sceUtilityInstall - Error while loading module %s: %s", fileName, e.getMessage()));
                this.installParams.base.result = -1;
            }
            return keepVisible;
        }

        @Override
        protected pspUtilityBaseDialog createParams() {
            this.installParams = new SceUtilityInstallParams();
            return this.installParams;
        }

        @Override
        protected boolean hasDialog() {
            return false;
        }
    }
}

