/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.SceModule;
import org.apache.log4j.Logger;

public class NIDMapper {
    private static Logger log = Modules.log;
    private static NIDMapper instance;
    private final Map<Integer, NIDInfo> syscallMap;
    private final Map<String, Map<Integer, NIDInfo>> moduleNidMap = new HashMap<String, Map<Integer, NIDInfo>>();
    private final Map<Integer, NIDInfo> nidMap = new HashMap<Integer, NIDInfo>();
    private final Map<Integer, NIDInfo> addressMap;
    private final Map<String, NIDInfo> nameMap;
    private int freeSyscallNumber = 16384;
    private boolean hideAllSyscalls;

    public static NIDMapper getInstance() {
        if (instance == null) {
            instance = new NIDMapper();
        }
        return instance;
    }

    private NIDMapper() {
        this.syscallMap = new HashMap<Integer, NIDInfo>();
        this.addressMap = new HashMap<Integer, NIDInfo>();
        this.nameMap = new HashMap<String, NIDInfo>();
    }

    private void addModuleNIDInfo(NIDInfo info) {
        Map<Integer, NIDInfo> moduleMap = this.moduleNidMap.get(info.getModuleName());
        if (moduleMap == null) {
            moduleMap = new HashMap<Integer, NIDInfo>();
            this.moduleNidMap.put(info.getModuleName(), moduleMap);
        }
        moduleMap.put(info.getNid(), info);
    }

    private void addNIDInfo(NIDInfo info) {
        this.addModuleNIDInfo(info);
        if (!info.isValidModuleName()) {
            this.nidMap.put(info.getNid(), info);
        }
        if (info.hasAddress()) {
            this.addressMap.put(info.getAddress(), info);
        }
        if (info.hasSyscall()) {
            this.syscallMap.put(info.getSyscall(), info);
        }
        if (info.hasName()) {
            this.nameMap.put(info.getName(), info);
        }
    }

    private void removeNIDInfo(NIDInfo info) {
        Map<Integer, NIDInfo> moduleMap = this.moduleNidMap.get(info.getModuleName());
        if (moduleMap != null) {
            moduleMap.remove(info.getNid());
            if (moduleMap.isEmpty()) {
                this.moduleNidMap.remove(info.getModuleName());
            }
        }
        if (!info.isValidModuleName()) {
            this.nidMap.remove(info.getNid());
        }
        if (info.hasAddress()) {
            this.addressMap.remove(info.getAddress());
        }
        if (info.hasSyscall()) {
            this.syscallMap.remove(info.getSyscall());
        }
        if (info.hasName()) {
            this.nameMap.remove(info.getName());
        }
    }

    private NIDInfo getNIDInfoByNid(String moduleName, int nid) {
        NIDInfo info = null;
        Map<Integer, NIDInfo> moduleMap = this.moduleNidMap.get(moduleName);
        if (moduleMap != null) {
            info = moduleMap.get(nid);
        }
        if (info == null) {
            info = this.nidMap.get(nid);
        }
        return info;
    }

    private NIDInfo getNIDInfoBySyscall(int syscall) {
        return this.syscallMap.get(syscall);
    }

    private NIDInfo getNIDInfoByAddress(int address) {
        return this.addressMap.get(address);
    }

    private NIDInfo getNIDInfoByName(String name) {
        return this.nameMap.get(name);
    }

    public int getNewSyscallNumber() {
        return this.freeSyscallNumber++;
    }

    public boolean addHLENid(int nid, String name, String moduleName, int firmwareVersion) {
        NIDInfo info = this.getNIDInfoByNid(moduleName, nid);
        if (info != null) {
            return name.equals(info.getName()) && moduleName.equals(info.getModuleName()) && firmwareVersion == info.getFirmwareVersion();
        }
        int syscall = this.getNewSyscallNumber();
        info = new NIDInfo(nid, syscall, name, moduleName, firmwareVersion);
        this.addNIDInfo(info);
        return true;
    }

    public void addModuleNid(SceModule module, String moduleName, int nid, int address, boolean variableExport, boolean requiresSyscall) {
        address &= 0x1FFFFFFF;
        NIDInfo info = this.getNIDInfoByNid(moduleName, nid);
        if (info != null) {
            if (module.pspfilename == null || !module.pspfilename.startsWith("flash0:")) {
                if (!moduleName.equals(info.moduleName)) {
                    info = new NIDInfo(nid, address, moduleName, variableExport);
                    this.addModuleNIDInfo(info);
                }
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("NID %s[0x%08X] at address 0x%08X from module '%s' overwriting an HLE syscall", info.getName(), nid, address, moduleName));
            }
            info.overwrite(address, false);
            this.addressMap.put(address, info);
        } else {
            if (module.pspfilename != null && module.pspfilename.startsWith("flash0:/kd/")) {
                log.warn((Object)String.format("NID 0x%08X from module '%s' (%s) not found in any HLE module", nid, moduleName, module.pspfilename));
            }
            info = new NIDInfo(nid, address, moduleName, variableExport);
            if (requiresSyscall) {
                int syscall = this.getNewSyscallNumber();
                info.setSyscall(syscall);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Created syscall 0x%05X for NID 0x%08X from module '%s'", syscall, nid, moduleName));
                }
            }
            this.addNIDInfo(info);
        }
    }

    public void addFakeSycall(String moduleName, int nid, int address) {
        address &= 0x1FFFFFFF;
        NIDInfo info = this.getNIDInfoByNid(moduleName, nid);
        if (info != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("NID %s[0x%08X] at address 0x%08X from module '%s' faking an HLE syscall", info.getName(), nid, address, moduleName));
            }
            info.overwrite(address, true);
            this.addressMap.put(address, info);
        }
    }

    public void setNidAddress(String moduleName, int nid, int address) {
        address &= 0x1FFFFFFF;
        NIDInfo info = this.getNIDInfoByNid(moduleName, nid);
        if (info == null) {
            log.error((Object)String.format("NID 0x%08X from module '%s' not found", nid, moduleName));
            return;
        }
        info.setAddress(address);
    }

    public void removeModuleNids(String moduleName) {
        LinkedList<NIDInfo> nidsToBeRemoved = new LinkedList<NIDInfo>();
        LinkedList<Integer> addressesToBeRemoved = new LinkedList<Integer>();
        for (NIDInfo info : this.addressMap.values()) {
            if (!info.isFromModule(moduleName)) continue;
            if (info.isOverwritten()) {
                addressesToBeRemoved.add(info.getAddress());
                info.undoOverwrite();
                continue;
            }
            nidsToBeRemoved.add(info);
        }
        for (NIDInfo info : nidsToBeRemoved) {
            this.removeNIDInfo(info);
        }
        for (Integer address : addressesToBeRemoved) {
            this.addressMap.remove(address);
        }
    }

    public int getAddressByNid(int nid, String moduleName) {
        NIDInfo info = this.getNIDInfoByNid(moduleName, nid);
        if (info == null || !info.hasAddress()) {
            return 0;
        }
        if (moduleName != null && !info.isFromModule(moduleName)) {
            log.debug((Object)String.format("Trying to resolve %s from module '%s'", info, moduleName));
        }
        return info.getAddress();
    }

    public int getAddressByNid(int nid) {
        return this.getAddressByNid(nid, null);
    }

    public int getAddressBySyscall(int syscall) {
        NIDInfo info = this.getNIDInfoBySyscall(syscall);
        if (info == null || !info.hasAddress()) {
            return 0;
        }
        if (info.isHLE() && !info.isOverwritten()) {
            return 0;
        }
        if (info.isFake()) {
            return 0;
        }
        return info.getAddress();
    }

    public int getAddressByName(String name) {
        NIDInfo info = this.getNIDInfoByName(name);
        if (info == null || !info.hasAddress()) {
            return 0;
        }
        return info.getAddress();
    }

    public int getSyscallByNid(int nid, String moduleName) {
        if (this.isHideAllSyscalls()) {
            return -1;
        }
        NIDInfo info = this.getNIDInfoByNid(moduleName, nid);
        if (info == null || !info.hasSyscall()) {
            return -1;
        }
        if (moduleName != null && !info.isFromModule(moduleName)) {
            log.debug((Object)String.format("Trying to resolve %s from module '%s'", info, moduleName));
        }
        return info.getSyscall();
    }

    public int getSyscallByNid(int nid) {
        return this.getSyscallByNid(nid, null);
    }

    public String getNameBySyscall(int syscall) {
        NIDInfo info = this.getNIDInfoBySyscall(syscall);
        if (info == null) {
            return null;
        }
        return info.getName();
    }

    public int getNidBySyscall(int syscall) {
        NIDInfo info = this.getNIDInfoBySyscall(syscall);
        if (info == null) {
            return 0;
        }
        return info.getNid();
    }

    public int getNidByAddress(int address) {
        NIDInfo info = this.getNIDInfoByAddress(address);
        if (info == null) {
            return 0;
        }
        return info.getNid();
    }

    public int getSyscallByAddress(int address) {
        NIDInfo info = this.getNIDInfoByAddress(address);
        if (info == null || !info.hasSyscall()) {
            return -1;
        }
        return info.getSyscall();
    }

    public String getModuleNameByAddress(int address) {
        NIDInfo info = this.getNIDInfoByAddress(address);
        if (info == null) {
            return null;
        }
        return info.getModuleName();
    }

    public String getModuleNameBySyscall(int syscall) {
        NIDInfo info = this.getNIDInfoBySyscall(syscall);
        if (info == null) {
            return null;
        }
        return info.getModuleName();
    }

    public void unloadNid(int nid) {
        for (String moduleName : this.moduleNidMap.keySet()) {
            NIDInfo info = this.getNIDInfoByNid(moduleName, nid);
            if (info == null) continue;
            info.setLoaded(false);
        }
    }

    public void unloadAll() {
        for (Map<Integer, NIDInfo> moduleMap : this.moduleNidMap.values()) {
            for (NIDInfo info : moduleMap.values()) {
                if (info.isOverwritten()) {
                    info.undoOverwrite();
                }
                info.setLoaded(false);
            }
        }
    }

    public int[] getModuleNids(String moduleName) {
        Map<Integer, NIDInfo> moduleMap = this.moduleNidMap.get(moduleName);
        if (moduleMap == null) {
            return null;
        }
        Integer[] nids = moduleMap.keySet().toArray(new Integer[moduleMap.size()]);
        if (nids == null) {
            return null;
        }
        int[] result = new int[nids.length];
        for (int i = 0; i < nids.length; ++i) {
            result[i] = nids[i];
        }
        return result;
    }

    public String[] getModuleNames() {
        String[] moduleNames = this.moduleNidMap.keySet().toArray(new String[this.moduleNidMap.size()]);
        return moduleNames;
    }

    public boolean isVariableExportByAddress(int address) {
        NIDInfo info = this.getNIDInfoByAddress(address);
        if (info == null) {
            return false;
        }
        return info.isVariableExport();
    }

    public boolean isHideAllSyscalls() {
        return this.hideAllSyscalls;
    }

    public void setHideAllSyscalls(boolean hideAllSyscalls) {
        this.hideAllSyscalls = hideAllSyscalls;
    }

    protected static class NIDInfo {
        private final int nid;
        private int syscall;
        private int address;
        private final String name;
        private final String moduleName;
        private final boolean variableExport;
        private int firmwareVersion;
        private boolean overwritten;
        private boolean loaded;
        private boolean validModuleName;
        private final boolean isHLE;
        private boolean fake;

        public NIDInfo(int nid, int address, String moduleName, boolean variableExport) {
            this.nid = nid;
            this.moduleName = moduleName;
            this.variableExport = variableExport;
            this.setAddress(address);
            this.name = null;
            this.setSyscall(-1);
            this.firmwareVersion = 999;
            this.overwritten = false;
            this.loaded = true;
            this.validModuleName = true;
            this.isHLE = false;
        }

        public NIDInfo(int nid, int syscall, String name, String moduleName, int firmwareVersion) {
            this.nid = nid;
            this.setSyscall(syscall);
            this.name = name;
            this.moduleName = moduleName;
            this.variableExport = false;
            this.firmwareVersion = firmwareVersion;
            this.loaded = true;
            this.validModuleName = false;
            this.isHLE = true;
        }

        public int getNid() {
            return this.nid;
        }

        public int getSyscall() {
            return this.syscall;
        }

        public boolean hasSyscall() {
            return this.syscall >= 0;
        }

        public void setSyscall(int syscall) {
            this.syscall = syscall;
        }

        public int getAddress() {
            return this.address;
        }

        private void setAddress(int address) {
            this.address = address;
        }

        public boolean hasAddress() {
            return this.address != 0;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasName() {
            return this.name != null && this.name.length() > 0;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public boolean isOverwritten() {
            return this.overwritten;
        }

        private void setOverwritten(boolean overwritten) {
            this.overwritten = overwritten;
        }

        public void overwrite(int address, boolean fake) {
            this.fake = fake;
            this.setOverwritten(true);
            this.setAddress(address);
        }

        public void undoOverwrite() {
            this.setOverwritten(false);
            this.setAddress(0);
        }

        public int getFirmwareVersion() {
            return this.firmwareVersion;
        }

        public void setFirmwareVersion(int firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
        }

        public boolean isFromModule(String moduleName) {
            return moduleName.equals(this.moduleName);
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }

        public boolean isValidModuleName() {
            return this.validModuleName;
        }

        public boolean isVariableExport() {
            return this.variableExport;
        }

        public boolean isHLE() {
            return this.isHLE;
        }

        public boolean isFake() {
            return this.fake;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            if (this.name != null) {
                s.append(String.format("%s(nid=0x%08X)", this.name, this.nid));
            } else {
                s.append(String.format("nid=0x%08X", this.nid));
            }
            s.append(String.format(", moduleName='%s'", this.moduleName));
            if (!this.isValidModuleName()) {
                s.append("(probably invalid)");
            }
            if (this.isVariableExport()) {
                s.append(", variable export");
            }
            s.append(String.format(", firmwareVersion=%d", this.firmwareVersion));
            if (this.isOverwritten()) {
                s.append(", overwritten");
            }
            if (this.hasAddress()) {
                s.append(String.format(", address=0x%08X", this.address));
            }
            if (this.hasSyscall()) {
                s.append(String.format(", syscall=0x%X", this.syscall));
            }
            return s.toString();
        }
    }
}

