/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.io.IOException;
import jpcsp.Allegrex.BcuState;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.Cp0State;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.Instructions;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.Memory;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class Processor
implements IState {
    private static final int STATE_VERSION = 0;
    public CpuState cpu = new CpuState();
    public Cp0State cp0 = new Cp0State();
    public static final Memory memory = Memory.getInstance();
    protected Logger log = Logger.getLogger((String)"cpu");
    private int opcode;
    private Common.Instruction instruction;
    private int delaySlotOpcode;
    private Common.Instruction delaySlotInstruction;

    public Processor() {
        this.setLogger(this.log);
        this.cpu.initialize();
        this.reset();
    }

    protected void setLogger(Logger log) {
        this.log = log;
        this.cpu.setLogger(log);
    }

    public Logger getLogger() {
        return this.log;
    }

    public void setCpu(CpuState cpu) {
        this.cpu = cpu;
    }

    public void reset() {
        this.cpu.reset();
        this.cp0.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.cpu.read(stream);
        this.cp0.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        this.cpu.write(stream);
        this.cp0.write(stream);
    }

    public void interpret() {
        this.opcode = this.cpu.fetchOpcode();
        this.instruction = Decoder.instruction(this.opcode);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("Interpreting 0x%08X: [0x%08X] - %s", this.cpu.pc - 4, this.opcode, this.instruction.disasm(this.cpu.pc - 4, this.opcode)));
        }
        this.instruction.interpret(this, this.opcode);
        if (RuntimeContext.debugCodeBlockCalls) {
            if (this.instruction == Instructions.JAL && this.cp0.isMediaEngineCpu()) {
                RuntimeContext.debugCodeBlockStart(this.cpu, this.cpu.pc);
            } else if (this.instruction == Instructions.JR && (this.opcode >> 21 & 0x1F) == 31 && Memory.isAddressGood(this.cpu._ra)) {
                int opcodeCaller = this.cpu.memory.read32(this.cpu._ra - 8);
                Common.Instruction insnCaller = Decoder.instruction(opcodeCaller);
                int codeBlockStart = this.cpu.pc;
                if (insnCaller == Instructions.JAL) {
                    codeBlockStart = BcuState.jumpTarget(this.cpu.pc, opcodeCaller & 0x3FFFFFF);
                }
                RuntimeContext.debugCodeBlockEnd(this.cpu, codeBlockStart, this.cpu._ra);
            }
        }
    }

    public void interpretDelayslot() {
        this.delaySlotOpcode = this.cpu.nextOpcode();
        this.delaySlotInstruction = Decoder.instruction(this.delaySlotOpcode);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("Interpreting 0x%08X: [0x%08X] - %s", this.cpu.pc - 4, this.delaySlotOpcode, this.delaySlotInstruction.disasm(this.cpu.pc - 4, this.delaySlotOpcode)));
        }
        this.delaySlotInstruction.interpret(this, this.delaySlotOpcode);
        this.cpu.nextPc();
    }

    public boolean isInterruptsEnabled() {
        int status = this.cp0.getStatus();
        if (Utilities.hasFlag(status, 4)) {
            return false;
        }
        return !Utilities.notHasFlag(status, 1);
    }

    public boolean isInterruptsDisabled() {
        return !this.isInterruptsEnabled();
    }

    public void setInterruptsEnabled(boolean interruptsEnabled) {
        int status = this.cp0.getStatus();
        if (interruptsEnabled) {
            if (Utilities.notHasFlag(status, 1)) {
                this.cp0.setStatus(Utilities.setFlag(status, 1));
                IntrManager.getInstance().onInterruptsEnabled();
            }
        } else if (Utilities.hasFlag(status, 1)) {
            this.cp0.setStatus(Utilities.clearFlag(status, 1));
        }
    }

    public void enableInterrupts() {
        this.setInterruptsEnabled(true);
    }

    public void disableInterrupts() {
        this.setInterruptsEnabled(false);
    }

    public void step() {
        this.interpret();
    }

    public int getOpcode() {
        return this.opcode;
    }

    public Common.Instruction getInstruction() {
        return this.instruction;
    }

    public int getDelaySlotOpcode() {
        return this.delaySlotOpcode;
    }

    public Common.Instruction getDelaySlotInstruction() {
        return this.delaySlotInstruction;
    }

    public static boolean isDelaySlotInstruction(int instruction) {
        switch (instruction >> 26 & 0x3F) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
            case 0: {
                switch (instruction & 0x3F) {
                    case 8: 
                    case 9: {
                        return true;
                    }
                }
                break;
            }
            case 1: {
                switch (instruction >> 16 & 0x1F) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        return true;
                    }
                }
                break;
            }
            case 17: {
                switch (instruction >> 21 & 0x1F) {
                    case 8: {
                        switch (instruction >> 16 & 0x1F) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public static boolean isInstructionInDelaySlot(Memory memory, int address) {
        int previousInstruction = memory.read32(address - 4);
        return Processor.isDelaySlotInstruction(previousInstruction);
    }

    public void triggerReset() {
        int status = 0;
        status = Utilities.setFlag(status, 0x400000);
        status = Utilities.setFlag(status, 4);
        this.cp0.setStatus(status);
        this.cp0.setEbase(0);
        this.cpu.pc = -1077936128;
    }

    public String toString() {
        return "Main Processor";
    }
}

