/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.arm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jpcsp.arm.ARMDecoder;
import jpcsp.arm.ARMInstruction;
import jpcsp.arm.ARMInstructions;
import jpcsp.arm.ARMInterpreter;
import jpcsp.arm.ARMMemory;
import jpcsp.arm.IARMHLECall;
import jpcsp.hardware.Wlan;
import jpcsp.util.Utilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ARMDisassembler {
    private final Logger log;
    private final Level level;
    private final ARMMemory mem;
    private final ARMInterpreter interpreter;
    private final List<Integer> pendingFunctions = new LinkedList<Integer>();
    private final Set<Integer> disassembledFunctions = new HashSet<Integer>();
    private final Map<Integer, Integer> branchingTo = new HashMap<Integer, Integer>();
    private final Set<Integer> branchingTargets = new HashSet<Integer>();
    private final Map<Integer, String> labels = new HashMap<Integer, String>();
    private final Set<Integer> dataAddresses = new HashSet<Integer>();
    private int switchNumber;
    private static final String validStringCharacters = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz !\"$%&/()=?{[]}+*#',;.:-_@^<>|";

    public ARMDisassembler(Logger log, Level level, ARMMemory mem, ARMInterpreter interpreter) {
        this.log = log;
        this.level = level;
        this.mem = mem;
        this.interpreter = interpreter;
    }

    private void log(String s) {
        this.log.log((Priority)this.level, (Object)s);
    }

    private boolean isAlwaysCondition(int insn) {
        return insn >>> 28 == 14;
    }

    private int getJumpFromBranchOffset(int addr, int offset, boolean thumbMode) {
        return addr + offset + (thumbMode ? 5 : 8);
    }

    private int getRegister(int insn, int offset) {
        return insn >> offset & 0xF;
    }

    private String getRegisterName(int insn, int offset) {
        return ARMInstructions.getRegisterName(this.getRegister(insn, offset));
    }

    private int getThumbRegister(int insn, int offset) {
        return insn >> offset & 7;
    }

    private int getThumbHighRegister(int insn) {
        return insn & 7 | insn >> 4 & 8;
    }

    private String getThumbRegisterName(int insn, int offset) {
        return ARMInstructions.getRegisterName(this.getThumbRegister(insn, offset));
    }

    private void addJump(List<Integer> list, int addr, int jumpTo) {
        list.add(jumpTo);
        jumpTo = Utilities.clearBit(jumpTo, 0);
        this.branchingTo.put(addr, jumpTo);
        this.branchingTargets.add(jumpTo);
    }

    private void addJumpToFunction(int addr, int jumpTo) {
        this.pendingFunctions.add(jumpTo);
        jumpTo = Utilities.clearBit(jumpTo, 0);
        this.branchingTo.put(addr, jumpTo);
        this.branchingTargets.add(jumpTo);
    }

    private boolean isLdrFixedValue(ARMInstruction instr, int insn, boolean allowRead8) {
        return instr == ARMInstructions.LDR && Utilities.notHasFlag(insn, 0x2000000) && (Utilities.notHasFlag(insn, 0x400000) || allowRead8) && this.getRegister(insn, 16) == 15;
    }

    private boolean isLdrFixedValue(int insn, boolean allowRead8) {
        return this.isLdrFixedValue(ARMDecoder.instruction(insn), insn, allowRead8);
    }

    private int getLdrFixedValue(int insn, int base) {
        int ptr = base;
        if (Utilities.hasFlag(insn, 0x1000000)) {
            int offset = insn & 0xFFF;
            ptr = Utilities.hasFlag(insn, 0x800000) ? (ptr += offset) : (ptr -= offset);
        }
        int value = Utilities.hasFlag(insn, 0x400000) ? this.mem.internalRead8(ptr) : this.mem.internalRead32(ptr);
        return value;
    }

    private int getThumbLdrFixedValue(int insn, int base) {
        int value = this.mem.internalRead32(Utilities.clearBit(base, 1) + ((insn & 0xFF) << 2));
        return value;
    }

    private String getStringValue(int addr) {
        int c;
        StringBuilder s = new StringBuilder();
        while ((c = this.mem.internalRead8(addr++)) != 0) {
            s.append((char)c);
        }
        return s.toString();
    }

    private boolean isValidStringChar(int addr) {
        int c = this.mem.internalRead8(addr);
        return validStringCharacters.indexOf(c) >= 0;
    }

    private boolean isStringValue(int addr) {
        for (int i = 0; i < 4; ++i) {
            if (this.isValidStringChar(addr + i)) continue;
            return false;
        }
        return true;
    }

    private boolean isMACAddress(int addr) {
        byte[] macAddress = Wlan.getMacAddress();
        for (int i = 0; i < macAddress.length; ++i) {
            if (macAddress[i] == (byte)this.mem.internalRead8(addr)) continue;
            return false;
        }
        return true;
    }

    private boolean isEndOfBlock(int addr, int insn, ARMInstruction instr, boolean thumbMode) {
        if (instr == ARMInstructions.B_Thumb || instr == ARMInstructions.BX_Thumb) {
            return true;
        }
        if ((instr == ARMInstructions.B || instr == ARMInstructions.BX) && this.isAlwaysCondition(insn)) {
            return true;
        }
        if (instr == ARMInstructions.POP_Thumb && Utilities.hasFlag(insn, 256)) {
            return true;
        }
        if (instr == ARMInstructions.LDR && this.isAlwaysCondition(insn) && this.getRegister(insn, 12) == 15) {
            return true;
        }
        if (instr == ARMInstructions.BKPT || instr == ARMInstructions.BKPT_Thumb) {
            return true;
        }
        if (instr == ARMInstructions.MOV_High_Thumb && this.getThumbHighRegister(insn) == 15) {
            return true;
        }
        return instr == ARMInstructions.ADD_High_Thumb && this.getThumbHighRegister(insn) == 15;
    }

    private void checkBranch(List<Integer> pendingAddresses, int addr, int insn, ARMInstruction instr, boolean thumbMode) {
        int previousInsn;
        ARMInstruction previousInstr;
        if (instr == ARMInstructions.B) {
            int jumpTo = this.getJumpFromBranchOffset(addr, insn << 8 >> 6, thumbMode);
            this.addJump(pendingAddresses, addr, jumpTo);
        } else if (instr == ARMInstructions.BL) {
            int jumpTo = this.getJumpFromBranchOffset(addr, insn << 8 >> 6, thumbMode);
            this.addJumpToFunction(addr, jumpTo);
        } else if (this.isLdrFixedValue(instr, insn, false) && this.getRegister(insn, 12) == 15) {
            int jumpTo = this.getLdrFixedValue(insn, addr + 8);
            this.addJump(pendingAddresses, addr, jumpTo);
        } else if (instr == ARMInstructions.BX) {
            if (this.getRegister(insn, 0) == 15) {
                this.addJump(pendingAddresses, addr, addr + 8);
            } else {
                int previousInsn2 = this.mem.internalRead32(addr - 4);
                if (this.isLdrFixedValue(previousInsn2, false) && this.getRegister(insn, 0) == this.getRegister(previousInsn2, 12)) {
                    int jumpTo = this.getLdrFixedValue(previousInsn2, addr + 4);
                    this.addJump(pendingAddresses, addr, jumpTo);
                }
            }
        } else if (instr == ARMInstructions.BX_Thumb) {
            if (this.getRegister(insn, 3) == 15) {
                this.addJump(pendingAddresses, addr, addr + 4);
            } else {
                int previousInsn3 = this.mem.internalRead16(addr - 2);
                ARMInstruction previousInstr2 = ARMDecoder.thumbInstruction(previousInsn3);
                if (previousInstr2 == ARMInstructions.ADD_Rd_Pc_Thumb && this.getThumbRegister(insn, 3) == this.getThumbRegister(previousInsn3, 8)) {
                    int jumpTo = Utilities.clearFlag(addr + 4, 3) + ((previousInsn3 & 0xFF) << 2);
                    this.addJump(pendingAddresses, addr, jumpTo);
                }
            }
        } else if (instr == ARMInstructions.BL_11_Thumb || instr == ARMInstructions.BLX_01_Thumb) {
            int previousInsn4 = this.mem.internalRead16(addr - 2);
            ARMInstruction previousInstr3 = ARMDecoder.thumbInstruction(previousInsn4);
            if (previousInstr3 == ARMInstructions.BL_10_Thumb) {
                int offset1 = previousInsn4 << 21 >> 9;
                int offset2 = (insn & 0x7FF) << 1;
                int jumpTo = addr + 2 + offset1 + offset2;
                if (instr == ARMInstructions.BL_11_Thumb) {
                    jumpTo = Utilities.setBit(jumpTo, 0);
                } else if (instr == ARMInstructions.BLX_01_Thumb) {
                    jumpTo = Utilities.clearFlag(jumpTo, 3);
                }
                this.addJumpToFunction(addr, jumpTo);
            }
        } else if (instr == ARMInstructions.B_Thumb) {
            int jumpTo = this.getJumpFromBranchOffset(addr, insn << 21 >> 20, thumbMode);
            this.addJump(pendingAddresses, addr, jumpTo);
        } else if (instr == ARMInstructions.B_Cond_Thumb) {
            int jumpTo = this.getJumpFromBranchOffset(addr, insn << 24 >> 23, thumbMode);
            this.addJump(pendingAddresses, addr, jumpTo);
        } else if (instr == ARMInstructions.MOV_High_Thumb && this.getThumbHighRegister(insn) == 15 && (previousInstr = ARMDecoder.thumbInstruction(previousInsn = this.mem.internalRead16(addr - 2))) == ARMInstructions.LDR_Pc_Thumb && this.getThumbRegister(previousInsn, 8) == this.getRegister(insn, 3)) {
            int jumpTo = this.getThumbLdrFixedValue(previousInsn, addr + 2);
            this.addJump(pendingAddresses, addr, Utilities.setBit(jumpTo, 0));
        }
    }

    private String getAdditionalBranchInfo(int addr, boolean thumbMode) {
        ARMInstruction instr;
        int insn;
        if (thumbMode) {
            insn = this.mem.internalRead16(addr);
            instr = ARMDecoder.thumbInstruction(insn);
        } else {
            insn = this.mem.internalRead32(addr);
            instr = ARMDecoder.instruction(insn);
        }
        String additionalBranchInfo = "";
        if (instr == ARMInstructions.BKPT_Thumb) {
            IARMHLECall hleCall = this.interpreter.getHLECall(addr, insn & 0xFF);
            if (hleCall != null) {
                additionalBranchInfo = String.format(" (%s)", hleCall);
            }
        } else if (instr == ARMInstructions.BKPT) {
            IARMHLECall hleCall = this.interpreter.getHLECall(addr, insn >> 4 & 0xFFF0 | insn & 0xF);
            if (hleCall != null) {
                additionalBranchInfo = String.format(" (%s)", hleCall);
            }
        } else if (this.interpreter.hasHLECall(addr)) {
            IARMHLECall hleCall = this.interpreter.getHLECall(addr);
            additionalBranchInfo = String.format(" (%s)", hleCall);
        }
        return additionalBranchInfo;
    }

    private String getAdditionalBranchInfo(int addr) {
        return this.getAdditionalBranchInfo(addr, Utilities.hasBit(addr, 0));
    }

    private String getAdditionalValueInfo(int addr) {
        String additionalValueInfo = "";
        if (addr != 0 && ARMMemory.isAddressInRAM(addr)) {
            if (this.isStringValue(addr)) {
                additionalValueInfo = String.format(" (\"%s\")", this.getStringValue(addr));
            } else if (this.isMACAddress(addr)) {
                additionalValueInfo = String.format(" (MAC Address %02x:%02x:%02x:%02x:%02x)", this.mem.internalRead8(addr), this.mem.internalRead8(addr + 1), this.mem.internalRead8(addr + 2), this.mem.internalRead8(addr + 3), this.mem.internalRead8(addr + 4), this.mem.internalRead8(addr + 5));
            }
        }
        return additionalValueInfo;
    }

    private String getAdditionalInfo(int addr, int insn, ARMInstruction instr, boolean thumbMode) {
        int previousInsn;
        ARMInstruction previousInstr;
        String additionalInfo = null;
        if (this.isLdrFixedValue(instr, insn, true)) {
            int value = this.getLdrFixedValue(insn, addr + 8);
            additionalInfo = Utilities.hasFlag(insn, 0x400000) ? String.format(" <=> mov %s, #0x%02X", this.getRegisterName(insn, 12), value) : String.format(" <=> mov %s, #0x%08X%s", this.getRegisterName(insn, 12), value, this.getAdditionalValueInfo(value));
        } else if (instr == ARMInstructions.LDR_Pc_Thumb) {
            int value = this.getThumbLdrFixedValue(insn, addr + 4);
            additionalInfo = String.format(" <=> mov %s, #0x%08X%s", this.getThumbRegisterName(insn, 8), value, this.getAdditionalValueInfo(value));
        } else if (instr == ARMInstructions.BX) {
            if (this.getRegister(insn, 0) == 15) {
                additionalInfo = String.format(" <=> bx 0x%08X%s", addr + 8, this.getAdditionalBranchInfo(addr + 8));
            } else {
                int previousInsn2 = this.mem.internalRead32(addr - 4);
                if (this.isLdrFixedValue(previousInsn2, false) && this.getRegister(insn, 0) == this.getRegister(previousInsn2, 12)) {
                    int jumpTo = this.getLdrFixedValue(previousInsn2, addr + 4);
                    additionalInfo = String.format(" <=> bx 0x%08X%s", jumpTo, this.getAdditionalBranchInfo(jumpTo));
                }
            }
        } else if (instr == ARMInstructions.ADD && this.getRegister(insn, 16) == 15 && Utilities.hasFlag(insn, 0x2000000)) {
            int imm8 = insn & 0xFF;
            int immRot = insn >> 8 & 0xF;
            int value = Integer.rotateRight(imm8, immRot << 1);
            additionalInfo = String.format(" <=> movs %s, #0x%08X", this.getRegisterName(insn, 12), addr + 8 + value);
        } else if (instr == ARMInstructions.BX_Thumb) {
            if (this.getRegister(insn, 3) == 15) {
                additionalInfo = String.format(" <=> bx 0x%08X%s", addr + 4, this.getAdditionalBranchInfo(addr + 4));
            } else {
                int previousInsn3 = this.mem.internalRead16(addr - 2);
                ARMInstruction previousInstr2 = ARMDecoder.thumbInstruction(previousInsn3);
                if (previousInstr2 == ARMInstructions.ADD_Rd_Pc_Thumb && this.getThumbRegister(insn, 3) == this.getThumbRegister(previousInsn3, 8)) {
                    int jumpTo = Utilities.clearFlag(addr + 4, 3) + ((previousInsn3 & 0xFF) << 2);
                    additionalInfo = String.format(" <=> bx 0x%08X%s", jumpTo, this.getAdditionalBranchInfo(jumpTo));
                }
            }
        } else if (instr == ARMInstructions.BL_11_Thumb || instr == ARMInstructions.BLX_01_Thumb) {
            int previousInsn4 = this.mem.internalRead16(addr - 2);
            ARMInstruction previousInstr3 = ARMDecoder.thumbInstruction(previousInsn4);
            if (previousInstr3 == ARMInstructions.BL_10_Thumb) {
                int offset1 = previousInsn4 << 21 >> 9;
                int offset2 = (insn & 0x7FF) << 1;
                int jumpTo = addr + 2 + offset1 + offset2;
                if (instr == ARMInstructions.BLX_01_Thumb) {
                    jumpTo = Utilities.clearFlag(jumpTo, 3);
                }
                additionalInfo = String.format(" <=> bl%s 0x%08X%s", instr == ARMInstructions.BLX_01_Thumb ? "x" : "", jumpTo, this.getAdditionalBranchInfo(jumpTo, instr == ARMInstructions.BL_11_Thumb));
            }
        } else if (instr == ARMInstructions.BKPT_Thumb) {
            IARMHLECall hleCall = this.interpreter.getHLECall(addr, insn & 0xFF);
            if (hleCall != null) {
                additionalInfo = String.format(" <=> %s", hleCall);
            }
        } else if (instr == ARMInstructions.BKPT) {
            IARMHLECall hleCall = this.interpreter.getHLECall(addr, insn >> 4 & 0xFFF0 | insn & 0xF);
            if (hleCall != null) {
                additionalInfo = String.format(" <=> %s", hleCall);
            }
        } else if (instr == ARMInstructions.MOV_High_Thumb && this.getThumbHighRegister(insn) == 15 && (previousInstr = ARMDecoder.thumbInstruction(previousInsn = this.mem.internalRead16(addr - 2))) == ARMInstructions.LDR_Pc_Thumb && this.getThumbRegister(previousInsn, 8) == this.getRegister(insn, 3)) {
            int jumpTo = this.getThumbLdrFixedValue(previousInsn, addr + 2);
            additionalInfo = String.format(" <=> b 0x%08X%s", Utilities.clearBit(jumpTo, 0), this.getAdditionalBranchInfo(jumpTo, true));
        }
        return additionalInfo;
    }

    private boolean isSwitchStart(List<Integer> pendingAddresses, int addr, int insn, ARMInstruction instr, boolean thumbMode) {
        if (instr == ARMInstructions.ADD_High_Thumb && this.getThumbHighRegister(insn) == 15) {
            int registerJump = this.getRegister(insn, 3);
            int currentAddr = addr - 2;
            int insnLsl = this.mem.internalRead16(currentAddr);
            ARMInstruction instrLsl = ARMDecoder.thumbInstruction(insnLsl);
            int insnLdr = this.mem.internalRead16(currentAddr -= 2);
            ARMInstruction instrLdr = ARMDecoder.thumbInstruction(insnLdr);
            currentAddr -= 2;
            int insnAddBeforeLdrh = 0;
            ARMInstruction instrAddBeforeLdrh = null;
            if (instrLdr == ARMInstructions.LDRH_Reg_Thumb) {
                insnAddBeforeLdrh = this.mem.internalRead16(currentAddr);
                instrAddBeforeLdrh = ARMDecoder.thumbInstruction(insnAddBeforeLdrh);
                currentAddr -= 2;
            }
            int pcAdd = currentAddr;
            int insnAdd = this.mem.internalRead16(pcAdd);
            ARMInstruction instrAdd = ARMDecoder.thumbInstruction(insnAdd);
            int pcBranch = currentAddr -= 2;
            int insnBranch = this.mem.internalRead16(pcBranch);
            ARMInstruction instrBranch = ARMDecoder.thumbInstruction(insnBranch);
            currentAddr -= 2;
            int insnCmp = 0;
            ARMInstruction instrCmp = null;
            for (int i = 0; i < 5; ++i) {
                insnCmp = this.mem.internalRead16(currentAddr);
                instrCmp = ARMDecoder.thumbInstruction(insnCmp);
                currentAddr -= 2;
                if (instrCmp == ARMInstructions.CMP_Imm_Thumb) break;
            }
            int registerSwitchValue = this.getThumbRegister(insnCmp, 8);
            int insnAddSub = this.mem.internalRead16(currentAddr);
            ARMInstruction instrAddSub = ARMDecoder.thumbInstruction(insnAddSub);
            currentAddr -= 2;
            int switchStartValue = 0;
            if ((instrAddSub == ARMInstructions.SUB_Imm_Thumb || instrAddSub == ARMInstructions.ADD_Imm_Thumb) && this.getThumbRegister(insnAddSub, 8) == registerSwitchValue) {
                switchStartValue = insnAddSub & 0xFF;
                if (instrAddSub == ARMInstructions.ADD_Imm_Thumb) {
                    switchStartValue = -switchStartValue;
                }
            }
            if (instrLsl == ARMInstructions.LSL_Imm_Thumb && this.getThumbRegister(insnLsl, 0) == registerJump && this.getThumbRegister(insnLsl, 3) == registerJump && (instrLdr == ARMInstructions.LDRB_Reg_Thumb || instrLdr == ARMInstructions.LDRH_Reg_Thumb) && this.getThumbRegister(insnLdr, 0) == registerJump && this.getThumbRegister(insnLdr, 3) == registerJump && this.getThumbRegister(insnLdr, 6) == registerSwitchValue && (instrAddBeforeLdrh == null || instrAddBeforeLdrh == ARMInstructions.ADD_Reg_Thumb && this.getThumbRegister(insnAddBeforeLdrh, 0) == registerJump && this.getThumbRegister(insnAddBeforeLdrh, 3) == registerJump && this.getThumbRegister(insnAddBeforeLdrh, 6) == registerSwitchValue) && instrAdd == ARMInstructions.ADD_Rd_Pc_Thumb && this.getThumbRegister(insnAdd, 8) == registerJump && instrBranch == ARMInstructions.B_Cond_Thumb && (insnBranch >> 8 & 0xF) == 2 && instrCmp == ARMInstructions.CMP_Imm_Thumb && this.getThumbRegister(insnCmp, 8) == registerSwitchValue) {
                int switchTableAddr = pcAdd + 4 + ((insnAdd & 0xFF) << 2);
                int switchMaxValue = insnCmp & 0xFF;
                int jumpSize = instrLdr == ARMInstructions.LDRB_Reg_Thumb ? 1 : 2;
                int lslShift = insnLsl >> 6 & 0x1F;
                int defaultJumpTo = Utilities.clearBit(this.getJumpFromBranchOffset(pcBranch, insnBranch << 24 >> 23, thumbMode), 0);
                ++this.switchNumber;
                this.labels.put(addr, String.format("switch (%s) { // [0x%X..0x%X] Switch#%d", ARMInstructions.getRegisterName(registerSwitchValue), switchStartValue, switchStartValue + switchMaxValue - 1, this.switchNumber));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("Found switch instruction at 0x%08X", addr));
                    this.log.debug((Object)String.format("switch (%s) { // [0x%X..0x%X]", ARMInstructions.getRegisterName(registerSwitchValue), switchStartValue, switchStartValue + switchMaxValue - 1));
                }
                HashMap<Integer, LinkedList<Integer>> switches = new HashMap<Integer, LinkedList<Integer>>();
                int i = 0;
                int switchTableElementAddr = switchTableAddr;
                while (i < switchMaxValue) {
                    int switchTableElement = jumpSize == 1 ? this.mem.internalRead8(switchTableElementAddr) : this.mem.internalRead16(switchTableElementAddr);
                    int switchJumpTo = addr + 4 + (switchTableElement << lslShift);
                    this.dataAddresses.add(switchTableElementAddr);
                    if (switchJumpTo != defaultJumpTo) {
                        LinkedList<Integer> switchesAtAddress = (LinkedList<Integer>)switches.get(switchJumpTo);
                        if (switchesAtAddress == null) {
                            switchesAtAddress = new LinkedList<Integer>();
                            switches.put(switchJumpTo, switchesAtAddress);
                        }
                        switchesAtAddress.add(switchStartValue + i);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)String.format("    case 0x%X: 0x%08X", switchStartValue + i, switchJumpTo));
                        }
                    }
                    ++i;
                    switchTableElementAddr += jumpSize;
                }
                for (Integer switchJumpTo : switches.keySet()) {
                    StringBuilder values = new StringBuilder();
                    for (Integer switchValue : (List)switches.get(switchJumpTo)) {
                        if (values.length() > 0) {
                            values.append(", ");
                        }
                        values.append(String.format("0x%X", switchValue));
                    }
                    this.labels.put(switchJumpTo, String.format("case %s: // Switch#%d", values, this.switchNumber));
                    pendingAddresses.add(Utilities.setBit(switchJumpTo, 0));
                }
                this.labels.put(defaultJumpTo, String.format("default: // or end of switch for Switch#%d", this.switchNumber));
                pendingAddresses.add(Utilities.setBit(defaultJumpTo, 0));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("    default %s: 0x%08X", switchMaxValue < 16 ? "" : (switchMaxValue < 256 ? " " : "  "), defaultJumpTo));
                    this.log.debug((Object)String.format("} // end of switch", new Object[0]));
                }
            }
        }
        return false;
    }

    private void disasmFunction(int startAddress) {
        if (this.disassembledFunctions.contains(startAddress)) {
            return;
        }
        this.log(String.format("Disassembling Function 0x%08X", Utilities.clearBit(startAddress, 0)));
        TreeMap<Integer, String> disassembled = new TreeMap<Integer, String>();
        LinkedList<Integer> pendingAddresses = new LinkedList<Integer>();
        pendingAddresses.add(startAddress);
        this.switchNumber = 0;
        block0: while (!pendingAddresses.isEmpty()) {
            int pc = (Integer)pendingAddresses.remove(0);
            boolean thumbMode = Utilities.hasBit(pc, 0);
            pc = Utilities.clearBit(pc, 0);
            boolean endOfBlock = false;
            while (!endOfBlock && !disassembled.containsKey(pc)) {
                int nextPc;
                ARMInstruction instr;
                String insnString;
                int insn;
                if (this.dataAddresses.contains(pc)) {
                    disassembled.put(pc, String.format("0x%08X - data", pc));
                    continue block0;
                }
                if (!ARMMemory.isAddressGood(pc)) continue block0;
                if (thumbMode) {
                    insn = this.mem.internalRead16(pc);
                    insnString = String.format("%04X", insn);
                    instr = ARMDecoder.thumbInstruction(insn);
                    nextPc = pc + 2;
                } else {
                    insn = this.mem.internalRead32(pc);
                    insnString = String.format("%08X", insn);
                    instr = ARMDecoder.instruction(insn);
                    nextPc = pc + 4;
                }
                String additionalInfo = this.getAdditionalInfo(pc, insn, instr, thumbMode);
                String disasm = String.format("0x%08X - [0x%s] - %s%s", pc, insnString, instr.disasm(pc, insn), additionalInfo == null ? "" : additionalInfo);
                disassembled.put(pc, disasm);
                this.checkBranch(pendingAddresses, pc, insn, instr, thumbMode);
                this.isSwitchStart(pendingAddresses, pc, insn, instr, thumbMode);
                endOfBlock = this.isEndOfBlock(pc, insn, instr, thumbMode);
                pc = nextPc;
            }
        }
        for (Integer pc : disassembled.keySet()) {
            String label = this.labels.get(pc);
            if (label != null) {
                this.log(label);
            }
            char branchingTarget = this.branchingTargets.contains(pc) ? (char)'>' : ' ';
            Integer branchTo = this.branchingTo.get(pc);
            int branchingFlag = branchTo == null ? 32 : (!disassembled.containsKey(branchTo) ? 60 : (branchTo <= pc ? 94 : 118));
            this.log(String.format("%c%c %s", Character.valueOf((char)branchingFlag), Character.valueOf(branchingTarget), disassembled.get(pc)));
        }
        this.disassembledFunctions.add(startAddress);
    }

    private void disasmAll() {
        while (!this.pendingFunctions.isEmpty()) {
            int addr = this.pendingFunctions.remove(0);
            this.disasmFunction(addr);
        }
    }

    public boolean isAlreadyDisassembled(int addr) {
        return this.disassembledFunctions.contains(addr);
    }

    public void disasm(int addr) {
        this.pendingFunctions.add(addr);
        this.branchingTargets.add(Utilities.clearBit(addr, 0));
        this.disasmAll();
    }
}

