/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.arm;

import jpcsp.Allegrex.compiler.ICompilerContext;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.arm.ARMInstruction;
import jpcsp.arm.ARMProcessor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ARMInstructions {
    public static Logger log = ARMInstruction.log;
    private static final String[] conditionNames = new String[]{"eq", "ne", "cs", "cc", "mi", "pl", "vs", "vc", "hi", "ls", "ge", "lt", "gt", "le", "", ""};
    private static final String[] registerNames = new String[]{"r0", "r1", "r2", "r3", "r4", "r5", "r6", "r7", "r8", "r9", "r10", "fp", "ip", "sp", "lr", "pc"};
    private static final String[] cpRegisterNames = new String[]{"cr0", "cr1", "cr2", "cr3", "cr4", "cr5", "cr6", "cr7", "cr8", "cr9", "cr10", "cr11", "cr12", "cr13", "cr14", "cr15"};
    private static final String[] shiftTypeNames = new String[]{"lsl", "lsr", "asr", "rotr"};
    private static final String[] LDM_STM = new String[]{"da", "ia", "db", "ib"};
    public static final ARMInstruction UNK = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            log.error((Object)String.format("0x%08X %s", processor.getCurrentInstructionPc(), this.disasm(processor.getCurrentInstructionPc(), insn)));
            Emulator.PauseEmuWithStatus(32);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("Unknown instruction 0x%08X", insn);
        }
    };
    public static final ARMInstruction UNK_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            log.error((Object)String.format("0x%08X %s", processor.getCurrentInstructionPc(), this.disasm(processor.getCurrentInstructionPc(), insn)));
            Emulator.PauseEmuWithStatus(32);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("Unknown Thumb instruction 0x%04X", insn);
        }
    };
    public static final ARMInstruction B = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int offset = insn << 8 >> 6;
                processor.branch(offset);
                this.checkHLECall(processor);
                if (offset == -8) {
                    log.error((Object)"Pausing emulator - branch to self (death loop)");
                    Emulator.PauseEmuWithStatus(128);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("b%s 0x%08X", ARMInstructions.getConditionName(insn), address + 8 + (insn << 8 >> 6));
        }
    };
    public static final ARMInstruction BL = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                processor.branchWithLink(insn << 8 >> 6);
                this.checkHLECall(processor);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bl%s 0x%08X", ARMInstructions.getConditionName(insn), address + 8 + (insn << 8 >> 6));
        }
    };
    public static final ARMInstruction BLX_uncond = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            processor.branchWithLink((insn << 8 >> 6) + (insn >> 23 & 2));
            processor.setThumbMode();
            this.checkHLECall(processor);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("blx 0x%08X", address + 8 + (insn << 8 >> 6) + (insn >> 23 & 2));
        }
    };
    public static final ARMInstruction BX_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rm = insn >> 3 & 0xF;
            int addr = processor.getRegister(rm);
            processor.jumpWithMode(addr);
            this.checkHLECall(processor);
            if (RuntimeContext.debugCodeBlockCalls && log.isDebugEnabled()) {
                if (rm == 14) {
                    log.debug((Object)String.format("Returning from CodeBlock to 0x%08X, sp=0x%08X, r0=0x%08X", Utilities.clearBit(addr, 0), processor.getSp(), processor.getRegister(0)));
                } else if (rm == 0) {
                    log.debug((Object)String.format("Starting CodeBlock 0x%08X, lr=0x%08X, sp=0x%08X", addr, Utilities.clearBit(processor.getLr(), 0), processor.getSp()));
                } else if (rm == 1) {
                    log.debug((Object)String.format("Starting CodeBlock 0x%08X, r0=0x%08X, lr=0x%08X, sp=0x%08X", addr, processor.getRegister(0), Utilities.clearBit(processor.getLr(), 0), processor.getSp()));
                } else if (rm == 2) {
                    log.debug((Object)String.format("Starting CodeBlock 0x%08X, r0=0x%08X, r1=0x%08X, lr=0x%08X, sp=0x%08X", addr, processor.getRegister(0), processor.getRegister(1), Utilities.clearBit(processor.getLr(), 0), processor.getSp()));
                } else if (rm == 3) {
                    log.debug((Object)String.format("Starting CodeBlock 0x%08X, r0=0x%08X, r1=0x%08X, r2=0x%08X, lr=0x%08X, sp=0x%08X", addr, processor.getRegister(0), processor.getRegister(1), processor.getRegister(2), Utilities.clearBit(processor.getLr(), 0), processor.getSp()));
                } else {
                    log.debug((Object)String.format("Starting CodeBlock 0x%08X, r0=0x%08X, r1=0x%08X, r2=0x%08X, r3=0x%08X, lr=0x%08X, sp=0x%08X", addr, processor.getRegister(0), processor.getRegister(1), processor.getRegister(2), processor.getRegister(3), Utilities.clearBit(processor.getLr(), 0), processor.getSp()));
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bx %s", ARMInstructions.getRegisterName(insn >> 3));
        }
    };
    public static final ARMInstruction BLX_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rm = insn >> 3 & 0xF;
            int addr = processor.getRegister(rm);
            processor.linkWithThumb();
            processor.jumpWithMode(addr);
            this.checkHLECall(processor);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("blx %s", ARMInstructions.getRegisterName(insn >> 3));
        }
    };
    public static final ARMInstruction BL_10_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int offset = insn << 21 >> 9;
            processor.setLr(processor.getPc() + offset);
        }

        @Override
        public String disasm(int address, int insn) {
            int offset = insn << 21 >> 9;
            if (offset == 0) {
                return String.format("bl +0 (part 1)", new Object[0]);
            }
            if (offset < 0) {
                return String.format("bl -0x%03X000 (part 1)", -(offset >> 12));
            }
            return String.format("bl +0x%03X000 (part 1)", offset >> 12);
        }
    };
    public static final ARMInstruction BL_11_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int offset = insn & 0x7FF;
            int lr = processor.getLr();
            processor.linkWithThumb();
            int addr = lr + (offset << 1);
            processor.jump(addr);
            this.checkHLECall(processor);
            if (RuntimeContext.debugCodeBlockCalls && log.isDebugEnabled() && (processor.mem.internalRead16(addr) & 0xFF87) != 18176) {
                log.debug((Object)String.format("Starting CodeBlock 0x%08X, r0=0x%08X, r1=0x%08X, r2=0x%08X, r3=0x%08X, lr=0x%08X, sp=0x%08X", addr, processor.getRegister(0), processor.getRegister(1), processor.getRegister(2), processor.getRegister(3), Utilities.clearBit(processor.getLr(), 0), processor.getSp()));
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bl 0x%08X (part 2)", address + 2 + ((insn & 0x7FF) << 1));
        }
    };
    public static final ARMInstruction BLX_01_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int offset = insn & 0x7FF;
            int lr = processor.getLr();
            processor.linkWithThumb();
            int addr = Utilities.clearFlag(lr + (offset << 1), 3);
            processor.jump(addr);
            processor.setARMMode();
            this.checkHLECall(processor);
            if (RuntimeContext.debugCodeBlockCalls && log.isDebugEnabled()) {
                log.debug((Object)String.format("Starting CodeBlock 0x%08X, r0=0x%08X, r1=0x%08X, r2=0x%08X, r3=0x%08X, lr=0x%08X, sp=0x%08X", addr, processor.getRegister(0), processor.getRegister(1), processor.getRegister(2), processor.getRegister(3), Utilities.clearBit(processor.getLr(), 0), processor.getSp()));
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("blx 0x%08X (part 2)", address + 2 + ((insn & 0x7FF) << 1));
        }
    };
    public static final ARMInstruction MCR = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int cpOperation = insn >> 21 & 7;
                int cpRegNumber = insn >> 16 & 0xF;
                int rd = insn >> 12 & 0xF;
                int cpNumber = insn >> 8 & 0xF;
                int cpInformation = insn >> 5 & 7;
                int cpRegNumberOperand = insn & 0xF;
                int rdValue = processor.getRegister(rd);
                if (cpNumber == 15 && cpInformation == 0 && cpOperation == 0 && cpRegNumberOperand == 0) {
                    processor.setSystemControlCoprocessorRegister(cpRegNumber, rdValue);
                } else {
                    log.error((Object)String.format("Unimplemented mcr cpOperation=0x%X, cpRegNumber=%s, rd=%s(value=0x%08X), cpNumber=0x%X, cpInformation=0x%X, cpRegNumberOperand=%s", cpOperation, ARMInstructions.getCoprocessorRegisterName(cpRegNumber), ARMInstructions.getRegisterName(rd), rdValue, cpNumber, cpInformation, ARMInstructions.getCoprocessorRegisterName(cpRegNumberOperand)));
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mcr%s %d, %d, %s, %s, %s, {%d}", ARMInstructions.getConditionName(insn), insn >> 8 & 0xF, insn >> 5 & 7, ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getCoprocessorRegisterName(insn >> 16), ARMInstructions.getCoprocessorRegisterName(insn), insn >> 21 & 7);
        }
    };
    public static final ARMInstruction MRC = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int value;
                int cpOperation = insn >> 21 & 7;
                int cpRegNumber = insn >> 16 & 0xF;
                int rd = insn >> 12 & 0xF;
                int cpNumber = insn >> 8 & 0xF;
                int cpInformation = insn >> 5 & 7;
                int cpRegNumberOperand = insn & 0xF;
                if (cpNumber == 15 && cpInformation == 0 && cpOperation == 0 && cpRegNumberOperand == 0) {
                    value = processor.getSystemControlCoprocessorRegister(cpRegNumber);
                } else {
                    log.error((Object)String.format("Unimplemented mrc cpOperation=0x%X, cpRegNumber=%s, rd=%s, cpNumber=0x%X, cpInformation=0x%X, cpRegNumberOperand=%s", cpOperation, ARMInstructions.getCoprocessorRegisterName(cpRegNumber), ARMInstructions.getRegisterName(rd), cpNumber, cpInformation, ARMInstructions.getCoprocessorRegisterName(cpRegNumberOperand)));
                    value = 0;
                }
                processor.setRegister(rd, value);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mrc%s %d, %d, %s, %s, %s, {%d}", ARMInstructions.getConditionName(insn), insn >> 8 & 0xF, insn >> 5 & 7, ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getCoprocessorRegisterName(insn >> 16), ARMInstructions.getCoprocessorRegisterName(insn), insn >> 21 & 7);
        }
    };
    public static final ARMInstruction CDP = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int cpOperation = insn >> 21 & 7;
                int cpRegNumber = insn >> 16 & 0xF;
                int cpRegNumberDest = insn >> 12 & 0xF;
                int cpNumber = insn >> 8 & 0xF;
                int cpInformation = insn >> 5 & 7;
                int cpRegNumberOperand = insn & 0xF;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Unimplemented cdp cpOperation=0x%X, cpRegNumber=0x%X, cpRegNumberDest=0x%X, cpNumber=0x%X, cpInformation0x%X, cpRegNumberOperand=0x%X", cpOperation, cpRegNumber, cpRegNumberDest, cpNumber, cpInformation, cpRegNumberOperand, cpRegNumberOperand));
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cdp%s %d, %d, %s, %s, %s, {%d}", ARMInstructions.getConditionName(insn), insn >> 8 & 0xF, insn >> 5 & 7, ARMInstructions.getCoprocessorRegisterName(insn >> 12), ARMInstructions.getCoprocessorRegisterName(insn >> 16), ARMInstructions.getCoprocessorRegisterName(insn), insn >> 21 & 7);
        }
    };
    public static final ARMInstruction AND = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int rd = insn >> 12 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value1 & value2;
                processor.setRegister(rd, value);
                if (Utilities.hasFlag(insn, 0x100000)) {
                    processor.setCpsrResult(value, processor.shifterCarryOut);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("and%s %s, %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction EOR = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int rd = insn >> 12 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value1 ^ value2;
                processor.setRegister(rd, value);
                if (Utilities.hasFlag(insn, 0x100000)) {
                    processor.setCpsrResult(value, processor.shifterCarryOut);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("eor%s %s, %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction SUB = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int rd = insn >> 12 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value1 - value2;
                processor.setRegister(rd, value);
                if (Utilities.hasFlag(insn, 0x100000)) {
                    processor.setCpsrResult(value, ARMInstructions.getSubstractC(value1, value2, value), ARMInstructions.getSubstractV(value1, value2, value));
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sub%s%s %s, %s, %s", ARMInstructions.getConditionName(insn), Utilities.hasFlag(insn, 0x100000) ? "s" : "", ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction RSB = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int rd = insn >> 12 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value2 - value1;
                processor.setRegister(rd, value);
                if (Utilities.hasFlag(insn, 0x100000)) {
                    processor.setCpsrResult(value, ARMInstructions.getSubstractC(value2, value1, value), ARMInstructions.getSubstractV(value2, value1, value));
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("rsb%s %s, %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction ADD = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int rd = insn >> 12 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value1 + value2;
                processor.setRegister(rd, value);
                if (Utilities.hasFlag(insn, 0x100000)) {
                    processor.setCpsrResult(value, ARMInstructions.getAdditionC(value1, value2, value), ARMInstructions.getAdditionV(value1, value2, value));
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add%s %s, %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction ADC = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int rd = insn >> 12 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value1 + value2;
                if (processor.hasCflag()) {
                    ++value;
                }
                processor.setRegister(rd, value);
                if (Utilities.hasFlag(insn, 0x100000)) {
                    processor.setCpsrResult(value, ARMInstructions.getAdditionC(value1, value2, value), ARMInstructions.getAdditionV(value1, value2, value));
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("adc%s %s, %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction SBC = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int rd = insn >> 12 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value1 - value2;
                if (!processor.hasCflag()) {
                    --value;
                }
                processor.setRegister(rd, value);
                if (Utilities.hasFlag(insn, 0x100000)) {
                    processor.setCpsrResult(value, ARMInstructions.getSubstractC(value1, value2, value), ARMInstructions.getSubstractV(value1, value2, value));
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sbc%s %s, %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction RSC = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int rd = insn >> 12 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value2 - value1;
                if (!processor.hasCflag()) {
                    --value;
                }
                processor.setRegister(rd, value);
                if (Utilities.hasFlag(insn, 0x100000)) {
                    processor.setCpsrResult(value, ARMInstructions.getSubstractC(value2, value1, value), ARMInstructions.getSubstractV(value2, value1, value));
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("rsc%s %s, %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction TST = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value1 & value2;
                processor.setCpsrResult(value, processor.shifterCarryOut);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("tst%s %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction TEQ = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value1 ^ value2;
                processor.setCpsrResult(value, processor.shifterCarryOut);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("teq%s %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction CMP = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value1 - value2;
                processor.setCpsrResult(value, ARMInstructions.getSubstractC(value1, value2, value), ARMInstructions.getSubstractV(value1, value2, value));
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmp%s %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction CMN = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value1 + value2;
                processor.setCpsrResult(value, ARMInstructions.getAdditionC(value1, value2, value), ARMInstructions.getAdditionV(value1, value2, value));
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmn%s %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction ORR = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int rd = insn >> 12 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value1 | value2;
                processor.setRegister(rd, value);
                if (Utilities.hasFlag(insn, 0x100000)) {
                    processor.setCpsrResult(value, processor.shifterCarryOut);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("orr%s %s, %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction MOV = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int value2;
                int rd = insn >> 12 & 0xF;
                int value = value2 = ARMInstructions.getAddressingMode1(processor, insn);
                processor.setRegister(rd, value);
                if (Utilities.hasFlag(insn, 0x100000)) {
                    processor.setCpsrResult(value, processor.shifterCarryOut);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov%s%s %s, %s", ARMInstructions.getConditionName(insn), Utilities.hasFlag(insn, 0x100000) ? "s" : "", ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction BIC = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn >> 16 & 0xF;
                int rd = insn >> 12 & 0xF;
                int value1 = processor.getRegister(rn);
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = value1 & ~value2;
                processor.setRegister(rd, value);
                if (Utilities.hasFlag(insn, 0x100000)) {
                    processor.setCpsrResult(value, processor.shifterCarryOut);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bic%s %s, %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getRegisterName(insn >> 16), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction MVN = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rd = insn >> 12 & 0xF;
                int value2 = ARMInstructions.getAddressingMode1(processor, insn);
                int value = ~value2;
                processor.setRegister(rd, value);
                if (Utilities.hasFlag(insn, 0x100000)) {
                    processor.setCpsrResult(value, processor.shifterCarryOut);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mvn%s %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getAddressingMode1(insn));
        }
    };
    public static final ARMInstruction LDM = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int pre;
                int rn = insn >> 16 & 0xF;
                int addr = processor.getRegister(rn);
                int n = pre = Utilities.hasFlag(insn, 0x1000000) ? 4 : 0;
                if (Utilities.hasFlag(insn, 0x800000)) {
                    addr += pre;
                    for (int i = 0; i < 16; ++i) {
                        if (!Utilities.hasBit(insn, i)) continue;
                        int value = processor.mem.read32(addr);
                        processor.setRegister(i, value);
                        addr += 4;
                    }
                    addr -= pre;
                } else {
                    addr -= pre;
                    for (int i = 15; i >= 0; ++i) {
                        if (!Utilities.hasBit(insn, i)) continue;
                        int value = processor.mem.read32(addr);
                        processor.setRegister(i, value);
                        addr -= 4;
                    }
                    addr += pre;
                }
                if (Utilities.hasFlag(insn, 0x200000)) {
                    processor.setRegister(rn, addr);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ldm%s%s %s%s, {%s}", LDM_STM[insn >> 23 & 3], ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 16), Utilities.hasFlag(insn, 0x200000) ? "!" : "", ARMInstructions.getRegisterList(insn));
        }
    };
    public static final ARMInstruction STM = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int pre;
                int rn = insn >> 16 & 0xF;
                int addr = processor.getRegister(rn);
                int n = pre = Utilities.hasFlag(insn, 0x1000000) ? 4 : 0;
                if (Utilities.hasFlag(insn, 0x800000)) {
                    addr += pre;
                    for (int i = 0; i < 16; ++i) {
                        if (!Utilities.hasBit(insn, i)) continue;
                        int value = processor.getRegister(i);
                        processor.mem.write32(addr, value);
                        addr += 4;
                    }
                    addr -= pre;
                } else {
                    addr -= pre;
                    for (int i = 15; i >= 0; --i) {
                        if (!Utilities.hasBit(insn, i)) continue;
                        int value = processor.getRegister(i);
                        processor.mem.write32(addr, value);
                        addr -= 4;
                    }
                    addr += pre;
                }
                if (Utilities.hasFlag(insn, 0x200000)) {
                    processor.setRegister(rn, addr);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("stm%s%s %s%s, {%s}", LDM_STM[insn >> 23 & 3], ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 16), Utilities.hasFlag(insn, 0x200000) ? "!" : "", ARMInstructions.getRegisterList(insn));
        }
    };
    public static final ARMInstruction LDR = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rd = insn >> 12 & 0xF;
                int addr = ARMInstructions.getAddressingMode2(processor, insn);
                int value = Utilities.hasFlag(insn, 0x400000) ? processor.mem.read8(addr) : processor.mem.read32(addr);
                processor.setRegister(rd, value);
                if (rd == 15) {
                    this.checkHLECall(processor);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ldr%s%s%s %s, %s", Utilities.hasFlag(insn, 0x400000) ? "b" : "", Utilities.hasFlag(insn, 0x1000000) && Utilities.hasFlag(insn, 0x200000) ? "t" : "", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getAddressingMode2(insn));
        }
    };
    public static final ARMInstruction STR = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rd = insn >> 12 & 0xF;
                int addr = ARMInstructions.getAddressingMode2(processor, insn);
                int value = processor.getRegister(rd);
                if (Utilities.hasFlag(insn, 0x400000)) {
                    processor.mem.write8(addr, (byte)value);
                } else {
                    processor.mem.write32(addr, value);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("str%s%s%s %s, %s", Utilities.hasFlag(insn, 0x400000) ? "b" : "", Utilities.hasFlag(insn, 0x1000000) && Utilities.hasFlag(insn, 0x200000) ? "t" : "", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 12), ARMInstructions.getAddressingMode2(insn));
        }
    };
    public static final ARMInstruction BX = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rn = insn & 0xF;
                int addr = processor.getRegister(rn);
                processor.jumpWithMode(addr);
                this.checkHLECall(processor);
                if (RuntimeContext.debugCodeBlockCalls && log.isDebugEnabled() && rn == 14) {
                    log.debug((Object)String.format("Returning from CodeBlock to 0x%08X, sp=0x%08X, r0=0x%08X", Utilities.clearBit(addr, 0), processor.getSp(), processor.getRegister(0)));
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bx%s %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn));
        }
    };
    public static final ARMInstruction PUSH_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int sp = processor.getSp();
            if (Utilities.hasFlag(insn, 256)) {
                int value = processor.getLr();
                processor.mem.write32(sp -= 4, value);
            }
            for (int i = 7; i >= 0; --i) {
                if (!Utilities.hasBit(insn, i)) continue;
                int value = processor.getRegister(i);
                processor.mem.write32(sp -= 4, value);
            }
            processor.setSp(sp);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("push %s", ARMInstructions.getRegisterListThumb(insn, 256, 0));
        }
    };
    public static final ARMInstruction POP_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int sp = processor.getSp();
            for (int i = 0; i < 8; ++i) {
                if (!Utilities.hasBit(insn, i)) continue;
                int value = processor.mem.read32(sp);
                processor.setRegister(i, value);
                sp += 4;
            }
            if (Utilities.hasFlag(insn, 256)) {
                int addr = processor.mem.read32(sp);
                processor.jumpWithMode(addr);
                sp += 4;
                this.checkHLECall(processor);
                if (RuntimeContext.debugCodeBlockCalls && log.isDebugEnabled()) {
                    log.debug((Object)String.format("Returning from CodeBlock to 0x%08X, sp=0x%08X, r0=0x%08X", Utilities.clearBit(addr, 0), sp, processor.getRegister(0)));
                }
            }
            processor.setSp(sp);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("pop %s", ARMInstructions.getRegisterListThumb(insn, 0, 256));
        }
    };
    public static final ARMInstruction ADD_Reg_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int imm3 = insn >> 6 & 7;
            int value1 = processor.getRegister(rn);
            int value2 = imm3;
            int value = value1 + value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value, ARMInstructions.getAdditionC(value1, value2, value), ARMInstructions.getAdditionV(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            int imm3 = insn >> 6 & 7;
            if (imm3 == 0) {
                return String.format("mov %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
            }
            return String.format("add %s, %s, #%d", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), imm3);
        }
    };
    public static final ARMInstruction SUB_Reg_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int imm3 = insn >> 6 & 7;
            int value1 = processor.getRegister(rn);
            int value2 = imm3;
            int value = value1 - value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value, ARMInstructions.getAdditionC(value1, value2, value), ARMInstructions.getAdditionV(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            int imm3 = insn >> 6 & 7;
            if (imm3 == 0) {
                return String.format("mov %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
            }
            return String.format("sub %s, %s, #%d", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), imm3);
        }
    };
    public static final ARMInstruction ADD_Reg_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int rm = insn >> 6 & 7;
            int value1 = processor.getRegister(rn);
            int value2 = processor.getRegister(rm);
            int value = value1 + value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value, ARMInstructions.getAdditionC(value1, value2, value), ARMInstructions.getAdditionV(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), ARMInstructions.getRegisterName(insn >> 6 & 7));
        }
    };
    public static final ARMInstruction SUB_Reg_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int rm = insn >> 6 & 7;
            int value1 = processor.getRegister(rn);
            int value2 = processor.getRegister(rm);
            int value = value1 - value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value, ARMInstructions.getSubstractC(value1, value2, value), ARMInstructions.getSubstractV(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sub %s, %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), ARMInstructions.getRegisterName(insn >> 6 & 7));
        }
    };
    public static final ARMInstruction ADD_Sp_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int imm7 = insn & 0x7F;
            int sp = processor.getSp();
            processor.setSp(sp + (imm7 << 2));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, %s, #0x%X", ARMInstructions.getRegisterName(13), ARMInstructions.getRegisterName(13), (insn & 0x7F) << 2);
        }
    };
    public static final ARMInstruction SUB_Sp_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int imm7 = insn & 0x7F;
            int sp = processor.getSp();
            processor.setSp(sp - (imm7 << 2));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sub %s, %s, #0x%X", ARMInstructions.getRegisterName(13), ARMInstructions.getRegisterName(13), (insn & 0x7F) << 2);
        }
    };
    public static final ARMInstruction LDR_Stack_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int imm8 = insn & 0xFF;
            int rd = insn >> 8 & 7;
            int sp = processor.getSp();
            int addr = sp + (imm8 << 2);
            int value = processor.mem.read32(addr);
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ldr %s, [%s, #0x%X]", ARMInstructions.getRegisterName(insn >> 8 & 7), ARMInstructions.getRegisterName(13), (insn & 0xFF) << 2);
        }
    };
    public static final ARMInstruction STR_Stack_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int imm8 = insn & 0xFF;
            int rd = insn >> 8 & 7;
            int sp = processor.getSp();
            int addr = sp + (imm8 << 2);
            int value = processor.getRegister(rd);
            processor.mem.write32(addr, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("str %s, [%s, #0x%X]", ARMInstructions.getRegisterName(insn >> 8 & 7), ARMInstructions.getRegisterName(13), (insn & 0xFF) << 2);
        }
    };
    public static final ARMInstruction MOV_Immediate_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int imm8 = insn & 0xFF;
            int rd = insn >> 8 & 7;
            int value = imm8;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, #0x%X", ARMInstructions.getRegisterName(insn >> 8 & 7), insn & 0xFF);
        }
    };
    public static final ARMInstruction LDR_Pc_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int imm8 = insn & 0xFF;
            int rd = insn >> 8 & 7;
            int pc = processor.getPc();
            int addr = Utilities.clearBit(pc, 1) + (imm8 << 2);
            int value = processor.mem.read32(addr);
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ldr %s, [%s, #0x%X]", ARMInstructions.getRegisterName(insn >> 8 & 7), ARMInstructions.getRegisterName(15), (insn & 0xFF) << 2);
        }
    };
    public static final ARMInstruction LDR_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int imm5 = insn >> 6 & 0x1F;
            int addr = processor.getRegister(rn) + (imm5 << 2);
            int value = processor.mem.read32(addr);
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ldr %s, [%s, #0x%X]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), (insn >> 6 & 0x1F) << 2);
        }
    };
    public static final ARMInstruction STR_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int imm5 = insn >> 6 & 0x1F;
            int addr = processor.getRegister(rn) + (imm5 << 2);
            int value = processor.getRegister(rd);
            processor.mem.write32(addr, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("str %s, [%s, #0x%X]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), (insn >> 6 & 0x1F) << 2);
        }
    };
    public static final ARMInstruction MOV_High_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7 | insn >> 4 & 8;
            int rm = insn >> 3 & 0xF;
            int value = processor.getRegister(rm);
            if (rd == 15) {
                value = Utilities.clearBit(value, 0);
            }
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mov %s, %s", ARMInstructions.getRegisterName(insn & 7 | insn >> 4 & 8), ARMInstructions.getRegisterName(insn >> 3));
        }
    };
    public static final ARMInstruction ADD_High_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7 | insn >> 4 & 8;
            int rm = insn >> 3 & 0xF;
            int value = processor.getRegister(rm) + processor.getRegister(rd);
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, %s", ARMInstructions.getRegisterName(insn & 7 | insn >> 4 & 8), ARMInstructions.getRegisterName(insn >> 3));
        }
    };
    public static final ARMInstruction ADD_Rd_Sp_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int imm8 = insn & 0xFF;
            int rd = insn >> 8 & 7;
            int sp = processor.getSp();
            int value = sp + (imm8 << 2);
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, %s, #0x%X", ARMInstructions.getRegisterName(insn >> 8 & 7), ARMInstructions.getRegisterName(13), (insn & 0xFF) << 2);
        }
    };
    public static final ARMInstruction ADD_Rd_Pc_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int imm8 = insn & 0xFF;
            int rd = insn >> 8 & 7;
            int pc = processor.getPc();
            int value = Utilities.clearFlag(pc, 3) + (imm8 << 2);
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, %s, #0x%X", ARMInstructions.getRegisterName(insn >> 8 & 7), ARMInstructions.getRegisterName(15), (insn & 0xFF) << 2);
        }
    };
    public static final ARMInstruction LDM_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn >> 8 & 7;
            int addr = processor.getRegister(rd);
            for (int i = 0; i < 8; ++i) {
                if (!Utilities.hasBit(insn, i)) continue;
                int value = processor.mem.read32(addr);
                processor.setRegister(i, value);
                addr += 4;
            }
            if (Utilities.notHasBit(insn, rd)) {
                processor.setRegister(rd, addr);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ldm%s %s!, %s", LDM_STM[1], ARMInstructions.getRegisterName(insn >> 8 & 7), ARMInstructions.getRegisterListThumb(insn, 0, 0));
        }
    };
    public static final ARMInstruction STM_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn >> 8 & 7;
            int addr = processor.getRegister(rd);
            for (int i = 0; i < 8; ++i) {
                if (!Utilities.hasBit(insn, i)) continue;
                int value = processor.getRegister(i);
                processor.mem.write32(addr, value);
                addr += 4;
            }
            processor.setRegister(rd, addr);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("stm%s %s!, %s", LDM_STM[1], ARMInstructions.getRegisterName(insn >> 8 & 7), ARMInstructions.getRegisterListThumb(insn, 0, 0));
        }
    };
    public static final ARMInstruction CMP_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int imm8 = insn & 0xFF;
            int rn = insn >> 8 & 7;
            int value1 = processor.getRegister(rn);
            int value2 = imm8;
            int value = value1 - value2;
            processor.setCpsrResult(value, ARMInstructions.getSubstractC(value1, value2, value), ARMInstructions.getSubstractV(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmp %s, #0x%X", ARMInstructions.getRegisterName(insn >> 8 & 7), insn & 0xFF);
        }
    };
    public static final ARMInstruction B_Cond_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int cond = insn >> 8 & 0xF;
            if (processor.isConditionCode(cond)) {
                if (insn == 54013 && processor.mem.internalRead16(processor.getCurrentInstructionPc() - 2) == 14337) {
                    processor.interpreter.delayHLE(processor.getRegister(0));
                    processor.setRegister(0, -1);
                } else {
                    processor.branch(insn << 24 >> 23);
                }
                this.checkHLECall(processor);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("b%s 0x%08X", conditionNames[insn >> 8 & 0xF], address + 4 + (insn << 24 >> 23));
        }
    };
    public static final ARMInstruction B_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            processor.branch(insn << 21 >> 20);
            this.checkHLECall(processor);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("b 0x%08X", address + 4 + (insn << 21 >> 20));
        }
    };
    public static final ARMInstruction LDRB_Reg_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int rm = insn >> 6 & 7;
            int addr = processor.getRegister(rn) + processor.getRegister(rm);
            int value = processor.mem.read8(addr);
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ldrb %s, [%s, %s]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), ARMInstructions.getRegisterName(insn >> 6 & 7));
        }
    };
    public static final ARMInstruction STRB_Reg_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int rm = insn >> 6 & 7;
            int addr = processor.getRegister(rn) + processor.getRegister(rm);
            int value = processor.getRegister(rd);
            processor.mem.write8(addr, (byte)value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("strb %s, [%s, %s]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), ARMInstructions.getRegisterName(insn >> 6 & 7));
        }
    };
    public static final ARMInstruction LDRSB_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int rm = insn >> 6 & 7;
            int addr = processor.getRegister(rn) + processor.getRegister(rm);
            byte value = (byte)processor.mem.read8(addr);
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ldrsb %s, [%s, %s]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), ARMInstructions.getRegisterName(insn >> 6 & 7));
        }
    };
    public static final ARMInstruction LDRH_Reg_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int rm = insn >> 6 & 7;
            int addr = processor.getRegister(rn) + processor.getRegister(rm);
            int value = processor.mem.read16(addr);
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ldrh %s, [%s, %s]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), ARMInstructions.getRegisterName(insn >> 6 & 7));
        }
    };
    public static final ARMInstruction LDRSH_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int rm = insn >> 6 & 7;
            int addr = processor.getRegister(rn) + processor.getRegister(rm);
            short value = (short)processor.mem.read16(addr);
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ldrsh %s, [%s, %s]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), ARMInstructions.getRegisterName(insn >> 6 & 7));
        }
    };
    public static final ARMInstruction STRH_Reg_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int rm = insn >> 6 & 7;
            int addr = processor.getRegister(rn) + processor.getRegister(rm);
            int value = processor.getRegister(rd);
            processor.mem.write16(addr, (short)value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("strh %s, [%s, %s]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), ARMInstructions.getRegisterName(insn >> 6 & 7));
        }
    };
    public static final ARMInstruction LDRB_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int imm5 = insn >> 6 & 0x1F;
            int addr = processor.getRegister(rn) + imm5;
            int value = processor.mem.read8(addr);
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ldrb %s, [%s, #0x%X]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), insn >> 6 & 0x1F);
        }
    };
    public static final ARMInstruction STRB_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int imm5 = insn >> 6 & 0x1F;
            int addr = processor.getRegister(rn) + imm5;
            int value = processor.getRegister(rd);
            processor.mem.write8(addr, (byte)value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("strb %s, [%s, #0x%X]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), insn >> 6 & 0x1F);
        }
    };
    public static final ARMInstruction LDRH_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int imm5 = insn >> 6 & 0x1F;
            int addr = processor.getRegister(rn) + (imm5 << 1);
            int value = processor.mem.read16(addr);
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ldrh %s, [%s, #0x%X]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), (insn >> 6 & 0x1F) << 1);
        }
    };
    public static final ARMInstruction STRH_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int imm5 = insn >> 6 & 0x1F;
            int addr = processor.getRegister(rn) + (imm5 << 1);
            int value = processor.getRegister(rd);
            processor.mem.write16(addr, (short)value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("strh %s, [%s, #0x%X]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), (insn >> 6 & 0x1F) << 1);
        }
    };
    public static final ARMInstruction LSL_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rm = insn >> 3 & 7;
            int imm5 = insn >> 6 & 0x1F;
            int rmValue = processor.getRegister(rm);
            if (imm5 == 0) {
                int value = rmValue;
                processor.setRegister(rd, value);
                processor.setCpsrResult(value);
            } else {
                int value = rmValue << imm5;
                processor.setRegister(rd, value);
                processor.setCpsrResult(value, rmValue << imm5 - 1 < 0);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            int imm5 = insn >> 6 & 0x1F;
            if (imm5 == 0) {
                return String.format("mov %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
            }
            return String.format("lsl %s, %s, #0x%X", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), imm5);
        }
    };
    public static final ARMInstruction LSR_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rm = insn >> 3 & 7;
            int imm5 = insn >> 6 & 0x1F;
            int rmValue = processor.getRegister(rm);
            int rdValue = processor.getRegister(rd);
            int shift = imm5 == 0 ? 32 : imm5;
            int value = rmValue >>> shift;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value, Utilities.hasFlag(rdValue >>> shift - 1, 1));
        }

        @Override
        public String disasm(int address, int insn) {
            int imm5 = insn >> 6 & 0x1F;
            return String.format("lsr %s, %s, #0x%X", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), imm5 == 0 ? 32 : imm5);
        }
    };
    public static final ARMInstruction LDR_Reg_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int rm = insn >> 6 & 7;
            int addr = processor.getRegister(rn) + processor.getRegister(rm);
            int value = processor.mem.read32(addr);
            processor.setRegister(rd, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ldr %s, [%s, %s]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), ARMInstructions.getRegisterName(insn >> 6 & 7));
        }
    };
    public static final ARMInstruction STR_Reg_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rn = insn >> 3 & 7;
            int rm = insn >> 6 & 7;
            int addr = processor.getRegister(rn) + processor.getRegister(rm);
            int value = processor.getRegister(rd);
            processor.mem.write32(addr, value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("str %s, [%s, %s]", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), ARMInstructions.getRegisterName(insn >> 6 & 7));
        }
    };
    public static final ARMInstruction ADD_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn >> 8 & 7;
            int imm8 = insn & 0xFF;
            int value1 = processor.getRegister(rd);
            int value2 = imm8;
            int value = value1 + value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value, ARMInstructions.getAdditionC(value1, value2, value), ARMInstructions.getAdditionV(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("add %s, #0x%X", ARMInstructions.getRegisterName(insn >> 8 & 7), insn & 0xFF);
        }
    };
    public static final ARMInstruction SUB_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn >> 8 & 7;
            int imm8 = insn & 0xFF;
            int value1 = processor.getRegister(rd);
            int value2 = imm8;
            int value = value1 - value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value, ARMInstructions.getSubstractC(value1, value2, value), ARMInstructions.getSubstractV(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sub %s, #0x%X", ARMInstructions.getRegisterName(insn >> 8 & 7), insn & 0xFF);
        }
    };
    public static final ARMInstruction CMN_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rn = insn & 7;
            int rm = insn >> 3 & 7;
            int value1 = processor.getRegister(rn);
            int value2 = processor.getRegister(rm);
            int value = value1 + value2;
            processor.setCpsrResult(value, ARMInstructions.getAdditionC(value1, value2, value), ARMInstructions.getAdditionV(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmn %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction MUL_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rm = insn >> 3 & 7;
            int value1 = processor.getRegister(rd);
            int value2 = processor.getRegister(rm);
            int value = value1 * value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mul %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction CMP_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rn = insn & 7;
            int rm = insn >> 3 & 7;
            int value1 = processor.getRegister(rn);
            int value2 = processor.getRegister(rm);
            int value = value1 - value2;
            processor.setCpsrResult(value, ARMInstructions.getSubstractC(value1, value2, value), ARMInstructions.getSubstractV(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmp %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction CMP_High_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rn = insn & 7 | insn >> 4 & 8;
            int rm = insn >> 3 & 0xF;
            int value1 = processor.getRegister(rn);
            int value2 = processor.getRegister(rm);
            int value = value1 - value2;
            processor.setCpsrResult(value, ARMInstructions.getSubstractC(value1, value2, value), ARMInstructions.getSubstractV(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("cmp %s, %s", ARMInstructions.getRegisterName(insn & 7 | insn >> 4 & 8), ARMInstructions.getRegisterName(insn >> 3));
        }
    };
    public static final ARMInstruction AND_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rm = insn >> 3 & 7;
            int value1 = processor.getRegister(rd);
            int value2 = processor.getRegister(rm);
            int value = value1 & value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("and %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction EOR_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rm = insn >> 3 & 7;
            int value1 = processor.getRegister(rd);
            int value2 = processor.getRegister(rm);
            int value = value1 ^ value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("eor %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction LSL_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rs = insn >> 3 & 7;
            int value1 = processor.getRegister(rd);
            int value2 = processor.getRegister(rs) & 0xFF;
            if (value2 == 0) {
                processor.setCpsrResult(value1);
            } else {
                int value = value1 << value2;
                processor.setRegister(rd, value);
                processor.setCpsrResult(value, value1 << value2 - 1 < 0);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("lsl %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction LSR_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rs = insn >> 3 & 7;
            int value1 = processor.getRegister(rd);
            int value2 = processor.getRegister(rs) & 0xFF;
            if (value2 == 0) {
                processor.setCpsrResult(value1);
            } else {
                int value = value1 >>> value2;
                processor.setRegister(rd, value);
                processor.setCpsrResult(value, Utilities.hasFlag(value1 >>> value2 - 1, 1));
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("lsr %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction ASR_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rs = insn >> 3 & 7;
            int value1 = processor.getRegister(rd);
            int value2 = processor.getRegister(rs) & 0xFF;
            if (value2 == 0) {
                processor.setCpsrResult(value1);
            } else {
                int value = value1 >> value2;
                processor.setRegister(rd, value);
                processor.setCpsrResult(value, Utilities.hasFlag(value1 >> value2 - 1, 1));
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("asr %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction ASR_Imm_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rm = insn >> 3 & 7;
            int imm5 = insn >> 6 & 0x1F;
            int value1 = processor.getRegister(rm);
            int value2 = imm5 == 0 ? 32 : imm5;
            int value = value1 >> value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value, Utilities.hasFlag(value1 >> value2 - 1, 1));
        }

        @Override
        public String disasm(int address, int insn) {
            int imm5 = insn >> 6 & 0x1F;
            return String.format("asr %s, %s, #0x%X", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7), imm5 == 0 ? 32 : imm5);
        }
    };
    public static final ARMInstruction ORR_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rm = insn >> 3 & 7;
            int value1 = processor.getRegister(rd);
            int value2 = processor.getRegister(rm);
            int value = value1 | value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("orr %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction ADC_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rm = insn >> 3 & 7;
            int value1 = processor.getRegister(rd);
            int value2 = processor.getRegister(rm);
            int value = value1 + value2;
            if (processor.hasCflag()) {
                ++value;
            }
            processor.setRegister(rd, value);
            processor.setCpsrResult(value, ARMInstructions.getAdditionC(value1, value2, value), ARMInstructions.getAdditionV(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("adc %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction SBC_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rm = insn >> 3 & 7;
            int value1 = processor.getRegister(rd);
            int value2 = processor.getRegister(rm);
            int value = value1 - value2;
            if (!processor.hasCflag()) {
                --value;
            }
            processor.setRegister(rd, value);
            processor.setCpsrResult(value, ARMInstructions.getSubstractC(value1, value2, value), ARMInstructions.getSubstractV(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("sbc %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction ROR_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rs = insn >> 3 & 7;
            int value1 = processor.getRegister(rd);
            int value2 = processor.getRegister(rs) & 0xFF;
            if (value2 == 0) {
                processor.setCpsrResult(value1);
            } else {
                int value = Integer.rotateRight(value1, value2);
                processor.setRegister(rd, value);
                processor.setCpsrResult(value, Utilities.hasFlag(Integer.rotateRight(value1, value2 - 1), 1));
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("ror %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction TST_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rm = insn >> 3 & 7;
            int value1 = processor.getRegister(rd);
            int value2 = processor.getRegister(rm);
            int value = value1 & value2;
            processor.setCpsrResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("tst %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction NEG_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rm = insn >> 3 & 7;
            int value1 = 0;
            int value2 = processor.getRegister(rm);
            int value = value1 - value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value, ARMInstructions.getSubstractC(value1, value2, value), ARMInstructions.getSubstractV(value1, value2, value));
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("neg %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction BIC_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rm = insn >> 3 & 7;
            int value1 = processor.getRegister(rd);
            int value2 = processor.getRegister(rm);
            int value = value1 & ~value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bic %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction MVN_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int rd = insn & 7;
            int rm = insn >> 3 & 7;
            int value2 = processor.getRegister(rm);
            int value = ~value2;
            processor.setRegister(rd, value);
            processor.setCpsrResult(value);
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mvn %s, %s", ARMInstructions.getRegisterName(insn & 7), ARMInstructions.getRegisterName(insn >> 3 & 7));
        }
    };
    public static final ARMInstruction SWI = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            processor.softwareInterruptException();
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("swi 0x%06X", insn & 0xFFFFFF);
        }
    };
    public static final ARMInstruction SWI_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            processor.softwareInterruptException();
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("swi 0x%02X", insn & 0xFF);
        }
    };
    public static final ARMInstruction MSR = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int operand;
                if (Utilities.hasFlag(insn, 0x2000000)) {
                    int imm8 = insn & 0xFF;
                    int rotateImm = insn >> 8 & 0xF;
                    operand = Integer.rotateRight(imm8, rotateImm << 1);
                } else {
                    int rm = insn & 0xF;
                    operand = processor.getRegister(rm);
                }
                if (Utilities.hasFlag(insn, 0x400000)) {
                    if (processor.currentModeHasSpsr()) {
                        int spsr = processor.getSpsr();
                        if (Utilities.hasFlag(insn, 65536)) {
                            spsr = Utilities.setFlag(spsr, operand, 255);
                        }
                        if (Utilities.hasFlag(insn, 131072)) {
                            spsr = Utilities.setFlag(spsr, operand, 65280);
                        }
                        if (Utilities.hasFlag(insn, 262144)) {
                            spsr = Utilities.setFlag(spsr, operand, 0xFF0000);
                        }
                        if (Utilities.hasFlag(insn, 524288)) {
                            spsr = Utilities.setFlag(spsr, operand, -16777216);
                        }
                        processor.setSpsr(spsr);
                    }
                } else {
                    int cpsr = processor.getCpsr();
                    if (processor.inAPrivilegeMode()) {
                        if (Utilities.hasFlag(insn, 65536)) {
                            cpsr = Utilities.setFlag(cpsr, operand, 255);
                        }
                        if (Utilities.hasFlag(insn, 131072)) {
                            cpsr = Utilities.setFlag(cpsr, operand, 65280);
                        }
                        if (Utilities.hasFlag(insn, 262144)) {
                            cpsr = Utilities.setFlag(cpsr, operand, 0xFF0000);
                        }
                    }
                    if (Utilities.hasFlag(insn, 524288)) {
                        cpsr = Utilities.setFlag(cpsr, operand, -16777216);
                    }
                    processor.setCpsr(cpsr);
                }
            }
        }

        @Override
        public String disasm(int address, int insn) {
            StringBuilder fields = new StringBuilder();
            if (Utilities.hasFlag(insn, 0x400000)) {
                fields.append("SPSR_");
            } else {
                fields.append("CPSR_");
            }
            if (Utilities.hasFlag(insn, 65536)) {
                fields.append('c');
            }
            if (Utilities.hasFlag(insn, 131072)) {
                fields.append('x');
            }
            if (Utilities.hasFlag(insn, 262144)) {
                fields.append('s');
            }
            if (Utilities.hasFlag(insn, 524288)) {
                fields.append('f');
            }
            StringBuilder operand = new StringBuilder();
            if (Utilities.hasFlag(insn, 0x2000000)) {
                int imm8 = insn & 0xFF;
                int rotateImm = insn >> 8 & 0xF;
                int value = Integer.rotateRight(imm8, rotateImm << 1);
                operand.append(String.format("#0x%X", value));
            } else {
                operand.append(ARMInstructions.getRegisterName(insn));
            }
            return String.format("msr%s %s, %s", ARMInstructions.getConditionName(insn), fields, operand);
        }
    };
    public static final ARMInstruction MRS = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            if (processor.isCondition(insn)) {
                int rd = insn >> 12 & 0xF;
                int value = Utilities.hasFlag(insn, 0x400000) ? processor.getSpsr() : processor.getCpsr();
                processor.setRegister(rd, value);
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("mrs%s %s, %s", ARMInstructions.getConditionName(insn), ARMInstructions.getRegisterName(insn >> 12), Utilities.hasFlag(insn, 0x400000) ? "SPSR" : "CPSR");
        }
    };
    public static final ARMInstruction BKPT = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int imm16 = insn >> 4 & 0xFFF0 | insn & 0xF;
            if (!processor.interpreter.interpretHLE(processor.getCurrentInstructionPc(), imm16)) {
                processor.prefetchAbortException();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bkpt 0x%X", insn >> 4 & 0xFFF0 | insn & 0xF);
        }
    };
    public static final ARMInstruction BKPT_Thumb = new ARMInstruction(){

        @Override
        public void interpret(ARMProcessor processor, int insn) {
            int imm8 = insn & 0xFF;
            if (!processor.interpreter.interpretHLE(processor.getCurrentInstructionPc(), imm8)) {
                processor.prefetchAbortException();
            }
        }

        @Override
        public String disasm(int address, int insn) {
            return String.format("bkpt 0x%X", insn & 0xFF);
        }
    };

    private static final String getConditionName(int insn) {
        return conditionNames[insn >>> 28];
    }

    public static final String getRegisterName(int reg) {
        return registerNames[reg & 0xF];
    }

    private static final void appendRegister(StringBuilder s, int reg) {
        if (s.length() > 0) {
            s.append(", ");
        }
        s.append(ARMInstructions.getRegisterName(reg));
    }

    private static final String getRegisterList(int insn) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            if (!Utilities.hasBit(insn, i)) continue;
            ARMInstructions.appendRegister(s, i);
        }
        return s.toString();
    }

    private static final String getRegisterListThumb(int insn, int lrFlag, int pcFlag) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            if (!Utilities.hasBit(insn, i)) continue;
            ARMInstructions.appendRegister(s, i);
        }
        if (Utilities.hasFlag(insn, lrFlag)) {
            ARMInstructions.appendRegister(s, 14);
        }
        if (Utilities.hasFlag(insn, pcFlag)) {
            ARMInstructions.appendRegister(s, 15);
        }
        return s.toString();
    }

    private static final String getCoprocessorRegisterName(int reg) {
        return cpRegisterNames[reg & 0xF];
    }

    private static final String getAddressingMode1(int insn) {
        if (Utilities.hasFlag(insn, 0x2000000)) {
            int imm8 = insn & 0xFF;
            int immShift = insn >> 8 & 0xF;
            int value = Integer.rotateRight(imm8, immShift << 1);
            return String.format("0x%X", value);
        }
        StringBuilder s = new StringBuilder();
        s.append(ARMInstructions.getRegisterName(insn & 0xF));
        if ((insn & 0xF90) != 0) {
            int shiftType = insn >> 5 & 3;
            s.append(' ');
            s.append(shiftTypeNames[shiftType]);
            s.append(' ');
            if (Utilities.hasFlag(insn, 16)) {
                s.append(ARMInstructions.getRegisterName(insn >> 8));
            } else {
                int shift = insn >> 7 & 0x1F;
                if (shift == 0 && shiftType >= 1 && shiftType <= 2) {
                    shift = 32;
                }
                s.append('#');
                s.append(shift);
            }
        }
        return s.toString();
    }

    private static final int getAddressingMode1(ARMProcessor processor, int insn) {
        boolean shifterCarryOut;
        int value;
        if (Utilities.hasFlag(insn, 0x2000000)) {
            int imm8 = insn & 0xFF;
            int immRot = insn >> 8 & 0xF;
            value = Integer.rotateRight(imm8, immRot << 1);
            shifterCarryOut = immRot == 0 ? processor.hasCflag() : value < 0;
        } else {
            int shift;
            int shiftType = insn >> 5 & 3;
            if (Utilities.hasFlag(insn, 16)) {
                int shiftRegister = insn >> 8 & 0xF;
                shift = processor.getRegister(shiftRegister);
                shift &= 0xFF;
            } else {
                shift = insn >> 7 & 0x1F;
                if (shift == 0 && shiftType >= 1 && shiftType <= 2) {
                    shift = 32;
                }
            }
            int register = insn & 0xF;
            value = processor.getRegister(register);
            if (shift == 0) {
                shifterCarryOut = processor.hasCflag();
            } else {
                switch (shiftType) {
                    case 0: {
                        shifterCarryOut = value << shift - 1 < 0;
                        value <<= shift;
                        break;
                    }
                    case 1: {
                        shifterCarryOut = (value >>> shift - 1 & 1) != 0;
                        value >>>= shift;
                        break;
                    }
                    case 2: {
                        shifterCarryOut = (value >> shift - 1 & 1) != 0;
                        value >>= shift;
                        break;
                    }
                    case 3: {
                        shifterCarryOut = (Integer.rotateRight(value, shift - 1) & 1) != 0;
                        value = Integer.rotateRight(value, shift);
                        break;
                    }
                    default: {
                        log.error((Object)String.format("Unknown shiftType=%d", shiftType));
                        shifterCarryOut = false;
                    }
                }
            }
        }
        processor.shifterCarryOut = shifterCarryOut;
        return value;
    }

    private static final String getAddressingMode2(int insn) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        s.append(ARMInstructions.getRegisterName(insn >> 16));
        boolean up = Utilities.hasFlag(insn, 0x800000);
        boolean pre = Utilities.hasFlag(insn, 0x1000000);
        if (!pre) {
            s.append(']');
        }
        if (Utilities.notHasFlag(insn, 0x2000000)) {
            int imm12 = insn & 0xFFF;
            if (imm12 != 0) {
                s.append(", #");
                if (!up) {
                    s.append('-');
                }
                s.append(String.format("0x%X", imm12));
            }
        } else {
            s.append(", ");
            if (!up) {
                s.append('-');
            }
            s.append(ARMInstructions.getRegisterName(insn & 0xF));
            if ((insn & 0xF90) != 0) {
                int shiftType = insn >> 5 & 3;
                int shift = insn >> 7 & 0x1F;
                if (shift == 0 && shiftType >= 1 && shiftType <= 2) {
                    shift = 32;
                }
                s.append(", ");
                s.append(shiftTypeNames[shiftType]);
                s.append(" #");
                s.append(shift);
            }
        }
        if (pre) {
            s.append(']');
        }
        return s.toString();
    }

    private static final int getAddressingMode2(ARMProcessor processor, int insn) {
        int addr;
        int offset;
        int rn = insn >> 16 & 0xF;
        int base = processor.getRegister(rn);
        if (Utilities.notHasFlag(insn, 0x2000000)) {
            offset = insn & 0xFFF;
        } else {
            int shiftType = insn >> 5 & 3;
            int shift = insn >> 7 & 0x1F;
            if (shift == 0 && shiftType >= 1 && shiftType <= 2) {
                shift = 32;
            }
            int register = insn & 0xF;
            offset = processor.getRegister(register);
            switch (shiftType) {
                case 0: {
                    offset <<= shift;
                    break;
                }
                case 1: {
                    offset >>>= shift;
                    break;
                }
                case 2: {
                    offset >>= shift;
                    break;
                }
                case 3: {
                    offset = Integer.rotateRight(offset, shift);
                }
            }
        }
        if (Utilities.hasFlag(insn, 0x1000000)) {
            addr = Utilities.hasFlag(insn, 0x800000) ? base + offset : base - offset;
            if (Utilities.hasFlag(insn, 0x200000)) {
                processor.setRegister(rn, addr);
            }
        } else {
            addr = base;
            int writebackAddr = Utilities.hasFlag(insn, 0x800000) ? base + offset : base - offset;
            processor.setRegister(rn, writebackAddr);
        }
        return addr;
    }

    private static final boolean getSubstractC(int value1, int value2, int value) {
        boolean neg2;
        boolean neg = value < 0;
        boolean neg1 = value1 < 0;
        boolean bl = neg2 = value2 < 0;
        boolean borrow = neg1 ? neg2 && neg : neg2 || neg;
        return !borrow;
    }

    private static final boolean getSubstractV(int value1, int value2, int value) {
        return (value1 ^ value2) < 0 && (value1 ^ value) < 0;
    }

    private static final boolean getAdditionC(int value1, int value2, int value) {
        return value < value1;
    }

    private static final boolean getAdditionV(int value1, int value2, int value) {
        return (value1 ^ value2) >= 0 && (value1 ^ value) < 0;
    }

    public static abstract class STUB
    extends ARMInstruction {
        @Override
        public void interpret(ARMProcessor processor, int insn) {
            this.instance(insn).interpret(processor, insn);
        }

        @Override
        public void compile(ICompilerContext context, int insn) {
            this.instance(insn).compile(context, insn);
        }

        @Override
        public String disasm(int address, int insn) {
            return this.instance(insn).disasm(address, insn);
        }

        @Override
        public abstract ARMInstruction instance(int var1);
    }
}

