/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.arm;

import java.util.HashMap;
import java.util.Map;
import jpcsp.Emulator;
import jpcsp.arm.ARMDecoder;
import jpcsp.arm.ARMInstruction;
import jpcsp.arm.ARMProcessor;
import jpcsp.arm.IARMHLECall;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ARMInterpreter {
    public static Logger log = ARMProcessor.log;
    private ARMProcessor processor;
    private final Map<Integer, IARMHLECall> hleCalls = new HashMap<Integer, IARMHLECall>();
    public static final int PC_END_RUN = -4;
    private boolean exitInterpreter;
    private boolean inInterpreter;

    public ARMInterpreter(ARMProcessor processor) {
        this.processor = processor;
        processor.setInterpreter(this);
        this.installHLECall(-4, 0, null);
    }

    public void run() {
        this.inInterpreter = true;
        while (!(Emulator.pause || this.exitInterpreter || this.processor.isNextInstructionPc(-4))) {
            this.processor.interpret();
        }
        this.inInterpreter = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Exiting ARMInterpreter loop at 0x%08X", this.processor.getNextInstructionPc()));
        }
        this.exitInterpreter = false;
    }

    public void exitInterpreter() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Request to exit ARMInterpreter inInterpreter=%b", this.inInterpreter));
        }
        if (this.inInterpreter) {
            this.exitInterpreter = true;
        }
    }

    public void disasm(int addr, int length) {
        boolean thumbMode = Utilities.hasBit(addr, 0);
        if (thumbMode) {
            int pc = Utilities.clearBit(addr, 0);
            log.info((Object)String.format("Disassembling 0x%08X-0x%08X", pc, pc + length - 2));
            int i = 0;
            while (i < length) {
                int insn = this.processor.mem.internalRead16(pc);
                ARMInstruction instruction = ARMDecoder.thumbInstruction(insn);
                log.info((Object)String.format("0x%08X: [0x%04X] - %s", pc, insn, instruction.disasm(pc, insn)));
                i += 2;
                pc += 2;
            }
        } else {
            int pc = Utilities.clearFlag(addr, 3);
            log.info((Object)String.format("Disassembling 0x%08X-0x%08X", pc, pc + length - 4));
            int i = 0;
            while (i < length) {
                int insn = this.processor.mem.internalRead32(pc);
                ARMInstruction instruction = ARMDecoder.instruction(insn);
                log.info((Object)String.format("0x%08X: [0x%08X] - %s", pc, insn, instruction.disasm(pc, insn)));
                i += 4;
                pc += 4;
            }
        }
    }

    public boolean hasHLECall(int addr) {
        return this.hleCalls.containsKey(addr);
    }

    public IARMHLECall getHLECall(int addr) {
        return this.hleCalls.get(addr);
    }

    public IARMHLECall getHLECall(int addr, int imm) {
        return this.getHLECall(addr);
    }

    public boolean interpretHLE(int addr, int imm) {
        IARMHLECall hleCall = this.getHLECall(addr, imm);
        if (hleCall == null) {
            return false;
        }
        hleCall.call(this.processor, imm);
        return true;
    }

    public void registerHLECall(int addr, IARMHLECall hleCall) {
        this.hleCalls.put(Utilities.clearBit(addr, 0), hleCall);
    }

    public void installHLECall(int addr, int imm, IARMHLECall hleCall) {
        if (Utilities.hasBit(addr, 0)) {
            addr = Utilities.clearBit(addr, 0);
            this.processor.mem.write16(addr, (short)(0xBE00 | imm & 0xFF));
        } else {
            this.processor.mem.write32(addr, 0xE1200070 | (imm & 0xFFF0) << 4 | imm & 0xF);
        }
        this.registerHLECall(addr, hleCall);
    }

    public void delayHLE(int count) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("delayHLE count=0x%X", count));
        }
    }
}

