/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.Memory;
import jpcsp.format.DeferredStub;

public class DeferredVStubHI16
extends DeferredStub {
    private boolean hasSavedValue;
    private short savedValue;

    public DeferredVStubHI16(SceModule sourceModule, String moduleName, int importAddress, int nid) {
        super(sourceModule, moduleName, importAddress, nid);
    }

    @Override
    public void resolve(Memory mem, int address) {
        if (!this.hasSavedValue) {
            this.savedValue = (short)mem.read16(this.getImportAddress());
            this.hasSavedValue = true;
        }
        int hiValue = mem.read16(this.getImportAddress()) << 16;
        int value = hiValue << 16;
        short relocatedLoValue = (short)(value += address);
        short relocatedHiValue = (short)(value >>> 16);
        if (relocatedLoValue < 0) {
            relocatedHiValue = (short)(relocatedHiValue + 1);
        }
        mem.write16(this.getImportAddress(), relocatedHiValue);
        this.invalidate(this.getImportAddress(), 2);
    }

    @Override
    public void unresolve(Memory mem) {
        if (this.hasSavedValue) {
            mem.write16(this.getImportAddress(), this.savedValue);
            this.invalidate(this.getImportAddress(), 2);
        }
        if (this.sourceModule != null) {
            this.sourceModule.unresolvedImports.add(this);
        }
    }

    @Override
    public String toString() {
        return String.format("HI16 %s", super.toString());
    }
}

