/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import jpcsp.Memory;
import jpcsp.util.Utilities;

public class PNG {
    private static final int PNG_MAGIC1 = -1991225785;
    private static final int PNG_MAGIC2 = 218765834;
    private static final int CHUNK_TYPE_IEND = 1229278788;

    public static int getEndOfPNG(Memory mem, int addr, int size) {
        if (Memory.isAddressGood(addr) && size >= 8) {
            int magic1 = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr));
            int magic2 = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 4));
            if (magic1 == -1991225785 && magic2 == 218765834) {
                int chunkAddr = addr + 8;
                while (chunkAddr + 12 <= addr + size) {
                    int chunkLength = Utilities.endianSwap32(Utilities.readUnaligned32(mem, chunkAddr));
                    int chunkType = Utilities.endianSwap32(Utilities.readUnaligned32(mem, chunkAddr + 4));
                    if (chunkAddr + chunkLength + 12 > addr + size) break;
                    if (chunkType == 1229278788) {
                        size = chunkAddr - addr + chunkLength + 12;
                        break;
                    }
                    chunkAddr += chunkLength + 12;
                }
            }
        }
        return size;
    }
}

