/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import jpcsp.graphics.RE.BaseRenderingEngineProxy;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngineUtilities;

public class ViewportFilter
extends BaseRenderingEngineProxy {
    private boolean isDirectRendering;

    public ViewportFilter(IRenderingEngine proxy) {
        super(proxy);
    }

    @Override
    public void startDisplay() {
        this.isDirectRendering = false;
        super.startDisplay();
    }

    @Override
    public void setRenderingEngine(IRenderingEngine re) {
        super.setRenderingEngine(re);
    }

    @Override
    public void setViewport(int x, int y, int width, int height) {
        if (!this.isDirectRendering) {
            x = VideoEngineUtilities.getResizedWidth(x);
            y = VideoEngineUtilities.getResizedHeight(y);
            width = VideoEngineUtilities.getResizedWidth(width);
            height = VideoEngineUtilities.getResizedHeight(height);
        }
        super.setViewport(x, y, width, height);
    }

    @Override
    public void setScissor(int x, int y, int width, int height) {
        if (!this.isDirectRendering) {
            x = VideoEngineUtilities.getResizedWidth(x);
            y = VideoEngineUtilities.getResizedHeight(y);
            width = VideoEngineUtilities.getResizedWidth(width);
            height = VideoEngineUtilities.getResizedHeight(height);
        }
        super.setScissor(x, y, width, height);
    }

    @Override
    public void endDirectRendering() {
        this.isDirectRendering = false;
        super.endDirectRendering();
    }

    @Override
    public void startDirectRendering(boolean textureEnabled, boolean depthWriteEnabled, boolean colorWriteEnabled, boolean setOrthoMatrix, boolean orthoInverted, int width, int height) {
        this.isDirectRendering = true;
        super.startDirectRendering(textureEnabled, depthWriteEnabled, colorWriteEnabled, setOrthoMatrix, orthoInverted, width, height);
    }
}

