/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.buffer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.buffer.BaseBufferManager;
import jpcsp.util.Utilities;

public class BufferManagerDefault
extends BaseBufferManager {
    protected int currentBufferId;

    @Override
    protected void init() {
        super.init();
        this.currentBufferId = 12345678;
    }

    @Override
    public boolean useVBO() {
        return false;
    }

    @Override
    public int genBuffer(IRenderingEngine re, int target, int type, int size, int usage) {
        int totalSize = size * sizeOfType[type];
        ByteBuffer byteBuffer = this.createByteBuffer(totalSize);
        int buffer = this.currentBufferId++;
        this.buffers.put(buffer, new BaseBufferManager.BufferInfo(buffer, byteBuffer, type, size));
        return buffer;
    }

    @Override
    public void bindBuffer(IRenderingEngine re, int target, int buffer) {
    }

    @Override
    public void setColorPointer(IRenderingEngine re, int buffer, int size, int type, int stride, int offset) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        re.setColorPointer(size, type, stride, bufferInfo.getBufferSize() - offset, bufferInfo.getBufferPosition(offset));
    }

    @Override
    public void setNormalPointer(IRenderingEngine re, int buffer, int type, int stride, int offset) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        re.setNormalPointer(type, stride, bufferInfo.getBufferSize() - offset, bufferInfo.getBufferPosition(offset));
    }

    @Override
    public void setTexCoordPointer(IRenderingEngine re, int buffer, int size, int type, int stride, int offset) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        re.setTexCoordPointer(size, type, stride, bufferInfo.getBufferSize() - offset, bufferInfo.getBufferPosition(offset));
    }

    @Override
    public void setVertexAttribPointer(IRenderingEngine re, int buffer, int id, int size, int type, boolean normalized, int stride, int offset) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        re.setVertexAttribPointer(id, size, type, normalized, stride, bufferInfo.getBufferSize() - offset, bufferInfo.getBufferPosition(offset));
    }

    @Override
    public void setVertexPointer(IRenderingEngine re, int buffer, int size, int type, int stride, int offset) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        re.setVertexPointer(size, type, stride, bufferInfo.getBufferSize() - offset, bufferInfo.getBufferPosition(offset));
    }

    @Override
    public void setWeightPointer(IRenderingEngine re, int buffer, int size, int type, int stride, int offset) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        re.setWeightPointer(size, type, stride, bufferInfo.getBufferSize() - offset, bufferInfo.getBufferPosition(offset));
    }

    @Override
    public void setBufferData(IRenderingEngine re, int target, int buffer, int size, Buffer data, int usage) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        if (bufferInfo.byteBuffer != data) {
            bufferInfo.byteBuffer.clear();
            Utilities.putBuffer(bufferInfo.byteBuffer, data, ByteOrder.nativeOrder());
        } else {
            bufferInfo.byteBuffer.position(0);
        }
    }

    @Override
    public void setBufferSubData(IRenderingEngine re, int target, int buffer, int offset, int size, Buffer data, int usage) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        if (bufferInfo.byteBuffer != data) {
            bufferInfo.byteBuffer.clear();
            Utilities.putBuffer(bufferInfo.byteBuffer, data, ByteOrder.nativeOrder());
        } else {
            bufferInfo.byteBuffer.position(0);
        }
    }
}

