/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.externalge;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.PspGeList;
import jpcsp.Memory;
import jpcsp.graphics.RE.externalge.ExternalGE;
import jpcsp.graphics.RE.externalge.NativeUtils;
import org.apache.log4j.Logger;

public class CoreThread
extends Thread {
    protected static Logger log = ExternalGE.log;
    private static CoreThread instance;
    private volatile boolean exit;
    private Semaphore sync = new Semaphore(0);
    private volatile boolean insideRendering;

    public static CoreThread getInstance() {
        if (instance == null) {
            instance = new CoreThread();
            instance.setDaemon(true);
            instance.setName("ExternalGE - Core Thread");
            instance.start();
        }
        return instance;
    }

    public static void exit() {
        if (instance != null) {
            CoreThread.instance.exit = true;
            instance = null;
        }
    }

    private CoreThread() {
    }

    @Override
    public void run() {
        RuntimeContext.setLog4jMDC();
        boolean doCoreInterpret = false;
        while (!this.exit) {
            PspGeList list = ExternalGE.getCurrentList();
            if (list == null) {
                if (!Emulator.pause && log.isTraceEnabled()) {
                    log.trace((Object)String.format("CoreThread no current list available... waiting", new Object[0]));
                }
                this.waitForSync(100);
                continue;
            }
            if (!doCoreInterpret && !list.waitForSync(100)) continue;
            this.setInsideRendering(true);
            doCoreInterpret = false;
            NativeUtils.setCoreMadr(list.getPc());
            NativeUtils.updateMemoryUnsafeAddr();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("CoreThread processing %s", list));
            }
            while (NativeUtils.coreInterpret()) {
                NativeUtils.updateMemoryUnsafeAddr();
                if (log.isDebugEnabled()) {
                    list.setPc(NativeUtils.getCoreMadr());
                    log.debug((Object)String.format("CoreThread looping %s", list));
                }
                if (NativeUtils.getRendererIndexCount() <= 0) continue;
            }
            list.setPc(NativeUtils.getCoreMadr());
            int intrStat = NativeUtils.getCoreIntrStat();
            if ((intrStat & 2) != 0) {
                if ((intrStat & 1) != 0) {
                    this.executeCommandSIGNAL(list);
                }
                if ((intrStat & 4) != 0) {
                    this.executeCommandFINISH(list);
                }
                NativeUtils.setCoreIntrStat(intrStat &= 0xFFFFFFF8);
            }
            if (NativeUtils.getRendererIndexCount() > 0) {
                ExternalGE.render();
                doCoreInterpret = true;
            }
            this.setInsideRendering(false);
        }
        log.info((Object)String.format("CoreThread exited", new Object[0]));
    }

    public void sync() {
        if (this.sync != null) {
            this.sync.release();
        }
    }

    private boolean waitForSync(int millis) {
        while (true) {
            try {
                int availablePermits = this.sync.drainPermits();
                if (availablePermits <= 0 && !this.sync.tryAcquire(millis, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                log.debug((Object)String.format("CoreThread waitForSync %s", e));
                continue;
            }
            break;
        }
        return true;
    }

    private static int command(int instruction) {
        return instruction >>> 24;
    }

    private void executeCommandFINISH(PspGeList list) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("FINISH %s", list));
        }
        list.clearRestart();
        list.finishList();
        list.pushFinishCallback(NativeUtils.getCoreCmdArray(15) & 0xFFFFFF);
        list.endList();
        list.status = 0;
        ExternalGE.finishList(list);
    }

    private void executeCommandSIGNAL(PspGeList list) {
        int args = NativeUtils.getCoreCmdArray(14) & 0xFFFFFF;
        int behavior = args >> 16 & 0xFF;
        int signal = args & 0xFFFF;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("SIGNAL (behavior=%d, signal=0x%X)", behavior, signal));
        }
        switch (behavior) {
            case 8: {
                Memory mem = Memory.getInstance();
                if (CoreThread.command(mem.read32(list.getPc())) == 15) {
                    list.readNextInstruction();
                    if (CoreThread.command(mem.read32(list.getPc())) == 12) {
                        list.readNextInstruction();
                    }
                }
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("PSP_GE_SIGNAL_SYNC ignored PC: 0x%08X", list.getPc()));
                break;
            }
            case 17: {
                int hi16 = signal & 0xFFF;
                int lo16 = NativeUtils.getCoreCmdArray(12) & 0xFFFF;
                int addr = hi16 << 16 | lo16;
                int oldPc = list.getPc();
                list.callAbsolute(addr);
                int newPc = list.getPc();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("PSP_GE_SIGNAL_CALL old PC: 0x%08X, new PC: 0x%08X", oldPc, newPc));
                break;
            }
            case 18: {
                int oldPc = list.getPc();
                list.ret();
                int newPc = list.getPc();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("PSP_GE_SIGNAL_RETURN old PC: 0x%08X, new PC: 0x%08X", oldPc, newPc));
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                int hi16 = signal & 0xFFFF;
                int end = NativeUtils.getCoreCmdArray(12);
                int lo16 = end & 0xFFFF;
                int width = end >> 16 & 0xFF;
                int addr = list.getAddressRel(hi16 << 16 | lo16);
                int tbpValue = behavior - 32 + 160 << 24 | addr & 0xFFFFFF;
                int tbwValue = behavior - 32 + 168 << 24 | addr >> 8 & 0xFF0000 | width & 0xFFFF;
                NativeUtils.interpretCoreCmd(CoreThread.command(tbpValue), tbpValue, NativeUtils.getCoreMadr());
                NativeUtils.interpretCoreCmd(CoreThread.command(tbwValue), tbwValue, NativeUtils.getCoreMadr());
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                int hi16 = signal & 0xFFFF;
                int end = NativeUtils.getCoreCmdArray(12);
                int lo16 = end & 0xFFFF;
                int width = end >> 16 & 0xFF;
                int addr = list.getAddressRelOffset(hi16 << 16 | lo16);
                int tbpValue = behavior - 32 + 160 << 24 | addr & 0xFFFFFF;
                int tbwValue = behavior - 32 + 168 << 24 | addr >> 8 & 0xFF0000 | width & 0xFFFF;
                NativeUtils.interpretCoreCmd(CoreThread.command(tbpValue), tbpValue, NativeUtils.getCoreMadr());
                NativeUtils.interpretCoreCmd(CoreThread.command(tbwValue), tbwValue, NativeUtils.getCoreMadr());
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                list.clearRestart();
                list.pushSignalCallback(behavior, signal);
                list.endList();
                list.status = 4;
                break;
            }
            default: {
                if (!log.isInfoEnabled()) break;
                log.warn((Object)String.format("SIGNAL (behavior=%d, signal=0x%X) unknown behavior at 0x%08X", behavior, signal, list.getPc() - 4));
            }
        }
        if (list.isDrawing()) {
            list.sync();
            NativeUtils.setCoreCtrlActive();
        }
    }

    public boolean isInsideRendering() {
        return this.insideRendering;
    }

    public void setInsideRendering(boolean insideRendering) {
        this.insideRendering = insideRendering;
    }
}

