/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import java.util.HashMap;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.software.BasePrimitiveRenderer;
import jpcsp.graphics.RE.software.PixelColor;
import jpcsp.graphics.RE.software.RendererTemplate;
import jpcsp.graphics.VideoEngine;
import jpcsp.util.ClassSpecializer;
import jpcsp.util.LongLongKey;
import org.apache.log4j.Logger;

public class FilterCompiler {
    private static Logger log = VideoEngine.log;
    private static FilterCompiler instance;
    private HashMap<LongLongKey, RendererTemplate> compiledRenderers = new HashMap();
    private static int classNameId;

    public static FilterCompiler getInstance() {
        if (instance == null) {
            instance = new FilterCompiler();
        }
        return instance;
    }

    private FilterCompiler() {
    }

    public RendererTemplate getCompiledRenderer(BasePrimitiveRenderer renderer, LongLongKey id, GeContext context) {
        RendererTemplate compiledRenderer = this.compiledRenderers.get(id);
        if (compiledRenderer == null && (compiledRenderer = this.compileRenderer(renderer, id, context)) != null) {
            this.compiledRenderers.put(id, compiledRenderer);
        }
        return compiledRenderer;
    }

    private static String getNewCompiledRendererClassName() {
        return String.format("Renderer%d", classNameId++);
    }

    private RendererTemplate compileRenderer(BasePrimitiveRenderer renderer, LongLongKey id, GeContext context) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Compiling Renderer %s", id));
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("hasMemInt", RuntimeContext.hasMemoryInt());
        variables.put("transform2D", renderer.transform2D);
        variables.put("clearMode", renderer.clearMode);
        variables.put("clearModeColor", context.clearModeColor);
        variables.put("clearModeStencil", context.clearModeStencil);
        variables.put("clearModeDepth", context.clearModeDepth);
        variables.put("needSourceDepthRead", renderer.needSourceDepthRead);
        variables.put("needDestinationDepthRead", renderer.needDestinationDepthRead);
        variables.put("needDepthWrite", renderer.needDepthWrite);
        variables.put("needTextureUV", renderer.needTextureUV);
        variables.put("simpleTextureUV", renderer.simpleTextureUV);
        variables.put("swapTextureUV", renderer.swapTextureUV);
        variables.put("needScissoringX", renderer.needScissoringX);
        variables.put("needScissoringY", renderer.needScissoringY);
        variables.put("nearZ", renderer.nearZ);
        variables.put("farZ", renderer.farZ);
        variables.put("colorTestFlagEnabled", context.colorTestFlag.isEnabled());
        variables.put("colorTestFunc", context.colorTestFunc);
        variables.put("alphaTestFlagEnabled", context.alphaTestFlag.isEnabled());
        variables.put("alphaFunc", context.alphaFunc);
        variables.put("alphaRef", context.alphaRef);
        variables.put("alphaMask", context.alphaMask);
        variables.put("stencilTestFlagEnabled", context.stencilTestFlag.isEnabled());
        variables.put("stencilFunc", context.stencilFunc);
        variables.put("stencilOpFail", context.stencilOpFail);
        variables.put("stencilOpZFail", context.stencilOpZFail);
        variables.put("stencilOpZPass", context.stencilOpZPass);
        variables.put("stencilRef", context.stencilRef);
        variables.put("depthTestFlagEnabled", context.depthTestFlag.isEnabled());
        variables.put("depthFunc", context.depthFunc);
        variables.put("blendFlagEnabled", context.blendFlag.isEnabled());
        variables.put("blendEquation", context.blendEquation);
        variables.put("blendSrc", context.blend_src);
        variables.put("blendDst", context.blend_dst);
        variables.put("sfix", context.sfix);
        variables.put("dfix", context.dfix);
        variables.put("colorLogicOpFlagEnabled", context.colorLogicOpFlag.isEnabled());
        variables.put("logicOp", context.logicOp);
        variables.put("colorMask", PixelColor.getColor(context.colorMask));
        variables.put("depthMask", context.depthMask);
        variables.put("textureFlagEnabled", context.textureFlag.isEnabled());
        variables.put("useVertexTexture", renderer.useVertexTexture);
        variables.put("lightingFlagEnabled", context.lightingFlag.isEnabled());
        variables.put("sameVertexColor", renderer.sameVertexColor);
        variables.put("setVertexPrimaryColor", renderer.setVertexPrimaryColor);
        variables.put("primaryColorSetGlobally", renderer.primaryColorSetGlobally);
        variables.put("isTriangle", renderer.isTriangle);
        variables.put("matFlagAmbient", (context.mat_flags & 1) != 0);
        variables.put("matFlagDiffuse", (context.mat_flags & 2) != 0);
        variables.put("matFlagSpecular", (context.mat_flags & 4) != 0);
        variables.put("useVertexColor", context.useVertexColor);
        variables.put("textureColorDoubled", context.textureColorDoubled);
        variables.put("lightMode", context.lightMode);
        variables.put("texMapMode", context.tex_map_mode);
        variables.put("texProjMapMode", context.tex_proj_map_mode);
        variables.put("texTranslateX", Float.valueOf(context.tex_translate_x));
        variables.put("texTranslateY", Float.valueOf(context.tex_translate_y));
        variables.put("texScaleX", Float.valueOf(context.tex_scale_x));
        variables.put("texScaleY", Float.valueOf(context.tex_scale_y));
        variables.put("texWrapS", context.tex_wrap_s);
        variables.put("texWrapT", context.tex_wrap_t);
        variables.put("textureFunc", context.textureFunc);
        variables.put("textureAlphaUsed", context.textureAlphaUsed);
        variables.put("psm", context.psm);
        variables.put("texMagFilter", context.tex_mag_filter);
        variables.put("needTextureWrapU", renderer.needTextureWrapU);
        variables.put("needTextureWrapV", renderer.needTextureWrapV);
        variables.put("needSourceDepthClamp", renderer.needSourceDepthClamp);
        variables.put("isLogTraceEnabled", renderer.isLogTraceEnabled);
        variables.put("collectStatistics", false);
        variables.put("ditherFlagEnabled", context.ditherFlag.isEnabled());
        String specializedClassName = FilterCompiler.getNewCompiledRendererClassName();
        ClassSpecializer cs = new ClassSpecializer();
        Class<?> specializedClass = cs.specialize(specializedClassName, RendererTemplate.class, variables);
        RendererTemplate compiledRenderer = null;
        if (specializedClass != null) {
            try {
                compiledRenderer = (RendererTemplate)specializedClass.newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)"Error while instanciating compiled renderer", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Error while instanciating compiled renderer", (Throwable)e);
            }
        }
        return compiledRenderer;
    }

    public static void exit() {
        if (instance == null) {
            return;
        }
        if (log.isInfoEnabled()) {
            // empty if block
        }
    }

    static {
        classNameId = 0;
    }
}

