/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.util.HashMap;
import jpcsp.graphics.VertexInfo;
import jpcsp.graphics.VertexInfoReaderTemplate;
import jpcsp.graphics.VideoEngine;
import jpcsp.util.ClassSpecializer;
import org.apache.log4j.Logger;

public class VertexInfoCompiler {
    private static Logger log = VideoEngine.log;
    private static VertexInfoCompiler instance;
    private HashMap<Integer, VertexInfoReaderTemplate> compiledVertexInfoReaders = new HashMap();
    private VertexInfo vinfo = new VertexInfo();

    public static VertexInfoCompiler getInstance() {
        if (instance == null) {
            instance = new VertexInfoCompiler();
        }
        return instance;
    }

    private VertexInfoCompiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VertexInfoReaderTemplate getCompiledVertexInfoReader(int vtype, boolean readTexture) {
        VertexInfoReaderTemplate compiledVertexInfoReader;
        int key = vtype;
        if (readTexture) {
            key |= 0x1000000;
        }
        if (log.isTraceEnabled()) {
            key |= 0x2000000;
        }
        if ((compiledVertexInfoReader = this.compiledVertexInfoReaders.get(key)) == null) {
            HashMap<Integer, VertexInfoReaderTemplate> hashMap = this.compiledVertexInfoReaders;
            synchronized (hashMap) {
                compiledVertexInfoReader = this.compiledVertexInfoReaders.get(key);
                if (compiledVertexInfoReader == null && (compiledVertexInfoReader = this.compileVertexInfoReader(key, vtype, readTexture)) != null) {
                    this.compiledVertexInfoReaders.put(key, compiledVertexInfoReader);
                }
            }
        }
        return compiledVertexInfoReader;
    }

    private VertexInfoReaderTemplate compileVertexInfoReader(int key, int vtype, boolean readTexture) {
        VertexInfo.processType(this.vinfo, vtype);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Compiling VertexInfoReader for %s", this.vinfo));
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("isLogTraceEnabled", log.isTraceEnabled());
        variables.put("transform2D", this.vinfo.transform2D);
        variables.put("skinningWeightCount", this.vinfo.skinningWeightCount);
        variables.put("morphingVertexCount", this.vinfo.morphingVertexCount);
        variables.put("texture", this.vinfo.texture);
        variables.put("color", this.vinfo.color);
        variables.put("normal", this.vinfo.normal);
        variables.put("position", this.vinfo.position);
        variables.put("weight", this.vinfo.weight);
        variables.put("index", this.vinfo.index);
        variables.put("vtype", this.vinfo.vtype);
        variables.put("readTexture", readTexture);
        variables.put("vertexSize", this.vinfo.vertexSize);
        variables.put("oneVertexSize", this.vinfo.oneVertexSize);
        variables.put("textureOffset", this.vinfo.textureOffset);
        variables.put("colorOffset", this.vinfo.colorOffset);
        variables.put("normalOffset", this.vinfo.normalOffset);
        variables.put("positionOffset", this.vinfo.positionOffset);
        variables.put("alignmentSize", this.vinfo.alignmentSize);
        String specializedClassName = String.format("VertexInfoReader%07X", key);
        ClassSpecializer cs = new ClassSpecializer();
        Class<?> specializedClass = cs.specialize(specializedClassName, VertexInfoReaderTemplate.class, variables);
        VertexInfoReaderTemplate compiledVertexInfoReader = null;
        if (specializedClass != null) {
            try {
                compiledVertexInfoReader = (VertexInfoReaderTemplate)specializedClass.newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)"Error while instanciating compiled vertexInfoReader", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Error while instanciating compiled vertexInfoReader", (Throwable)e);
            }
        }
        return compiledVertexInfoReader;
    }
}

