/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.capture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.sceDisplay;

public class CaptureFrameBufDetails {
    private int topaddrFb;
    private int bufferwidthFb;
    private int pixelformatFb;
    private int sync;

    public CaptureFrameBufDetails() {
        sceDisplay display = Modules.sceDisplayModule;
        this.topaddrFb = display.getTopAddrFb();
        this.bufferwidthFb = display.getBufferWidthFb();
        this.pixelformatFb = display.getPixelFormatFb();
        this.sync = display.getSync();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(4);
        out.writeInt(this.topaddrFb);
        out.writeInt(this.bufferwidthFb);
        out.writeInt(this.pixelformatFb);
        out.writeInt(this.sync);
    }

    public static CaptureFrameBufDetails read(DataInputStream in) throws IOException {
        CaptureFrameBufDetails details = new CaptureFrameBufDetails();
        details.topaddrFb = in.readInt();
        details.bufferwidthFb = in.readInt();
        details.pixelformatFb = in.readInt();
        details.sync = in.readInt();
        return details;
    }

    public void commit() {
        sceDisplay display = Modules.sceDisplayModule;
        display.hleDisplaySetFrameBuf(this.topaddrFb, this.bufferwidthFb, this.pixelformatFb, this.sync);
    }
}

