/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.capture;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.PspGeList;
import jpcsp.Memory;
import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.capture.CaptureFrameBufDetails;
import jpcsp.graphics.capture.CaptureGEDetails;
import jpcsp.graphics.capture.CaptureGeContext;
import jpcsp.graphics.capture.CaptureImage;
import jpcsp.graphics.capture.CaptureList;
import jpcsp.graphics.capture.CaptureRAM;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import org.apache.log4j.Logger;

public class CaptureManager {
    public static Logger log = VideoEngine.log;
    public static final String replayFileName = "record.bin";
    private static final int MAGIC = 1380274252;
    private static final int CURRENT_VERSION = 1;
    private static final int BUFFER_SIZE = 0x100000;
    public static final int PACKET_TYPE_RESERVED = 0;
    public static final int PACKET_TYPE_START_LIST = 1;
    public static final int PACKET_TYPE_RAM = 2;
    public static final int PACKET_TYPE_FRAME_BUFFER_DETAILS = 3;
    public static final int PACKET_TYPE_GE_DETAILS = 4;
    public static final int PACKET_TYPE_GE_CONTEXT = 5;
    public static boolean captureInProgress;
    protected static int version;
    private static DataOutputStream out;
    private static DataInputStream in;
    private static CaptureList list;
    private static boolean listExecuted;
    private static CaptureFrameBufDetails replayFrameBufDetails;
    private static CaptureGEDetails replayGEDetails;
    private static CaptureGeContext replayGeContext;
    private static HashSet<Integer> capturedImages;
    private static Map<Integer, Integer> capturedAddresses;

    private static boolean processReplayPacket(Memory mem, DataInputStream in) throws IOException {
        if (in.available() <= 0) {
            return true;
        }
        boolean endOfList = false;
        int packetType = in.readInt();
        switch (packetType) {
            case 1: {
                list = CaptureList.read(in);
                break;
            }
            case 2: {
                CaptureRAM ramFragment = CaptureRAM.read(in);
                ramFragment.commit(mem);
                break;
            }
            case 4: {
                replayGEDetails = CaptureGEDetails.read(in);
                endOfList = replayGEDetails.isEndOfList();
                break;
            }
            case 3: {
                replayFrameBufDetails = CaptureFrameBufDetails.read(in);
                break;
            }
            case 5: {
                replayGeContext = CaptureGeContext.read(in);
                break;
            }
            default: {
                throw new IOException(String.format("Unknown packet type 0x%08X", packetType));
            }
        }
        return endOfList;
    }

    private static boolean processReplayHeader(Memory mem, DataInputStream in) throws IOException {
        int magic = in.readInt();
        if (magic != 1380274252) {
            log.error((Object)String.format("Not a replay file", new Object[0]));
            return false;
        }
        version = in.readInt();
        if (version > 1) {
            log.error((Object)String.format("Unsupported replay file version 0x%X", version));
            return false;
        }
        return true;
    }

    public static synchronized boolean startRecordReplay(Memory mem, String filename) {
        if (captureInProgress) {
            log.error((Object)"Ignoring startRecordReplay, capture is in progress");
            return false;
        }
        log.info((Object)String.format("Starting replay '%s'", filename));
        boolean continueReplay = false;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(filename), 0x100000));
            if (!CaptureManager.processReplayHeader(mem, in)) {
                in.close();
                in = null;
                return false;
            }
            list = null;
            continueReplay = CaptureManager.continueRecordReplay(mem);
        }
        catch (IOException e) {
            log.error((Object)"Failed to start replay", (Throwable)e);
        }
        return continueReplay;
    }

    public static synchronized boolean continueRecordReplay(Memory mem) {
        boolean continueReplay = false;
        log.debug((Object)"continueRecordReplay");
        try {
            while (!CaptureManager.processReplayPacket(mem, in)) {
            }
            if (list != null) {
                list.commit(mem);
                list = null;
            }
            continueReplay = in != null && in.available() > 0;
        }
        catch (IOException e) {
            log.error((Object)"Failed to continue replay", (Throwable)e);
        }
        return continueReplay;
    }

    public static synchronized void startListReplay(IRenderingEngine re, GeContext context) {
        if (replayGeContext != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("startListReplay %s", replayGeContext));
            }
            replayGeContext.commit(re, context);
            replayGeContext = null;
        }
    }

    public static synchronized void endListReplay() {
        if (replayGEDetails != null) {
            replayGEDetails.commit();
            replayGEDetails = null;
        }
        if (replayFrameBufDetails != null) {
            replayFrameBufDetails.commit();
            replayFrameBufDetails = null;
        }
        log.debug((Object)"Replay List completed");
        Emulator.PauseEmu();
    }

    private static void startGeContextCapture(GeContext context) {
        try {
            CaptureGeContext captureGeContext = new CaptureGeContext(context);
            captureGeContext.write(out);
        }
        catch (IOException e) {
            log.error((Object)"Failed to capture GE Context", (Throwable)e);
            Emulator.PauseEmu();
        }
    }

    public static synchronized void startCapture(Memory mem, String filename, PspGeList list) {
        if (captureInProgress) {
            log.error((Object)"Ignoring startCapture, capture is already in progress");
            return;
        }
        capturedImages = new HashSet();
        capturedAddresses = new HashMap<Integer, Integer>();
        try {
            log.info((Object)String.format("Starting capture to '%s'...", filename));
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename), 0x100000));
            out.writeInt(1380274252);
            out.writeInt(1);
            captureInProgress = true;
            CaptureManager.startGeContextCapture(VideoEngine.getInstance().getContext());
            CaptureManager.startListCapture(mem, list);
        }
        catch (IOException e) {
            log.error((Object)"Failed to start capture", (Throwable)e);
            Emulator.PauseEmu();
        }
    }

    public static synchronized void startListCapture(Memory mem, PspGeList list) {
        capturedImages = new HashSet();
        capturedAddresses = new HashMap<Integer, Integer>();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Starting capture list id=0x%X", list.id));
            }
            CaptureList commandList = new CaptureList(mem, list);
            commandList.write(out);
            CaptureManager.captureList(mem, list.list_addr, list.getStallAddr());
            listExecuted = false;
        }
        catch (IOException e) {
            log.error((Object)"Failed to start list capture", (Throwable)e);
            Emulator.PauseEmu();
        }
    }

    public static synchronized void endCapture() {
        if (!captureInProgress) {
            log.error((Object)"Ignoring endCapture, capture hasn't been started");
            return;
        }
        try {
            out.flush();
            out.close();
            out = null;
        }
        catch (IOException e) {
            log.error((Object)"Failed to end capture", (Throwable)e);
            Emulator.PauseEmu();
        }
        capturedAddresses = null;
        capturedImages = null;
        captureInProgress = false;
        log.info((Object)"Capture completed");
    }

    protected static int getListCmdsLength(int address, int stall) {
        int instruction;
        int command;
        IMemoryReader memoryReader = stall == 0 ? MemoryReader.getMemoryReader(address, 4) : MemoryReader.getMemoryReader(address, stall - address, 4);
        while (memoryReader.getCurrentAddress() != stall && (command = VideoEngine.command(instruction = memoryReader.readNext())) != 12 && command != 8 && command != 11 && command != 10) {
        }
        int length = memoryReader.getCurrentAddress() - address;
        return length;
    }

    public static synchronized void captureList(Memory mem, PspGeList list) {
        CaptureManager.captureList(mem, list.getPc(), list.getStallAddr());
    }

    public static synchronized void captureList(Memory mem, int address, int stall) {
        if (!captureInProgress) {
            return;
        }
        int length = CaptureManager.getListCmdsLength(address, stall);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("captureList pc=0x%08X, stall=0x%08X, length=0x%X", address, stall, length));
        }
        CaptureManager.captureRAM(mem, address, length);
    }

    private static boolean isAlreadyCaptured(int address, int length) {
        Integer capturedLength = capturedAddresses.get(address);
        return capturedLength != null && capturedLength >= length;
    }

    public static synchronized void captureRAM(Memory mem, int address, int length) {
        if (!captureInProgress) {
            return;
        }
        if (!Memory.isAddressGood(address) || length <= 0) {
            return;
        }
        if (CaptureManager.isAlreadyCaptured(address, length)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("captureRAM already captured address=0x%08X, length=0x%X", address, length));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("captureRAM address=0x%08X, length=0x%X", address, length));
        }
        try {
            CaptureRAM captureRAM = new CaptureRAM(mem, address, length);
            captureRAM.write(out);
            capturedAddresses.put(address, length);
        }
        catch (IOException e) {
            log.error((Object)"Failed to capture RAM", (Throwable)e);
        }
    }

    public static void dumpImage(int imageaddr, int level, Buffer buffer, int width, int height, int bufferWidth, int imageType, boolean compressedImage, int compressedImageSize, boolean invert, boolean overwriteFile) {
        try {
            CaptureImage captureImage = new CaptureImage(imageaddr, level, buffer, width, height, bufferWidth, imageType, compressedImage, compressedImageSize, invert, overwriteFile, null);
            captureImage.write();
            if (capturedImages != null) {
                capturedImages.add(imageaddr);
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to capture Image", (Throwable)e);
            Emulator.PauseEmu();
        }
    }

    public static boolean isImageCaptured(int imageaddr) {
        if (capturedImages == null) {
            return false;
        }
        return capturedImages.contains(imageaddr);
    }

    public static synchronized void captureFrameBufDetails() {
        if (!captureInProgress) {
            return;
        }
        try {
            CaptureFrameBufDetails details = new CaptureFrameBufDetails();
            details.write(out);
        }
        catch (IOException e) {
            log.error((Object)"Failed to capture frame buf details", (Throwable)e);
            Emulator.PauseEmu();
        }
    }

    public static synchronized void captureGEDetails(boolean endOfList) {
        if (!captureInProgress) {
            return;
        }
        try {
            CaptureGEDetails geDetails = new CaptureGEDetails(endOfList);
            geDetails.write(out);
        }
        catch (IOException e) {
            log.error((Object)"Failed to capture GE details", (Throwable)e);
            Emulator.PauseEmu();
        }
    }

    public static void markListExecuted() {
        listExecuted = true;
    }

    public static boolean hasListExecuted() {
        return listExecuted;
    }
}

