/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.textures;

import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.textures.GETexture;

public class FBTexture
extends GETexture {
    private int fboId = -1;
    private int depthTextureId = -1;
    private static final int depthPixelFormat = 15;

    public FBTexture(int address, int bufferWidth, int width, int height, int pixelFormat) {
        super(address, bufferWidth, width, height, pixelFormat, true);
    }

    public FBTexture(FBTexture copy) {
        super(copy.address, copy.bufferWidth, copy.width, copy.height, copy.pixelFormat, copy.useViewportResize);
    }

    @Override
    public void bind(IRenderingEngine re, boolean forDrawing) {
        if (forDrawing) {
            re.bindFramebuffer(0, 0);
            super.bind(re, forDrawing);
        } else if (this.fboId == -1 || this.isResized()) {
            this.createFBO(re, forDrawing);
        } else {
            re.bindFramebuffer(0, this.fboId);
        }
    }

    protected void createFBO(IRenderingEngine re, boolean forDrawing) {
        if (this.fboId != -1) {
            re.deleteFramebuffer(this.fboId);
            this.fboId = -1;
        }
        if (this.depthTextureId != -1) {
            re.deleteTexture(this.depthTextureId);
            this.depthTextureId = -1;
        }
        this.fboId = re.genFramebuffer();
        re.bindFramebuffer(0, this.fboId);
        this.depthTextureId = re.genTexture();
        re.bindTexture(this.depthTextureId);
        re.setTexImage(0, 15, this.getTexImageWidth(), this.getTexImageHeight(), 15, 15, 0, null);
        re.setTextureMipmapMinFilter(0);
        re.setTextureMipmapMagFilter(0);
        re.setTextureMipmapMinLevel(0);
        re.setTextureMipmapMaxLevel(0);
        re.setTextureWrapMode(1, 1);
        super.bind(re, forDrawing);
        re.setFramebufferTexture(0, 3, this.textureId, 0);
        re.setFramebufferTexture(0, 0, this.depthTextureId, 0);
    }

    public int getDepthTextureId() {
        return this.depthTextureId;
    }

    @Override
    public void delete(IRenderingEngine re) {
        if (this.fboId != -1) {
            re.deleteFramebuffer(this.fboId);
            this.fboId = -1;
        }
        if (this.depthTextureId != -1) {
            re.deleteTexture(this.depthTextureId);
            this.depthTextureId = -1;
        }
        super.delete(re);
    }

    public void blitFrom(IRenderingEngine re, FBTexture src) {
        if (this.fboId == -1) {
            this.createFBO(re, false);
        }
        re.bindFramebuffer(1, src.fboId);
        re.bindFramebuffer(2, this.fboId);
        re.blitFramebuffer(0, 0, src.getResizedWidth(), src.getResizedHeight(), 0, 0, this.getResizedWidth(), this.getResizedHeight(), 1, 0);
        re.bindFramebuffer(0, src.fboId);
    }

    @Override
    public String toString() {
        return String.format("FBTexture[0x%08X-0x%08X, %dx%d, bufferWidth=%d, pixelFormat=%d(%s), textureId=%d, depthTextureId=%d, fboId=%d]", this.address, this.address + this.length, this.width, this.height, this.bufferWidth, this.pixelFormat, VideoEngine.getPsmName(this.pixelFormat), this.textureId, this.depthTextureId, this.fboId);
    }
}

