/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.textures;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import jpcsp.Memory;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.textures.Texture;
import jpcsp.util.CacheStatistics;
import org.apache.log4j.Logger;

public class TextureCache {
    public static final int cacheMaxSize = 1000;
    public static final float cacheLoadFactor = 0.75f;
    private static Logger log = VideoEngine.log;
    private static TextureCache instance = null;
    private LinkedHashMap<Integer, Texture> cache;
    public CacheStatistics statistics = new CacheStatistics("Texture", 1000);
    private Set<Integer> textureAlreadyHashed;
    private LinkedList<Texture> vramTextures = new LinkedList();

    public static TextureCache getInstance() {
        if (instance == null) {
            instance = new TextureCache();
        }
        return instance;
    }

    private TextureCache() {
        this.cache = new LinkedHashMap(1334, 0.75f, true);
        this.textureAlreadyHashed = new HashSet<Integer>();
    }

    private Integer getKey(int addr, int clutAddr, int clutStart, int clutMode) {
        int clutEntrySize = clutMode == 3 ? 4 : 2;
        return addr + clutAddr + (clutStart << 4) * clutEntrySize;
    }

    public boolean hasTexture(int addr, int clutAddr, int clutStart, int clutMode) {
        return this.cache.containsKey(this.getKey(addr, clutAddr, clutStart, clutMode));
    }

    private Texture getTexture(int addr, int clutAddr, int clutStart, int clutMode) {
        return this.cache.get(this.getKey(addr, clutAddr, clutStart, clutMode));
    }

    public void addTexture(IRenderingEngine re, Texture texture) {
        Iterator<Map.Entry<Integer, Texture>> it;
        Integer key = this.getKey(texture.getAddr(), texture.getClutAddr(), texture.getClutStart(), texture.getClutMode());
        Texture previousTexture = this.cache.get(key);
        if (previousTexture != null) {
            previousTexture.deleteTexture(re);
            this.vramTextures.remove(previousTexture);
        } else if (this.cache.size() >= 1000 && (it = this.cache.entrySet().iterator()).hasNext()) {
            Map.Entry<Integer, Texture> entry = it.next();
            Texture lruTexture = entry.getValue();
            lruTexture.deleteTexture(re);
            this.vramTextures.remove(lruTexture);
            it.remove();
            ++this.statistics.entriesRemoved;
        }
        this.cache.put(key, texture);
        if (this.isVramTexture(texture)) {
            this.vramTextures.add(texture);
        }
        if ((long)this.cache.size() > this.statistics.maxSizeUsed) {
            this.statistics.maxSizeUsed = this.cache.size();
        }
    }

    public Texture getTexture(int addr, int lineWidth, int width, int height, int pixelStorage, int clutAddr, int clutMode, int clutStart, int clutShift, int clutMask, int clutNumBlocks, int mipmapLevels, boolean mipmapShareClut, short[] values16, int[] values32) {
        ++this.statistics.totalHits;
        Texture texture = this.getTexture(addr, clutAddr, clutStart, clutMode);
        if (texture == null) {
            ++this.statistics.notPresentHits;
            return texture;
        }
        if (texture.equals(addr, lineWidth, width, height, pixelStorage, clutAddr, clutMode, clutStart, clutShift, clutMask, clutNumBlocks, mipmapLevels, mipmapShareClut, values16, values32)) {
            ++this.statistics.successfulHits;
            return texture;
        }
        ++this.statistics.changedHits;
        return null;
    }

    public void resetTextureAlreadyHashed() {
        this.textureAlreadyHashed.clear();
    }

    public boolean textureAlreadyHashed(int addr, int clutAddr, int clutStart, int clutMode) {
        return this.textureAlreadyHashed.contains(this.getKey(addr, clutAddr, clutStart, clutMode));
    }

    public void setTextureAlreadyHashed(int addr, int clutAddr, int clutStart, int clutMode) {
        this.textureAlreadyHashed.add(this.getKey(addr, clutAddr, clutStart, clutMode));
    }

    public void resetTextureAlreadyHashed(int addr, int clutAddr, int clutStart, int clutMode) {
        this.textureAlreadyHashed.remove(this.getKey(addr, clutAddr, clutStart, clutMode));
    }

    public void reset(IRenderingEngine re) {
        for (Texture texture : this.cache.values()) {
            texture.deleteTexture(re);
        }
        this.cache.clear();
        this.resetTextureAlreadyHashed();
    }

    private boolean isVramTexture(Texture texture) {
        return Memory.isVRAM(texture.getAddr());
    }

    public void deleteVramTextures(IRenderingEngine re, int addr, int length) {
        ListIterator lit = this.vramTextures.listIterator();
        while (lit.hasNext()) {
            Texture texture = (Texture)lit.next();
            if (!texture.isInsideMemory(addr, addr + length)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Delete VRAM texture inside GE %s", texture.toString()));
            }
            texture.deleteTexture(re);
            lit.remove();
            Integer key = this.getKey(texture.getAddr(), texture.getClutAddr(), texture.getClutStart(), texture.getClutMode());
            this.cache.remove(key);
            ++this.statistics.entriesRemoved;
        }
    }
}

