/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.hardware;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;
import java.util.Arrays;
import java.util.List;
import jpcsp.hardware.Battery;
import jpcsp.util.OS;

public class BatteryUpdateThread
extends Thread {
    private static BatteryUpdateThread instance = null;
    private long sleepMillis;

    public static void initialize() {
        if (instance == null) {
            long secondsForOnePercentDrain = Battery.getLifeTime() * 60 / 100;
            instance = new BatteryUpdateThread(secondsForOnePercentDrain * 1000L);
            instance.setDaemon(true);
            instance.setName("Battery Drain");
            instance.start();
        }
    }

    public BatteryUpdateThread(long sleepMillis) {
        this.sleepMillis = sleepMillis;
    }

    @Override
    public void run() {
        if (OS.isWindows) {
            this.updateWindows();
        } else if (OS.isLinux) {
            this.updateLinux();
        } else if (OS.isMac) {
            this.updateMac();
        } else {
            this.updateGeneric();
        }
    }

    private void updateWindows() {
        while (true) {
            BatteryWindows.Kernel32.SYSTEM_POWER_STATUS status = BatteryWindows.status();
            int batteryLifeTimeInSeconds = status.BatteryLifeTime;
            if (batteryLifeTimeInSeconds < 0) {
                batteryLifeTimeInSeconds = 18000;
            }
            Battery.setLifeTime(batteryLifeTimeInSeconds / 60);
            Battery.setPluggedIn(status.ACLineStatus == 1);
            Battery.setPresent((status.BatteryFlag & 0x80) != 0);
            byte percent = status.BatteryLifePercent;
            if (percent >= 0 && percent <= 100) {
                Battery.setCurrentPowerPercent(percent);
            }
            Battery.setCharging((status.BatteryFlag & 8) != 0);
            BatteryUpdateThread.sleepMillis(5000L);
        }
    }

    private static void sleepMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void updateLinux() {
        this.updateGeneric();
    }

    private void updateMac() {
        this.updateGeneric();
    }

    private void updateGeneric() {
        while (true) {
            BatteryUpdateThread.sleepMillis(this.sleepMillis);
            int powerPercent = Battery.getCurrentPowerPercent();
            if (Battery.isCharging()) {
                if (powerPercent < 100) {
                    ++powerPercent;
                }
            } else if (powerPercent > 0) {
                --powerPercent;
            }
            Battery.setCurrentPowerPercent(powerPercent);
        }
    }

    static class BatteryLinux {
        private static BatteryLinux INSTANCE = new BatteryLinux();
        private static String FOLDER = "/sys/class/power_supply/BAT0";

        BatteryLinux() {
        }

        public static BatteryLinux status() {
            return INSTANCE;
        }

        public static void refresh() {
        }
    }

    static class BatteryWindows {
        private static Kernel32.SYSTEM_POWER_STATUS result = new Kernel32.SYSTEM_POWER_STATUS();

        BatteryWindows() {
        }

        public static Kernel32.SYSTEM_POWER_STATUS status() {
            Kernel32.INSTANCE.GetSystemPowerStatus(result);
            return result;
        }

        public static interface Kernel32
        extends StdCallLibrary {
            public static final Kernel32 INSTANCE = (Kernel32)Native.loadLibrary((String)"Kernel32", Kernel32.class);

            public int GetSystemPowerStatus(SYSTEM_POWER_STATUS var1);

            public static class SYSTEM_POWER_STATUS
            extends Structure {
                public byte ACLineStatus;
                public byte BatteryFlag;
                public byte BatteryLifePercent;
                public byte Reserved1;
                public int BatteryLifeTime;
                public int BatteryFullLifeTime;

                protected List<String> getFieldOrder() {
                    return Arrays.asList("ACLineStatus", "BatteryFlag", "BatteryLifePercent", "Reserved1", "BatteryLifeTime", "BatteryFullLifeTime");
                }
            }
        }
    }
}

