/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.battery;

import java.util.HashSet;
import java.util.Set;
import jpcsp.memory.mmio.IMMIOHandler;
import jpcsp.memory.mmio.battery.MMIOHandlerBatteryFirmwareSfr;
import jpcsp.nec78k0.Nec78k0MMIOHandlerReadWrite;
import jpcsp.nec78k0.Nec78k0Memory;
import jpcsp.nec78k0.Nec78k0Processor;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class BatteryMemory
extends Nec78k0Memory {
    private static final int BASE_RAM_UNKNOWN = 0;
    private static final int SIZE_RAM_UNKNOWN = 1024;
    private static final int END_RAM_UNKNOWN = 1023;
    private final int[] ramUnknown = new int[256];
    private final Nec78k0MMIOHandlerReadWrite ramUnknownHandler = new Nec78k0MMIOHandlerReadWrite(0, 1024, this.ramUnknown);
    private final Set<Integer> ramKnown;

    public BatteryMemory(Logger log) {
        super(log, new MMIOHandlerBatteryFirmwareSfr(65280), 0, 65248);
        this.ramUnknownHandler.setLogger(log);
        this.ramUnknownHandler.setLogLevel(Level.WARN);
        this.ramKnown = new HashSet<Integer>();
    }

    @Override
    public void setProcessor(Nec78k0Processor processor) {
        this.ramUnknownHandler.setProcessor(processor);
        super.setProcessor(processor);
    }

    @Override
    protected IMMIOHandler getHandler(int address) {
        if (address >= 0 && address <= 1023 && !this.ramKnown.contains(address)) {
            return this.ramUnknownHandler;
        }
        return super.getHandler(address);
    }

    public void setRamKnown(int address) {
        this.ramKnown.add(address);
    }

    public void setRamKnown(int address, int size) {
        for (int i = 0; i < size; ++i) {
            this.setRamKnown(address + i);
        }
    }
}

