/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.syscon;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.RuntimeThread;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.sceSyscon;
import jpcsp.State;
import jpcsp.hardware.Battery;
import jpcsp.hardware.LED;
import jpcsp.hardware.MemoryStick;
import jpcsp.hardware.Model;
import jpcsp.hardware.UMDDrive;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.MMIOHandlerGpio;
import jpcsp.memory.mmio.battery.BatteryEmulator;
import jpcsp.memory.mmio.battery.BatteryToSysconSerialInterface;
import jpcsp.memory.mmio.syscon.SysconEmulator;
import jpcsp.memory.mmio.syscon.SysconToBatterySerialInterface;
import jpcsp.memory.mmio.wlan.MMIOHandlerWlan;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerSyscon
extends MMIOHandlerBase {
    public static Logger log = sceSyscon.log;
    private static final int STATE_VERSION = 0;
    private static MMIOHandlerSyscon instance;
    public static final int BASE_ADDRESS = -1101529088;
    public static final int PSP_SYSCON_RX_STATUS = 0;
    public static final int PSP_SYSCON_RX_LEN = 1;
    public static final int PSP_SYSCON_RX_RESPONSE = 2;
    public static final int PSP_SYSCON_TX_CMD = 0;
    public static final int PSP_SYSCON_TX_LEN = 1;
    public static final int PSP_SYSCON_TX_DATA = 2;
    public static final int BARYON_STATUS_AC_SUPPLY = 1;
    public static final int BARYON_STATUS_WLAN_POWER = 2;
    public static final int BARYON_STATUS_HR_POWER = 4;
    public static final int BARYON_STATUS_ALARM = 8;
    public static final int BARYON_STATUS_POWER_SWITCH = 16;
    public static final int BARYON_STATUS_LOW_BATTERY = 32;
    public static final int BARYON_STATUS_GSENSOR = 128;
    public static final int MAX_DATA_LENGTH = 16;
    private int[] data = new int[16];
    private int dataIndex;
    private boolean endDataIndex;
    private int error;
    private static final int NUMBER_INTERNAL_REGISTERS = 8;
    private final byte[][] internalRegisters = new byte[8][8];
    private SysconEmulator fw;
    private BatteryEmulator battery;

    public static MMIOHandlerSyscon getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerSyscon(-1101529088);
        }
        return instance;
    }

    private MMIOHandlerSyscon(int baseAddress) {
        super(baseAddress);
        if (BatteryEmulator.isEnabled()) {
            this.battery = new BatteryEmulator();
            this.battery.boot();
        }
        if (SysconEmulator.isEnabled()) {
            this.fw = new SysconEmulator();
            this.init(this.fw.getSysconSfr());
            this.fw.boot();
        }
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readInts(this.data);
        this.dataIndex = stream.readInt();
        this.endDataIndex = stream.readBoolean();
        this.error = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInts(this.data);
        stream.writeInt(this.dataIndex);
        stream.writeBoolean(this.endDataIndex);
        stream.writeInt(this.error);
        super.write(stream);
    }

    public BatteryEmulator getBatteryEmulator() {
        return this.battery;
    }

    public void init(Nec78k0Sfr sfr) {
        if (this.battery != null) {
            sfr.getSerialInterfaceUART6().setSerialInterface(new SysconToBatterySerialInterface(sfr, sfr.getSerialInterfaceUART6(), this.battery.getBatterySfr()));
            this.battery.getBatterySfr().getSerialInterfaceUART6().setSerialInterface(new BatteryToSysconSerialInterface(this.battery.getBatterySfr(), this.battery.getBatterySfr().getSerialInterfaceUART6(), sfr));
        }
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.data, 0);
        this.dataIndex = 0;
        this.endDataIndex = false;
        this.error = 0;
    }

    public void clearData() {
        Arrays.fill(this.data, 0);
        this.endDataIndex = false;
    }

    public void setDataValue(int offset, int value) {
        this.data[offset] = value & 0xFF;
    }

    private void addHashValue() {
        int hash = 0;
        int length = this.data[1];
        for (int i = 0; i < length; ++i) {
            hash = hash + this.data[i] & 0xFF;
        }
        this.data[length] = ~hash & 0xFF;
    }

    private int[] addResponseData16(int[] responseData, int value) {
        responseData = Utilities.add(responseData, value & 0xFF);
        responseData = Utilities.add(responseData, value >> 8 & 0xFF);
        return responseData;
    }

    private int[] addResponseData32(int[] responseData, int value) {
        responseData = Utilities.add(responseData, value & 0xFF);
        responseData = Utilities.add(responseData, value >> 8 & 0xFF);
        responseData = Utilities.add(responseData, value >> 16 & 0xFF);
        responseData = Utilities.add(responseData, value >> 24 & 0xFF);
        return responseData;
    }

    private int getData32(int[] responseData, int offset) {
        int value = responseData[offset] & 0xFF;
        value |= (responseData[offset + 1] & 0xFF) << 8;
        value |= (responseData[offset + 2] & 0xFF) << 16;
        return value |= (responseData[offset + 3] & 0xFF) << 24;
    }

    private int getData24(int[] responseData, int offset) {
        int value = responseData[offset] & 0xFF;
        value |= (responseData[offset + 1] & 0xFF) << 8;
        return value |= (responseData[offset + 2] & 0xFF) << 16;
    }

    private int getBaryonStatus() {
        int baryonStatus = 0;
        baryonStatus |= 1;
        baryonStatus |= 2;
        return baryonStatus |= 0x10;
    }

    private int[] addButtonsResponseData(int[] responseData, boolean kernel) {
        int buttons = State.controller.getButtons();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("addButtonsResponseData buttons=0x%08X", buttons));
        }
        responseData = Utilities.add(responseData, ((buttons ^= kernel ? 553120761 : 521209) & 0xF000) >> 8 | (buttons & 0xF0) >> 4);
        responseData = Utilities.add(responseData, (buttons & 0xF0000) >> 12 | (buttons & 0x300) >> 7 | buttons & 9);
        if (kernel) {
            responseData = Utilities.add(responseData, (buttons & 0xBF00000) >> 20);
            responseData = Utilities.add(responseData, (buttons & 0x30000000) >> 28);
        }
        return responseData;
    }

    private int[] addAnalogResponseData(int[] responseData) {
        int lx = State.controller.getLx();
        int ly = State.controller.getLy();
        if (Modules.sceCtrlModule.isModeDigital()) {
            lx = -128;
            ly = -128;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("addAnalogResponseData lx=0x%02X, ly=0x%02X", lx & 0xFF, ly & 0xFF));
        }
        responseData = Utilities.add(responseData, lx & 0xFF);
        responseData = Utilities.add(responseData, ly & 0xFF);
        return responseData;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void startSysconCmd() {
        int cmd = this.data[0];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("startSysconCmd cmd=0x%02X(%s), %s", cmd, sceSyscon.getSysconCmdName(cmd), this.toString(this.data[1] + 1)));
        }
        if (this.fw != null) {
            this.fw.startSysconCmd(this.data);
            return;
        }
        int[] responseData = new int[]{130};
        MMIOHandlerGpio.getInstance().clearPort(4);
        block0 : switch (cmd) {
            case 0: {
                break;
            }
            case 75: {
                UMDDrive.setUmdPower(this.data[2] != 0);
                break;
            }
            case 50: {
                int device = this.data[2] & 0x3F;
                boolean resetMode1 = (this.data[2] & 0x80) != 0;
                boolean resetMode2 = (this.data[2] & 0x40) != 0;
                switch (device) {
                    case 2: {
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)String.format("PSP_SYSCON_CMD_RESET_DEVICE device=0x%X(UMD Drive), reset=%b", device, resetMode1));
                        break;
                    }
                    case 4: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("PSP_SYSCON_CMD_RESET_DEVICE device=0x%X(WLAN), reset=%b", device, resetMode1));
                        }
                        if (!resetMode1) break;
                        MMIOHandlerWlan.getInstance().reset();
                        break;
                    }
                    case 1: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("PSP_SYSCON_CMD_RESET_DEVICE device=0x%X(PSP), resetMode1=%b, resetMode2=%b", device, resetMode1, resetMode2));
                        }
                        Emulator.getScheduler().addAction(new ResetAction());
                        break;
                    }
                    default: {
                        log.error((Object)String.format("PSP_SYSCON_CMD_RESET_DEVICE unimplemented device=0x%X, reset=%b", device, resetMode1));
                        break;
                    }
                }
                break;
            }
            case 2: {
                State.controller.hleControllerPoll();
                responseData = this.addButtonsResponseData(responseData, false);
                break;
            }
            case 3: {
                State.controller.hleControllerPoll();
                responseData = this.addAnalogResponseData(responseData);
                break;
            }
            case 5: {
                responseData = this.addResponseData32(responseData, Modules.sceSysconModule.getTachyonTemp());
                break;
            }
            case 6: {
                State.controller.hleControllerPoll();
                responseData = this.addButtonsResponseData(responseData, false);
                responseData = this.addAnalogResponseData(responseData);
                break;
            }
            case 7: {
                State.controller.hleControllerPoll();
                responseData = this.addButtonsResponseData(responseData, true);
                break;
            }
            case 8: {
                State.controller.hleControllerPoll();
                responseData = this.addButtonsResponseData(responseData, true);
                responseData = this.addAnalogResponseData(responseData);
                break;
            }
            case 51: {
                Modules.sceCtrlModule.setSamplingMode(this.data[2]);
                break;
            }
            case 71: {
                int led;
                boolean setOn;
                int flag = this.data[2];
                if (Model.getModel() == 4) {
                    setOn = (flag & 1) != 0;
                    led = flag & 0xF0;
                } else {
                    setOn = (flag & 0x10) != 0;
                    led = flag & 0xE0;
                }
                switch (led) {
                    case 64: {
                        LED.setLedMemoryStickOn(setOn);
                        break block0;
                    }
                    case 128: {
                        LED.setLedWlanOn(setOn);
                        break block0;
                    }
                    case 32: {
                        LED.setLedPowerOn(setOn);
                        break block0;
                    }
                    case 16: {
                        LED.setLedBluetoothOn(setOn);
                        break block0;
                    }
                }
                log.warn((Object)String.format("startSysconCmd PSP_SYSCON_CMD_CTRL_LED unknown flag value 0x%02X", flag));
                break;
            }
            case 38: {
                int parameterId = 0;
                if (this.data[1] >= 3) {
                    parameterId = this.data[2];
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("startSysconCmd PSP_SYSCON_CMD_RECEIVE_SETPARAM parameterId=0x%X", parameterId));
                }
                responseData = this.addResponseData16(responseData, Modules.scePowerModule.scePowerGetForceSuspendCapacity());
                for (int i = 2; i < 8; ++i) {
                    responseData = Utilities.add(responseData, 0);
                }
                break;
            }
            case 37: {
                int parameterId = 0;
                if (this.data[1] >= 11) {
                    parameterId = this.data[12];
                }
                int forceSuspendCapacity = this.data[2];
                forceSuspendCapacity |= this.data[3] << 8;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("startSysconCmd PSP_SYSCON_CMD_SEND_SETPARAM parameterId=0x%X, forceSuspendCapacity=0x%X", parameterId, forceSuspendCapacity));
                break;
            }
            case 52: {
                boolean power = this.data[2] != 0;
                Modules.sceSysconModule.sceSysconCtrlHRPower(power);
                break;
            }
            case 77: {
                boolean power = this.data[2] != 0;
                Modules.sceSysconModule.sceSysconCtrlWlanPower(power);
                break;
            }
            case 11: {
                responseData = this.addResponseData32(responseData, Modules.sceSysconModule.getPowerSupplyStatus());
                break;
            }
            case 97: {
                responseData = this.addResponseData16(responseData, Modules.sceSysconModule.getBatteryStatusCap1());
                responseData = this.addResponseData16(responseData, Modules.sceSysconModule.getBatteryStatusCap2());
                break;
            }
            case 103: {
                responseData = this.addResponseData32(responseData, Battery.getFullCapacity());
                break;
            }
            case 107: {
                responseData = this.addResponseData32(responseData, Modules.sceSysconModule.getBatteryCycle());
                break;
            }
            case 105: {
                responseData = this.addResponseData32(responseData, Modules.sceSysconModule.getBatteryLimitTime());
                break;
            }
            case 98: {
                responseData = this.addResponseData32(responseData, Battery.getTemperature());
                break;
            }
            case 100: {
                responseData = this.addResponseData32(responseData, Modules.sceSysconModule.getBatteryElec());
                break;
            }
            case 99: {
                responseData = this.addResponseData32(responseData, Battery.getVoltage());
                break;
            }
            case 1: {
                responseData = this.addResponseData32(responseData, Model.getBaryonVersion());
                break;
            }
            case 64: {
                responseData = this.addResponseData32(responseData, Model.getPommelVersion());
                break;
            }
            case 70: {
                responseData = this.addResponseData32(responseData, Modules.sceSysconModule.getPowerStatus());
                break;
            }
            case 17: {
                int[] timeStamp = Modules.sceSysconModule.getTimeStamp();
                for (int i = 0; i < timeStamp.length; ++i) {
                    responseData = Utilities.add(responseData, timeStamp[i] & 0xFF);
                }
                break;
            }
            case 36: {
                int src = (this.data[2] & 0xFC) >> 2;
                int size = 1 << (this.data[2] & 3);
                int[] values = new int[size];
                Modules.sceSysconModule.readScratchpad(src, values, size);
                for (int i = 0; i < size; ++i) {
                    responseData = Utilities.add(responseData, values[i] & 0xFF);
                }
                break;
            }
            case 35: {
                int dst = (this.data[2] & 0xFC) >> 2;
                int size = 1 << (this.data[2] & 3);
                int[] values = new int[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.data[3 + i];
                }
                Modules.sceSysconModule.writeScratchpad(dst, values, size);
                break;
            }
            case 9: {
                responseData = this.addResponseData32(responseData, Modules.sceSysconModule.readClock());
                break;
            }
            case 32: {
                int clock = this.getData32(this.data, 2);
                Modules.sceSysconModule.writeClock(clock);
                break;
            }
            case 10: {
                responseData = this.addResponseData32(responseData, Modules.sceSysconModule.readAlarm());
                break;
            }
            case 34: {
                int alarm = this.getData32(this.data, 2);
                Modules.sceSysconModule.writeAlarm(alarm);
                break;
            }
            case 76: {
                boolean power = this.getData32(this.data, 2) != 0;
                MemoryStick.setMsPower(power);
                break;
            }
            case 69: {
                int unknown = this.getData24(this.data, 2);
                Modules.sceSysconModule.sceSysconCtrlPower(unknown & 0x3FFFFF, unknown >> 23 & 1);
                break;
            }
            case 66: {
                int unknown = this.getData24(this.data, 2);
                Modules.sceSysconModule.sceSysconCtrlVoltage(unknown & 0xFF, unknown >> 8 & 0xFFFF);
                break;
            }
            case 16: {
                break;
            }
            case 53: {
                log.info((Object)"Shutdown PSP");
                Emulator.PauseEmuWithStatus(1024);
                break;
            }
            case 54: {
                int unknown = this.data[2];
                log.info((Object)"Suspend PSP");
                Emulator.PauseEmuWithStatus(2048);
                break;
            }
            case 48: {
                if (Model.getGeneration() < 2) {
                    responseData = new int[]{132};
                    break;
                }
                int length = this.data[1] - 3;
                int registerAndFlag = this.data[2];
                int register = registerAndFlag & 0x7F;
                if (register > 8) {
                    log.error((Object)String.format("startSysconCmd: unknown cmd=0x%02X(%s), %s", cmd, sceSyscon.getSysconCmdName(cmd), this));
                    break;
                }
                if (Utilities.hasFlag(registerAndFlag, 128)) {
                    if (length <= this.internalRegisters[register].length) {
                        for (int i = 0; i < length; ++i) {
                            this.internalRegisters[register][i] = (byte)this.data[3 + i];
                        }
                        break;
                    } else {
                        log.error((Object)String.format("startSysconCmd: unknown cmd=0x%02X(%s), %s", cmd, sceSyscon.getSysconCmdName(cmd), this));
                        break;
                    }
                }
                responseData = Utilities.add(responseData, 0);
                for (int i = 0; i < this.internalRegisters[register].length; ++i) {
                    responseData = Utilities.add(responseData, this.internalRegisters[register][i] & 0xFF);
                }
                break;
            }
            case 115: {
                if (Model.getBaryonVersion() >= 0x230000) {
                    responseData = new int[]{132};
                    break;
                }
                int address = this.data[2] << 1;
                Battery.writeEeprom(address + 0, this.data[3]);
                Battery.writeEeprom(address + 1, this.data[4]);
                break;
            }
            case 116: {
                int address = this.data[2] << 1;
                responseData = Utilities.add(responseData, 0);
                responseData = Utilities.add(responseData, Battery.readEeprom(address + 0));
                responseData = Utilities.add(responseData, Battery.readEeprom(address + 1));
                break;
            }
            case 49: {
                int tachyonWatchdogTimer = this.data[2];
                Modules.sceSysconModule.sceSysconCtrlTachyonWDT(tachyonWatchdogTimer);
                break;
            }
            case 14: {
                int unknown = 1216;
                responseData = this.addResponseData16(responseData, unknown &= 0xFFFFFF7F);
                break;
            }
            case 15: {
                responseData = Utilities.add(responseData, 255);
                break;
            }
            case 13: {
                responseData = Utilities.add(responseData, 0);
                break;
            }
            default: {
                log.error((Object)String.format("startSysconCmd: unknown cmd=0x%02X(%s), %s", cmd, sceSyscon.getSysconCmdName(cmd), this));
            }
        }
        this.setResponseData(this.getBaryonStatus(), responseData, 0, responseData.length);
        this.endSysconCmd();
    }

    private void endSysconCmd() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("endSysconCmd %s", this));
        }
        MMIOHandlerGpio.getInstance().setPort(4);
    }

    public void setEndOfData() {
        this.endDataIndex = false;
    }

    public void setResponseData(int status, int[] responseData, int offset, int length) {
        this.clearData();
        if (length >= 0 && length <= 13) {
            this.setDataValue(0, status);
            this.setDataValue(1, length + 2);
            for (int i = 0; i < length; ++i) {
                this.setDataValue(2 + i, responseData[offset + i]);
            }
            this.addHashValue();
        }
    }

    private int readData16() {
        int value = (this.data[this.dataIndex++] & 0xFF) << 8 | this.data[this.dataIndex++] & 0xFF;
        if (this.dataIndex > this.data[1]) {
            this.dataIndex = 0;
            this.endDataIndex = true;
        }
        return value;
    }

    private void writeData16(int value) {
        this.data[this.dataIndex++] = value >> 8 & 0xFF;
        this.data[this.dataIndex++] = value & 0xFF;
        if (this.dataIndex >= 16) {
            this.dataIndex = 0;
            this.endDataIndex = true;
        }
    }

    private int getFlags0C() {
        int flags = 0;
        if (!this.endDataIndex) {
            flags |= 4;
        }
        if (this.error == 0) {
            flags |= 1;
        }
        return flags;
    }

    private void setFlags04(int flags) {
        if ((flags & 4) != 0) {
            this.dataIndex = 0;
            this.endDataIndex = true;
        }
        if ((flags & 2) != 0) {
            this.startSysconCmd();
        } else {
            MMIOHandlerGpio.getInstance().clearPort(4);
        }
    }

    private int getFlags04() {
        return 0;
    }

    private void setFlags20(int flags) {
        if ((flags & 3) != 0) {
            this.error = 0;
        }
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 4: {
                value = this.getFlags04();
                break;
            }
            case 8: {
                value = this.readData16();
                break;
            }
            case 12: {
                value = this.getFlags0C();
                break;
            }
            case 24: {
                value = 0;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                if (value == 207) break;
                super.write32(address, value);
                break;
            }
            case 4: {
                this.setFlags04(value);
                break;
            }
            case 8: {
                this.writeData16(value);
                break;
            }
            case 20: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 32: {
                this.setFlags20(value);
                break;
            }
            case 36: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    public String toString(int length) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("MMIOHandlerSyscon dataIndex=0x%X, data: [", this.dataIndex));
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(String.format("0x%02X", this.data[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("MMIOHandlerSyscon dataIndex=0x%X, data: [", this.dataIndex));
        for (int i = 0; i < 16; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(String.format("0x%02X", this.data[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    private static class ResetAction
    implements IAction {
        private ResetAction() {
        }

        @Override
        public void execute() {
            log.info((Object)"Reset PSP");
            Emulator.getProcessor().enableInterrupts();
            RuntimeThread runtimeThread = RuntimeContext.getRuntimeThread();
            if (runtimeThread != null) {
                runtimeThread.setInSyscall(true);
            }
            Modules.scePowerModule.scePowerRequestColdReset(0);
        }
    }
}

