/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.syscon;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.hardware.Model;
import jpcsp.memory.mmio.syscon.MMIOHandlerSysconFirmwareSfr;
import jpcsp.memory.mmio.syscon.SysconMemory;
import jpcsp.nec78k0.Nec78k0Interpreter;
import jpcsp.nec78k0.Nec78k0Memory;
import jpcsp.nec78k0.Nec78k0Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class SysconEmulator {
    public static Logger log = Logger.getLogger((String)"syscon");
    public static boolean firmwareBootloader = false;
    private static final int firmwareBootloaderCodeLength = 8192;
    private static final int firmwareBootloaderCodeOffset = 32768;
    private static final int firmwareBootloaderAddress = 32768;
    private static final String firmwareBootloaderFileName = "TA-086_Full.bin";
    private final Nec78k0Memory mem = new SysconMemory(log);
    private final Nec78k0Processor processor = new Nec78k0Processor(this.mem);
    private final Nec78k0Interpreter interpreter = new Nec78k0Interpreter(this.processor);
    private SysconProcessorThread thread;
    private volatile boolean exit;
    private static boolean isEnabled;
    private static int initializedModel;

    public static String getFirmwareFileName() {
        switch (Model.getModel()) {
            case 1: {
                return "TA-085_Full.bin";
            }
            case 0: {
                return firmwareBootloaderFileName;
            }
            case 2: {
                return "TA-090_Full.bin";
            }
            case 4: {
                return "TA-091_Full.bin";
            }
            case 3: {
                return "TA-093_Full.bin";
            }
            case 5: 
            case 6: {
                return "TA-095_Full.bin";
            }
            case 7: {
                return "TA-096_Full.bin";
            }
        }
        return String.format("syscon_%02dg.bin", Model.getGeneration());
    }

    public static void disable() {
        initializedModel = Model.getModel();
        isEnabled = false;
    }

    public static boolean isEnabled() {
        if (initializedModel != Model.getModel()) {
            File firmwareFile = new File(SysconEmulator.getFirmwareFileName());
            isEnabled = firmwareFile.canRead() && firmwareFile.length() >= 49152L;
            initializedModel = Model.getModel();
        }
        return isEnabled;
    }

    public static void load(Nec78k0Memory mem) {
        if (firmwareBootloader) {
            log.info((Object)String.format("Loading the bootloader code from %s at address 0x%04X for %s", firmwareBootloaderFileName, 0, Model.getModelName()));
            try {
                File inputFile = new File(firmwareBootloaderFileName);
                byte[] buffer = new byte[8192];
                FileInputStream is = new FileInputStream(inputFile);
                ((InputStream)is).skip(32768L);
                int length = ((InputStream)is).read(buffer);
                ((InputStream)is).close();
                for (int i = 0; i < length; i += 4) {
                    mem.write32(i, Utilities.readUnaligned32(buffer, i));
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        } else {
            String firmwareFileName = SysconEmulator.getFirmwareFileName();
            log.info((Object)String.format("Loading the syscon firmware from %s for %s", firmwareFileName, Model.getModelName()));
            File inputFile = new File(firmwareFileName);
            byte[] buffer = new byte[(int)inputFile.length()];
            int length = buffer.length;
            try {
                FileInputStream is = new FileInputStream(inputFile);
                length = ((InputStream)is).read(buffer);
                ((InputStream)is).close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            int baseAddress = 0;
            length = Math.min(length, 65247);
            for (int i = 0; i < length; i += 4) {
                mem.write32(baseAddress + i, Utilities.readUnaligned32(buffer, i));
            }
            SysconEmulator.loadBootloader(mem);
        }
    }

    public static void loadBootloader(Nec78k0Memory mem) {
        if (mem.internalRead32(32768) == -1 || mem.internalRead32(32768) == 0) {
            log.info((Object)String.format("Loading the bootloader code from %s at address 0x%04X", firmwareBootloaderFileName, 32768));
            try {
                FileInputStream is = new FileInputStream(firmwareBootloaderFileName);
                ((InputStream)is).skip(32768L);
                byte[] buffer = new byte[8192];
                int length = ((InputStream)is).read(buffer, 0, 8192);
                ((InputStream)is).close();
                for (int i = 0; i < length; i += 4) {
                    mem.write32(32768 + i, Utilities.readUnaligned32(buffer, i));
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    public void boot() {
        if (this.thread == null) {
            this.thread = new SysconProcessorThread();
            this.thread.setName("Syscon NEC 78k0 Processor Thread");
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            log.error((Object)String.format("SysconEmulator.boot() SysconProcessorThread already running", new Object[0]));
        }
    }

    public void exit() {
        this.exit = true;
        this.interpreter.exitInterpreter();
        while (this.thread != null) {
            Utilities.sleep(1, 0);
        }
    }

    public MMIOHandlerSysconFirmwareSfr getSysconSfr() {
        return (MMIOHandlerSysconFirmwareSfr)this.mem.getSfr();
    }

    public void startSysconCmd(int[] data) {
        this.getSysconSfr().startSysconCmd(data);
    }

    static {
        initializedModel = -1;
    }

    private class SysconProcessorThread
    extends Thread {
        private SysconProcessorThread() {
        }

        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            SysconEmulator.load(SysconEmulator.this.mem);
            SysconEmulator.this.processor.reset();
            while (!Emulator.pause && !SysconEmulator.this.exit) {
                SysconEmulator.this.interpreter.run();
            }
            SysconEmulator.this.thread = null;
        }
    }
}

