/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.syscon;

import jpcsp.HLE.modules.sceSyscon;
import jpcsp.nec78k0.sfr.Nec78k0SerialInterface;
import jpcsp.nec78k0.sfr.Nec78k0SerialInterfaceUART6;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;

public class SysconToBatterySerialInterface
extends Nec78k0SerialInterface {
    private final Nec78k0Sfr batterySfr;

    public SysconToBatterySerialInterface(Nec78k0Sfr sfr, Nec78k0SerialInterfaceUART6 serialInterface, Nec78k0Sfr batterySfr) {
        super(sfr, serialInterface);
        this.batterySfr = batterySfr;
    }

    private Nec78k0SerialInterface getBatterySerialInterface() {
        return this.batterySfr.getSerialInterfaceUART6().getConnectedSerialInterface();
    }

    private void avoidSysconTimeout() {
        if (this.sfr.getTimer50().getClockSelection() == 7) {
            this.sfr.getTimer50().setClockStep(100000000);
        }
    }

    @Override
    public synchronized void startTransmission() {
        this.getBatterySerialInterface().startReception();
        this.avoidSysconTimeout();
        super.startTransmission();
    }

    @Override
    public synchronized void transmit(int value) {
        this.getBatterySerialInterface().received(value);
        super.transmit(value);
    }

    private void debugSysconCmdBattery() {
        int length = this.transmissionBuffer.peek(1);
        int sysconCmdBattery = 96 + this.transmissionBuffer.peek(2);
        switch (sysconCmdBattery) {
            case 224: {
                if (length == 11) {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("UART6 Battery command %s, keyId=0x%02X, challenge=%s", sceSyscon.getSysconCmdName(sysconCmdBattery), this.transmissionBuffer.peek(3), this.transmissionBuffer.toString(8, 4, 8)));
                    break;
                }
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("UART6 Battery command %s: %s", sceSyscon.getSysconCmdName(sysconCmdBattery), this.transmissionBuffer.toString(8)));
                break;
            }
            default: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("UART6 Battery command %s: %s", sceSyscon.getSysconCmdName(sysconCmdBattery), this.transmissionBuffer.toString(8)));
            }
        }
    }

    @Override
    public synchronized void endTransmission() {
        super.endTransmission();
        if (this.transmissionBuffer.peek(0) == 90) {
            this.debugSysconCmdBattery();
        }
        this.transmissionBuffer.clear();
    }
}

