/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.umd;

import jpcsp.HLE.modules.sceAta;
import jpcsp.memory.mmio.MMIOHandlerBaseAta;
import jpcsp.memory.mmio.umd.MMIOHandlerUmd;

public class MMIOHandlerUmdAta
extends MMIOHandlerBaseAta {
    private static MMIOHandlerUmdAta instance;
    public static final int BASE_ADDRESS = -1116733440;

    public static MMIOHandlerUmdAta getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerUmdAta(-1116733440);
        }
        return instance;
    }

    private MMIOHandlerUmdAta(int baseAddress) {
        super(baseAddress);
        this.log = sceAta.log;
    }

    @Override
    protected int getInterruptNumber() {
        return 5;
    }

    @Override
    protected boolean supportsCmdPacket() {
        return true;
    }

    @Override
    protected void executeCommand(int command, int[] data, int dataLength, int totalDataLength, boolean firstCommand) {
        this.log.error((Object)String.format("MMIOHandlerUmdAta.executeCommand unimplemented command 0x%X", command));
    }

    @Override
    protected void executePacketCommand(int[] data) {
        int operationCode = data[0];
        switch (operationCode) {
            case 18: {
                int allocationLength = data[4];
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("ATA_CMD_OP_INQUIRY allocationLength=0x%X", allocationLength));
                }
                this.prepareDataInit(allocationLength);
                this.prepareData8(5);
                this.prepareData8(128);
                this.prepareData8(0);
                this.prepareData8(50);
                this.prepareData8(92);
                this.prepareData8(0);
                this.prepareData8(0);
                this.prepareData8(0);
                this.prepareData("SCEI    ");
                this.prepareData("UMD ROM DRIVE   ");
                this.prepareData("    ");
                this.prepareData("1.090 Oct18 ,2004   ");
                this.prepareDataEndWithDelay(allocationLength, allocationLength, 2000);
                break;
            }
            case 0: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("ATA_CMD_OP_TEST_UNIT_READY", new Object[0]));
                }
                this.commandCompletedWithDelay(1000);
                break;
            }
            case 3: {
                int allocationLength = data[4];
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("ATA_CMD_OP_REQUEST_SENSE allocationLength=0x%X", allocationLength));
                }
                this.prepareDataInit(allocationLength);
                boolean mediumPresent = MMIOHandlerUmd.getInstance().hasUmdInserted();
                this.prepareData8(128);
                this.prepareData8(0);
                if (mediumPresent) {
                    this.prepareData8(0);
                } else {
                    this.prepareData8(2);
                }
                this.prepareData32(0);
                this.prepareData8(10);
                this.prepareData32(0);
                if (mediumPresent) {
                    this.prepareData8(0);
                    this.prepareData8(0);
                } else {
                    this.prepareData8(58);
                    this.prepareData8(2);
                }
                this.prepareData8(0);
                this.prepareData8(0);
                this.prepareData8(0);
                this.prepareData8(0);
                this.prepareDataEndWithDelay(allocationLength, allocationLength, 2000);
                break;
            }
            case 173: {
                int allocationLength = data[9] | data[8] << 8;
                int formatCode = data[7];
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("ATA_CMD_OP_READ_STRUCTURE formatCode=0x%X, allocationLength=0x%X", formatCode, allocationLength));
                }
                int returnLength = allocationLength + 4;
                this.prepareDataInit(returnLength);
                int delayUs = 0;
                switch (formatCode) {
                    case 0: {
                        int numberOfSectors = 921600;
                        int startingSectorNumber = 196608;
                        int endSectorNumber = 0x110FFF;
                        this.prepareData16(allocationLength + 4);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(128);
                        this.prepareData8(0);
                        this.prepareData8(1);
                        this.prepareData8(224);
                        this.prepareData8(0);
                        this.prepareData24(196608);
                        this.prepareData8(0);
                        this.prepareData24(0x110FFF);
                        this.prepareData8(0);
                        this.prepareData24(0);
                        this.prepareData8(0);
                        this.prepareData8(7);
                        for (int i = 22; i < returnLength; ++i) {
                            this.prepareData8(0);
                        }
                        delayUs = 6000;
                        break;
                    }
                    default: {
                        this.log.error((Object)String.format("ATA_CMD_OP_READ_STRUCTURE unknown formatCode=0x%X", formatCode));
                    }
                }
                this.prepareDataEndWithDelay(returnLength, returnLength, delayUs);
                break;
            }
            case 240: {
                int unknown = data[1];
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("ATA_CMD_OP_UNKNOWN_F0 unknown=0x%X", unknown));
                }
                int allocationLength = 1;
                this.prepareDataInit(allocationLength);
                this.prepareData8(8);
                this.prepareDataEnd(allocationLength, allocationLength);
                break;
            }
            case 90: {
                int allocationLength = data[8] | data[7] << 8;
                int pageCode = data[2] & 0x3F;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("ATA_CMD_OP_MODE_SENSE_BIG pageCode=0x%X, allocationLength=0x%X", pageCode, allocationLength));
                }
                this.prepareDataInit(allocationLength);
                int delayUs = 0;
                switch (pageCode) {
                    case 26: {
                        this.prepareData16(26);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(154);
                        this.prepareData8(18);
                        this.prepareData8(0);
                        this.prepareData8(2);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(6);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(4);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(0);
                        this.prepareData8(4);
                        delayUs = 2000;
                        break;
                    }
                    default: {
                        this.log.error((Object)String.format("ATA_CMD_OP_MODE_SENSE_BIG unknown pageCode=0x%X", pageCode));
                    }
                }
                this.prepareDataEndWithDelay(allocationLength, allocationLength, delayUs);
                break;
            }
            case 85: {
                int parameterListLength = data[8] | data[7] << 8;
                int unknown = data[1];
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("ATA_CMD_OP_MODE_SELECT_BIG parameterListLength=0x%X, unknown=0x%X", parameterListLength, unknown));
                }
                this.preparePacketCommandParameterList(parameterListLength, operationCode);
                break;
            }
            case 241: {
                int unknown = data[7] | data[6] << 8;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("ATA_CMD_OP_UNKNOWN_F1 unknown=0x%X", unknown));
                }
                this.prepareDataInit(0);
                this.prepareDataEnd(0, 0);
                break;
            }
            case 247: {
                int unknown = data[2];
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("ATA_CMD_OP_UNKNOWN_F7 unknown=0x%X", unknown));
                }
                this.commandCompleted();
                break;
            }
            case 252: {
                int allocationLength = data[8] | data[7] << 8;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("ATA_CMD_OP_UNKNOWN_FC allocationLength=0x%X", allocationLength));
                }
                this.prepareDataInit(allocationLength);
                for (int i = 0; i < allocationLength; ++i) {
                    this.prepareData8(0);
                }
                this.prepareDataEnd(allocationLength, allocationLength);
                break;
            }
            case 40: {
                int logicalBlockAddress = data[5] | data[4] << 8 | data[3] << 16 | data[2] << 24;
                int numberOfSectorsToTransfer = data[8] | data[7] << 8;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("ATA_CMD_OP_READ_BIG logicalBlockAddress=0x%X, numberOfSectorsToTransfer=0x%X", logicalBlockAddress, numberOfSectorsToTransfer));
                }
                this.setLogicalBlockAddress(logicalBlockAddress);
                this.prepareDataInit(0);
                this.prepareDataEndWithDelay(0, 0, 1000);
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerUmdAta.executePacketCommand unknown operation code 0x%02X(%s)", operationCode, MMIOHandlerUmdAta.getOperationCodeName(operationCode)));
            }
        }
    }

    private void executePacketCommandParameterList(int operationCode, int[] data) {
        switch (operationCode) {
            case 85: {
                int pageCode = data[0] & 0x3F;
                int pageLength = data[1];
                if (pageCode != 0) {
                    this.log.error((Object)String.format("ATA_CMD_OP_MODE_SELECT_BIG parameter unknown pageCode=0x%X", pageCode));
                }
                if (pageLength != 26) {
                    this.log.error((Object)String.format("ATA_CMD_OP_MODE_SELECT_BIG parameter unknown pageLength=0x%X", pageLength));
                }
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("ATA_CMD_OP_MODE_SELECT_BIG parameters pageCode=0x%X, pageLength=0x%X", pageCode, pageLength));
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerBaseAta.executePacketCommandParameterList unknown operation code 0x%02X(%s)", operationCode, MMIOHandlerUmdAta.getOperationCodeName(operationCode)));
            }
        }
        this.commandCompleted();
    }

    @Override
    protected void executeCommandWithData(int command, int pendingOperationCodeParameters, int[] data, int dataLength, boolean firstCommand, boolean lastCommand) {
        switch (command) {
            case 160: {
                if (pendingOperationCodeParameters < 0) {
                    this.executePacketCommand(data);
                    break;
                }
                this.executePacketCommandParameterList(pendingOperationCodeParameters, data);
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerUmdAta.executeCommandWithData unknown command 0x%X(%s)", command, MMIOHandlerUmdAta.getCommandName(command)));
            }
        }
    }
}

