/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wlan;

import jpcsp.arm.ARMInterpreter;
import jpcsp.arm.ARMMemory;
import jpcsp.arm.ARMProcessor;
import jpcsp.memory.mmio.wlan.threadx.hle.TXManager;
import org.apache.log4j.Logger;

public class WlanEmulator {
    public static Logger log = Logger.getLogger((String)"arm");
    private static WlanEmulator instance;
    private final ARMMemory mem = new ARMMemory(log);
    private final ARMProcessor processor = new ARMProcessor(this.mem);
    private final ARMInterpreter interpreter = new ARMInterpreter(this.processor);
    private final TXManager txManager = new TXManager();
    private ARMProcessorThread thread;

    public static WlanEmulator getInstance() {
        if (instance == null) {
            instance = new WlanEmulator();
        }
        return instance;
    }

    private WlanEmulator() {
    }

    public ARMInterpreter getInterpreter() {
        return this.interpreter;
    }

    public ARMProcessor getProcessor() {
        return this.processor;
    }

    public ARMMemory getMemory() {
        return this.mem;
    }

    public TXManager getTxManager() {
        return this.txManager;
    }

    public void bootFromThread() {
        this.txManager.installHLECalls(this.interpreter);
        this.processor.resetException();
        this.interpreter.run();
    }

    public void boot() {
        if (this.thread == null) {
            this.thread = new ARMProcessorThread();
            this.thread.setName("ARM Processor Thread");
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            log.error((Object)String.format("WlanEmulator.boot() ARMProcessorThread already running", new Object[0]));
        }
    }

    private class ARMProcessorThread
    extends Thread {
        private ARMProcessorThread() {
        }

        @Override
        public void run() {
            WlanEmulator.this.bootFromThread();
            WlanEmulator.this.thread = null;
        }
    }
}

