/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wm8750;

import java.io.IOException;
import jpcsp.hardware.Model;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class WM8750
implements IState {
    public static Logger log = Logger.getLogger((String)"WM8750");
    private static final int STATE_VERSION = 0;
    private static WM8750 instance;
    private final int NUMBER_REGISTERS = Model.getGeneration() == 1 ? 43 : 50;
    private final int[] registers = new int[this.NUMBER_REGISTERS];
    private static final int[] defaultRegisterValues;
    public static final int REGISTER_RESET = 15;

    public static WM8750 getInstance() {
        if (instance == null) {
            instance = new WM8750();
        }
        return instance;
    }

    private WM8750() {
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readInts(this.registers);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInts(this.registers);
    }

    public void reset() {
        System.arraycopy(defaultRegisterValues, 0, this.registers, 0, this.NUMBER_REGISTERS);
    }

    public void executeTransmitReceiveCommand(int[] transmitData, int[] receiveData) {
        log.error((Object)String.format("Unimplemented executeTransmitReceiveCommand transmitData: 0x%02X 0x%02X", transmitData[0], transmitData[1]));
    }

    public void executeTransmitCommand(int[] transmitData) {
        int register = transmitData[0] >> 1 & 0x7F;
        int value = transmitData[1] | (transmitData[0] & 1) << 8;
        if (register >= 0 && register < this.NUMBER_REGISTERS) {
            this.setRegisterValue(register, value);
        } else {
            log.error((Object)String.format("executeTransmitCommand unknown register number: register=%d, value=0x%03X on %s", register, value, this));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("executeTransmitCommand register=%d, value=0x%03X on %s", register, value, this));
        }
    }

    private void setRegisterValue(int register, int value) {
        if (register == 15) {
            this.reset();
        } else {
            this.registers[register] = value & 0x1FF;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WM8750[");
        boolean first = true;
        for (int i = 0; i < this.NUMBER_REGISTERS; ++i) {
            if (this.registers[i] == defaultRegisterValues[i]) continue;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(String.format("R%d=0x%03X", i, this.registers[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        defaultRegisterValues = new int[]{151, 151, 121, 121, 0, 8, 0, 10, 0, 0, 255, 255, 15, 15, 0, 0, 0, 123, 0, 50, 0, 195, 195, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 80, 80, 80, 80, 80, 121, 121, 121, 0, 0, 0, 0, 0, 0, 0};
    }
}

