/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0;

import jpcsp.memory.mmio.syscon.MMIOHandlerSysconFirmwareSfr;
import jpcsp.nec78k0.Nec78k0Processor;
import org.apache.log4j.Logger;

public class Nec78k0Debug {
    private final Logger log;
    private final StackCallInfo[] stackCallInfos = new StackCallInfo[128];
    private int stackCallInfoIndex;

    public Nec78k0Debug(Logger log) {
        this.log = log;
        for (int i = 0; i < this.stackCallInfos.length; ++i) {
            this.stackCallInfos[i] = new StackCallInfo();
        }
        this.stackCallInfoIndex = 0;
    }

    public void call(Nec78k0Processor processor, int addr) {
        if (this.stackCallInfoIndex < this.stackCallInfos.length) {
            this.stackCallInfos[this.stackCallInfoIndex].pc = processor.getCurrentInstructionPc();
            this.stackCallInfos[this.stackCallInfoIndex].callAddress = addr;
            this.stackCallInfos[this.stackCallInfoIndex].sp = processor.getSp();
            this.stackCallInfos[this.stackCallInfoIndex].isInterrupt = false;
            ++this.stackCallInfoIndex;
        } else {
            this.log.error((Object)String.format("Stack overflow", new Object[0]));
        }
    }

    public void ret() {
        if (this.stackCallInfoIndex == 0) {
            this.log.error((Object)String.format("Stack underflow", new Object[0]));
        } else {
            --this.stackCallInfoIndex;
        }
    }

    public void callInterrupt(Nec78k0Processor processor, int addr, int vectorTableAddr) {
        if (this.stackCallInfoIndex < this.stackCallInfos.length) {
            this.stackCallInfos[this.stackCallInfoIndex].pc = processor.getCurrentInstructionPc();
            this.stackCallInfos[this.stackCallInfoIndex].callAddress = addr;
            this.stackCallInfos[this.stackCallInfoIndex].sp = processor.getSp();
            this.stackCallInfos[this.stackCallInfoIndex].vectorTableAddress = vectorTableAddr;
            this.stackCallInfos[this.stackCallInfoIndex].isInterrupt = true;
            ++this.stackCallInfoIndex;
        } else {
            this.log.error((Object)String.format("Stack overflow", new Object[0]));
        }
    }

    public void dump() {
        for (int i = 0; i < this.stackCallInfoIndex; ++i) {
            String interruptName = this.stackCallInfos[i].isInterrupt ? String.format("(%s)", MMIOHandlerSysconFirmwareSfr.getInterruptName(this.stackCallInfos[i].vectorTableAddress)) : "";
            this.log.debug((Object)String.format("Stack#0x%02X: 0x%04X - %s !0x%04X%s; sp=0x%04X", i, this.stackCallInfos[i].pc, this.stackCallInfos[i].isInterrupt ? "interrupt" : "call", this.stackCallInfos[i].callAddress, interruptName, this.stackCallInfos[i].sp));
        }
    }

    private static class StackCallInfo {
        public int pc;
        public int callAddress;
        public int sp;
        public int vectorTableAddress;
        public boolean isInterrupt;

        private StackCallInfo() {
        }
    }
}

