/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import java.io.IOException;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.nec78k0.sfr.Nec78k0SfrNames;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class Nec78k0I2c
implements IState {
    private static final int STATE_VERSION = 0;
    public static final int IICE0 = 7;
    public static final int LREL0 = 6;
    public static final int WREL0 = 5;
    public static final int SPIE0 = 4;
    public static final int WTIM0 = 3;
    public static final int ACKE0 = 2;
    public static final int STT0 = 1;
    public static final int SPT0 = 0;
    public static final int MSTS0 = 7;
    public static final int ALD0 = 6;
    public static final int EXC0 = 5;
    public static final int COI0 = 4;
    public static final int TRC0 = 3;
    public static final int ACKD0 = 2;
    public static final int STD0 = 1;
    public static final int SPD0 = 0;
    private final Nec78k0Sfr sfr;
    protected Logger log;
    private int shift;
    private int slaveAddress;
    private int control;
    private int status;
    private int flag;
    private int clockSelection;
    private int functionExpansion;
    protected final int[] buffer = new int[16];
    private int bufferIndex;

    public Nec78k0I2c(Nec78k0Sfr sfr) {
        this.sfr = sfr;
        this.log = sfr.log;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.shift = stream.readInt();
        this.slaveAddress = stream.readInt();
        this.control = stream.readInt();
        this.status = stream.readInt();
        this.flag = stream.readInt();
        this.clockSelection = stream.readInt();
        this.functionExpansion = stream.readInt();
        stream.readInts(this.buffer);
        this.bufferIndex = stream.readInt();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.shift);
        stream.writeInt(this.slaveAddress);
        stream.writeInt(this.control);
        stream.writeInt(this.status);
        stream.writeInt(this.flag);
        stream.writeInt(this.clockSelection);
        stream.writeInt(this.functionExpansion);
        stream.writeInts(this.buffer);
        stream.writeInt(this.bufferIndex);
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void reset() {
        this.shift = 0;
        this.slaveAddress = 0;
        this.control = 0;
        this.status = 0;
        this.flag = 0;
        this.clockSelection = 0;
        this.functionExpansion = 0;
        this.bufferIndex = 0;
    }

    public int getShift() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("I2c getShift 0x%02X", this.shift));
            if (this.isRead()) {
                this.log.debug((Object)String.format("I2c read from slaveAddress 0x%02X, data#%d 0x%02X", this.getSlaveAddress(), this.bufferIndex - 1, this.shift));
            }
        }
        return this.shift;
    }

    protected void performRead() {
        this.log.error((Object)String.format("I2c unimplemented read from slaveAddress 0x%02X", this.getSlaveAddress()));
    }

    public void setShift(int value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("I2c setShift 0x%02X", value));
        }
        this.shift = value;
        if (this.hasStatusBit(1)) {
            this.setSlaveAddress(this.shift);
            this.clearStatusBit(1);
            this.clearStatusBit(0);
            this.bufferIndex = 0;
            if (this.isRead()) {
                this.performRead();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("I2c start %s to slaveAddress 0x%02X", this.isRead() ? "read" : "write", this.getSlaveAddress()));
            }
        } else if (this.isWrite()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("I2c write to slaveAddress 0x%02X, data#%d 0x%02X", this.getSlaveAddress(), this.bufferIndex, this.shift));
            }
            this.buffer[this.bufferIndex++] = this.shift;
        }
        this.setStatusBit(2);
        this.sfr.setInterruptRequest(Nec78k0Sfr.IICIF0);
    }

    public int getSlaveAddress() {
        return Utilities.clearBit(this.slaveAddress, 0);
    }

    public void setSlaveAddress(int value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("I2c setSlaveAddress 0x%02X", value));
        }
        this.slaveAddress = value;
    }

    private boolean isRead() {
        return Utilities.hasBit(this.slaveAddress, 0);
    }

    private boolean isWrite() {
        return !this.isRead();
    }

    public int getControl() {
        return this.control;
    }

    public void setControl(int value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("I2c setControl 0x%02X(%s)", value, Nec78k0SfrNames.getSfr1Names(65446, value)));
        }
        this.control = value;
        if (Utilities.hasBit(value, 0)) {
            this.clearStatusBit(2);
            this.setSlaveAddress(0);
            this.setStatusBit(0);
            this.control = Utilities.clearBit(this.control, 0);
            this.bufferIndex = 0;
        }
        if (Utilities.hasBit(this.control, 1)) {
            this.setStatusBit(1);
            this.control = Utilities.clearBit(this.control, 1);
        }
        if (Utilities.hasBit(this.control, 5)) {
            if (this.isRead()) {
                int data = this.buffer[this.bufferIndex++];
                this.setShift(data);
            }
            this.control = Utilities.clearBit(this.control, 5);
        }
    }

    public int getStatus() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("I2c getStatus 0x%02X(%s)", this.status, Nec78k0SfrNames.getSfr1Names(65450, this.status)));
        }
        return this.status;
    }

    private void setStatusBit(int bit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("I2c setStatusBit %s", Nec78k0SfrNames.getSfr1Name(65450, bit)));
        }
        this.status = Utilities.setBit(this.status, bit);
    }

    private void clearStatusBit(int bit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("I2c clearStatusBit %s", Nec78k0SfrNames.getSfr1Name(65450, bit)));
        }
        this.status = Utilities.clearBit(this.status, bit);
    }

    private boolean hasStatusBit(int bit) {
        boolean result = Utilities.hasBit(this.status, bit);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("I2c hasStatusBit %s returning %b", Nec78k0SfrNames.getSfr1Name(65450, bit), result));
        }
        return result;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("I2c setFlag 0x%02X", value));
        }
        this.flag = value;
    }

    public int getClockSelection() {
        return this.clockSelection;
    }

    public void setClockSelection(int value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("I2c setClockSelection 0x%02X", value));
        }
        this.clockSelection = value;
    }

    public int getFunctionExpansion() {
        return this.functionExpansion;
    }

    public void setFunctionExpansion(int value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("I2c setFunctionExpansion 0x%02X", value));
        }
        this.functionExpansion = value;
    }
}

