/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.memory.mmio.syscon.MMIOHandlerSysconFirmwareSfr;
import jpcsp.scheduler.SchedulerAction;
import org.apache.log4j.Logger;

public class Nec78k0Scheduler
extends Thread {
    private Logger log;
    private final Object update = new Object();
    private final List<SchedulerAction> actions = new LinkedList<SchedulerAction>();
    private SchedulerAction nextAction;

    public void setLogger(Logger log) {
        this.log = log;
    }

    @Override
    public void run() {
        RuntimeContext.setLog4jMDC();
        block0: while (true) {
            this.waitForNextAction();
            long now = MMIOHandlerSysconFirmwareSfr.now();
            while (true) {
                IAction action;
                if ((action = this.getAction(now)) == null) continue block0;
                action.execute();
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNextAction() {
        long delayMicros = this.getNextActionDelay(10000L);
        if (delayMicros > 0L) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("Scheduler.waitForNextAction delay=0x%X, now=0x%X", delayMicros, MMIOHandlerSysconFirmwareSfr.now()));
            }
            try {
                Object object = this.update;
                synchronized (object) {
                    this.update.wait(delayMicros / 1000L, (int)(delayMicros % 1000L) * 1000);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized long getNextActionDelay(long noActionDelay) {
        if (this.nextAction == null) {
            return noActionDelay;
        }
        long now = MMIOHandlerSysconFirmwareSfr.now();
        return this.nextAction.getSchedule() - now;
    }

    private boolean updateNextAction(SchedulerAction schedulerAction) {
        if (this.nextAction == null || schedulerAction.getSchedule() < this.nextAction.getSchedule()) {
            this.nextAction = schedulerAction;
            return true;
        }
        return false;
    }

    private void updateNextAction() {
        this.nextAction = null;
        for (SchedulerAction schedulerAction : this.actions) {
            this.updateNextAction(schedulerAction);
        }
    }

    private synchronized IAction getAction(long now) {
        if (this.nextAction == null || now < this.nextAction.getSchedule()) {
            return null;
        }
        IAction action = this.nextAction.getAction();
        this.actions.remove(this.nextAction);
        this.updateNextAction();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("Scheduler.getAction %s, now=0x%X", action, now));
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSchedulerAction(SchedulerAction schedulerAction) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("Scheduler.addSchedulerAction %s", schedulerAction));
        }
        this.actions.add(schedulerAction);
        if (this.updateNextAction(schedulerAction)) {
            Object object = this.update;
            synchronized (object) {
                this.update.notifyAll();
            }
        }
    }

    public synchronized void addAction(IAction action) {
        SchedulerAction schedulerAction = new SchedulerAction(0L, action);
        this.addSchedulerAction(schedulerAction);
    }

    public synchronized void addAction(long schedule, IAction action) {
        SchedulerAction schedulerAction = new SchedulerAction(schedule, action);
        this.addSchedulerAction(schedulerAction);
    }

    public synchronized void removeAction(IAction action) {
        ListIterator<SchedulerAction> lit = this.actions.listIterator();
        while (lit.hasNext()) {
            SchedulerAction schedulerAction = lit.next();
            if (schedulerAction.getAction() != action) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("Scheduler.removeAction %s", schedulerAction));
            }
            lit.remove();
            this.updateNextAction();
            break;
        }
    }
}

