/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class Nec78k0SerialInterfaceCSI1n
implements IState {
    private static final int STATE_VERSION = 0;
    protected final Nec78k0Sfr sfr;
    private final String name;
    private final int interruptFlag;
    private Logger log;
    private int operationMode;
    private int clockSelection;
    private int transmitBuffer;
    private int ioShift;
    private int receiveIndex;
    private final int[] receiveBuffer = new int[16];
    private int sendIndex;
    private final int[] sendBuffer = new int[16];

    public Nec78k0SerialInterfaceCSI1n(Nec78k0Sfr sfr, String name, int interruptFlag) {
        this.sfr = sfr;
        this.name = name;
        this.interruptFlag = interruptFlag;
        this.log = sfr.log;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.operationMode = stream.readInt();
        this.clockSelection = stream.readInt();
        this.transmitBuffer = stream.readInt();
        this.ioShift = stream.readInt();
        this.receiveIndex = stream.readInt();
        stream.readInts(this.receiveBuffer);
        this.sendIndex = stream.readInt();
        stream.readInts(this.sendBuffer);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.operationMode);
        stream.writeInt(this.clockSelection);
        stream.writeInt(this.transmitBuffer);
        stream.writeInt(this.ioShift);
        stream.writeInt(this.receiveIndex);
        stream.writeInts(this.receiveBuffer);
        stream.writeInt(this.sendIndex);
        stream.writeInts(this.sendBuffer);
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void reset() {
        this.operationMode = 0;
        this.clockSelection = 0;
        this.transmitBuffer = 0;
        this.ioShift = 0;
        this.receiveIndex = 0;
        Arrays.fill(this.receiveBuffer, 0);
        this.sendIndex = 0;
        Arrays.fill(this.sendBuffer, 0);
    }

    public int getOperationMode() {
        return this.operationMode;
    }

    public void setOperationMode(int value) {
        this.operationMode = value;
    }

    public int getClockSelection() {
        return this.clockSelection;
    }

    public void setClockSelection(int value) {
        this.clockSelection = value;
    }

    public void setTransmitBuffer(int value) {
        if (this.sendIndex < this.sendBuffer.length) {
            this.sendBuffer[this.sendIndex++] = value;
        }
        this.transmitBuffer = value;
        this.sfr.setInterruptRequest(this.interruptFlag);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("%s setTransmitBuffer 0x%02X", this.name, value));
        }
    }

    public int getTransmitBuffer() {
        return this.transmitBuffer;
    }

    public int getIOShift() {
        this.ioShift = this.receiveIndex < this.receiveBuffer.length ? this.receiveBuffer[this.receiveIndex++] : 0;
        this.sfr.setInterruptRequest(this.interruptFlag);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("%s getIOShift 0x%02X", this.name, this.ioShift));
        }
        return this.ioShift;
    }

    public void setReceiveBuffer(int[] data) {
        this.receiveIndex = 0;
        if (data != null) {
            System.arraycopy(data, 0, this.receiveBuffer, 0, Math.min(data.length, this.receiveBuffer.length));
        }
    }

    public int getSendBuffer(int[] data) {
        int length = this.sendIndex;
        this.sendIndex = 0;
        System.arraycopy(this.sendBuffer, 0, data, 0, Math.min(length, data.length));
        return length;
    }
}

