/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import java.io.IOException;
import jpcsp.memory.mmio.syscon.MMIOHandlerSysconFirmwareSfr;
import jpcsp.nec78k0.sfr.AbstractSysconTimerEventCounter;
import jpcsp.nec78k0.sfr.Nec78k0Scheduler;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class Nec78k0TimerEventCounter16
extends AbstractSysconTimerEventCounter {
    private static final int STATE_VERSION = 0;
    private final int interruptFlagCompare0;
    private final int interruptFlagCompare1;
    private int timerModeControl;
    private int prescalerMode;
    private int compareControl;
    private int outputControl;
    private int compare00;
    private int compare01;

    public Nec78k0TimerEventCounter16(Nec78k0Sfr sfr, Nec78k0Scheduler scheduler, String name, int interruptFlagCompare0, int interruptFlagCompare1) {
        super(sfr, scheduler, name, 65535);
        this.interruptFlagCompare0 = interruptFlagCompare0;
        this.interruptFlagCompare1 = interruptFlagCompare1;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.timerModeControl = stream.readInt();
        this.prescalerMode = stream.readInt();
        this.compareControl = stream.readInt();
        this.outputControl = stream.readInt();
        this.compare00 = stream.readInt();
        this.compare01 = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.timerModeControl);
        stream.writeInt(this.prescalerMode);
        stream.writeInt(this.compareControl);
        stream.writeInt(this.outputControl);
        stream.writeInt(this.compare00);
        stream.writeInt(this.compare01);
        super.write(stream);
    }

    @Override
    public void reset() {
        this.timerModeControl = 0;
        this.prescalerMode = 0;
        this.compareControl = 0;
        this.outputControl = 0;
        this.compare00 = 0;
        this.compare01 = 0;
        super.reset();
        this.updateCompare();
    }

    @Override
    protected void onTimerCounterOverflow() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("%s onTimerCounterOverflow", this.name));
        }
        this.timerModeControl = Utilities.setBit(this.timerModeControl, 0);
    }

    @Override
    protected void onTimerCounterCompare0() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("%s onTimerCounterCompare0 triggering interrupt %s", this.name, MMIOHandlerSysconFirmwareSfr.getInterruptName(MMIOHandlerSysconFirmwareSfr.IFtoINT(this.interruptFlagCompare0))));
        }
        this.sfr.setInterruptRequest(this.interruptFlagCompare0);
    }

    @Override
    protected void onTimerCounterCompare1() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("%s onTimerCounterCompare1 triggering interrupt %s", this.name, MMIOHandlerSysconFirmwareSfr.getInterruptName(MMIOHandlerSysconFirmwareSfr.IFtoINT(this.interruptFlagCompare1))));
        }
        this.sfr.setInterruptRequest(this.interruptFlagCompare1);
    }

    public void setTimerModeControl(int value) {
        if (Utilities.hasBit(value, 1)) {
            this.log.error((Object)String.format("%s setTimerModeControl unimplemented operation enable 0x%02X", this.name, value));
        }
        this.timerModeControl = value;
        if (Utilities.hasBit(value, 3)) {
            if (Utilities.hasBit(value, 2)) {
                this.setMode(false, true);
            } else {
                this.log.error((Object)String.format("%s setTimerModeControl unimplemented operation enable 0x%02X", this.name, value));
            }
        } else if (Utilities.hasBit(value, 2)) {
            this.setMode(true, false);
        } else {
            this.disable();
        }
    }

    public int getTimerModeControl() {
        return this.timerModeControl;
    }

    private void updateCompare() {
        if (Utilities.hasBit(this.compareControl, 0)) {
            this.setCompareValue0(-1);
        } else {
            this.setCompareValue0(this.compare00);
        }
        if (Utilities.hasBit(this.compareControl, 2)) {
            this.setCompareValue1(-1);
        } else {
            this.setCompareValue1(this.compare01);
        }
    }

    public void setCompareControl(int value) {
        this.compareControl = value;
        this.updateCompare();
    }

    public void setOutputControl(int value) {
        this.outputControl = value;
    }

    public void setPrescalerMode(int value) {
        this.prescalerMode = value;
        switch (this.prescalerMode & 3) {
            case 0: {
                this.setClockStep(200);
                break;
            }
            case 1: {
                this.setClockStep(800);
                break;
            }
            case 2: {
                this.setClockStep(51200);
                break;
            }
            case 3: {
                this.setClockStep(0);
                this.log.error((Object)String.format("%s setPrescalerMode unimplemented 0x%02X", value));
            }
        }
    }

    public void setCompare00(int value) {
        this.compare00 = value;
        this.updateCompare();
    }

    public void setCompare01(int value) {
        this.compare01 = value;
        this.updateCompare();
    }
}

