/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.nec78k0.sfr;

import java.io.IOException;
import jpcsp.memory.mmio.syscon.MMIOHandlerSysconFirmwareSfr;
import jpcsp.nec78k0.sfr.AbstractSysconTimerEventCounter;
import jpcsp.nec78k0.sfr.Nec78k0Scheduler;
import jpcsp.nec78k0.sfr.Nec78k0Sfr;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class Nec78k0TimerEventCounter8
extends AbstractSysconTimerEventCounter {
    private static final int STATE_VERSION = 0;
    private final int interruptFlagCompare;
    private int timerModeControl;
    private int clockSelection;
    private int compare;

    public Nec78k0TimerEventCounter8(Nec78k0Sfr sfr, Nec78k0Scheduler scheduler, String name, int interruptFlagCompare) {
        super(sfr, scheduler, name, 255);
        this.interruptFlagCompare = interruptFlagCompare;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.timerModeControl = stream.readInt();
        this.clockSelection = stream.readInt();
        this.compare = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.timerModeControl);
        stream.writeInt(this.clockSelection);
        stream.writeInt(this.compare);
        super.write(stream);
    }

    @Override
    public void reset() {
        this.timerModeControl = 0;
        this.clockSelection = 0;
        this.compare = 0;
        super.reset();
        this.updateCompare();
    }

    @Override
    protected void onTimerCounterOverflow() {
    }

    @Override
    protected void onTimerCounterCompare0() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("%s onTimerCounterCompare0 triggering interrupt %s", this.name, MMIOHandlerSysconFirmwareSfr.getInterruptName(MMIOHandlerSysconFirmwareSfr.IFtoINT(this.interruptFlagCompare))));
        }
        this.sfr.setInterruptRequest(this.interruptFlagCompare);
    }

    @Override
    protected void onTimerCounterCompare1() {
    }

    public void setTimerModeControl(int value) {
        if (Utilities.hasBit(value, 0)) {
            this.log.error((Object)String.format("%s setTimerModeControl unimplemented output enabled 0x%02X", this.name, value));
        }
        if (Utilities.hasBit(value, 7)) {
            this.setMode(false, true);
        }
        this.timerModeControl = value;
    }

    public int getTimerModeControl() {
        return this.timerModeControl & 0xF3;
    }

    public int getClockSelection() {
        return this.clockSelection;
    }

    public void setClockSelection(int value) {
        this.clockSelection = value;
        switch (this.clockSelection & 7) {
            case 2: {
                this.setClockStep(200);
                break;
            }
            case 3: {
                this.setClockStep(400);
                break;
            }
            case 4: {
                this.setClockStep(800);
                break;
            }
            case 5: {
                this.setClockStep(12800);
                break;
            }
            case 6: {
                this.setClockStep(51200);
                break;
            }
            case 7: {
                this.setClockStep(1639340);
                break;
            }
            default: {
                this.log.error((Object)String.format("%s setClockSelection unimplemented 0x%02X", this.name, value));
            }
        }
    }

    private void updateCompare() {
        this.setCompareValue0(this.compare);
    }

    public void setCompare(int value) {
        this.compare = value;
        this.updateCompare();
    }
}

