/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.xlinkkai;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import jpcsp.Emulator;
import jpcsp.GUI.ChatGUI;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceNet;
import jpcsp.HLE.modules.sceNetAdhoc;
import jpcsp.hardware.Wlan;
import jpcsp.memory.mmio.wlan.MMIOHandlerWlan;
import jpcsp.network.BaseWlanAdapter;
import jpcsp.network.protocols.EtherFrame;
import jpcsp.scheduler.Scheduler;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.AbstractIntSettingsListener;
import jpcsp.settings.AbstractStringSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class XLinkKaiWlanAdapter
extends BaseWlanAdapter {
    public static Logger log = Logger.getLogger((String)"XLinkKai");
    private static final boolean filterDuplicateMessages = true;
    private static boolean enabled = false;
    private DatagramSocket socket;
    private String uniqueIdentifier;
    private InetAddress destAddr;
    private String destServer = "localhost";
    private int destPort = 34523;
    private static final String applicationName = "Jpcsp";
    static final long timeout = 2000000L;
    private volatile boolean connected;
    private volatile boolean disconnected;
    private List<byte[]> receivedData = new LinkedList<byte[]>();
    private byte[] lastDataReceived = null;
    private int gameModeCounter;
    private static final boolean workaroundBugMulticast = false;
    private static final byte[] rawIdentifier = "802.11.Raw".getBytes();
    private ChatGUI chatGUI;
    private String username;
    private String arena = "";
    private String gameName = "";
    private String gameConsole = "";

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        XLinkKaiWlanAdapter.enabled = enabled;
        if (enabled) {
            log.info((Object)"Enabling XLink Kai network");
        }
    }

    public static void init() {
        Settings.getInstance().registerSettingsListener("XLinkKai", "emu.enableXLinkKai", new EnabledSettingsListener());
    }

    public static void exit() {
        Settings.getInstance().removeSettingsListener("XLinkKai");
        if (!XLinkKaiWlanAdapter.isEnabled()) {
            return;
        }
    }

    public XLinkKaiWlanAdapter() {
        Settings.getInstance().registerSettingsListener("XLinkKai", "network.XLinkKai.server", new ServerSettingsListener());
        Settings.getInstance().registerSettingsListener("XLinkKai", "network.XLinkKai.port", new PortSettingsListener());
    }

    public void setServer(String server) {
        this.destServer = server;
        if (this.destAddr != null) {
            try {
                this.destAddr = InetAddress.getByName(this.destServer);
            }
            catch (UnknownHostException e) {
                log.error((Object)"Cannot change XLink Kai server", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("setServer '%s'", server));
        }
    }

    public void setPort(int port) {
        this.destPort = port;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("setPort %d", port));
        }
    }

    private void send(byte[] buffer, int offset, int length) throws IOException {
        if (this.socket == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Sending bytes %s", Utilities.getMemoryDump(buffer, offset, length)));
        }
        DatagramPacket packet = new DatagramPacket(buffer, offset, length, this.destAddr, this.destPort);
        this.socket.send(packet);
    }

    private void send(String s) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Sending '%s'", s));
        }
        byte[] bytes = s.getBytes();
        this.send(bytes, 0, bytes.length);
    }

    private void sendDataPacket(byte[] buffer, int offset, int length) throws IOException {
        int headerSize = 4;
        byte[] bytes = new byte[length + 4];
        bytes[0] = 101;
        bytes[1] = 59;
        bytes[2] = 101;
        bytes[3] = 59;
        System.arraycopy(buffer, offset, bytes, 4, length);
        this.send(bytes, 0, bytes.length);
    }

    private byte[] receiveBytes() throws IOException {
        if (this.socket == null) {
            return null;
        }
        byte[] buffer = new byte[10000];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        try {
            this.socket.receive(packet);
        }
        catch (SocketTimeoutException e) {
            return null;
        }
        byte[] data = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), packet.getOffset(), data, 0, packet.getLength());
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Received bytes from %s: %s", packet.getAddress(), Utilities.getMemoryDump(data)));
        }
        return data;
    }

    private String extractParameters(String s) {
        int start;
        if (s != null && (start = s.indexOf(59)) >= 0 && (s = s.substring(start + 1)).endsWith(";")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private void process(byte[] data) throws IOException {
        if (data.length < 4) {
            log.warn((Object)String.format("Received too short packet %s", Utilities.getMemoryDump(data)));
            return;
        }
        if (data[0] == 101 && data[1] == 59 && data[2] == 101 && data[3] == 59) {
            this.processData(data, 4, data.length - 4);
        } else {
            String controlMessage = new String(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Processing control message '%s'", controlMessage));
            }
            if (controlMessage.startsWith("connected;")) {
                this.connected = true;
            } else if (controlMessage.startsWith("disconnected;")) {
                this.disconnected = true;
            } else if (controlMessage.startsWith("keepalive;")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Received keepalive", new Object[0]));
                }
                this.send("keepalive;");
            } else if (controlMessage.startsWith("message;")) {
                String message = this.extractParameters(controlMessage);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Received message '%s'", message));
                }
                if (this.chatGUI != null) {
                    this.chatGUI.addChatMessage("System message", message);
                }
            } else if (controlMessage.startsWith("chat;")) {
                String message = this.extractParameters(controlMessage);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Received chat '%s'", message));
                }
                String playerName = "chat";
                int endOfPlayerName = message.indexOf(": ");
                if (endOfPlayerName >= 0) {
                    playerName = message.substring(0, endOfPlayerName);
                    message = message.substring(endOfPlayerName + 2);
                }
                if (this.chatGUI != null) {
                    this.chatGUI.addChatMessage(playerName, message);
                }
            } else if (controlMessage.startsWith("directmessage;")) {
                String message = this.extractParameters(controlMessage);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Received direct message '%s'", message));
                }
                String playerName = "Direct message";
                int endOfPlayerName = message.indexOf(": ");
                if (endOfPlayerName >= 0) {
                    playerName = message.substring(0, endOfPlayerName);
                    message = message.substring(endOfPlayerName + 2);
                }
                if (this.chatGUI != null) {
                    this.chatGUI.addChatMessage(playerName, message);
                }
            } else if (controlMessage.startsWith("player_names;")) {
                String names = this.extractParameters(controlMessage);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Received player names '%s'", names));
                }
                String[] players = names.split("/");
                LinkedList<String> chatMembers = new LinkedList<String>();
                if (players != null) {
                    for (int i = 0; i < players.length; ++i) {
                        String player = players[i];
                        if (player.length() <= 0 || player.equals(this.username)) continue;
                        chatMembers.add(player);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("Player#%d: '%s'", i, players[i]));
                    }
                }
                if (this.chatGUI == null && chatMembers.size() > 0) {
                    this.openChat();
                }
                if (this.chatGUI != null) {
                    this.chatGUI.updateMembers(chatMembers);
                }
            } else if (controlMessage.startsWith("player_join;")) {
                String name = this.extractParameters(controlMessage);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Player '%s' joined", name));
                }
                if (!name.equals(this.username)) {
                    this.openChat();
                    if (this.chatGUI != null) {
                        this.chatGUI.addMember(name);
                    }
                }
            } else if (controlMessage.startsWith("player_leave;")) {
                String name = this.extractParameters(controlMessage);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Player '%s' leaved", name));
                }
                if (this.chatGUI != null && !name.equals(this.username)) {
                    this.chatGUI.removeMember(name);
                }
            } else if (controlMessage.startsWith("arena;")) {
                this.arena = this.extractParameters(controlMessage);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Arena '%s'", this.arena));
                }
                this.gameConsole = "";
                this.gameName = "";
                this.updateChat();
                this.send("getplayernames;");
            } else if (controlMessage.startsWith("gameinfo;")) {
                String gameInfo = this.extractParameters(controlMessage);
                String[] gameInfos = gameInfo.split(";");
                if (gameInfos != null && gameInfos.length >= 2) {
                    this.gameConsole = gameInfos[0];
                    this.gameName = gameInfos[1];
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Game info Console '%s', Game name '%s'", this.gameConsole, this.gameName));
                }
                this.updateChat();
            } else if (controlMessage.startsWith("username;")) {
                this.username = this.extractParameters(controlMessage);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Username '%s'", this.username));
                }
                this.updateChat();
            } else {
                log.warn((Object)String.format("Received unknown control message '%s'", controlMessage));
            }
        }
    }

    private void receive() throws IOException {
        byte[] data = this.receiveBytes();
        if (data != null) {
            this.process(data);
        }
    }

    private void processData(byte[] data, int offset, int length) throws IOException {
        byte[] buffer = new byte[length];
        System.arraycopy(data, offset, buffer, 0, length);
        if (this.lastDataReceived != null && buffer.length == this.lastDataReceived.length && Utilities.equals(buffer, 0, this.lastDataReceived, 0, length)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Dropping duplicate data message", new Object[0]));
            }
            this.lastDataReceived = null;
            return;
        }
        this.lastDataReceived = (byte[])buffer.clone();
        if (length >= 12 + rawIdentifier.length && Utilities.memcmp(data, offset + 12, rawIdentifier, 0, rawIdentifier.length) == 0) {
            this.processRawMessage(data, offset + 12 + rawIdentifier.length, length - 12 - rawIdentifier.length);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Processing data message %s", Utilities.getMemoryDump(buffer)));
        }
        this.receivedData.add(buffer);
    }

    private void connect() throws IOException {
        this.connected = false;
        String connectString = String.format("connect;%s;%s;", this.uniqueIdentifier, applicationName);
        this.send(connectString);
        long start = Scheduler.getNow();
        while (!this.connected) {
            this.receive();
            long now = Scheduler.getNow();
            if (now - start <= 2000000L) continue;
            int response = JOptionPane.showConfirmDialog(null, ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("XLinkKai.cannotConnect"), "XLink Kai", 2, 2);
            if (response == 0) {
                this.send(connectString);
                start = Scheduler.getNow();
                continue;
            }
            log.error((Object)String.format("Could not connect to XLink Kai, please make sure it is started", new Object[0]));
            throw new IOException("Could not connect to XLink Kai");
        }
    }

    private void disconnect() throws IOException {
        this.disconnected = false;
        this.send(String.format("disconnect;%s;%s;", this.uniqueIdentifier, applicationName));
        long start = Scheduler.getNow();
        while (!this.disconnected) {
            this.receive();
            long now = Scheduler.getNow();
            if (now - start <= 2000000L) continue;
            log.error((Object)String.format("Cannot disconnect from XLink Kai, please make sure it is started", new Object[0]));
            throw new IOException("Cannot disconnect from XLink Kai");
        }
    }

    private void enableChat() throws IOException {
        this.send("setting;chat;true;");
        this.send("getplayernames;");
    }

    @Override
    public void start() throws IOException {
        this.uniqueIdentifier = String.format("%s_%s", applicationName, sceNet.convertMacAddressToString(Wlan.getMacAddress()));
        while (true) {
            try {
                this.destAddr = InetAddress.getByName(this.destServer);
            }
            catch (UnknownHostException e) {
                int response = JOptionPane.showConfirmDialog(null, ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("XLinkKai.cannotConnect"), "XLink Kai", 2, 2);
                if (response == 0) continue;
                throw e;
            }
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("XLink Kai server %s(%s), port %d", this.destServer, this.destAddr, this.destPort));
        }
        this.socket = new DatagramSocket();
        this.socket.setSoTimeout(1);
        this.connected = false;
        this.disconnected = false;
        this.receivedData.clear();
        this.gameModeCounter = 0;
        this.connect();
        this.enableChat();
        this.send("getusername;");
    }

    @Override
    public void stop() throws IOException {
        this.closeChat();
        this.disconnect();
    }

    @Override
    public void sendWlanPacket(byte[] buffer, int offset, int length) throws IOException {
        byte[] gameModeGroupAddress = MMIOHandlerWlan.getInstance().getGameModeGroupAddress();
        if (pspNetMacAddress.equals(gameModeGroupAddress, 0, buffer, offset) && MMIOHandlerWlan.getInstance().isGameModeMaster()) {
            this.gameModeCounter = this.gameModeCounter + 1 & 0xF;
            this.sendBeacon(MMIOHandlerWlan.getInstance().getSsid(), 1, this.gameModeCounter);
        }
        this.sendDataPacket(buffer, offset, length);
    }

    @Override
    public void sendAccessPointPacket(byte[] buffer, int offset, int length, EtherFrame etherFrame) throws IOException {
        log.error((Object)"Unimplemented sendAccessPointPacket");
    }

    @Override
    public void sendGameModePacket(pspNetMacAddress macAddress, byte[] buffer, int offset, int length) throws IOException {
        log.error((Object)"Unimplemented sendGameModePacket");
    }

    @Override
    public int receiveWlanPacket(byte[] buffer, int offset, int length) throws IOException {
        this.receive();
        if (this.receivedData.size() <= 0) {
            return -1;
        }
        byte[] bytes = this.receivedData.remove(0);
        int receivedLength = Math.min(bytes.length, length);
        System.arraycopy(bytes, 0, buffer, offset, receivedLength);
        return receivedLength;
    }

    @Override
    public int receiveGameModePacket(pspNetMacAddress macAddress, byte[] buffer, int offset, int length) throws IOException {
        return -1;
    }

    @Override
    public void wlanScan(String ssid, int[] channels) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("wlanScan ssid=%s, channels=%s", ssid, channels));
        }
        this.sendProbeRequest(ssid);
    }

    private void writeMacAddress(byte[] buffer, int offset, byte[] macAddress, int macAddressOffset) {
        System.arraycopy(macAddress, macAddressOffset, buffer, offset, 6);
    }

    private void writeMacAddress(byte[] buffer, int offset, byte[] macAddress) {
        this.writeMacAddress(buffer, offset, macAddress, 0);
    }

    private void sendRawMessage(byte[] buffer, int offset, int length) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sendRawMessage length=0x%X: %s", length, Utilities.getMemoryDump(buffer, offset, length)));
        }
        byte[] dataPacket = new byte[length + 12 + rawIdentifier.length];
        this.writeMacAddress(dataPacket, 0, sceNetAdhoc.ANY_MAC_ADDRESS);
        this.writeMacAddress(dataPacket, 6, Wlan.getMacAddress());
        System.arraycopy(rawIdentifier, 0, dataPacket, 12, rawIdentifier.length);
        System.arraycopy(buffer, offset, dataPacket, 12 + rawIdentifier.length, length);
        this.sendDataPacket(dataPacket, 0, dataPacket.length);
    }

    private int addHeader(byte[] buffer, int offset, int type, byte[] destMacAddress, int destMacAddressOffset, byte[] bssId) {
        Utilities.write8(buffer, offset, 0);
        Utilities.write8(buffer, ++offset, 0);
        int headerLengthOffset = ++offset;
        Utilities.writeUnaligned16(buffer, offset, 0);
        Utilities.writeUnaligned32(buffer, offset += 2, 18478);
        Utilities.write8(buffer, offset += 4, 0);
        Utilities.write8(buffer, ++offset, 4);
        Utilities.writeUnaligned16(buffer, ++offset, 2412);
        Utilities.writeUnaligned16(buffer, offset += 2, 160);
        Utilities.write8(buffer, offset += 2, -45);
        Utilities.write8(buffer, ++offset, 1);
        Utilities.writeUnaligned16(buffer, ++offset, 0);
        Utilities.writeUnaligned16(buffer, headerLengthOffset, offset += 2);
        Utilities.write8(buffer, offset, type);
        Utilities.write8(buffer, ++offset, 0);
        Utilities.writeUnaligned16(buffer, ++offset, 65535);
        this.writeMacAddress(buffer, offset += 2, destMacAddress, destMacAddressOffset);
        this.writeMacAddress(buffer, offset += 6, Wlan.getMacAddress());
        this.writeMacAddress(buffer, offset += 6, bssId);
        Utilities.writeUnaligned16(buffer, offset += 6, 0);
        return offset += 2;
    }

    private int addProbeHeader(byte[] buffer, int offset) {
        Utilities.writeUnaligned64(buffer, offset, 0L);
        Utilities.writeUnaligned16(buffer, offset += 8, 100);
        Utilities.writeUnaligned16(buffer, offset += 2, 34);
        return offset += 2;
    }

    private int addTagSSID(byte[] buffer, int offset, String ssid) {
        Utilities.write8(buffer, offset, 0);
        byte[] ssidBytes = ssid == null ? new byte[]{} : ssid.getBytes();
        Utilities.write8(buffer, ++offset, ssidBytes.length);
        ++offset;
        if (ssidBytes.length > 0) {
            System.arraycopy(ssidBytes, 0, buffer, offset, ssidBytes.length);
            offset += ssidBytes.length;
        }
        return offset;
    }

    private int addTagCurrentChannel(byte[] buffer, int offset, int channel) {
        Utilities.write8(buffer, offset, 3);
        Utilities.write8(buffer, ++offset, 1);
        Utilities.write8(buffer, ++offset, channel);
        return ++offset;
    }

    private int addTagSupportedRates(byte[] buffer, int offset) {
        Utilities.write8(buffer, offset, 1);
        Utilities.write8(buffer, ++offset, 4);
        Utilities.write8(buffer, ++offset, 130);
        Utilities.write8(buffer, ++offset, 132);
        Utilities.write8(buffer, ++offset, 11);
        Utilities.write8(buffer, ++offset, 22);
        return ++offset;
    }

    private int addTagATIMWindow(byte[] buffer, int offset) {
        Utilities.write8(buffer, offset, 6);
        Utilities.write8(buffer, ++offset, 2);
        Utilities.writeUnaligned16(buffer, ++offset, 0);
        return offset += 2;
    }

    private void sendProbeRequest(String ssid) throws IOException {
        byte[] buffer = new byte[100];
        int offset = 0;
        offset = this.addHeader(buffer, offset, 64, sceNetAdhoc.ANY_MAC_ADDRESS, 0, sceNetAdhoc.ANY_MAC_ADDRESS);
        offset = this.addTagSSID(buffer, offset, ssid);
        offset = this.addTagSupportedRates(buffer, offset);
        this.sendRawMessage(buffer, 0, offset);
    }

    private void sendProbeResponse(byte[] destMacAddress, int destMacAddresssOffset, String ssid, int channel) throws IOException {
        byte[] buffer = new byte[100];
        int offset = 0;
        offset = this.addHeader(buffer, offset, 80, destMacAddress, destMacAddresssOffset, Wlan.getMacAddress());
        offset = this.addProbeHeader(buffer, offset);
        offset = this.addTagSSID(buffer, offset, ssid);
        offset = this.addTagSupportedRates(buffer, offset);
        offset = this.addTagCurrentChannel(buffer, offset, channel);
        offset = this.addTagATIMWindow(buffer, offset);
        this.sendRawMessage(buffer, 0, offset);
    }

    private void sendBeacon(String ssid, int channel, int gameModeCounter) throws IOException {
        byte[] buffer = new byte[200];
        int offset = 0;
        offset = this.addHeader(buffer, offset, 128, sceNetAdhoc.ANY_MAC_ADDRESS, 0, Wlan.getMacAddress());
        offset = this.addProbeHeader(buffer, offset);
        offset = this.addTagSSID(buffer, offset, ssid);
        offset = this.addTagCurrentChannel(buffer, offset, channel);
        offset = this.addTagSupportedRates(buffer, offset);
        offset = this.addTagATIMWindow(buffer, offset);
        if (gameModeCounter >= 0) {
            Utilities.write8(buffer, offset, 221);
            Utilities.write8(buffer, ++offset, 10);
            Utilities.write8(buffer, ++offset + 0, 0);
            Utilities.write8(buffer, offset + 1, 4);
            Utilities.write8(buffer, offset + 2, 31);
            Utilities.write8(buffer, (offset += 3) + 0, 0);
            Utilities.write8(buffer, offset + 1, 0);
            Utilities.write8(buffer, offset + 2, 2);
            Utilities.write8(buffer, offset + 3, gameModeCounter);
            Utilities.write8(buffer, offset + 4, 2);
            Utilities.write8(buffer, offset + 5, 15);
            Utilities.write8(buffer, offset + 6, 8);
            offset += 7;
        }
        this.sendRawMessage(buffer, 0, offset);
    }

    private boolean isSSIDMatching(String ssid, String matchSsid) {
        if (ssid == null) {
            return false;
        }
        if (matchSsid == null || matchSsid.length() == 0) {
            return true;
        }
        return matchSsid.equals(ssid);
    }

    private void processRawMessage(byte[] buffer, int offset, int length) throws IOException {
        int headerRevision;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("processRawMessage length=0x%X: %s", length, Utilities.getMemoryDump(buffer, offset, length)));
        }
        if ((headerRevision = Utilities.read8(buffer, offset + 0)) == 0) {
            int headerLength = Utilities.readUnaligned16(buffer, offset + 2);
            int headerLength802_11 = 24;
            if (headerLength + 24 > length) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Received raw message with an incorrect header length: packet length=0x%X, header length=0x%X", length, headerLength));
                }
                return;
            }
            int sourceMacAddressOffset = offset + headerLength + 10;
            if (pspNetMacAddress.isMyMacAddress(buffer, sourceMacAddressOffset)) {
                log.trace((Object)String.format("processRawMessage ignoring raw message coming from myself", new Object[0]));
                return;
            }
            int frameControlField = Utilities.readUnaligned16(buffer, offset + headerLength);
            if (frameControlField == 128) {
                byte[] gameModeGroupAddress = MMIOHandlerWlan.getInstance().getGameModeGroupAddress();
                if (pspNetMacAddress.isEmptyMacAddress(gameModeGroupAddress)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("processRawMessage Beacon frame, sending own Beacon", new Object[0]));
                    }
                    this.sendBeacon(MMIOHandlerWlan.getInstance().getSsid(), 1, -1);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("processRawMessage Beacon frame in GameMode, ignoring", new Object[0]));
                }
            } else if (frameControlField == 64) {
                int channel = 1;
                String matchSsid = null;
                for (int i = offset + headerLength + 24; i < length; i += 2) {
                    int tagNumber = Utilities.read8(buffer, i);
                    int tagLength = Utilities.read8(buffer, i + 1);
                    if (tagNumber == 0) {
                        matchSsid = Utilities.readStringNZ(buffer, i + 2, tagLength);
                    } else if (tagNumber == 3 && tagLength >= 1) {
                        channel = Utilities.read8(buffer, i + 2);
                    }
                    i += tagLength;
                }
                String currentSsid = MMIOHandlerWlan.getInstance().getSsid();
                if (this.isSSIDMatching(currentSsid, matchSsid)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("processRawMessage Probe Request, simulating Probe Response to %s with SSID=%s, channel=%d", pspNetMacAddress.toString(buffer, sourceMacAddressOffset), matchSsid, channel));
                    }
                    this.sendProbeResponse(buffer, sourceMacAddressOffset, currentSsid, channel);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("processRawMessage Probe Request, non-matching SSID from %s with SSID=%s, channel=%d", pspNetMacAddress.toString(buffer, sourceMacAddressOffset), matchSsid, channel));
                }
            } else if (frameControlField == 80) {
                int channel = 1;
                String ssid = null;
                pspNetMacAddress sourceMacAddress = new pspNetMacAddress(buffer, sourceMacAddressOffset);
                byte[] ibss = sourceMacAddress.macAddress;
                for (int i = offset + headerLength + 24; i < length; i += 2) {
                    int tagNumber = Utilities.read8(buffer, i);
                    int tagLength = Utilities.read8(buffer, i + 1);
                    if (tagNumber == 0) {
                        ssid = Utilities.readStringNZ(buffer, i + 2, tagLength);
                    } else if (tagNumber == 3 && tagLength >= 1) {
                        channel = Utilities.read8(buffer, i + 2);
                    }
                    i += tagLength;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("processRawMessage Probe Response sourceMacAddress=%s, ssid=%s, channel=%d", sourceMacAddress, ssid, channel));
                }
                Modules.sceNetAdhocctlModule.hleNetAdhocctlAddNetwork(sourceMacAddress, ssid, ibss, channel);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("processRawMessage unknown frameControl=0x%04X", frameControlField));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("processRawMessage unknown headerRevision=0x%02X", headerRevision));
        }
    }

    private void openChat() {
        if (!this.hasChatEnabled()) {
            return;
        }
        if (this.chatGUI == null || !this.chatGUI.isVisible()) {
            this.chatGUI = new ChatGUI();
            this.updateChat();
            Emulator.getMainGUI().startBackgroundWindowDialog(this.chatGUI);
        }
    }

    private void closeChat() {
        if (this.chatGUI != null) {
            this.chatGUI.dispose();
            this.chatGUI = null;
        }
    }

    private void updateChat() {
        if (this.chatGUI != null) {
            this.chatGUI.setMyNickName(this.username);
            this.chatGUI.setGroupName(this.gameName);
            if (this.arena != null && this.arena.length() > 0) {
                this.chatGUI.setTitle(String.format("Chat in %s", this.arena));
            } else {
                this.chatGUI.setTitle("Chat");
            }
        }
    }

    @Override
    public void sendChatMessage(String message) {
        block2: {
            try {
                this.send("chat;" + message);
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"sendChatMessage", (Throwable)e);
            }
        }
    }

    private class PortSettingsListener
    extends AbstractIntSettingsListener {
        private PortSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(int value) {
            XLinkKaiWlanAdapter.this.setPort(value);
        }
    }

    private class ServerSettingsListener
    extends AbstractStringSettingsListener {
        private ServerSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(String value) {
            XLinkKaiWlanAdapter.this.setServer(value);
        }
    }

    private static class EnabledSettingsListener
    extends AbstractBoolSettingsListener {
        private EnabledSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            XLinkKaiWlanAdapter.setEnabled(value);
        }
    }
}

