/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExtractRawVideoFromPSMF {
    private static byte[] buffer = new byte[2048];

    private static int read8(InputStream in) throws IOException {
        return in.read() & 0xFF;
    }

    private static int read16(InputStream in) throws IOException {
        return ExtractRawVideoFromPSMF.read8(in) << 8 | ExtractRawVideoFromPSMF.read8(in);
    }

    private static int read32(InputStream in) throws IOException {
        return ExtractRawVideoFromPSMF.read8(in) << 24 | ExtractRawVideoFromPSMF.read8(in) << 16 | ExtractRawVideoFromPSMF.read8(in) << 8 | ExtractRawVideoFromPSMF.read8(in);
    }

    private static void skip(InputStream in, int n) throws IOException {
        in.skip(n);
    }

    private static int skipPesHeader(InputStream in, int startCode) throws IOException {
        int pesLength = 0;
        int c = ExtractRawVideoFromPSMF.read8(in);
        ++pesLength;
        while (c == 255) {
            c = ExtractRawVideoFromPSMF.read8(in);
            ++pesLength;
        }
        if ((c & 0xC0) == 64) {
            ExtractRawVideoFromPSMF.skip(in, 1);
            c = ExtractRawVideoFromPSMF.read8(in);
            pesLength += 2;
        }
        if ((c & 0xE0) == 32) {
            ExtractRawVideoFromPSMF.skip(in, 4);
            pesLength += 4;
            if ((c & 0x10) != 0) {
                ExtractRawVideoFromPSMF.skip(in, 5);
                pesLength += 5;
            }
        } else if ((c & 0xC0) == 128) {
            ExtractRawVideoFromPSMF.skip(in, 1);
            int headerLength = ExtractRawVideoFromPSMF.read8(in);
            pesLength += 2;
            ExtractRawVideoFromPSMF.skip(in, headerLength);
            pesLength += headerLength;
        }
        if (startCode == 445) {
            int channel = ExtractRawVideoFromPSMF.read8(in);
            ++pesLength;
            if (channel >= 128 && channel <= 207) {
                ExtractRawVideoFromPSMF.skip(in, 3);
                pesLength += 3;
                if (channel >= 176 && channel <= 191) {
                    ExtractRawVideoFromPSMF.skip(in, 1);
                    ++pesLength;
                }
            } else {
                ExtractRawVideoFromPSMF.skip(in, 3);
                pesLength += 3;
            }
        }
        return pesLength;
    }

    private static void write(OutputStream out, InputStream in, int n) throws IOException {
        if (n > 0) {
            in.read(buffer, 0, n);
            out.write(buffer, 0, n);
        }
    }

    public static void main(String[] args) {
        try {
            int startCode;
            FileInputStream in = new FileInputStream(args[0]);
            FileOutputStream out = new FileOutputStream(args[0] + ".raw");
            while ((startCode = ExtractRawVideoFromPSMF.read32(in)) != -1) {
                switch (startCode) {
                    case 442: {
                        ExtractRawVideoFromPSMF.skip(in, 10);
                        break;
                    }
                    case 443: {
                        ExtractRawVideoFromPSMF.skip(in, 14);
                        break;
                    }
                    case 445: 
                    case 446: 
                    case 447: {
                        int codeLength = ExtractRawVideoFromPSMF.read16(in);
                        ExtractRawVideoFromPSMF.skip(in, codeLength);
                        break;
                    }
                    case 480: 
                    case 481: 
                    case 482: 
                    case 483: 
                    case 484: 
                    case 485: 
                    case 486: 
                    case 487: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 493: 
                    case 494: 
                    case 495: {
                        int codeLength = ExtractRawVideoFromPSMF.read16(in);
                        ExtractRawVideoFromPSMF.write(out, in, codeLength -= ExtractRawVideoFromPSMF.skipPesHeader(in, startCode));
                    }
                }
            }
            out.close();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

