/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import com.twilight.h264.decoder.AVFrame;
import com.twilight.h264.decoder.AVPacket;
import com.twilight.h264.decoder.H264Decoder;
import com.twilight.h264.decoder.MpegEncContext;
import com.twilight.h264.player.PlayerFrame;
import com.twilight.h264.util.FrameUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JFrame;
import jpcsp.Memory;
import jpcsp.media.codec.CodecFactory;
import jpcsp.util.LWJGLFixer;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class PSMFPlayer
implements Runnable {
    private static Logger log = Logger.getLogger((String)"PSMFPlayer");
    private static final int progressHeight = 2;
    private PlayerFrame displayPanel;
    private String fileName;
    private int[] buffer = null;
    private int[] videoData = new int[65536];
    private int[] audioData = new int[65536];
    private int videoDataOffset;
    private int audioDataOffset;
    private int audioFrameLength;
    private final int[] frameHeader = new int[8];
    private int frameHeaderLength;
    private InputStream is;
    private int totalNumberOfFrames;

    public static void main(String[] args) {
        LWJGLFixer.fixOnce();
        new PSMFPlayer(args);
    }

    public PSMFPlayer(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java jpcsp.PSMFPlayer <.pmf file>\n");
            return;
        }
        JFrame frame = new JFrame("Player");
        this.displayPanel = new PlayerFrame();
        frame.getContentPane().add((Component)this.displayPanel, "Center");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.displayPanel.setVisible(true);
        this.displayPanel.setPreferredSize(new Dimension(480, 274));
        frame.pack();
        frame.setVisible(true);
        this.fileName = args[0];
        new Thread(this).start();
    }

    @Override
    public void run() {
        System.out.println("Playing " + this.fileName);
        this.playFile(this.fileName);
    }

    private int read8(InputStream is) {
        try {
            return is.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int read16(InputStream is) {
        return this.read8(is) << 8 | this.read8(is);
    }

    private int read32(InputStream is) {
        return this.read8(is) << 24 | this.read8(is) << 16 | this.read8(is) << 8 | this.read8(is);
    }

    private long readTimestamp(InputStream is) {
        long timestamp = ((long)this.read16(is) & 0xFFFFL) << 32;
        return timestamp |= (long)this.read32(is) & 0xFFFFFFFFL;
    }

    private void skip(InputStream is, int n) {
        if (n > 0) {
            try {
                is.skip(n);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private int skipPesHeader(InputStream is, int startCode) {
        int pesLength = 0;
        int c = this.read8(is);
        ++pesLength;
        while (c == 255) {
            c = this.read8(is);
            ++pesLength;
        }
        if ((c & 0xC0) == 64) {
            this.skip(is, 1);
            c = this.read8(is);
            pesLength += 2;
        }
        if ((c & 0xE0) == 32) {
            this.skip(is, 4);
            pesLength += 4;
            if ((c & 0x10) != 0) {
                this.skip(is, 5);
                pesLength += 5;
            }
        } else if ((c & 0xC0) == 128) {
            this.skip(is, 1);
            int headerLength = this.read8(is);
            pesLength += 2;
            this.skip(is, headerLength);
            pesLength += headerLength;
        }
        if (startCode == 445) {
            int channel = this.read8(is);
            ++pesLength;
            if (channel >= 128 && channel <= 207) {
                this.skip(is, 3);
                pesLength += 3;
                if (channel >= 176 && channel <= 191) {
                    this.skip(is, 1);
                    ++pesLength;
                }
            } else {
                this.skip(is, 3);
                pesLength += 3;
            }
        }
        return pesLength;
    }

    private void addVideoData(InputStream is, int length) {
        if (this.videoDataOffset + length > this.videoData.length) {
            int[] newInputBuffer = new int[this.videoDataOffset + length];
            System.arraycopy(this.videoData, 0, newInputBuffer, 0, this.videoDataOffset);
            this.videoData = newInputBuffer;
        }
        for (int i = 0; i < length; ++i) {
            this.videoData[this.videoDataOffset++] = this.read8(is);
        }
    }

    private void addAudioData(InputStream is, int length) {
        if (this.audioDataOffset + length > this.audioData.length) {
            int[] newInputBuffer = new int[this.audioDataOffset + length];
            System.arraycopy(this.audioData, 0, newInputBuffer, 0, this.audioDataOffset);
            this.audioData = newInputBuffer;
        }
        while (length > 0) {
            int currentFrameLength;
            int n = currentFrameLength = this.audioFrameLength == 0 ? 0 : this.audioDataOffset % this.audioFrameLength;
            if (currentFrameLength == 0) {
                while (this.frameHeaderLength < this.frameHeader.length && length > 0) {
                    this.frameHeader[this.frameHeaderLength++] = this.read8(is);
                    --length;
                }
                if (this.frameHeaderLength < this.frameHeader.length || length == 0) break;
                int frameHeader23 = this.frameHeader[2] << 8 | this.frameHeader[3];
                this.audioFrameLength = ((frameHeader23 & 0x3FF) << 3) + 8;
                if (this.frameHeader[0] != 15 || this.frameHeader[1] != 208) {
                    log.warn((Object)String.format("Audio frame length 0x%X with incorrect header (header: %02X %02X %02X %02X %02X %02X %02X %02X)", this.audioFrameLength, this.frameHeader[0], this.frameHeader[1], this.frameHeader[2], this.frameHeader[3], this.frameHeader[4], this.frameHeader[5], this.frameHeader[6], this.frameHeader[7]));
                }
                this.frameHeaderLength = 0;
            }
            int lengthToNextFrame = this.audioFrameLength - currentFrameLength;
            int readLength = Utilities.min(length, lengthToNextFrame);
            for (int i = 0; i < readLength; ++i) {
                this.audioData[this.audioDataOffset++] = this.read8(is);
            }
            length -= readLength;
        }
    }

    private void readPsmfHeader(File f) {
        try {
            this.is = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        if (this.read32(this.is) != 1347636550) {
            return;
        }
        this.skip(this.is, 4);
        int mpegOffset = this.read32(this.is);
        this.skip(this.is, 72);
        long firstTimestamp = this.readTimestamp(this.is);
        long lastTimestamp = this.readTimestamp(this.is);
        this.totalNumberOfFrames = (int)((lastTimestamp - firstTimestamp) / 3003L);
        this.skip(this.is, mpegOffset - 96);
    }

    private boolean readPsmfPacket(int videoChannel, int audioChannel) {
        int startCode;
        while ((startCode = this.read32(this.is)) != -1) {
            switch (startCode) {
                case 442: {
                    this.skip(this.is, 10);
                    break;
                }
                case 443: {
                    this.skip(this.is, 14);
                    break;
                }
                case 446: 
                case 447: {
                    int codeLength = this.read16(this.is);
                    this.skip(this.is, codeLength);
                    break;
                }
                case 445: {
                    int codeLength = this.read16(this.is);
                    int pesLength = this.skipPesHeader(this.is, startCode);
                    this.addAudioData(this.is, codeLength -= pesLength);
                    break;
                }
                case 480: 
                case 481: 
                case 482: 
                case 483: 
                case 484: 
                case 485: 
                case 486: 
                case 487: 
                case 488: 
                case 489: 
                case 490: 
                case 491: 
                case 492: 
                case 493: 
                case 494: 
                case 495: {
                    int pesLength;
                    int codeLength = this.read16(this.is);
                    if (videoChannel < 0 || startCode - 480 == videoChannel) {
                        pesLength = this.skipPesHeader(this.is, startCode);
                        this.addVideoData(this.is, codeLength -= pesLength);
                        return true;
                    }
                    this.skip(this.is, codeLength);
                }
            }
        }
        return false;
    }

    private void consumeVideoData(int length) {
        if (length >= this.videoDataOffset) {
            this.videoDataOffset = 0;
        } else {
            System.arraycopy(this.videoData, length, this.videoData, 0, this.videoDataOffset - length);
            this.videoDataOffset -= length;
        }
    }

    private void consumeAudioData(int length) {
        if (length >= this.audioDataOffset) {
            this.audioDataOffset = 0;
        } else {
            System.arraycopy(this.audioData, length, this.audioData, 0, this.audioDataOffset - length);
            this.audioDataOffset -= length;
        }
    }

    private int findFrameEnd() {
        for (int i = 5; i < this.videoDataOffset; ++i) {
            int naluType;
            if (this.videoData[i - 4] != 0 || this.videoData[i - 3] != 0 || this.videoData[i - 2] != 0 || this.videoData[i - 1] != 1 || (naluType = this.videoData[i] & 0x1F) != 9) continue;
            return i - 4;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean playFile(String filename) {
        DOMConfigurator.configure((String)"LogSettings.xml");
        c = null;
        got_picture = new int[1];
        f = new File(filename);
        avpkt = new AVPacket();
        avpkt.av_init_packet();
        System.out.println("Video decoding\n");
        codec = new H264Decoder();
        if (codec == null) {
            System.out.println("codec not found\n");
            System.exit(1);
        }
        c = MpegEncContext.avcodec_alloc_context();
        picture = AVFrame.avcodec_alloc_frame();
        if ((codec.capabilities & 8) != 0) {
            c.flags |= 65536;
        }
        if (c.avcodec_open(codec) < 0) {
            System.out.println("could not open codec\n");
            System.exit(1);
        }
        showProgress = true;
        frame = 0;
        try {
            this.readPsmfHeader(f);
            if (this.totalNumberOfFrames <= 0) {
                showProgress = false;
            }
            videoChannel = 0;
            audioChannel = 0;
            audioChannels = 2;
            mem = Memory.getInstance();
            audioInputAddr = 0x8810000;
            audioOutputAddr = 0x8800000;
            audioCodec = CodecFactory.getCodec(4096);
            audioCodecInit = false;
            audioOutputData = null;
            audioFormat = new AudioFormat(44100.0f, 16, audioChannels, true, false);
            info = new DataLine.Info(SourceDataLine.class, audioFormat);
            mLine = (SourceDataLine)AudioSystem.getLine(info);
            mLine.open(audioFormat);
            PSMFPlayer.log.info((Object)String.format("Audio line buffer size %d", new Object[]{mLine.getBufferSize()}));
            mLine.start();
            startTime = System.currentTimeMillis();
            block11: while (true) {
                frameSize = -1;
                do {
                    if (!this.readPsmfPacket(videoChannel, audioChannel)) {
                        if (this.videoDataOffset <= 0) break;
                        frameSize = this.findFrameEnd();
                        if (frameSize >= 0) continue;
                        frameSize = this.videoDataOffset;
                        continue;
                    }
                    frameSize = this.findFrameEnd();
                } while (frameSize <= 0);
                if (frameSize <= 0) break;
                avpkt.data_base = this.videoData;
                avpkt.size = frameSize;
                avpkt.data_offset = 0;
                while (avpkt.size > 0) {
                    len = c.avcodec_decode_video2(picture, got_picture, avpkt);
                    if (len < 0) {
                        PSMFPlayer.log.error((Object)("Error while decoding frame " + frame));
                        break;
                    }
                    if (got_picture[0] != 0) {
                        picture = c.priv_data.displayPicture;
                        imageWidth = picture.imageWidthWOEdge;
                        imageHeight = picture.imageHeightWOEdge;
                        bufferSize = imageWidth * imageHeight;
                        if (this.buffer == null || bufferSize != this.buffer.length) {
                            this.buffer = new int[bufferSize];
                        }
                        FrameUtils.YUV2RGB_WOEdge(picture, this.buffer);
                        progress = showProgress != false ? imageWidth * frame / this.totalNumberOfFrames : 0;
                        y = Math.min(272, imageHeight - 2);
                        offset = y * imageWidth;
                        i = 0;
                        while (i < 2) {
                            Arrays.fill(this.buffer, offset, offset + progress, -1);
                            Arrays.fill(this.buffer, offset + progress, offset + imageWidth, -16777216);
                            ++i;
                            offset += imageWidth;
                        }
                        this.displayPanel.lastFrame = this.displayPanel.createImage(new MemoryImageSource(imageWidth, imageHeight, this.buffer, 0, imageWidth));
                        this.displayPanel.invalidate();
                        this.displayPanel.updateUI();
                        now = System.currentTimeMillis();
                        currentDuration = now - startTime;
                        videoDuration = (long)(++frame) * 100000L / 3003L;
                        if (currentDuration < videoDuration) {
                            Thread.sleep(videoDuration - currentDuration);
                        }
                        now = System.currentTimeMillis();
                        PSMFPlayer.log.info((Object)String.format("FPS %f", new Object[]{Float.valueOf(1000.0f * (float)frame / (float)(now - startTime))}));
                    }
                    avpkt.size -= len;
                    avpkt.data_offset += len;
                }
                this.consumeVideoData(frameSize);
                if (audioOutputData != null) {
                    if (mLine.available() < audioOutputData.length) continue;
                    mLine.write(audioOutputData, 0, audioOutputData.length);
                    audioOutputData = null;
                    continue;
                }
                if (this.audioFrameLength <= 0) continue;
                if (!audioCodecInit) {
                    audioCodec.init(this.audioFrameLength, audioChannels, audioChannels, 0);
                    audioCodecInit = true;
                }
                while (true) {
                    if (this.audioDataOffset < this.audioFrameLength) continue block11;
                    for (i = 0; i < this.audioFrameLength; ++i) {
                        mem.write8(audioInputAddr + i, (byte)this.audioData[i]);
                    }
                    result = audioCodec.decode(mem, audioInputAddr, this.audioFrameLength, mem, audioOutputAddr);
                    if (result < 0) {
                        PSMFPlayer.log.error((Object)String.format("Audio decode error 0x%08X", new Object[]{result}));
                        continue block11;
                    }
                    if (result == 0) continue block11;
                    if (result <= 0) continue;
                    this.consumeAudioData(this.audioFrameLength);
                    audioOutputData = new byte[audioCodec.getNumberOfSamples() * 2 * audioChannels];
                    for (i = 0; i < audioOutputData.length; ++i) {
                        audioOutputData[i] = (byte)mem.read8(audioOutputAddr + i);
                    }
                    if (mLine.available() >= audioOutputData.length) ** break;
                    continue block11;
                    mLine.write(audioOutputData, 0, audioOutputData.length);
                    audioOutputData = null;
                }
                break;
            }
            mLine.drain();
            mLine.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.is.close();
            }
            catch (Exception var10_13) {}
        }
        c.avcodec_close();
        c = null;
        picture = null;
        System.out.println(String.format("Stop playing video (%d frames).", new Object[]{frame}));
        return true;
    }
}

