/*
 * Decompiled with CFR 0.152.
 */
package libchdr;

public class ChdHeader {
    public static final int CHD_HEADER_VERSION = 5;
    public static final int CHD_V1_HEADER_SIZE = 76;
    public static final int CHD_V2_HEADER_SIZE = 80;
    public static final int CHD_V3_HEADER_SIZE = 120;
    public static final int CHD_V4_HEADER_SIZE = 108;
    public static final int CHD_V5_HEADER_SIZE = 124;
    public static final int CHD_MAX_HEADER_SIZE = 124;
    public static final int CHD_MD5_BYTES = 16;
    public static final int CHD_SHA1_BYTES = 20;
    public static final int CHDFLAGS_HAS_PARENT = 1;
    public static final int CHDFLAGS_IS_WRITEABLE = 2;
    public static final int CHDFLAGS_UNDEFINED = -4;
    public static final int CHDCOMPRESSION_NONE = 0;
    public static final int CHDCOMPRESSION_ZLIB = 1;
    public static final int CHDCOMPRESSION_ZLIB_PLUS = 2;
    public static final int CHDCOMPRESSION_AV = 3;
    public static final int CHD_CODEC_NONE = 0;
    public static final int CHD_CODEC_ZLIB = ChdHeader.CHD_MAKE_TAG('z', 'l', 'i', 'b');
    public static final int CHD_CODEC_LZMA = ChdHeader.CHD_MAKE_TAG('l', 'z', 'm', 'a');
    public static final int CHD_CODEC_FLAC = ChdHeader.CHD_MAKE_TAG('f', 'l', 'a', 'c');
    public static final int CHD_CODEC_CD_ZLIB = ChdHeader.CHD_MAKE_TAG('c', 'd', 'z', 'l');
    public static final int CHD_CODEC_CD_LZMA = ChdHeader.CHD_MAKE_TAG('c', 'd', 'l', 'z');
    public static final int CHD_CODEC_CD_FLAC = ChdHeader.CHD_MAKE_TAG('c', 'd', 'f', 'l');
    public static final int AV_CODEC_COMPRESS_CONFIG = 1;
    public static final int AV_CODEC_DECOMPRESS_CONFIG = 2;
    public static final int CHDMETATAG_WILDCARD = 0;
    public static final int CHD_METAINDEX_APPEND = -1;
    public static final int CHD_MDFLAGS_CHECKSUM = 1;
    public static final int HARD_DISK_METADATA_TAG = ChdHeader.CHD_MAKE_TAG('G', 'D', 'D', 'D');
    public static final String HARD_DISK_METADATA_FORMAT = "CYLS:%d,HEADS:%d,SECS:%d,BPS:%d";
    public static final int HARD_DISK_IDENT_METADATA_TAG = ChdHeader.CHD_MAKE_TAG('I', 'D', 'N', 'T');
    public static final int HARD_DISK_KEY_METADATA_TAG = ChdHeader.CHD_MAKE_TAG('K', 'E', 'Y', ' ');
    public static final int PCMCIA_CIS_METADATA_TAG = ChdHeader.CHD_MAKE_TAG('C', 'I', 'S', ' ');
    public static final int CDROM_OLD_METADATA_TAG = ChdHeader.CHD_MAKE_TAG('C', 'H', 'C', 'D');
    public static final int CDROM_TRACK_METADATA_TAG = ChdHeader.CHD_MAKE_TAG('C', 'H', 'T', 'R');
    public static final String CDROM_TRACK_METADATA_FORMAT = "TRACK:%d TYPE:%s SUBTYPE:%s FRAMES:%d";
    public static final int CDROM_TRACK_METADATA2_TAG = ChdHeader.CHD_MAKE_TAG('C', 'H', 'T', '2');
    public static final String CDROM_TRACK_METADATA2_FORMAT = "TRACK:%d TYPE:%s SUBTYPE:%s FRAMES:%d PREGAP:%d PGTYPE:%s PGSUB:%s POSTGAP:%d";
    public static final int GDROM_OLD_METADATA_TAG = ChdHeader.CHD_MAKE_TAG('C', 'H', 'G', 'T');
    public static final int GDROM_TRACK_METADATA_TAG = ChdHeader.CHD_MAKE_TAG('C', 'H', 'G', 'D');
    public static final String GDROM_TRACK_METADATA_FORMAT = "TRACK:%d TYPE:%s SUBTYPE:%s FRAMES:%d PAD:%d PREGAP:%d PGTYPE:%s PGSUB:%s POSTGAP:%d";
    public static final int AV_METADATA_TAG = ChdHeader.CHD_MAKE_TAG('A', 'V', 'A', 'V');
    public static final String AV_METADATA_FORMAT = "FPS:%d.%06d WIDTH:%d HEIGHT:%d INTERLACED:%d CHANNELS:%d SAMPLERATE:%d";
    public static final int AV_LD_METADATA_TAG = ChdHeader.CHD_MAKE_TAG('A', 'V', 'L', 'D');
    public static final int CHD_OPEN_READ = 1;
    public static final int CHD_OPEN_READWRITE = 2;
    public int length;
    public int version;
    public int flags;
    public final int[] compression = new int[4];
    public int hunkbytes;
    public int totalhunks;
    public long logicalbytes;
    public long metaoffset;
    public long mapoffset;
    public final byte[] md5 = new byte[16];
    public final byte[] parentmd5 = new byte[16];
    public final byte[] sha1 = new byte[20];
    public final byte[] rawsha1 = new byte[20];
    public final byte[] parentsha1 = new byte[20];
    public int unitbytes;
    public long unitcount;
    public int hunkcount;
    public int mapentrybytes;
    public byte[] rawmap;
    public int obsolete_cylinders;
    public int obsolete_sectors;
    public int obsolete_heads;
    public int obsolete_hunksize;

    public static int CHD_MAKE_TAG(char a, char b, char c, char d) {
        return a << 24 | b << 16 | c << 8 | d;
    }

    public String toString() {
        return String.format("ChdHeader[version=%d, hunkbytes=%d, totalhunks=%d]", this.version, this.hunkbytes, this.totalhunks);
    }

    public static enum ChdError {
        CHDERR_NONE,
        CHDERR_NO_INTERFACE,
        CHDERR_OUT_OF_MEMORY,
        CHDERR_INVALID_FILE,
        CHDERR_INVALID_PARAMETER,
        CHDERR_INVALID_DATA,
        CHDERR_FILE_NOT_FOUND,
        CHDERR_REQUIRES_PARENT,
        CHDERR_FILE_NOT_WRITEABLE,
        CHDERR_READ_ERROR,
        CHDERR_WRITE_ERROR,
        CHDERR_CODEC_ERROR,
        CHDERR_INVALID_PARENT,
        CHDERR_HUNK_OUT_OF_RANGE,
        CHDERR_DECOMPRESSION_ERROR,
        CHDERR_COMPRESSION_ERROR,
        CHDERR_CANT_CREATE_FILE,
        CHDERR_CANT_VERIFY,
        CHDERR_NOT_SUPPORTED,
        CHDERR_METADATA_NOT_FOUND,
        CHDERR_INVALID_METADATA_SIZE,
        CHDERR_UNSUPPORTED_VERSION,
        CHDERR_VERIFY_INCOMPLETE,
        CHDERR_INVALID_METADATA,
        CHDERR_INVALID_STATE,
        CHDERR_OPERATION_PENDING,
        CHDERR_NO_ASYNC_OPERATION,
        CHDERR_UNSUPPORTED_FORMAT;

    }
}

