/*
 * Decompiled with CFR 0.152.
 */
package libchdr;

import java.util.Arrays;
import libchdr.Bitstream;

public class HuffmanDecoder {
    protected int numcodes;
    protected int maxbits;
    protected int prevdata;
    protected int rleremaining;
    protected int[] lookup;
    protected Node[] huffnode;
    protected int[] datahisto;

    private static int MAKE_LOOKUP(int code, int bits) {
        return code << 5 | bits & 0x1F;
    }

    public HuffmanDecoder(int numcodes, int maxbits) {
        this.numcodes = numcodes;
        this.maxbits = maxbits;
        this.lookup = new int[1 << maxbits];
        this.huffnode = new Node[numcodes];
        for (int i = 0; i < numcodes; ++i) {
            this.huffnode[i] = new Node();
        }
    }

    public void delete() {
        this.lookup = null;
        this.huffnode = null;
    }

    public int decode_one(Bitstream bitbuf) {
        int bits = bitbuf.peek(this.maxbits);
        int lookupValue = this.lookup[bits];
        bitbuf.remove(lookupValue & 0x1F);
        return lookupValue >> 5;
    }

    public HuffmanError import_tree_rle(Bitstream bitbuf) {
        int numbits = this.maxbits >= 16 ? 5 : (this.maxbits >= 8 ? 4 : 3);
        int curnode = 0;
        while (curnode < this.numcodes) {
            int nodebits = bitbuf.read(numbits);
            if (nodebits != 1) {
                this.huffnode[curnode++].numbits = nodebits;
                continue;
            }
            nodebits = bitbuf.read(numbits);
            if (nodebits == 1) {
                this.huffnode[curnode++].numbits = nodebits;
                continue;
            }
            int repcount = bitbuf.read(numbits) + 3;
            while (repcount-- != 0) {
                this.huffnode[curnode++].numbits = nodebits;
            }
        }
        if (curnode != this.numcodes) {
            return HuffmanError.HUFFERR_INVALID_DATA;
        }
        HuffmanError error = this.assign_canonical_codes();
        if (error != HuffmanError.HUFFERR_NONE) {
            return error;
        }
        this.build_lookup_table();
        return bitbuf.overflow() ? HuffmanError.HUFFERR_INPUT_BUFFER_TOO_SMALL : HuffmanError.HUFFERR_NONE;
    }

    public HuffmanError import_tree_huffman(Bitstream bitbuf) {
        int last = 0;
        int count = 0;
        int rlefullbits = 0;
        HuffmanDecoder smallhuff = new HuffmanDecoder(24, 6);
        smallhuff.huffnode[0].numbits = bitbuf.read(3);
        int start = bitbuf.read(3) + 1;
        for (int index = 1; index < 24; ++index) {
            if (index < start || count == 7) {
                smallhuff.huffnode[index].numbits = 0;
                continue;
            }
            count = bitbuf.read(3);
            smallhuff.huffnode[index].numbits = count == 7 ? 0 : count;
        }
        HuffmanError error = smallhuff.assign_canonical_codes();
        if (error != HuffmanError.HUFFERR_NONE) {
            return error;
        }
        smallhuff.build_lookup_table();
        int temp = this.numcodes - 9;
        while (temp != 0) {
            temp >>= 1;
            ++rlefullbits;
        }
        int curcode = 0;
        while (curcode < this.numcodes) {
            int value = smallhuff.decode_one(bitbuf);
            if (value != 0) {
                this.huffnode[curcode++].numbits = last = value - 1;
                continue;
            }
            count = bitbuf.read(3) + 2;
            if (count == 9) {
                count += bitbuf.read(rlefullbits);
            }
            while (count != 0 && curcode < this.numcodes) {
                this.huffnode[curcode++].numbits = last;
                --count;
            }
        }
        if (curcode != this.numcodes) {
            return HuffmanError.HUFFERR_INVALID_DATA;
        }
        error = this.assign_canonical_codes();
        if (error != HuffmanError.HUFFERR_NONE) {
            return error;
        }
        this.build_lookup_table();
        return bitbuf.overflow() ? HuffmanError.HUFFERR_INPUT_BUFFER_TOO_SMALL : HuffmanError.HUFFERR_NONE;
    }

    public HuffmanError compute_tree_from_histo() {
        int sdatacount = 0;
        for (int i = 0; i < this.numcodes; ++i) {
            sdatacount += this.datahisto[i];
        }
        int lowerweight = 0;
        int upperweight = sdatacount * 2;
        while (true) {
            int curweight;
            int curmaxbits;
            if ((curmaxbits = this.build_tree(sdatacount, curweight = (upperweight + lowerweight) / 2)) <= this.maxbits) {
                lowerweight = curweight;
                if (curweight != sdatacount && upperweight - lowerweight > 1) continue;
                break;
            }
            upperweight = curweight;
        }
        return this.assign_canonical_codes();
    }

    private int build_tree(int totaldata, int totalweight) {
        int curcode;
        int listitems = 0;
        int maxbits = 0;
        Object[] list = new Node[this.numcodes * 2];
        for (int i = 0; i < this.numcodes; ++i) {
            this.huffnode[i] = new Node();
        }
        for (curcode = 0; curcode < this.numcodes; ++curcode) {
            if (this.datahisto[curcode] == 0) continue;
            list[listitems++] = this.huffnode[curcode];
            this.huffnode[curcode].count = this.datahisto[curcode];
            this.huffnode[curcode].bits = curcode;
            this.huffnode[curcode].weight = (int)((long)this.datahisto[curcode] * (long)totalweight / (long)totaldata);
            if (this.huffnode[curcode].weight != 0) continue;
            this.huffnode[curcode].weight = 1;
        }
        Arrays.sort(list, 0, listitems);
        int nextalloc = this.numcodes;
        while (listitems > 1) {
            Object node1 = list[--listitems];
            Object node0 = list[--listitems];
            Node newnode = this.huffnode[nextalloc++];
            newnode.parent = null;
            ((Node)node0).parent = ((Node)node1).parent = newnode;
            newnode.weight = ((Node)node0).weight + ((Node)node1).weight;
            for (int curitem = 0; curitem < listitems; ++curitem) {
                if (newnode.weight <= ((Node)list[curitem]).weight) continue;
                System.arraycopy(list, curitem, list, curitem + 1, listitems - curitem);
                break;
            }
            list[curitem] = newnode;
            ++listitems;
        }
        for (curcode = 0; curcode < this.numcodes; ++curcode) {
            Node node = this.huffnode[curcode];
            node.numbits = 0;
            node.bits = 0;
            if (node.weight <= 0) continue;
            Node curnode = node;
            while (curnode.parent != null) {
                ++node.numbits;
                curnode = curnode.parent;
            }
            if (node.numbits == 0) {
                node.numbits = 1;
            }
            maxbits = Math.max(maxbits, node.numbits);
        }
        return maxbits;
    }

    private HuffmanError assign_canonical_codes() {
        int curcode;
        int curstart = 0;
        int[] bithisto = new int[33];
        for (curcode = 0; curcode < this.numcodes; ++curcode) {
            Node node = this.huffnode[curcode];
            if (node.numbits > this.maxbits) {
                return HuffmanError.HUFFERR_INTERNAL_INCONSISTENCY;
            }
            if (node.numbits > 32) continue;
            int n = node.numbits;
            bithisto[n] = bithisto[n] + 1;
        }
        for (int codelen = 32; codelen > 0; --codelen) {
            int nextstart = curstart + bithisto[codelen] >> 1;
            if (codelen != 1 && nextstart * 2 != curstart + bithisto[codelen]) {
                return HuffmanError.HUFFERR_INTERNAL_INCONSISTENCY;
            }
            bithisto[codelen] = curstart;
            curstart = nextstart;
        }
        for (curcode = 0; curcode < this.numcodes; ++curcode) {
            Node node = this.huffnode[curcode];
            if (node.numbits <= 0) continue;
            int n = node.numbits;
            bithisto[n] = bithisto[n] + 1;
            node.bits = node.bits;
        }
        return HuffmanError.HUFFERR_NONE;
    }

    private void build_lookup_table() {
        for (int curcode = 0; curcode < this.numcodes; ++curcode) {
            Node node = this.huffnode[curcode];
            if (node.numbits <= 0) continue;
            int value = HuffmanDecoder.MAKE_LOOKUP(curcode, node.numbits);
            int shift = this.maxbits - node.numbits;
            Arrays.fill(this.lookup, node.bits << shift, node.bits + 1 << shift, value);
        }
    }

    protected static class Node
    implements Comparable<Node> {
        Node parent;
        int count;
        int weight;
        int bits;
        int numbits;

        protected Node() {
        }

        @Override
        public int compareTo(Node node) {
            if (node.weight != this.weight) {
                return node.weight - this.weight;
            }
            return this.bits - node.bits;
        }
    }

    public static enum HuffmanError {
        HUFFERR_NONE,
        HUFFERR_TOO_MANY_BITS,
        HUFFERR_INVALID_DATA,
        HUFFERR_INPUT_BUFFER_TOO_SMALL,
        HUFFERR_OUTPUT_BUFFER_TOO_SMALL,
        HUFFERR_INTERNAL_INCONSISTENCY,
        HUFFERR_TOO_MANY_CONTEXTS;

    }
}

