#ifndef SOUND_H
#define SOUND_H

#include "common.h"

/** Initialisation du systme sonore.
	\note Doit tre ralise avant mem_init, qui met les registres dans un tat
	connu (incluant ceux du son).
*/
void sound_init();
/** Produit du son  44.1 kHz en fonction de l'tat actuel des registres de
	l'APU.
	\param buf tampon o placer les donnes sonores
	\param len nombre d'chantillons stro  produire (44100 = 1 seconde)
	\note le son produit est  44100 Hz, 16 bits par chantillon, stro.
*/
void sound_render(s16 *buf, unsigned len);

/** Ralise une lecture dans la zone I/O rserve  l'APU ($FF10-$FF3F).
	On a besoin d'isoler la lecture et criture sur cette zone car les valeurs
	pouvant tre lues voluent en fonction du son produit.
	\param port n du port  lire (adresse - $FF00)
	\return valeur de retour par le bus de donnes
*/
u8 sound_read(u16 port);

/** Ralise une criture dans la zone I/O rserve  l'APU ($FF10-$FF3F).
	Voir #sound_read pour plus d'informations.
	\param port n du port  lire (adresse - $FF00)
	\param value valeur  crire (via le bus de donnes)
*/
void sound_write(u16 port, u8 value);

#endif
