/**
 Classe permettant de configurer les touches.
 Inspire de la classe ayant le mme fonctionnement
 dans l'application Nipples.
 */

#pragma once

#include "wx/wx.h"
#include "KeysMap.h"

class ConfigDialog : public wxDialog
{
	DECLARE_CLASS(ConfigDialog)
    DECLARE_EVENT_TABLE()

private:

	//Identifiants des objets de la fentre
	enum {
		idBtnSave = 100,
		idBtnDefault,
		idBtnCancel
	};
	
	//Pour que les changements restes locaux
	KeysMap local;
	//Lien la config du parent
	KeysMap &mapParent;

	//Les boutons de jeux
	wxButton* buttons[KeysMap::nbButtons];
	//Bouton pour sauver les modif
	wxButton* btnSave;
	//Bouton permettant de remettre les touches par dfaut
	wxButton* btnDefault;
	//Bouton permettant d'annuler les modifications
	wxButton* btnCancel;

	/**
	 Prpare la fentre.
	 */
	void init();

	/**
	 Appel lorsque l'utilisateur appuie sur le
	 bouton 'Save'
	 \param event Evnement correspondant
	 */
	void onSaveButton(wxCommandEvent &event);

	/**
	 Appel lorsque l'utilisateur presse sur le
	 bouton 'Reset'
	 \param event Evnement correspondant
	 */
	void onDefaultButton(wxCommandEvent &event);

	/**
	 Appel lorsque l'utilisateur presse sur le
	 bouton 'Cancel'
	 \param event Evnement correspondant
	 */
	void onCancelButton(wxCommandEvent &event);

	/**
	 Appl lorsqu'un des boutons configurable est
	 press.
	 \param event Evnement correspondant
	 */
	void onConfigurableButton(wxCommandEvent &event);

	/**
	 Affiche la valeur actuelle des touches sur les boutons.
	 */
	void showValues();

public:
	/**
	 Constructeur.
	 Construit une fentre permettant de modifier
	 la configuration des touches.
	 \param parent La fentre mre
	 \param keys Permet au parent de de rcuprer 
				les nouvelles touches.
	 */
	ConfigDialog(wxWindow* parent, KeysMap& keys);

	/**
	 Permet d'afficher la fentre (redef)
	 */
	int ShowModal();

	/**
	 Affiche la valeur actuelle des touches sur les boutons.
	 */
	void showButtonsValues();
};