#ifndef TIMER_H
#define TIMER_H

#include "common.h"

/** Initialisation du timer
	\note  appeler au dbut de l'excution ou lorsque  du jeu */
void timer_init();

/** Mise  jour du composant timer
	\param elapsed cycles couls depuis le dernier tick
*/
void timer_tick(int elapsed);

/** Ralise une lecture dans la zone I/O du timer
	\param port n du port  lire (adresse - $FF00)
	\return valeur de retour par le bus de donnes
*/
u8 timer_read(u16 port);

/** Ralise une criture dans la zone I/O du timer
	\param port n du port  lire (adresse - $FF00)
	\param value valeur  crire (via le bus de donnes)
*/
void timer_write(u16 port, u8 value);

#endif
