//============================================================================
//  debug.h ufobOwb_t@Cv PS2/Win32/GBA/NDS 
//----------------------------------------------------------------------------
//													Programmed by 
//----------------------------------------------------------------------------
// 2004.06.29 Ver.1.12 NDS Ń[jOôCB
// 2004.06.14 Ver.1.11 o̓t@C report.txt ɕύX.
//                     DEBUGFILECLEAR() ǉB
// 2004.05.28 Ver.1.10 L̏Cɋ@ˑ̂ŏC.
// 2004.05.26 Ver.1.09 DEBUG.TXT st@CƓꏊɂȂ悤ɏC.
// 2004.02.23 Ver.1.08 malloc ̃TCY int  size_t ɕύX.
// 2004.02.18 Ver.1.07 DirectX ̃G[񂪂̂ŏC.
// 2003.07.11 Ver.1.06 1.05  VC.NET ŃRpCłȂ̂ŏC.
// 2003.07.10 Ver.1.05 1.04  GBA ŃRpCłȂ̂ŏC.
// 2003.06.26 Ver.1.04 VC ŃRpCƃ[jOôC.
// 2003.05.28 Ver.1.03 new/delete ̓ftHgŃI[o[[hȂ.
//                     (new/delete ̎g̊ԈĂ.̓I[o[
//                     [hĂ͂Ȃ)
//                     GBA ɑΉ.GBA RpC -DGBA IvVK{.
// 2003.05.06 Ver.1.02 PS2EE Ńt@C݂ɑΉ.
// 2003.02.21 Ver.1.01 JE^ 0 ̎t@C폜悤ɂ.
//                     ֌W̃fobOpɃt@CƍsL.
//                     new/delete I[o[[h.
// 2003.02.20 Ver.1.00 쐬Jn.
//============================================================================
#ifndef DEBUG_H
#define DEBUG_H

// -------------------- wb_t@Co^
#if defined R5900
#include <stdio.h>
#endif
#include "generic.h"

// fobO (0=Ȃ,1=,2=o͂̂)
#define DEBUG_MODE 2
// o͐ (0=Wo(PS2),fobOEChE(Win32),1=t@C)
#define DEBUG_OUTPUT 0
// DirectX ̃o[W (0=fobOȂ,8  9 ̂ݎw\)
#define DEBUG_DIRECTX 0
// New/delete I[o[[h (0=Ȃ, 1=)
#define DEBUG_NEWDELETE 0

// -------------------- NCu̎w
#if defined _WIN32
#if DEBUG_DIRECTX == 8
#pragma comment( lib, "dxerr8.lib" )
#elif DEBUG_DIRECTX == 9
#pragma comment( lib, "dxerr9.lib" )
#endif
#endif

// -------------------- 萔`
#if defined GBA
static const int DEBUG_MEMORY_MAX = 256;					// mۊĎő吔 GBA
#else
static const int DEBUG_MEMORY_MAX = 65536;					// mۊĎő吔 Win32/PS2
#endif

#if defined R5900
static const char* const DEBUG_FILE = "host0:report.txt";	// PS2EE fobOõ͎t@C
#else
static const char* const DEBUG_FILE = "report.txt";			// fobOõ͎t@C
#endif
static const U32 DEBUG_10 = 0;
static const U32 DEBUG_16 = 1;
static const U32 DEBUG_DUMP8  = 0x00000001;
static const U32 DEBUG_DUMP16 = 0x00000002;
static const U32 DEBUG_DUMP32 = 0x00000004;

#if DEBUG_MODE == 1
#if DEBUG_NEWDELETE == 1
// -------------------- I[o[Ch
void* operator new( size_t size, const char* file, int line );
void* operator new[]( size_t size, const char* file, int line );
void operator delete( void* ptr );
void operator delete[]( void* ptr );
#endif
#endif

#if DEBUG_MODE != 0
// -------------------- NX`
class cDebug {
	public:
		cDebug( void );
		cDebug( int type );
		~cDebug( void );
		// fobOo
		void DeleteFile( void );
		void SetOutputType( int type );
		void Output( const char* outputstring, ... ) const;
		void OutputDump( const void *address, int width, int height, U32 mode ) const;
		// DirectX
		void OutputDxResult( void *result ) const;
		// Ǘ
		void* Malloc( size_t size, const char *file, int line );
		void Free( void *memblock );
		void MemoryStatus( void );
	private:
		// 풓
		static int StatCount;
		// o
		int OutputType;
		// Ǘ
		static int MallocHandle;
		static const void *MallocAddress[ DEBUG_MEMORY_MAX ];
		static const char *MallocFile[ DEBUG_MEMORY_MAX ];
		static int MallocLine[ DEBUG_MEMORY_MAX ];
		static size_t MallocSize[ DEBUG_MEMORY_MAX ];
		// ֎~
		cDebug( cDebug& debug );
		cDebug& operator = ( const cDebug &debug );
};
#endif

// -------------------- fobOȂ
#if DEBUG_MODE == 0
#define DEBUGINIT( x )             ;
#define DEBUGFILECLEAR             ;
#define DEBUGOUTMODE( x )          ;
#define DEBUGOUT( x )              ;
#define DEBUGOUTDUMP( a, w, h )    ;
#define DEBUGDX( x )               ;
#define MEMORYSTATE()              ;
// -------------------- ׂ
#elif DEBUG_MODE == 1
#define DEBUGINIT( x )             cDebug DebugMacro( x )
#define DEBUGFILECLEAR             DebugMacro.DeleteFile
#define DEBUGOUTTYPE( x )          DebugMacro.OutputType( x )
#define DEBUGOUT                   DebugMacro.Output
#define DEBUGOUTDUMP( a, w, h )    DebugMacro.OutputDump( a, w, h, DEBUG_DUMP8 )
#define DEBUGDX( x )               DebugMacro.OutputDxResult( (void*)&x )
#define malloc( x )                DebugMacro.Malloc( x, __FILE__, __LINE__ )
#define free( x )                  DebugMacro.Free( x )
#define MEMORYSTATE()              DebugMacro.MemoryStatus()
#if DEBUG_NEWDELETE == 1
#define new                        new( __FILE__, __LINE__ )
#endif

// -------------------- o͂̂
#elif DEBUG_MODE == 2
#define DEBUGINIT( x )             cDebug DebugMacro( x )
#define DEBUGFILECLEAR             DebugMacro.DeleteFile
#define DEBUGOUTTYPE( x )          DebugMacro.OutputType( x )
#define DEBUGOUT                   DebugMacro.Output
#define DEBUGOUTDUMP( a, w, h )    DebugMacro.OutputDump( a, w, h, DEBUG_DUMP8 )
#define DEBUGDX( x )               DebugMacro.OutputDxResult( (void*)&x )
#define MEMORYSTATE()              ;
#endif

// -------------------- ̃t@CQƉ
extern cDebug DebugMacro;

#endif
