#include <windows.h>
#include <mmsystem.h>
#include "waveout.h"

// NCu̎w
#pragma comment( lib, "Winmm.lib" )

WaveOutClass::WaveOutClass( void )
:MmioHandle( NULL ), Handle( NULL ), ThreadHandle( NULL ), Status( 0 ),
 LoopStart( 0 ), LoopEnd( -1 ), Volume( 1.0f ), NowVolume( 1.0f ), VolumeRate( 0.0f ),
 SampleCount( 0 )
{
}

WaveOutClass::~WaveOutClass( void )
{
}

int WaveOutClass::Init( int buffer_size, int count )
{
	int i;
	// NA
	MmioHandle = NULL;
	Handle = NULL;
	ThreadHandle = NULL;
	Status = 0;
	LoopStart = 0;
	LoopEnd = -1;
	Volume = 1.0f;
	NowVolume = 1.0f;
	VolumeRate = 0.0f;
	SampleCount = buffer_size / 2;
	// g`f[^i[obt@쐬
	WaveData = (WAVEHDR*)malloc( sizeof( WAVEHDR ) * count );
	WaveDataCount = count;
	ZeroMemory( WaveData, sizeof( WAVEHDR ) * count );
	for( i = 0; i < count; i ++ )
	{
		WaveData[ i ].lpData = (LPSTR)malloc( buffer_size );
		ZeroMemory( WaveData[ i ].lpData, buffer_size );
		WaveData[ i ].dwBufferLength = buffer_size;
	}
	// tH[}bgݒ
	ZeroMemory( &Format, sizeof( WAVEFORMATEX ) );
	Format.wFormatTag = WAVE_FORMAT_PCM;
	Format.nChannels = 2;
	Format.nSamplesPerSec = 44100;
	Format.wBitsPerSample = 16;
	Format.nBlockAlign = Format.nChannels * Format.wBitsPerSample / 8;
	Format.nAvgBytesPerSec = Format.nSamplesPerSec * Format.nBlockAlign;
	// R[obNpXbhN
	ThreadEnd = false;
	ThreadLock = CreateMutex( NULL, FALSE, NULL );
	ThreadHandle = CreateThread( NULL, 0, ThreadProc, this, 0, &ThreadID );
	if ( NULL == ThreadHandle )
	{
		Release();
		return 1;
	}
	SetThreadPriority( ThreadHandle, THREAD_PRIORITY_ABOVE_NORMAL);
	// Đ
	if( waveOutOpen( &Handle, WAVE_MAPPER, &Format, (DWORD_PTR)ThreadID, (DWORD_PTR)this, CALLBACK_THREAD ) != MMSYSERR_NOERROR )
	{
		Release();
		return 2;
	}
	return 0;
}

void WaveOutClass::Release( void )
{
	int i;
	// Đ~
	Stop();
	// WaveOut I
	if( Handle )
	{
		while( MMSYSERR_HANDLEBUSY == waveOutReset( Handle ) )
		{
			Sleep( 1 );
		}
		for( i = 0; i < WaveDataCount; i ++ )
		{
			if( WaveData[ i ].dwFlags & WHDR_PREPARED )
			{
				waveOutUnprepareHeader( Handle, &WaveData[ i ], sizeof( WAVEHDR ) );
			}
		}
		while( MMSYSERR_HANDLEBUSY == waveOutClose( Handle ) )
		{
			Sleep( 1 );
		}
		Handle = NULL;
	}
	for( i = 0; i < WaveDataCount; i ++ )
	{
		if( WaveData[ i ].lpData )
		{
			free( WaveData[ i ].lpData );
			WaveData[ i ].lpData = NULL;
		}
	}
	// XbhI
	if ( ThreadHandle )
	{
		int retry = 2000; // 2 bȓɏI邱ƂłȂ狭I
		DWORD exit_code = -1;
		ThreadEnd = true;
		while( ThreadEnd )
		{
			Sleep( 1 );
			if( GetExitCodeThread( ThreadHandle, &exit_code ) != 0 )
			{
				if( exit_code != STILL_ACTIVE )
				{
					ThreadEnd = false;
				}
			}
			retry --;
			if( retry < 0 )
			{
				// I
				TerminateThread( ThreadHandle, 0 );
				Sleep( 100 );
				ThreadEnd = false;
			}
		}
		CloseHandle( ThreadLock );
		CloseHandle( ThreadHandle );
		ThreadHandle = NULL;
	}
}

int WaveOutClass::Play( char *path, unsigned int mode )
{
	Stop();
	WaitForSingleObject( ThreadLock, INFINITE );
	PlayMode = mode;
	PlayBlock = 0;
	if ( OpenWave( path ) != 0 )
	{
		ReleaseMutex( ThreadLock );
		return 1;
	}
	int i;
	for( i = 0; i < WaveDataCount; i ++ )
	{
		ReadWave( (char*)WaveData[ i ].lpData, WaveData[ i ].dwBufferLength, mode );
	}
	for( i = 0; i < WaveDataCount; i ++ )
	{
		if( waveOutPrepareHeader( Handle, &WaveData[ i ], sizeof( WAVEHDR ) ) )
		{
			ReleaseMutex( ThreadLock );
			return 2;
		}
		if( waveOutWrite( Handle, &WaveData[ i ], sizeof( WAVEHDR ) ) )
		{
			waveOutUnprepareHeader( Handle, &WaveData[ i ], sizeof( WAVEHDR ) );
			ReleaseMutex( ThreadLock );
			return 3;
		}
	}
	Status = 1;
	ReleaseMutex( ThreadLock );
	return 0;
}

// In  : pause = ( 0 = ꎞ~, 1 = ꎞ~ )
void WaveOutClass::Pause( int pause )
{
	if( 1 == pause )
	{
		waveOutPause( Handle );
	}
	else
	{
		waveOutRestart( Handle );
	}
}

void WaveOutClass::Stop( void )
{
	WaitForSingleObject( ThreadLock, INFINITE );
	while( MMSYSERR_HANDLEBUSY == waveOutReset( Handle ) )
	{
		Sleep( 1 );
	}
	if( MmioHandle )
	{
		CloseWave();
	}
	Status = 0;
	ReleaseMutex( ThreadLock );
}

// In  : start = [v̊Jnʒu (TvŎw)
//     : end = 
void WaveOutClass::SetLoop( int start, int end )
{
	LoopStart = (LONG)( start * 4 );
	LoopEnd = (LONG)( end * 4 );
}

// Out : (0 = ĐĂȂ, 1 = Đ)
int WaveOutClass::GetStatus( void )
{
	return Status;
}

int WaveOutClass::GetPosition( void )
{
	MMTIME mmtime;
	ZeroMemory( &mmtime, sizeof( mmtime ) );
	mmtime.wType = TIME_SAMPLES;
	if ( waveOutGetPosition( Handle, &mmtime, sizeof( mmtime ) ) != MMSYSERR_NOERROR )
	{
		return -1;
	}
	return (int)mmtime.u.sample;
}

// In  : volume = 0.0f ` 1.0f
//     : time = Tv (44100 = 1b)
void WaveOutClass::SetVolume( float volume, int time )
{
	if( 0 == time )
	{
		VolumeRate = 0.0f;
		Volume = volume;
		NowVolume = volume;
	}
	else
	{
		VolumeRate = ( volume - Volume ) / (float)time;
		Volume = volume;
		if( 0.0f == VolumeRate )
		{
			Volume = volume;
			NowVolume = volume;
		}
	}
}

// Out : volume = 0.0f ` 1.0f
float WaveOutClass::GetVolume( void )
{
	return Volume;
}

void WaveOutClass::AddPlayData( void )
{
	if( 0 == Status )
	{
		return;
	}
	if( waveOutUnprepareHeader( Handle, &WaveData[ PlayBlock ], sizeof( WAVEHDR ) ) )
	{
		return;
	}
	// f[^ǂݍ
	ReadWave( (char*)WaveData[ PlayBlock ].lpData, WaveData[ PlayBlock ].dwBufferLength, PlayMode );
	// ʒ
	short *wave_data;
	int i;
    wave_data = (short*)WaveData[ PlayBlock ].lpData;
	if( 0 == VolumeRate )
	{
		if( Volume != 1.0f )
		{
			for( i = 0; i < SampleCount; i ++ )
			{
				wave_data[ i ] = (short)( (float)wave_data[ i ] * Volume );
			}
		}
	}
	else
	{
		for( i = 0; i < SampleCount; i ++ )
		{
			wave_data[ i ] = (short)( (float)wave_data[ i ] * NowVolume );
			if( i & 1 )
			{
				NowVolume += VolumeRate;
				if( VolumeRate < 0 )
				{
					if( NowVolume < 0 )
					{
						NowVolume = 0.0f;
						VolumeRate = 0.0f;
					}
				}
				else
				{
					if( NowVolume > 1.0f )
					{
						NowVolume = 1.0f;
						VolumeRate = 0.0f;
					}
				}
			}
		}
	}
	// Đ
	if( waveOutPrepareHeader( Handle, &WaveData[ PlayBlock ], sizeof( WAVEHDR ) ) )
	{
		Status = 0;
		return;
	}
	if( waveOutWrite( Handle, &WaveData[ PlayBlock ], sizeof( WAVEHDR ) ) )
	{
		waveOutUnprepareHeader( Handle, &WaveData[ PlayBlock ], sizeof( WAVEHDR ) );
		Status = 0;
		return;
	}
	// ĐubNXV
	PlayBlock ++;
	PlayBlock %= WaveDataCount;
}

int WaveOutClass::OpenWave( char *path )
{
	MMCKINFO mmck_infomain;
	MMCKINFO mmck_infosub;
	MMRESULT result;
	BYTE *pbyBuffer = NULL;
	MmioHandle = mmioOpen( (char*)path, NULL, MMIO_READ );
	if( NULL == MmioHandle )
	{
		return 1;
	}
	mmck_infomain.fccType = mmioFOURCC( 'W', 'A', 'V', 'E' );
	result = mmioDescend( MmioHandle, &mmck_infomain, NULL, MMIO_FINDRIFF );
	if( MMIOERR_CHUNKNOTFOUND == result )
	{
		// 'WAVE' `NȂ
		mmioClose( MmioHandle, 0 );
		return 2;
	}
	mmck_infosub.ckid = mmioFOURCC( 'f', 'm', 't', ' ' );
	result = mmioDescend( MmioHandle, &mmck_infosub, &mmck_infomain, MMIO_FINDCHUNK );
	if( MMIOERR_CHUNKNOTFOUND == result )
	{
		// 'fmt ' `NȂ
		mmioClose( MmioHandle, 0 );
		return 3;
	}
	DWORD chunk_size;
	WAVEFORMATEX format;
	chunk_size = mmioRead( MmioHandle, (HPSTR)&format, mmck_infosub.cksize );
	if( chunk_size != mmck_infosub.cksize )
	{
		// 'fmt ' `Ñf[^ǂݍ߂Ȃ
		mmioClose( MmioHandle, 0 );
		return 4;
	}
	if( format.wFormatTag != Format.wFormatTag )
	{
		// w̃tH[}bgł͂Ȃ
		mmioClose( MmioHandle, 0 );
		return 5;
	}
	if( format.nChannels != Format.nChannels )
	{
		// w̃tH[}bgł͂Ȃ
		mmioClose( MmioHandle, 0 );
		return 5;
	}
	if( format.nSamplesPerSec != Format.nSamplesPerSec )
	{
		// w̃tH[}bgł͂Ȃ
		mmioClose( MmioHandle, 0 );
		return 5;
	}
	if( format.wBitsPerSample != Format.wBitsPerSample )
	{
		// w̃tH[}bgł͂Ȃ
		mmioClose( MmioHandle, 0 );
		return 5;
	}
	// `N߂
	mmioAscend( MmioHandle, &mmck_infosub, 0 );
	// 'data' `N
	mmck_infosub.ckid = mmioFOURCC( 'd', 'a', 't', 'a' );
	result = mmioDescend( MmioHandle, &mmck_infosub, &mmck_infomain, MMIO_FINDCHUNK );
	if( MMIOERR_CHUNKNOTFOUND == result )
	{
		// 'data' `NȂ
		mmioClose( MmioHandle, 0 );
		return 6;
	}
	// ݂̏ꏊۑ
	WaveStart = mmioSeek( MmioHandle, 0L, SEEK_CUR );
	// t@C̏I[̏ꏊۑ
	WaveEnd = mmioSeek( MmioHandle, 0L, SEEK_END );
	//  2 f[^TCYvZ
	WaveSize = WaveEnd - WaveStart;
	WaveSampleSize = WaveSize / 4;
	// V[NʒuƂ̏ꏊɖ߂
	result = mmioSeek( MmioHandle, (LONG)WaveStart, SEEK_SET );
	return 0;
}

int WaveOutClass::ReadWave( char *buffer, int size, unsigned int mode )
{
	if( NULL == MmioHandle )
	{
		return 0;
	}
	int rest;
	int result;
	rest = size;
	while( rest > 0 )
	{
		ZeroMemory( buffer, rest );
		result = (int)mmioRead( MmioHandle, (HPSTR)buffer, rest );
		if ( rest != result )
		{
			if( PlayMode & MODE_LOOP )
			{
				mmioSeek( MmioHandle, WaveStart + LoopStart, SEEK_SET );
				buffer += result;
			}
			else
			{
				break;
			}
		}
		rest -= result;
	}
	return size - rest;
}

void WaveOutClass::CloseWave( void )
{
	if( NULL == MmioHandle )
	{
		return;
	}
	mmioClose( MmioHandle, 0 );
	MmioHandle = NULL;
}

DWORD WINAPI WaveOutClass::ThreadProc( LPVOID Thread )
{
	WaveOutClass *waveout_class;
	waveout_class = (WaveOutClass*)Thread;
	MSG msg;
	while( 1 )
	{
		Sleep( 1 );
		WaitForSingleObject( waveout_class->ThreadLock, INFINITE );
		if( waveout_class->ThreadEnd )
		{
			ReleaseMutex( waveout_class->ThreadLock );
			break;
		}
		if( !( waveout_class->PlayMode & MODE_LOOP ) )
		{
			if ( waveout_class->GetPosition() > waveout_class->WaveSampleSize )
			{
				waveout_class->Status = 0;
			}
		}
		if( waveout_class->Status != 0 )
		{
			if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
			{
				if( FALSE == GetMessage( &msg, NULL, 0, 0 ) )
				{
					ReleaseMutex( waveout_class->ThreadLock );
					break;
				}
				switch( msg.message )
				{
					case MM_WOM_DONE:
					{
						waveout_class->AddPlayData();
						break;
					}
				}
			}
		}
		ReleaseMutex( waveout_class->ThreadLock );
	}
	ExitThread( 0 );
}
