/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import java.io.DataOutputStream;
import java.io.IOException;
import mnj.lua.Loader;
import mnj.lua.LocVar;
import mnj.lua.Lua;
import mnj.lua.Proto;
import mnj.lua.Slot;

final class DumpState {
    DataOutputStream writer;
    boolean strip;

    DumpState(DataOutputStream dataOutputStream, boolean bl) {
        this.writer = dataOutputStream;
        this.strip = bl;
    }

    void DumpHeader() throws IOException {
        Loader.HEADER[6] = 0;
        this.writer.write(Loader.HEADER);
    }

    private void DumpInt(int n) throws IOException {
        this.writer.writeInt(n);
    }

    private void DumpNumber(double d) throws IOException {
        this.writer.writeDouble(d);
    }

    void DumpFunction(Proto proto, String string) throws IOException {
        this.DumpString(proto.source == string || this.strip ? null : proto.source);
        this.DumpInt(proto.linedefined);
        this.DumpInt(proto.lastlinedefined);
        this.writer.writeByte(proto.nups);
        this.writer.writeByte(proto.numparams);
        this.writer.writeBoolean(proto.isVararg());
        this.writer.writeByte(proto.maxstacksize);
        this.DumpCode(proto);
        this.DumpConstants(proto);
        this.DumpDebug(proto);
    }

    private void DumpCode(Proto proto) throws IOException {
        int n = proto.sizecode;
        int[] nArray = proto.code;
        this.DumpInt(n);
        for (int i = 0; i < n; ++i) {
            this.DumpInt(nArray[i]);
        }
    }

    private void DumpConstants(Proto proto) throws IOException {
        Object object;
        int n;
        int n2 = proto.sizek;
        Slot[] slotArray = proto.k;
        this.DumpInt(n2);
        for (n = 0; n < n2; ++n) {
            object = slotArray[n].r;
            if (object == Lua.NIL) {
                this.writer.writeByte(0);
                continue;
            }
            if (object instanceof Boolean) {
                this.writer.writeByte(1);
                this.writer.writeBoolean((Boolean)object);
                continue;
            }
            if (object == Lua.NUMBER) {
                this.writer.writeByte(3);
                this.DumpNumber(slotArray[n].d);
                continue;
            }
            if (!(object instanceof String)) continue;
            this.writer.writeByte(4);
            this.DumpString((String)object);
        }
        n2 = proto.sizep;
        this.DumpInt(n2);
        for (n = 0; n < n2; ++n) {
            object = proto.p[n];
            this.DumpFunction((Proto)object, proto.source);
        }
    }

    private void DumpString(String string) throws IOException {
        if (string == null) {
            this.DumpInt(0);
        } else {
            byte[] byArray = string.getBytes("UTF-8");
            int n = byArray.length;
            this.DumpInt(n + 1);
            this.writer.write(byArray, 0, n);
            this.writer.writeByte(0);
        }
    }

    private void DumpDebug(Proto proto) throws IOException {
        int n;
        if (this.strip) {
            this.DumpInt(0);
            this.DumpInt(0);
            this.DumpInt(0);
            return;
        }
        int n2 = proto.sizelineinfo;
        this.DumpInt(n2);
        for (n = 0; n < n2; ++n) {
            this.DumpInt(proto.lineinfo[n]);
        }
        n2 = proto.sizelocvars;
        this.DumpInt(n2);
        for (n = 0; n < n2; ++n) {
            LocVar locVar = proto.locvars[n];
            this.DumpString(locVar.varname);
            this.DumpInt(locVar.startpc);
            this.DumpInt(locVar.endpc);
        }
        n2 = proto.sizeupvalues;
        this.DumpInt(n2);
        for (n = 0; n < n2; ++n) {
            this.DumpString(proto.upvalues[n]);
        }
    }
}

