/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import mnj.lua.FromReader;
import mnj.lua.Loader;
import mnj.lua.Lua;
import mnj.lua.LuaFunction;
import mnj.lua.LuaJavaCallback;
import mnj.lua.Proto;
import mnj.lua.Syntax;
import mnj.lua.UpVal;

final class LuaInternal
extends LuaJavaCallback {
    private InputStream stream;
    private Reader reader;
    private String chunkname;

    LuaInternal(InputStream inputStream, String string) {
        this.stream = inputStream;
        this.chunkname = string;
    }

    LuaInternal(Reader reader, String string) {
        this.reader = reader;
        this.chunkname = string;
    }

    @Override
    public int luaFunction(Lua lua) {
        try {
            Proto proto = null;
            if (this.stream != null) {
                this.stream.mark(1);
                int n = this.stream.read();
                this.stream.reset();
                if (n == Loader.HEADER[0]) {
                    Loader loader = new Loader(this.stream, this.chunkname);
                    proto = loader.undump();
                } else {
                    this.reader = new InputStreamReader(this.stream, "UTF-8");
                    proto = Syntax.parser(lua, this.reader, this.chunkname);
                }
            } else if (this.reader.markSupported()) {
                this.reader.mark(1);
                int n = this.reader.read();
                this.reader.reset();
                if (n == Loader.HEADER[0]) {
                    this.stream = new FromReader(this.reader);
                    Loader loader = new Loader(this.stream, this.chunkname);
                    proto = loader.undump();
                } else {
                    proto = Syntax.parser(lua, this.reader, this.chunkname);
                }
            } else {
                proto = Syntax.parser(lua, this.reader, this.chunkname);
            }
            lua.push(new LuaFunction(proto, new UpVal[0], lua.getGlobals()));
            return 1;
        }
        catch (IOException iOException) {
            lua.push("cannot read " + this.chunkname + ": " + iOException.toString());
            lua.dThrow(6);
            return 0;
        }
    }
}

