/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import java.util.Vector;
import mnj.lua.Lua;
import mnj.lua.Syntax;

final class MatchState {
    Lua L;
    String src;
    int end;
    int level;
    Vector<Object> capture = new Vector();
    static final char L_ESC = '%';
    static final String SPECIALS = "^$*+?.([%-";
    private static final int CAP_UNFINISHED = -1;
    private static final int CAP_POSITION = -2;

    MatchState(Lua lua, String string, int n) {
        this.L = lua;
        this.src = string;
        this.end = n;
    }

    private int captureLen(int n) {
        int[] nArray = (int[])this.capture.elementAt(n);
        return nArray[1];
    }

    private int captureInit(int n) {
        int[] nArray = (int[])this.capture.elementAt(n);
        return nArray[0];
    }

    private int[] capture(int n) {
        return (int[])this.capture.elementAt(n);
    }

    int capInvalid() {
        return this.L.error("invalid capture index");
    }

    int malBra() {
        return this.L.error("malformed pattern (missing '[')");
    }

    int capUnfinished() {
        return this.L.error("unfinished capture");
    }

    int malEsc() {
        return this.L.error("malformed pattern (ends with '%')");
    }

    char check_capture(char c) {
        if ((c = (char)(c - 49)) >= this.level || this.captureLen(c) == -1) {
            this.capInvalid();
        }
        return c;
    }

    int capture_to_close() {
        int n = this.level;
        --n;
        while (n >= 0) {
            if (this.captureLen(n) == -1) {
                return n;
            }
            --n;
        }
        return this.capInvalid();
    }

    int classend(String string, int n) {
        switch (string.charAt(n++)) {
            case '%': {
                return n + 1;
            }
            case '[': {
                if (string.length() == n) {
                    return this.malBra();
                }
                if (string.charAt(n) == '^') {
                    ++n;
                }
                do {
                    if (string.length() == n) {
                        return this.malBra();
                    }
                    if (string.charAt(n++) != '%') continue;
                    if (string.length() == n) {
                        return this.malBra();
                    }
                    if (string.length() != ++n) continue;
                    return this.malBra();
                } while (string.charAt(n) != ']');
                return n + 1;
            }
        }
        return n;
    }

    static boolean match_class(char c, char c2) {
        boolean bl;
        switch (Character.toLowerCase(c2)) {
            case 'a': {
                bl = Syntax.isalpha(c);
                break;
            }
            case 'c': {
                bl = Syntax.iscntrl(c);
                break;
            }
            case 'd': {
                bl = Syntax.isdigit(c);
                break;
            }
            case 'l': {
                bl = Syntax.islower(c);
                break;
            }
            case 'p': {
                bl = Syntax.ispunct(c);
                break;
            }
            case 's': {
                bl = Syntax.isspace(c);
                break;
            }
            case 'u': {
                bl = Syntax.isupper(c);
                break;
            }
            case 'w': {
                bl = Syntax.isalnum(c);
                break;
            }
            case 'x': {
                bl = Syntax.isxdigit(c);
                break;
            }
            case 'z': {
                bl = c == '\u0000';
                break;
            }
            default: {
                return c2 == c;
            }
        }
        return Character.isLowerCase(c2) ? bl : !bl;
    }

    static boolean matchbracketclass(char c, String string, int n, int n2) {
        boolean bl = true;
        if (string.charAt(n + 1) == '^') {
            bl = false;
            ++n;
        }
        while (++n < n2) {
            if (!(string.charAt(n) == '%' ? MatchState.match_class(c, string.charAt(++n)) : (string.charAt(n + 1) == '-' && n + 2 < n2 ? string.charAt((n += 2) - 2) <= c && c <= string.charAt(n) : string.charAt(n) == c))) continue;
            return bl;
        }
        return !bl;
    }

    static boolean singlematch(char c, String string, int n, int n2) {
        switch (string.charAt(n)) {
            case '.': {
                return true;
            }
            case '%': {
                return MatchState.match_class(c, string.charAt(n + 1));
            }
            case '[': {
                return MatchState.matchbracketclass(c, string, n, n2 - 1);
            }
        }
        return string.charAt(n) == c;
    }

    int matchbalance(int n, String string, int n2) {
        if (n2 + 1 >= string.length()) {
            this.L.error("unbalanced pattern");
        }
        if (n >= this.end || this.src.charAt(n) != string.charAt(n2)) {
            return -1;
        }
        char c = string.charAt(n2);
        char c2 = string.charAt(n2 + 1);
        int n3 = 1;
        while (++n < this.end) {
            if (this.src.charAt(n) == c2) {
                if (--n3 != 0) continue;
                return n + 1;
            }
            if (this.src.charAt(n) != c) continue;
            ++n3;
        }
        return -1;
    }

    int max_expand(int n, String string, int n2, int n3) {
        int n4 = 0;
        while (n + n4 < this.end && MatchState.singlematch(this.src.charAt(n + n4), string, n2, n3)) {
            ++n4;
        }
        while (n4 >= 0) {
            int n5 = this.match(n + n4, string, n3 + 1);
            if (n5 >= 0) {
                return n5;
            }
            --n4;
        }
        return -1;
    }

    int min_expand(int n, String string, int n2, int n3) {
        while (true) {
            int n4;
            if ((n4 = this.match(n, string, n3 + 1)) >= 0) {
                return n4;
            }
            if (n >= this.end || !MatchState.singlematch(this.src.charAt(n), string, n2, n3)) break;
            ++n;
        }
        return -1;
    }

    int start_capture(int n, String string, int n2, int n3) {
        this.capture.setSize(this.level + 1);
        this.capture.setElementAt(new int[]{n, n3}, this.level);
        ++this.level;
        int n4 = this.match(n, string, n2);
        if (n4 < 0) {
            --this.level;
        }
        return n4;
    }

    int end_capture(int n, String string, int n2) {
        int n3 = this.capture_to_close();
        this.capture((int)n3)[1] = n - this.captureInit(n3);
        int n4 = this.match(n, string, n2);
        if (n4 < 0) {
            this.capture((int)n3)[1] = -1;
        }
        return n4;
    }

    int match_capture(int n, char c) {
        int n2 = this.captureLen(c = this.check_capture(c));
        if (this.end - n >= n2 && this.src.regionMatches(false, this.captureInit(c), this.src, n, n2)) {
            return n + n2;
        }
        return -1;
    }

    int match(int n, String string, int n2) {
        block16: while (string.length() != n2) {
            char c;
            char c2;
            int n3;
            switch (string.charAt(n2)) {
                case '(': {
                    if (string.length() == n2 + 1) {
                        return this.capUnfinished();
                    }
                    if (string.charAt(n2 + 1) == ')') {
                        return this.start_capture(n, string, n2 + 2, -2);
                    }
                    return this.start_capture(n, string, n2 + 1, -1);
                }
                case ')': {
                    return this.end_capture(n, string, n2 + 1);
                }
                case '%': {
                    if (string.length() == n2 + 1) {
                        return this.malEsc();
                    }
                    switch (string.charAt(n2 + 1)) {
                        case 'b': {
                            n = this.matchbalance(n, string, n2 + 2);
                            if (n < 0) {
                                return n;
                            }
                            n2 += 4;
                            continue block16;
                        }
                        case 'f': {
                            if (string.length() == (n2 += 2) || string.charAt(n2) != '[') {
                                return this.L.error("missing '[' after '%f' in pattern");
                            }
                            n3 = this.classend(string, n2);
                            c2 = n == 0 ? (char)'\u0000' : this.src.charAt(n - 1);
                            char c3 = c = n == this.end ? (char)'\u0000' : (char)this.src.charAt(n);
                            if (MatchState.matchbracketclass(c2, string, n2, n3 - 1) || !MatchState.matchbracketclass(c, string, n2, n3 - 1)) {
                                return -1;
                            }
                            n2 = n3;
                            continue block16;
                        }
                    }
                    if (Syntax.isdigit(string.charAt(n2 + 1))) {
                        if ((n = this.match_capture(n, string.charAt(n2 + 1))) < 0) {
                            return n;
                        }
                        n2 += 2;
                        continue block16;
                    }
                }
                case '$': {
                    if (string.charAt(n2) != '$' || string.length() != n2 + 1) break;
                    return n == this.end ? n : -1;
                }
            }
            n3 = this.classend(string, n2);
            char c4 = c2 = n < this.end && MatchState.singlematch(this.src.charAt(n), string, n2, n3) ? (char)'\u0001' : '\u0000';
            if (string.length() > n3) {
                switch (string.charAt(n3)) {
                    case '?': {
                        if (c2 != '\u0000' && (c = this.match(n + 1, string, n3 + 1)) >= '\u0000') {
                            return c;
                        }
                        n2 = n3 + 1;
                        continue block16;
                    }
                    case '*': {
                        return this.max_expand(n, string, n2, n3);
                    }
                    case '+': {
                        return c2 != '\u0000' ? this.max_expand(n + 1, string, n2, n3) : -1;
                    }
                    case '-': {
                        return this.min_expand(n, string, n2, n3);
                    }
                }
            }
            if (c2 == '\u0000') {
                return -1;
            }
            ++n;
            n2 = n3;
        }
        return n;
    }

    Object onecapture(int n, int n2, int n3) {
        int n4;
        if (n >= this.level) {
            if (n == 0) {
                return this.src.substring(n2, n3);
            }
            this.capInvalid();
        }
        if ((n4 = this.captureLen(n)) == -1) {
            this.capUnfinished();
        }
        if (n4 == -2) {
            return Lua.valueOfNumber(this.captureInit(n) + 1);
        }
        return this.src.substring(this.captureInit(n), this.captureInit(n) + n4);
    }

    void push_onecapture(int n, int n2, int n3) {
        this.L.push(this.onecapture(n, n2, n3));
    }

    int push_captures(int n, int n2) {
        int n3 = this.level == 0 && n >= 0 ? 1 : this.level;
        for (int i = 0; i < n3; ++i) {
            this.push_onecapture(i, n, n2);
        }
        return n3;
    }

    void adds(StringBuffer stringBuffer, int n, int n2) {
        String string = this.L.toString(this.L.value(3));
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            if (string.charAt(i) != '%') {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (!Syntax.isdigit(string.charAt(++i))) {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (string.charAt(i) == '0') {
                stringBuffer.append(this.src.substring(n, n2));
                continue;
            }
            stringBuffer.append(this.L.toString(this.onecapture(string.charAt(i) - 49, n, n2)));
        }
    }

    void addvalue(StringBuffer stringBuffer, int n, int n2) {
        switch (this.L.type(3)) {
            case 3: 
            case 4: {
                this.adds(stringBuffer, n, n2);
                return;
            }
            case 6: {
                this.L.pushValue(3);
                int n3 = this.push_captures(n, n2);
                this.L.call(n3, 1);
                break;
            }
            case 5: {
                this.L.push(this.L.getTable(this.L.value(3), this.onecapture(0, n, n2)));
                break;
            }
            default: {
                this.L.argRaiseError(3, "string/function/table expected");
                return;
            }
        }
        if (!this.L.toBoolean(this.L.value(-1))) {
            this.L.pop(1);
            this.L.pushString(this.src.substring(n, n2));
        } else if (!Lua.isString(this.L.value(-1))) {
            this.L.error("invalid replacement value (a " + Lua.typeName(this.L.type(-1)) + ")");
        }
        stringBuffer.append(this.L.toString(this.L.value(-1)));
        this.L.pop(1);
    }
}

