/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import java.util.Enumeration;
import mnj.lua.Lua;
import mnj.lua.LuaJavaCallback;
import mnj.lua.LuaTable;

public final class TableLib
extends LuaJavaCallback {
    private static final int CONCAT = 1;
    private static final int INSERT = 2;
    private static final int MAXN = 3;
    private static final int REMOVE = 4;
    private static final int SORT = 5;
    private int which;

    private TableLib(int n) {
        this.which = n;
    }

    @Override
    public int luaFunction(Lua lua) {
        switch (this.which) {
            case 1: {
                return TableLib.concat(lua);
            }
            case 2: {
                return TableLib.insert(lua);
            }
            case 3: {
                return TableLib.maxn(lua);
            }
            case 4: {
                return TableLib.remove(lua);
            }
            case 5: {
                return TableLib.sort(lua);
            }
        }
        return 0;
    }

    public static void open(Lua lua) {
        lua.register("table");
        TableLib.r(lua, "concat", 1);
        TableLib.r(lua, "insert", 2);
        TableLib.r(lua, "maxn", 3);
        TableLib.r(lua, "remove", 4);
        TableLib.r(lua, "sort", 5);
    }

    private static void r(Lua lua, String string, int n) {
        TableLib tableLib = new TableLib(n);
        Object object = lua.getGlobal("table");
        lua.setField(object, string, tableLib);
    }

    private static int concat(Lua lua) {
        String string = lua.optString(2, "");
        lua.checkType(1, 5);
        int n = lua.optInt(4, Lua.objLen(lua.value(1)));
        StringBuffer stringBuffer = new StringBuffer();
        Object object = lua.value(1);
        for (int i = lua.optInt(3, 1); i <= n; ++i) {
            Object object2 = Lua.rawGetI(object, i);
            lua.argCheck(Lua.isString(object2), 1, "table contains non-strings");
            stringBuffer.append(lua.toString(object2));
            if (i == n) continue;
            stringBuffer.append(lua.toString(string));
        }
        lua.pushString(stringBuffer.toString());
        return 1;
    }

    private static int insert(Lua lua) {
        int n;
        int n2 = TableLib.aux_getn(lua, 1) + 1;
        Object object = lua.value(1);
        switch (lua.getTop()) {
            case 2: {
                n = n2;
                break;
            }
            case 3: {
                n = lua.checkInt(2);
                if (n > n2) {
                    n2 = n;
                }
                for (int i = n2; i > n; --i) {
                    lua.rawSetI(object, i, Lua.rawGetI(object, i - 1));
                }
                break;
            }
            default: {
                return lua.error("wrong number of arguments to 'insert'");
            }
        }
        lua.rawSetI(object, n, lua.value(-1));
        return 0;
    }

    private static int maxn(Lua lua) {
        double d = 0.0;
        lua.checkType(1, 5);
        LuaTable luaTable = (LuaTable)lua.value(1);
        Enumeration<Object> enumeration = luaTable.keys();
        while (enumeration.hasMoreElements()) {
            double d2;
            Object object = enumeration.nextElement();
            if (Lua.type(object) != 3 || !((d2 = lua.toNumber(object)) > d)) continue;
            d = d2;
        }
        lua.pushNumber(d);
        return 1;
    }

    private static int remove(Lua lua) {
        int n;
        int n2 = TableLib.aux_getn(lua, 1);
        if (n2 == 0) {
            return 0;
        }
        Object object = lua.value(1);
        Object object2 = Lua.rawGetI(object, n);
        for (n = lua.optInt(2, n2); n < n2; ++n) {
            lua.rawSetI(object, n, Lua.rawGetI(object, n + 1));
        }
        lua.rawSetI(object, n2, Lua.NIL);
        lua.push(object2);
        return 1;
    }

    private static int sort(Lua lua) {
        int n = TableLib.aux_getn(lua, 1);
        if (!lua.isNoneOrNil(2)) {
            lua.checkType(2, 6);
        }
        lua.setTop(2);
        TableLib.auxsort(lua, 1, n);
        return 0;
    }

    static void auxsort(Lua lua, int n, int n2) {
        Object object = lua.value(1);
        while (n < n2) {
            Object object2 = Lua.rawGetI(object, n);
            Object object3 = Lua.rawGetI(object, n2);
            if (TableLib.sort_comp(lua, object3, object2)) {
                lua.rawSetI(object, n, object3);
                lua.rawSetI(object, n2, object2);
            }
            if (n2 - n == 1) break;
            int n3 = (n + n2) / 2;
            object2 = Lua.rawGetI(object, n3);
            if (TableLib.sort_comp(lua, object2, object3 = Lua.rawGetI(object, n))) {
                lua.rawSetI(object, n3, object3);
                lua.rawSetI(object, n, object2);
            } else {
                object3 = Lua.rawGetI(object, n2);
                if (TableLib.sort_comp(lua, object3, object2)) {
                    lua.rawSetI(object, n3, object3);
                    lua.rawSetI(object, n2, object2);
                }
            }
            if (n2 - n == 2) break;
            Object object4 = Lua.rawGetI(object, n3);
            object3 = Lua.rawGetI(object, n2 - 1);
            lua.rawSetI(object, n3, object3);
            lua.rawSetI(object, n2 - 1, object4);
            n3 = n;
            int n4 = n2 - 1;
            while (true) {
                if (TableLib.sort_comp(lua, object2 = Lua.rawGetI(object, ++n3), object4)) {
                    if (n3 <= n2) continue;
                    lua.error("invalid order function for sorting");
                    continue;
                }
                while (TableLib.sort_comp(lua, object4, object3 = Lua.rawGetI(object, --n4))) {
                    if (n4 >= n) continue;
                    lua.error("invalid order function for sorting");
                }
                if (n4 < n3) break;
                lua.rawSetI(object, n3, object3);
                lua.rawSetI(object, n4, object2);
            }
            object2 = Lua.rawGetI(object, n2 - 1);
            object3 = Lua.rawGetI(object, n3);
            lua.rawSetI(object, n2 - 1, object3);
            lua.rawSetI(object, n3, object2);
            if (n3 - n < n2 - n3) {
                n4 = n;
                n = --n3 + 2;
            } else {
                n4 = n3 + 1;
                n3 = n2;
                n2 = n4 - 2;
            }
            TableLib.auxsort(lua, n4, n3);
        }
    }

    private static boolean sort_comp(Lua lua, Object object, Object object2) {
        if (!Lua.isNil(lua.value(2))) {
            lua.pushValue(2);
            lua.push(object);
            lua.push(object2);
            lua.call(2, 1);
            boolean bl = lua.toBoolean(lua.value(-1));
            lua.pop(1);
            return bl;
        }
        return lua.lessThan(object, object2);
    }

    private static int aux_getn(Lua lua, int n) {
        lua.checkType(n, 5);
        LuaTable luaTable = (LuaTable)lua.value(n);
        return luaTable.getn();
    }
}

